/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.titulo.EnumConstTipoTitulo;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.WorkspaceBancoAuthOp;
import com.touchcomp.basementor.model.vo.WorkspaceBancoOp;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import lombok.Generated;

@Entity
@Table(name="WORKSPACE_BANCO")
public class WorkspaceBanco
implements InterfaceVO {
    @Id
    @Column(name="ID_WORKSPACE_BANCO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_WORKSPACE_BANCO")
    private Long identificador;
    @Column(unique=true, name="DESCRICAO", length=100)
    private String descricao;
    @Column(name="ATIVO")
    private Short ativo = 0;
    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    private Date dataCadastro;
    @Version
    @Column(name="DATA_ATUALIZACAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataAtualizacao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_WORKSPACE_BANCO_EMPRESA"))
    private Empresa empresa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_EMPRESA", foreignKey=@ForeignKey(name="FK_WORKSPACE_BANCO_GR_EMPRESA"))
    private GrupoEmpresa grupoEmpresa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INSTITUICAO_VALOR", foreignKey=@ForeignKey(name="FK_WORKSPACE_BANCO_INST_VAL"))
    private InstituicaoValores instituicaoValores;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CARTEIRA_PRINCIPAL", foreignKey=@ForeignKey(name="FK_WORKSPACE_BANCO_CART_COB"))
    private CarteiraCobranca carteiraPrincipal;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONFIGURACAO_CERTIFICADO", foreignKey=@ForeignKey(name="FK_WORKSPACE_BANCO_CONF_CERT"))
    private ConfiguracaoCertificado configuracaoCertificado;
    @Column(name="WORKSPACE_BANCO_ID")
    private String workspaceBancoId;
    @Column(name="WEBHOOK_URL")
    private String webhookURL;
    @Column(name="PAG_REC")
    private Short pagRec = EnumConstTipoTitulo.RECEBIMENTO.getValue();
    @OneToMany(mappedBy="workspaceBanco", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<WorkspaceBancoOp> opcoesOp = new LinkedList<WorkspaceBancoOp>();
    @OneToMany(mappedBy="workspaceBanco", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<WorkspaceBancoAuthOp> opcoesAuthOp = new LinkedList<WorkspaceBancoAuthOp>();

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Short getAtivo() {
        return this.ativo;
    }

    @Generated
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Generated
    public Date getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public GrupoEmpresa getGrupoEmpresa() {
        return this.grupoEmpresa;
    }

    @Generated
    public InstituicaoValores getInstituicaoValores() {
        return this.instituicaoValores;
    }

    @Generated
    public CarteiraCobranca getCarteiraPrincipal() {
        return this.carteiraPrincipal;
    }

    @Generated
    public ConfiguracaoCertificado getConfiguracaoCertificado() {
        return this.configuracaoCertificado;
    }

    @Generated
    public String getWorkspaceBancoId() {
        return this.workspaceBancoId;
    }

    @Generated
    public String getWebhookURL() {
        return this.webhookURL;
    }

    @Generated
    public Short getPagRec() {
        return this.pagRec;
    }

    @Generated
    public List<WorkspaceBancoOp> getOpcoesOp() {
        return this.opcoesOp;
    }

    @Generated
    public List<WorkspaceBancoAuthOp> getOpcoesAuthOp() {
        return this.opcoesAuthOp;
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Generated
    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Generated
    public void setDataAtualizacao(Date dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setGrupoEmpresa(GrupoEmpresa grupoEmpresa) {
        this.grupoEmpresa = grupoEmpresa;
    }

    @Generated
    public void setInstituicaoValores(InstituicaoValores instituicaoValores) {
        this.instituicaoValores = instituicaoValores;
    }

    @Generated
    public void setCarteiraPrincipal(CarteiraCobranca carteiraPrincipal) {
        this.carteiraPrincipal = carteiraPrincipal;
    }

    @Generated
    public void setConfiguracaoCertificado(ConfiguracaoCertificado configuracaoCertificado) {
        this.configuracaoCertificado = configuracaoCertificado;
    }

    @Generated
    public void setWorkspaceBancoId(String workspaceBancoId) {
        this.workspaceBancoId = workspaceBancoId;
    }

    @Generated
    public void setWebhookURL(String webhookURL) {
        this.webhookURL = webhookURL;
    }

    @Generated
    public void setPagRec(Short pagRec) {
        this.pagRec = pagRec;
    }

    @Generated
    public void setOpcoesOp(List<WorkspaceBancoOp> opcoesOp) {
        this.opcoesOp = opcoesOp;
    }

    @Generated
    public void setOpcoesAuthOp(List<WorkspaceBancoAuthOp> opcoesAuthOp) {
        this.opcoesAuthOp = opcoesAuthOp;
    }
}

