/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.rules.totalizadoresitemgrade;

import com.touchcomp.basementor.model.vo.ComunicadoProducao;
import com.touchcomp.basementor.model.vo.ImplantacaoSaldos;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.TransferenciaCentroEstoque;
import com.touchcomp.basementor.model.vo.WmsEntradaEstoque;
import com.touchcomp.basementor.model.vo.WmsPedido;
import com.touchcomp.basementor.model.vo.WmsSeparacaoPedido;
import com.touchcomp.basementor.model.vo.WmsSeparacaoPedidoEmb;
import com.touchcomp.basementor.model.vo.WmsSeparacaoPedidoGrConf;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.CompTotaisItemGrade;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.CompTotaisItemGradeComparer;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.adapter.AdpComunicadoProducao;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.adapter.AdpImplantacaoSaldos;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.adapter.AdpNotaFiscalPropria;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.adapter.AdpNotaFiscalTerceiros;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.adapter.AdpPedidoWms;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.adapter.AdpWmsEntradaEstoque;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.adapter.AdpWmsSeparacaoEmb;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.adapter.AdpWmsTransferenciaCentroEstoque;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.model.TotalItemDiferencas;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.model.TotalItemGrade;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.model.TotalItemGradeLoteFabricacao;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompTotaisItemGradesAdp {
    @Autowired
    CompTotaisItemGrade compTotItemGrade;

    public List<TotalItemGrade> getTotaisGrades(WmsPedido vo) {
        return this.compTotItemGrade.getTotaisGrades(new AdpPedidoWms(vo).getItens());
    }

    public List<TotalItemGradeLoteFabricacao> getTotaisGradesLotes(WmsEntradaEstoque vo) {
        return this.compTotItemGrade.getTotaisGradesLoteFabricacao(new AdpWmsEntradaEstoque(vo));
    }

    public List<TotalItemGradeLoteFabricacao> getTotaisGradesLotes(TransferenciaCentroEstoque vo) {
        return this.compTotItemGrade.getTotaisGradesLoteFabricacao(new AdpWmsTransferenciaCentroEstoque(vo));
    }

    public List<TotalItemGradeLoteFabricacao> getTotaisGradesLotes(ComunicadoProducao vo) {
        return this.compTotItemGrade.getTotaisGradesLoteFabricacao(new AdpComunicadoProducao(vo));
    }

    public List<TotalItemGradeLoteFabricacao> getTotaisGradesLotes(ImplantacaoSaldos vo) {
        return this.compTotItemGrade.getTotaisGradesLoteFabricacao(new AdpImplantacaoSaldos(vo));
    }

    public List<TotalItemGrade> getTotaisGrades(WmsSeparacaoPedidoEmb embalagem) {
        return this.getTotaisGrades(embalagem, new LinkedList<TotalItemGrade>());
    }

    public List<TotalItemGrade> getTotaisGrades(WmsSeparacaoPedidoEmb embalagem, List<TotalItemGrade> totais) {
        if (embalagem.getGradesConf() == null) {
            embalagem.setGradesConf(new LinkedList<WmsSeparacaoPedidoGrConf>());
        }
        LinkedList<AdpWmsSeparacaoEmb> itensGrades = new LinkedList<AdpWmsSeparacaoEmb>();
        for (WmsSeparacaoPedidoGrConf grade : embalagem.getGradesConf()) {
            AdpWmsSeparacaoEmb gi = new AdpWmsSeparacaoEmb(grade);
            itensGrades.add(gi);
        }
        return this.compTotItemGrade.getTotaisGrades(itensGrades, totais);
    }

    public List<TotalItemGrade> getTotaisGrades(WmsSeparacaoPedido pedido) {
        LinkedList<TotalItemGrade> itensGrades = new LinkedList<TotalItemGrade>();
        for (WmsSeparacaoPedidoEmb emb : pedido.getEmbalagens()) {
            this.getTotaisGrades(emb, itensGrades);
        }
        return itensGrades;
    }

    public List<TotalItemGradeLoteFabricacao> getTotaisGradesLotes(NotaFiscalTerceiros vo) {
        return this.compTotItemGrade.getTotaisGradesLoteFabricacao(new AdpNotaFiscalTerceiros(vo));
    }

    public List<TotalItemGradeLoteFabricacao> getTotaisGradesLotes(NotaFiscalPropria vo) {
        return this.compTotItemGrade.getTotaisGradesLoteFabricacao(new AdpNotaFiscalPropria(vo));
    }

    public void calcularTotalizadores(WmsPedido vo) {
        this.compTotItemGrade.calcularTotalizadores(new AdpPedidoWms(vo));
    }

    public void calcularTotalizadores(ComunicadoProducao vo) {
        this.compTotItemGrade.calcularTotalizadores(new AdpComunicadoProducao(vo));
    }

    public void calcularTotalizadores(ImplantacaoSaldos vo) {
        this.compTotItemGrade.calcularTotalizadores(new AdpImplantacaoSaldos(vo));
    }

    public void calcularTotalizadores(NotaFiscalPropria vo) {
        this.compTotItemGrade.calcularTotalizadores(new AdpNotaFiscalPropria(vo));
    }

    public void calcularTotalizadores(NotaFiscalTerceiros vo) {
        this.compTotItemGrade.calcularTotalizadores(new AdpNotaFiscalTerceiros(vo));
    }

    public void calcularTotalizadores(WmsEntradaEstoque vo) {
        this.compTotItemGrade.calcularTotalizadores(new AdpWmsEntradaEstoque(vo));
    }

    public boolean isEquals(List<TotalItemGradeLoteFabricacao> listaItens1, List<TotalItemGradeLoteFabricacao> listaItens2) {
        return new CompTotaisItemGradeComparer().isEquals(listaItens1, listaItens2);
    }

    public List<TotalItemDiferencas<TotalItemGradeLoteFabricacao>> getItensComDiferenca(List<TotalItemGradeLoteFabricacao> listaItens1, List<TotalItemGradeLoteFabricacao> listaItens2) {
        return new CompTotaisItemGradeComparer().getItensComDiferenca(listaItens1, listaItens2);
    }
}

