/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.rules.totalizadoresitemgrade.impl;

import com.touchcomp.basementor.model.vo.WmsEntradaEstoque;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.CompTotaisItemGradesAdp;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.model.TotalItemDiferencas;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.model.TotalItemGradeLoteFabricacao;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RulesWmsEntradaProdutos {
    @Autowired
    CompTotaisItemGradesAdp compTotaisItemGrade;

    public List<TotalItemDiferencas<TotalItemGradeLoteFabricacao>> getResumoItensDiferenca(WmsEntradaEstoque wmsEntrada, boolean retornaVazioSeSemOrigem) {
        List<TotalItemGradeLoteFabricacao> itensOrigem = this.getResumoItens(wmsEntrada);
        if (itensOrigem.isEmpty() && retornaVazioSeSemOrigem) {
            return new LinkedList<TotalItemDiferencas<TotalItemGradeLoteFabricacao>>();
        }
        List<TotalItemGradeLoteFabricacao> itensAtual = this.compTotaisItemGrade.getTotaisGradesLotes(wmsEntrada);
        List<TotalItemDiferencas<TotalItemGradeLoteFabricacao>> m = this.compTotaisItemGrade.getItensComDiferenca(itensOrigem, itensAtual);
        return m;
    }

    public List<TotalItemGradeLoteFabricacao> getResumoItens(WmsEntradaEstoque wmsEntrada) {
        List<Object> itens = new LinkedList();
        if (wmsEntrada.getComunicadoProducao() != null) {
            itens = this.compTotaisItemGrade.getTotaisGradesLotes(wmsEntrada.getComunicadoProducao());
        }
        if (wmsEntrada.getImplantacaoSaldos() != null) {
            itens = this.compTotaisItemGrade.getTotaisGradesLotes(wmsEntrada.getImplantacaoSaldos());
        }
        if (wmsEntrada.getNotaFiscalTerceiros() != null) {
            itens = this.compTotaisItemGrade.getTotaisGradesLotes(wmsEntrada.getNotaFiscalTerceiros());
        }
        if (wmsEntrada.getNotaFiscalPropria() != null) {
            itens = this.compTotaisItemGrade.getTotaisGradesLotes(wmsEntrada.getNotaFiscalPropria());
        }
        if (wmsEntrada.getTransferenciaEstEntrada() != null) {
            itens = this.compTotaisItemGrade.getTotaisGradesLotes(wmsEntrada.getTransferenciaEstEntrada());
        }
        return itens;
    }
}

