/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.certificado;

import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificadoItem;
import com.touchcomp.basementorclientwebservices.constants.EnumTipoCertificado;
import com.touchcomp.basementorexceptions.exceptions.impl.certificado.EnumCertificado;
import com.touchcomp.basementorexceptions.exceptions.impl.certificado.ExceptionCertificado;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementortools.tools.certificado.ToolCertificadoSocketFactTrustAll;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.exception.ToolException;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class CertificadoConfClienteWebservice {
    private Provider provider;
    private CeritifificadoParams params;
    private static final int SSL_PORT = 443;
    private static boolean configurado = false;
    private static CertificadoConfClienteWebservice instance = null;

    public static void destroy() {
        instance = null;
        configurado = false;
    }

    public static CertificadoConfClienteWebservice getConfiguracaoCertificado() throws ExceptionCertificado {
        if (instance == null) {
            throw new ExceptionCertificado(EnumCertificado.CERTIFICADO_NAO_CONFIGURADO, new Object[0]);
        }
        return instance;
    }

    public static boolean isConfigured() {
        return configurado;
    }

    public static void configure(ConfiguracaoCertificado conf) throws ExceptionCertificado {
        if (CertificadoConfClienteWebservice.isConfigured()) {
            return;
        }
        CertificadoConfClienteWebservice.configure(CertificadoConfClienteWebservice.configureParamsCertification(conf));
    }

    private static CeritifificadoParams configureParamsCertification(ConfiguracaoCertificado conf) throws ExceptionCertificado {
        CeritifificadoParams params = new CeritifificadoParams();
        if (ToolMethods.isNotNull((Object)conf.getArquivoPFX()).booleanValue()) {
            params.setPathCertificadoA1(conf.getArquivoPFX());
        }
        if (ToolMethods.isNotNull((Object)conf.getArquivoCFGToken()).booleanValue()) {
            params.setPathCfgTokenA3(conf.getArquivoCFGToken());
        }
        params.setSenhaCertificado(conf.getSenha());
        params.setTipoCertificado(EnumTipoCertificado.toEnum(conf.getTipoCertificado().shortValue()));
        HashMap<String, String> h = new HashMap<String, String>();
        for (ConfiguracaoCertificadoItem item : conf.getItensConfCertificado()) {
            h.put(item.getPropCertificadoConexao().getPropriedade(), item.getPropCertificadoConexao().getValorPropriedade());
        }
        params.setOutrasPropriedades(h);
        return params;
    }

    public static void configure(CeritifificadoParams parametros) throws ExceptionCertificado {
        instance = new CertificadoConfClienteWebservice();
        CertificadoConfClienteWebservice.instance.params = parametros;
        instance.configuraCertificado(parametros);
        configurado = true;
    }

    private void configuraCertificado(CeritifificadoParams params) throws ExceptionCertificado {
        try {
            this.informadoParametros(params);
            this.setPropriedades(params.getOutrasPropriedades());
            if (params.getTipoCertificado() == EnumTipoCertificado.CERTIFICADO_A3) {
                this.configuraA3(params);
            } else {
                X509Certificate cert = this.configureCertificado(params);
                this.checarValidadeCertificado(cert.getNotAfter(), cert.getNotBefore());
                this.configuraA1(params);
            }
        }
        catch (ExceptionCertificado ex) {
            this.tryToDetectExceptionCause(ex);
        }
    }

    private void setPropriedades(Map<String, String> props) {
        if (props == null) {
            return;
        }
        for (String str : props.keySet()) {
            System.setProperty(str, props.get(str));
        }
    }

    private void configuraA3(CeritifificadoParams params) throws ExceptionCertificado {
        try {
            File f = ToolFile.createTempFile((String)"token.cfg");
            ToolFile.writeBytesOnFile((File)f, (byte[])params.getPathCfgTokenA3());
            Provider p = Security.getProvider("SunPKCS11");
            p = p.configure(f.getAbsolutePath());
            Security.addProvider(p);
            char[] pin = params.getSenhaCertificado().toCharArray();
            KeyStore ks = KeyStore.getInstance("pkcs11", this.provider);
            ks.load(null, pin);
            this.configuraSocketFactoryDinamico(ks, params.getSenhaCertificado());
        }
        catch (KeyStoreException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (IOException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (UnrecoverableKeyException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (CertificateException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (ExceptionIO ex) {
            throw new ExceptionCertificado(ex);
        }
    }

    private void configuraA1(CeritifificadoParams params) throws ExceptionCertificado {
        this.provider = null;
        this.configuraSocketFactoryDinamico(params.getPathCertificadoA1(), params.getSenhaCertificado());
    }

    private void informadoParametros(CeritifificadoParams params) throws ExceptionCertificado {
        if (params.getTipoCertificado() == null) {
            throw new ExceptionCertificado(EnumCertificado.TIPO_CERTIFICADO_A1_A3_NAO_INFORMADO, new Object[0]);
        }
        if (params.getSenhaCertificado() == null) {
            throw new ExceptionCertificado(EnumCertificado.SENHA_NAO_INFORMADA, new Object[0]);
        }
        if (params.getTipoCertificado() == EnumTipoCertificado.CERTIFICADO_A1) {
            if (params.getPathCertificadoA1() == null || params.getPathCertificadoA1().length == 0) {
                throw new ExceptionCertificado(EnumCertificado.PATH_CERTIFICADO_A1_INVALIDO, new Object[]{params.getPathCfgTokenA3()});
            }
        } else if (params.getPathCfgTokenA3() == null || params.getPathCfgTokenA3().length == 0) {
            throw new ExceptionCertificado(EnumCertificado.PATH_CFG_TOKEN_INVALIDO, new Object[]{params.getPathCfgTokenA3()});
        }
    }

    public void checaCertificado(ConfiguracaoCertificado conf) throws ExceptionCertificado {
        X509Certificate cert = this.configureCertificado(CertificadoConfClienteWebservice.configureParamsCertification(conf));
        this.checarValidadeCertificado(cert.getNotAfter(), cert.getNotBefore());
    }

    private void checarValidadeCertificado(Date notAfter, Date notBefore) throws ExceptionCertificado {
        if (notAfter.before(new Date())) {
            throw new ExceptionCertificado(EnumCertificado.CERTIFICADO_VENCIDO_FORA_DATA, new Object[]{ToolDate.dateToStr((Date)notAfter, (String)"dd/MM/yyyy hh:mm:ss")});
        }
        if (notBefore.after(new Date())) {
            throw new ExceptionCertificado(EnumCertificado.CERTIFICADO_VENCIDO_FORA_DATA, new Object[]{ToolDate.dateToStr((Date)notBefore, (String)"dd/MM/yyyy hh:mm:ss")});
        }
    }

    public Date getDataExpiracao(ConfiguracaoCertificado conf) throws ExceptionCertificado {
        X509Certificate cert = this.configureCertificado(CertificadoConfClienteWebservice.configureParamsCertification(conf));
        return cert.getNotAfter();
    }

    private X509Certificate configureCertificado(CeritifificadoParams params) throws ExceptionCertificado {
        try {
            KeyStore ks;
            if (params.getTipoCertificado() == EnumTipoCertificado.CERTIFICADO_A3) {
                ks = KeyStore.getInstance("pkcs11", this.getProvider());
                ks.load(null, params.getSenhaCertificado().toCharArray());
            } else {
                ks = KeyStore.getInstance("PKCS12");
                ks.load(new ByteArrayInputStream(params.getPathCertificadoA1()), params.getSenhaCertificado().toCharArray());
            }
            KeyStore.PrivateKeyEntry pkEntry = null;
            Enumeration<String> aliasesEnum = ks.aliases();
            while (aliasesEnum.hasMoreElements()) {
                String alias = aliasesEnum.nextElement();
                System.out.println(alias);
                if (!ks.isKeyEntry(alias)) continue;
                pkEntry = (KeyStore.PrivateKeyEntry)ks.getEntry(alias, new KeyStore.PasswordProtection(params.getSenhaCertificado().toCharArray()));
                break;
            }
            X509Certificate cert = (X509Certificate)pkEntry.getCertificate();
            return cert;
        }
        catch (FileNotFoundException ex) {
            throw new ExceptionCertificado((IOException)ex);
        }
        catch (IOException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (CertificateException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (KeyStoreException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (UnrecoverableEntryException ex) {
            throw new ExceptionCertificado(ex);
        }
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void configuraSocketFactoryDinamico(byte[] certificado, String senhaCertificado) throws ExceptionCertificado {
        ByteArrayInputStream entrada = null;
        try {
            entrada = new ByteArrayInputStream(certificado);
            KeyStore ks = KeyStore.getInstance("pkcs12");
            ks.load(entrada, senhaCertificado.toCharArray());
            this.configuraSocketFactoryDinamico(ks, senhaCertificado);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (CertificateException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (FileNotFoundException ex) {
            throw new ExceptionCertificado((IOException)ex);
        }
        catch (KeyStoreException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (UnrecoverableKeyException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (IOException ex) {
            throw new ExceptionCertificado(ex);
        }
        finally {
            try {
                if (entrada != null) {
                    entrada.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void configuraSocketFactoryDinamico(KeyStore ks, String senhaCertificado) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String alias = "";
        Enumeration<String> aliasesEnum = ks.aliases();
        while (aliasesEnum.hasMoreElements() && !ks.isKeyEntry(alias = aliasesEnum.nextElement())) {
        }
        X509Certificate certificate = (X509Certificate)ks.getCertificate(alias);
        PrivateKey privateKey = (PrivateKey)ks.getKey(alias, senhaCertificado.toCharArray());
        ToolCertificadoSocketFactTrustAll socketFactoryDinamico = new ToolCertificadoSocketFactTrustAll(certificate, privateKey);
        Protocol protocol = new Protocol("https", (ProtocolSocketFactory)socketFactoryDinamico, 443);
        Protocol.registerProtocol((String)"https", (Protocol)protocol);
    }

    private void tryToDetectExceptionCause(ExceptionCertificado ex) throws ExceptionCertificado {
        if (ToolException.findMessage((Throwable)ex, (String)"CKR_PIN_LOCKED").booleanValue()) {
            throw new ExceptionCertificado(EnumCertificado.CKR_PIN_LOCKED, new Object[]{ex});
        }
        if (ToolException.findMessage((Throwable)ex, (String)"CKR_PIN_INCORRECT").booleanValue()) {
            throw new ExceptionCertificado(EnumCertificado.CKR_PIN_INCORRECT, new Object[]{ex});
        }
        if (ToolException.findMessage((Throwable)ex, (String)"password").booleanValue()) {
            throw new ExceptionCertificado(EnumCertificado.CKR_PIN_INCORRECT, new Object[]{ex});
        }
        if (ToolException.findMessage((Throwable)ex, (String)"CKR_PIN_INVALID").booleanValue()) {
            throw new ExceptionCertificado(EnumCertificado.CKR_PIN_INVALID, new Object[]{ex});
        }
        if (ToolException.findMessage((Throwable)ex, (String)"CKR_PIN_EXPIRED").booleanValue()) {
            throw new ExceptionCertificado(EnumCertificado.CKR_PIN_EXPIRED, new Object[]{ex});
        }
        if (ToolException.findMessage((Throwable)ex, (String)"CKR_SLOT_ID_INVALID").booleanValue()) {
            throw new ExceptionCertificado(EnumCertificado.CKR_SLOT_ID_INVALID, new Object[]{ex});
        }
        if (ToolException.findMessage((Throwable)ex, (String)"CKR_GENERAL_ERROR").booleanValue()) {
            throw new ExceptionCertificado(EnumCertificado.CKR_GENERAL_ERROR, new Object[]{ex});
        }
        if (ToolException.findMessage((Throwable)ex, (String)"CKR_ARGUMENTS_BAD").booleanValue()) {
            throw new ExceptionCertificado(EnumCertificado.CKR_ARGUMENTS_BAD, new Object[]{ex});
        }
        if (ToolException.findMessage((Throwable)ex, (String)"CKR_DATA_INVALID").booleanValue()) {
            throw new ExceptionCertificado(EnumCertificado.CKR_DATA_INVALID, new Object[]{ex});
        }
        if (ToolException.findMessage((Throwable)ex, (String)"CKR_DEVICE_ERROR").booleanValue()) {
            throw new ExceptionCertificado(EnumCertificado.CKR_DEVICE_ERROR, new Object[]{ex});
        }
        if (ToolException.findMessage((Throwable)ex, (String)"CKR_DEVICE_MEMORY").booleanValue()) {
            throw new ExceptionCertificado(EnumCertificado.CKR_DEVICE_MEMORY, new Object[]{ex});
        }
        if (ToolException.findMessage((Throwable)ex, (String)"CKR_DEVICE_REMOVED").booleanValue()) {
            throw new ExceptionCertificado(EnumCertificado.CKR_DEVICE_REMOVED, new Object[]{ex});
        }
        throw ex;
    }

    public CeritifificadoParams getParams() {
        return this.params;
    }

    public static class CeritifificadoParams {
        private EnumTipoCertificado tipoCertificado;
        private byte[] pathCertificadoA1;
        private byte[] pathCfgTokenA3;
        private String senhaCertificado;
        private String aliasCertificado;
        private Map<String, String> outrasPropriedades = new HashMap<String, String>();

        public EnumTipoCertificado getTipoCertificado() {
            return this.tipoCertificado;
        }

        public void setTipoCertificado(EnumTipoCertificado tipoCertificado) {
            this.tipoCertificado = tipoCertificado;
        }

        public byte[] getPathCertificadoA1() {
            return this.pathCertificadoA1;
        }

        public void setPathCertificadoA1(byte[] pathCertificadoA1) {
            this.pathCertificadoA1 = pathCertificadoA1;
        }

        public String getSenhaCertificado() {
            return this.senhaCertificado;
        }

        public void setSenhaCertificado(String senhaCertificado) {
            this.senhaCertificado = senhaCertificado;
        }

        public byte[] getPathCfgTokenA3() {
            return this.pathCfgTokenA3;
        }

        public void setPathCfgTokenA3(byte[] pathCfgTokenA3) {
            this.pathCfgTokenA3 = pathCfgTokenA3;
        }

        public String getAliasCertificado() {
            return this.aliasCertificado;
        }

        public void setAliasCertificado(String aliasCertificado) {
            this.aliasCertificado = aliasCertificado;
        }

        public Map<String, String> getOutrasPropriedades() {
            return this.outrasPropriedades;
        }

        public void setOutrasPropriedades(Map<String, String> outrasPropriedades) {
            this.outrasPropriedades = outrasPropriedades;
        }
    }
}

