/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.certificado;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementorclientwebservices.certificado.model.ParamsCertificado;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class CertificadoConfigCTe
extends CTeConfig {
    private final ParamsCertificado paramsCertificado;
    private final String codIbgeUF;

    public CertificadoConfigCTe(ParamsCertificado paramsCertificado, String codIbgeUF) {
        this.paramsCertificado = paramsCertificado;
        this.codIbgeUF = codIbgeUF;
    }

    public DFUnidadeFederativa getCUF() {
        return DFUnidadeFederativa.valueOfCodigo((String)this.codIbgeUF);
    }

    public KeyStore getCertificadoKeyStore() throws KeyStoreException {
        try {
            KeyStore keyStoreCertificado = KeyStore.getInstance("PKCS12");
            keyStoreCertificado.load(new ByteArrayInputStream(this.paramsCertificado.getKeystoreCertificado()), this.getCertificadoSenha().toCharArray());
            return keyStoreCertificado;
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new KeyStoreException("Nao foi possivel montar o KeyStore com a cadeia de certificados", e);
        }
    }

    public String getCertificadoSenha() {
        return this.paramsCertificado.getSenhaCertificado();
    }

    public KeyStore getCadeiaCertificadosKeyStore() throws KeyStoreException {
        try {
            KeyStore keyStoreCertificado = KeyStore.getInstance("JKS");
            keyStoreCertificado.load(new ByteArrayInputStream(this.paramsCertificado.getKeystoreCadeia()), this.getCadeiaCertificadosSenha().toCharArray());
            return keyStoreCertificado;
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new KeyStoreException("Nao foi possivel montar o KeyStore com a cadeia de certificados", e);
        }
    }

    public String getCadeiaCertificadosSenha() {
        return this.paramsCertificado.getSenhaKeystore();
    }

    public DFAmbiente getAmbiente() {
        return ToolMethods.isEquals((Object)this.paramsCertificado.getAmbiente(), (Object)ConstAmbiente.PRODUCAO) ? DFAmbiente.PRODUCAO : DFAmbiente.HOMOLOGACAO;
    }
}

