/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.certificado;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementorclientwebservices.certificado.model.ParamsCertificado;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class CertificadoConfigNFeCTe
extends NFeConfig {
    private final ParamsCertificado paramsCertificado;
    private final String codIbgeUF;

    public CertificadoConfigNFeCTe(ParamsCertificado paramsCertificado, String codIbgeUF) {
        this.paramsCertificado = paramsCertificado;
        this.codIbgeUF = codIbgeUF;
    }

    public DFUnidadeFederativa getCUF() {
        return DFUnidadeFederativa.valueOfCodigo((String)this.codIbgeUF);
    }

    public KeyStore getCertificadoKeyStore() throws KeyStoreException {
        try {
            if (this.paramsCertificado.getKeystoreCertificado() == null) {
                throw new KeyStoreException(MessagesBaseMentor.getErrorMsg((String)"E.GEN.000059", (Object[])new Object[0]));
            }
            KeyStore keyStoreCertificado = KeyStore.getInstance("PKCS12");
            keyStoreCertificado.load(new ByteArrayInputStream(this.paramsCertificado.getKeystoreCertificado()), this.getCertificadoSenha().toCharArray());
            return keyStoreCertificado;
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            TLogger.get(((Object)((Object)this)).getClass()).error((Throwable)e);
            throw new KeyStoreException(MessagesBaseMentor.getErrorMsg((String)"E.GEN.000059", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public String getCertificadoSenha() {
        return this.paramsCertificado.getSenhaCertificado();
    }

    public KeyStore getCadeiaCertificadosKeyStore() throws KeyStoreException {
        if (this.paramsCertificado.getKeystoreCadeia() == null) {
            throw new KeyStoreException(MessagesBaseMentor.getErrorMsg((String)"E.GEN.000058", (Object[])new Object[0]));
        }
        try {
            KeyStore keyStoreCertificado = KeyStore.getInstance("JKS");
            keyStoreCertificado.load(new ByteArrayInputStream(this.paramsCertificado.getKeystoreCadeia()), this.getCadeiaCertificadosSenha().toCharArray());
            return keyStoreCertificado;
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            TLogger.get(((Object)((Object)this)).getClass()).error((Throwable)e);
            throw new KeyStoreException(MessagesBaseMentor.getErrorMsg((String)"E.GEN.000058", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public String getCadeiaCertificadosSenha() {
        return this.paramsCertificado.getSenhaKeystore();
    }

    public DFAmbiente getAmbiente() {
        return this.paramsCertificado.getAmbiente().equals((Object)ConstAmbiente.PRODUCAO) ? DFAmbiente.PRODUCAO : DFAmbiente.HOMOLOGACAO;
    }
}

