/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.components;

import com.touchcomp.basementor.model.vo.CotacaoMoeda;
import com.touchcomp.basementorclientwebservices.cotacaomoedabancocentral.ClienteBCB;
import com.touchcomp.basementorexceptions.exceptions.impl.jdom.ExceptionJDom;
import com.touchcomp.basementorexceptions.exceptions.impl.moeda.EnumExcepCotacaoMoeda;
import com.touchcomp.basementorexceptions.exceptions.impl.moeda.ExceptionCotacaoMoeda;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.jdom.ToolJdom;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.jdom2.Element;
import org.springframework.stereotype.Component;

@Component
public class DocCotacaoMoedaBancoCentral {
    public CotacaoMoeda getUltCotacao(Integer codModedaBC) throws ExceptionCotacaoMoeda {
        try {
            if (codModedaBC == null) {
                throw new ExceptionCotacaoMoeda(EnumExcepCotacaoMoeda.COD_MOEDA_BC_NAO_INFORMADO, new Object[0]);
            }
            ClienteBCB c = ClienteBCB.getInstance();
            String xml = c.getUltimoValorXML(codModedaBC.intValue());
            Element root = ToolJdom.getRootElement((String)xml);
            Element serie = root.getChild("SERIE");
            Element valor = serie.getChild("VALOR");
            Object dia = serie.getChild("DATA").getChildText("DIA");
            Object mes = serie.getChild("DATA").getChildText("MES");
            String ano = serie.getChild("DATA").getChildText("ANO");
            if (((String)dia).trim().length() == 1) {
                dia = "0" + (String)dia;
            }
            if (((String)mes).trim().length() == 1) {
                mes = "0" + (String)mes;
            }
            Date dataCotacao = ToolDate.strToDate((String)((String)dia + (String)mes + ano), (String)"ddMMyyyy");
            CotacaoMoeda cot = new CotacaoMoeda();
            cot.setDataCotacao(dataCotacao);
            DecimalFormat nf = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(new Locale("pt", "BR")));
            try {
                Double valorCot = nf.parse(valor.getText()).doubleValue();
                cot.setValor(valorCot);
                return cot;
            }
            catch (ParseException ex) {
                throw new ExceptionCotacaoMoeda(ex, new Object[]{valor.getText()});
            }
        }
        catch (ExceptionJDom ex) {
            throw new ExceptionCotacaoMoeda(ex);
        }
    }

    public Double getValor(Integer codModedaBC, String data) throws ExceptionCotacaoMoeda {
        if (codModedaBC == null) {
            throw new ExceptionCotacaoMoeda(EnumExcepCotacaoMoeda.COD_MOEDA_BC_NAO_INFORMADO, new Object[0]);
        }
        ClienteBCB c = ClienteBCB.getInstance();
        String valor = c.getValor(codModedaBC.intValue(), data);
        if (valor != null) {
            return Double.parseDouble(valor);
        }
        return 0.0;
    }
}

