/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.consultapessoas.impl;

import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.cadastro.NFRetornoConsultaCadastro;
import com.fincatto.documentofiscal.nfe400.classes.cadastro.NFRetornoConsultaCadastroDados;
import com.fincatto.documentofiscal.nfe400.classes.cadastro.NFRetornoConsultaCadastroEndereco;
import com.fincatto.documentofiscal.nfe400.classes.cadastro.NFRetornoConsultaCadastroSituacaoCadastral;
import com.fincatto.documentofiscal.nfe400.webservices.WSFacade;
import com.touchcomp.basementorclientwebservices.certificado.CertificadoConfigNFeCTe;
import com.touchcomp.basementorclientwebservices.consultapessoas.WEBConsultaPessoas;
import com.touchcomp.basementorclientwebservices.consultapessoas.constants.ConstEnumConsultaPessoasRegTrib;
import com.touchcomp.basementorclientwebservices.consultapessoas.model.DTOConsultaPessoaParams;
import com.touchcomp.basementorclientwebservices.consultapessoas.model.DTOConsutalPessoaResp;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.time.LocalDate;

public class WEBConsultaPessoaSefaz {
    public DTOConsutalPessoaResp consultaDados(DTOConsultaPessoaParams param, WEBConsultaPessoas.Config config) throws ExceptionIO, ExceptionInvalidState {
        if (!ToolMethods.isStrWithData((String)param.getCodigoUF())) {
            throw new ExceptionInvalidState("E.ERP.0047.050", new Object[0]);
        }
        if (config.getParamsCertificado() == null) {
            throw new ExceptionInvalidState("E.ERP.0047.051", new Object[0]);
        }
        if (config.getParamsCertificado().getKeystoreCadeia() == null) {
            throw new ExceptionInvalidState("E.ERP.0047.052", new Object[0]);
        }
        if (config.getParamsCertificado().getKeystoreCertificado() == null) {
            throw new ExceptionInvalidState("E.ERP.0047.053", new Object[0]);
        }
        if (!ToolMethods.isStrWithData((String)config.getParamsCertificado().getSenhaCertificado())) {
            throw new ExceptionInvalidState("E.ERP.0047.054", new Object[0]);
        }
        if (!ToolMethods.isStrWithData((String)config.getParamsCertificado().getSenhaKeystore())) {
            throw new ExceptionInvalidState("E.ERP.0047.055", new Object[0]);
        }
        CertificadoConfigNFeCTe nfc = new CertificadoConfigNFeCTe(config.getParamsCertificado(), param.getCodigoUF());
        try {
            NFRetornoConsultaCadastro retorno;
            if (ToolMethods.isStrWithData((String)param.getCpfCnpj())) {
                String cpfCnpj = ToolString.onlyNumbers((String)param.getCpfCnpj());
                retorno = new WSFacade((NFeConfig)nfc).consultaCadastro(cpfCnpj, DFUnidadeFederativa.valueOfCodigo((String)param.getCodigoUF()));
            } else {
                String ie = ToolString.onlyNumbers((String)param.getInscricaoEstadual());
                retorno = new WSFacade((NFeConfig)nfc).consultaCadastroInscEst(ie, DFUnidadeFederativa.valueOfCodigo((String)param.getCodigoUF()));
            }
            NFRetornoConsultaCadastroDados dados = retorno.getDados();
            DTOConsutalPessoaResp resp = new DTOConsutalPessoaResp();
            for (NFRetornoConsultaCadastroSituacaoCadastral sit : dados.getSituacaoCadastral()) {
                DTOConsutalPessoaResp.Pessoa pessoa = new DTOConsutalPessoaResp.Pessoa();
                if (ToolMethods.isStrWithData((String)sit.getCnpj())) {
                    pessoa.setCpfCnpj(sit.getCnpj());
                } else {
                    pessoa.setCpfCnpj(sit.getCpf());
                }
                pessoa.setCnaePrincipal(sit.getCnaePrincipalContribuinte());
                pessoa.setNomeFantasia(sit.getNomeFantasia());
                pessoa.setNome(sit.getRazaoSocial());
                pessoa.setDataInicioAtividades(ToolDate.asDate((LocalDate)sit.getDataInicioAtividade()));
                pessoa.setDataSituacaoCadastral(ToolDate.asDate((LocalDate)sit.getDataUltimaModificacaoSituacaoCadastral()));
                pessoa.setDataOcorrenciaBaixa(ToolDate.asDate((LocalDate)sit.getDataOcorrenciaBaixa()));
                pessoa.setInscricaoEstadual(sit.getInscricaoEstadual());
                pessoa.setInscricaoEstadualAtual(sit.getInscricaoEstadualAtual());
                pessoa.setInscricaoEstadualUnica(sit.getInscricaoEstadualUnica());
                pessoa.setSituacaoContribuinte(sit.getSituacaoContribuinte().toString());
                pessoa.setIndicadorContribuinteNFe(sit.getIndicadorContribuinteNFe().toString());
                pessoa.setIndicadorContribuinteCTe(sit.getIndicaodrContribuinteCTe().toString());
                NFRetornoConsultaCadastroEndereco end = sit.getEndereco();
                DTOConsutalPessoaResp.Endereco endereco = new DTOConsutalPessoaResp.Endereco();
                endereco.setBairro(end.getBairro());
                endereco.setCep(end.getCep());
                endereco.setCodigoMunicipio(end.getCodigoMunicipio());
                endereco.setComplemento(end.getComplemento());
                endereco.setMunicipio(end.getDescricaoMunicipio());
                endereco.setLogradouro(end.getLogradouro());
                endereco.setNumero(end.getNumero());
                endereco.setUf(sit.getUf().getCodigo());
                pessoa.setEndereco(endereco);
                DTOConsutalPessoaResp.Tributacao trib = new DTOConsutalPessoaResp.Tributacao();
                if (sit.getRegimeApuracaoICMSContribuinte().contains("SIMPLES")) {
                    trib.setRegimeTrib(ConstEnumConsultaPessoasRegTrib.SIMPLES);
                } else if (sit.getRegimeApuracaoICMSContribuinte().contains("NORMAL")) {
                    trib.setRegimeTrib(ConstEnumConsultaPessoasRegTrib.NORMAL);
                } else {
                    trib.setRegimeTrib(ConstEnumConsultaPessoasRegTrib.NAO_INFORMADO);
                }
                pessoa.setTributacao(trib);
                resp.getPessoas().add(pessoa);
            }
            return resp;
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionInvalidState("E.ERP.0047.056", (Throwable)ex, new Object[0]);
        }
    }
}

