/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.cotacaomoedabancocentral;

import com.touchcomp.basementorlogger.TLogger;
import java.io.PrintStream;
import java.net.URL;
import java.util.Arrays;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.rpc.client.RPCServiceClient;

class BCBCliente {
    private final TLogger logger = TLogger.get(BCBCliente.class);
    private static final String tns = "https://www3.bcb.gov.br/wssgs/services/FachadaWSSGS";
    private static final String serviceName = "FachadaWSSGSService";
    private static final String portName = "FachadaWSSGS";
    private RPCServiceClient cliente;
    private Class[] types = new Class[1];
    public static final String NEWLINE = System.getProperty("line.separator");

    public BCBCliente() {
        QName q = new QName(tns, serviceName);
        URL u = this.getClass().getClassLoader().getResource("cotacaomoedabc/FachadaWSSGS.wsdl");
        try {
            this.cliente = new RPCServiceClient(null, u, q, portName);
            Options option = this.cliente.getOptions();
            option.setProperty("userAgent", (Object)"neo.BCBCliente");
            option.setProperty("__CHUNKED__", (Object)Boolean.FALSE);
            option.setProperty("REUSE_HTTP_CLIENT", (Object)Boolean.TRUE);
            this.types[0] = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException | AxisFault e) {
            this.logger.error(e.toString());
        }
    }

    private String invoke(QName procedure, Object[] parameters) {
        String result = null;
        try {
            result = (String)this.cliente.invokeBlocking(procedure, parameters, this.types)[0];
        }
        catch (AxisFault e) {
            StringBuilder sb = new StringBuilder(e.getMessage());
            sb.append(NEWLINE).append(NEWLINE).append("Isto ocorreu no \"").append(Thread.currentThread().getStackTrace()[1].getMethodName()).append("\" com par\u00c3\u00a2metros:").append(NEWLINE).append(NEWLINE).append("\t procedure: ").append(procedure.getLocalPart()).append(NEWLINE).append("\tparameters:");
            for (Object par : parameters) {
                sb.append(' ');
                if (par instanceof String) {
                    sb.append((String)par);
                    continue;
                }
                if (par instanceof Long) {
                    sb.append((Long)par);
                    continue;
                }
                if (par.getClass().isArray()) {
                    sb.append(Arrays.toString((long[])par));
                    continue;
                }
                sb.append("UNKNOWN");
            }
            sb.append(NEWLINE);
            this.logger.error(sb.toString());
            result = null;
        }
        return result;
    }

    public String getUltimoValorXML(long code) {
        Object[] parameters = new Object[]{code};
        return this.invoke(new QName(tns, "getUltimoValorXML"), parameters);
    }

    public String get(long code) {
        return this.getUltimoValorXML(code);
    }

    public String getValor(long code, String data) {
        Object[] parameters = new Object[]{code, data};
        return this.invoke(new QName(tns, "getValor"), parameters);
    }

    public String get(long code, String data) {
        return this.getValor(code, data);
    }

    public String getValorEspecial(long code, String dataInicial, String dataFinal) {
        Object[] parameters = new Object[]{code, dataInicial, dataFinal};
        return this.invoke(new QName(tns, "getValorEspecial"), parameters);
    }

    public String get(long code, String dataInicial, String dataFinal) {
        return this.getValorEspecial(code, dataInicial, dataFinal);
    }

    public String getValoresSeriesXML(long[] codes, String dataInicial, String dataFinal) {
        Object[] parameters = new Object[]{codes, dataInicial, dataFinal};
        return this.invoke(new QName(tns, "getValoresSeriesXML"), parameters);
    }

    public String get(long[] codes, String dataInicial, String dataFinal) {
        return this.getValoresSeriesXML(codes, dataInicial, dataFinal);
    }

    public static void main(String[] args) {
        PrintStream out = System.out;
        int n = args.length;
        if (n == 0) {
            out.format("%nPossiveis argumentos:%n%n", new Object[0]);
            out.println("  (1): codigo");
            out.println("  (2): codigo data");
            out.println("  (3): *codigo data_inicial data_final");
            out.println("  (4): codigo(s) data_inicial data_final");
            out.format("%nEm (3) prefixe o codigo para invocar \"GetValorEspecial\".%n", new Object[0]);
            out.format("%nFormatos de datas:%n%n", new Object[0]);
            out.println("  (1): dd/MM/aaaa");
            out.println("  (2): MM/aaaa");
            out.format("%nO formato (2) equivale a 01/MM/aaaa%n%n", new Object[0]);
        } else {
            BCBCliente c = new BCBCliente();
            if (n == 1) {
                long codigo = Long.parseLong(args[0]);
                String xml = c.getUltimoValorXML(codigo);
                out.println(xml);
            } else if (n == 2) {
                long codigo = Long.parseLong(args[0]);
                String data = args[1].replaceAll("^(\\d\\d?/\\d{4})$", "1/$1");
                String valor = c.getValor(codigo, data);
                out.println(valor);
            } else if (n == 3 && args[0].matches("^\\D\\d+$")) {
                long codigo = Long.parseLong(args[0].substring(1));
                String data_ini = args[1].replaceAll("^(\\d\\d?/\\d{4})$", "1/$1");
                String data_fim = args[2].replaceAll("^(\\d\\d?/\\d{4})$", "1/$1");
                String valor = c.getValorEspecial(codigo, data_ini, data_fim);
                out.println(valor);
            } else {
                long[] codigos = new long[n - 2];
                for (int i = 0; i < n - 2; ++i) {
                    codigos[i] = Long.parseLong(args[i]);
                }
                String data_ini = args[n - 2].replaceAll("^(\\d\\d?/\\d{4})$", "1/$1");
                String data_fim = args[n - 1].replaceAll("^(\\d\\d?/\\d{4})$", "1/$1");
                String xml = c.getValoresSeriesXML(codigos, data_ini, data_fim);
                out.println(xml);
            }
        }
    }
}

