/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.cte.cte400.consultacte400.impl;

import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte400.classes.envio.CTeProtocolo;
import com.fincatto.documentofiscal.cte400.classes.envio.CTeProtocoloInfo;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeDetalhamentoEvento;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeEvento;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeEventoRetorno;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeInfoEvento;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeInfoEventoRetorno;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeInformacoesNotaFiscalFacil;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeInformacoesPAA;
import com.fincatto.documentofiscal.cte400.classes.nota.consulta.CTeNotaConsultaRetorno;
import com.fincatto.documentofiscal.cte400.classes.nota.consulta.CTeProtocoloEvento;
import com.fincatto.documentofiscal.cte400.webservices.WSFacade;
import com.touchcomp.basementorclientwebservices.cte.cte400.consultacte400.model.ConsultaCte;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UtilConsultaCte {
    public ConsultaCte consultarCte400(CTeConfig config, String uf) throws Exception {
        return this.consultaCte400(config, uf);
    }

    private ConsultaCte consultaCte400(CTeConfig config, String chave) throws Exception {
        CTeNotaConsultaRetorno retorno = new WSFacade(config).consultaNota(chave);
        ConsultaCte c = new ConsultaCte();
        c.setAmbiente(retorno.getAmbiente());
        c.setMotivo(retorno.getMotivo());
        if (ToolMethods.isNotNull((Object)retorno.getProtocolo()).booleanValue()) {
            c.setProtocolo(this.criarProtocolo(retorno.getProtocolo()));
        }
        if (ToolMethods.isWithData((Collection)retorno.getProtocoloEvento())) {
            c.setProtocoloEvento(this.criarProtocoloEvento(retorno.getProtocoloEvento()));
        }
        c.setStatus(retorno.getStatus());
        c.setUf(retorno.getUf());
        c.setVersao(retorno.getVersao());
        c.setVersaoAplicacao(retorno.getVersaoAplicacao());
        if (ToolMethods.isNotNull((Object)retorno.getProtocolo()).booleanValue()) {
            c.setXmlRecebido(retorno.getProtocolo().getInfo().toString());
        }
        return c;
    }

    private ConsultaCte.CTeProtocolo criarProtocolo(CTeProtocolo protocolo) {
        ConsultaCte.CTeProtocolo c = new ConsultaCte.CTeProtocolo();
        c.setInfo(this.criarInfo(protocolo.getInfo()));
        c.setVersao(protocolo.getVersao());
        return c;
    }

    private ConsultaCte.CTeProtocoloInfo criarInfo(CTeProtocoloInfo info) {
        ConsultaCte.CTeProtocoloInfo c = new ConsultaCte.CTeProtocoloInfo();
        c.setAmbiente(info.getAmbiente());
        c.setChave(info.getChave());
        c.setDataRecebimento(info.getDataRecebimento());
        c.setId(info.getId());
        c.setMotivo(info.getMotivo());
        c.setNumeroProtocolo(info.getNumeroProtocolo());
        c.setStatus(info.getStatus());
        c.setValidador(info.getValidador());
        c.setVersaoAplicacao(info.getVersaoAplicacao());
        return c;
    }

    private List<ConsultaCte.CTeProtocoloEvento> criarProtocoloEvento(List<CTeProtocoloEvento> protocoloEvento) {
        ArrayList<ConsultaCte.CTeProtocoloEvento> list = new ArrayList<ConsultaCte.CTeProtocoloEvento>();
        for (CTeProtocoloEvento cTeProtocoloEvento : protocoloEvento) {
            ConsultaCte.CTeProtocoloEvento c = new ConsultaCte.CTeProtocoloEvento();
            c.setEvento(this.criarEvento(cTeProtocoloEvento.getEvento()));
            c.setEventoRetorno(this.criarEventoRetorno(cTeProtocoloEvento.getEventoRetorno()));
            c.setVersao(cTeProtocoloEvento.getVersao());
            list.add(c);
        }
        return list;
    }

    private ConsultaCte.CTeEvento criarEvento(CTeEvento evento) {
        ConsultaCte.CTeEvento c = new ConsultaCte.CTeEvento();
        c.setInfoEvento(this.criarInfoEvento(evento.getInfoEvento()));
        c.setVersao(evento.getVersao());
        return c;
    }

    private ConsultaCte.CTeInfoEvento criarInfoEvento(CTeInfoEvento infoEvento) {
        ConsultaCte.CTeInfoEvento c = new ConsultaCte.CTeInfoEvento();
        c.setAmbiente(infoEvento.getAmbiente());
        c.setChave(infoEvento.getChave());
        c.setCnpj(infoEvento.getCnpj());
        c.setCodigoEvento(infoEvento.getCodigoEvento());
        c.setCpf(infoEvento.getCpf());
        c.setDataHoraEvento(infoEvento.getDataHoraEvento());
        c.setDetalheEvento(this.criarDetalheEvento(infoEvento.getDetalheEvento()));
        c.setId(infoEvento.getId());
        if (ToolMethods.isNotNull((Object)infoEvento.getInformacoesNotaFiscalFacil()).booleanValue()) {
            c.setInformacoesNotaFiscalFacil(this.criarInformacoesNotaFiscalFacil(infoEvento.getInformacoesNotaFiscalFacil()));
        }
        if (ToolMethods.isNotNull((Object)infoEvento.getInformacoesPAA()).booleanValue()) {
            c.setInformacoesPAA(this.criarInformacoesPAA(infoEvento.getInformacoesPAA()));
        }
        c.setNumeroSequencialEvento(infoEvento.getNumeroSequencialEvento());
        c.setOrgao(infoEvento.getOrgao());
        return c;
    }

    private ConsultaCte.CTeDetalhamentoEvento criarDetalheEvento(CTeDetalhamentoEvento detalheEvento) {
        ConsultaCte.CTeDetalhamentoEvento c = new ConsultaCte.CTeDetalhamentoEvento();
        c.setVersaoEvento(detalheEvento.getVersaoEvento());
        return c;
    }

    private ConsultaCte.CTeInformacoesNotaFiscalFacil criarInformacoesNotaFiscalFacil(CTeInformacoesNotaFiscalFacil informacoesNotaFiscalFacil) {
        ConsultaCte.CTeInformacoesNotaFiscalFacil c = new ConsultaCte.CTeInformacoesNotaFiscalFacil();
        c.setSolicitacao(informacoesNotaFiscalFacil.getSolicitacao());
        return c;
    }

    private ConsultaCte.CTeInformacoesPAA criarInformacoesPAA(CTeInformacoesPAA informacoesPAA) {
        ConsultaCte.CTeInformacoesPAA c = new ConsultaCte.CTeInformacoesPAA();
        c.setCNPJPAA(informacoesPAA.getCNPJPAA());
        return c;
    }

    private ConsultaCte.CTeEventoRetorno criarEventoRetorno(CTeEventoRetorno eventoRetorno) {
        ConsultaCte.CTeEventoRetorno c = new ConsultaCte.CTeEventoRetorno();
        c.setInfoEventoRetorno(this.criarInfoEventoRetorno(eventoRetorno.getInfoEventoRetorno()));
        c.setVersao(eventoRetorno.getVersao());
        return c;
    }

    private ConsultaCte.CTeInfoEventoRetorno criarInfoEventoRetorno(CTeInfoEventoRetorno infoEventoRetorno) {
        ConsultaCte.CTeInfoEventoRetorno c = new ConsultaCte.CTeInfoEventoRetorno();
        c.setAmbiente(infoEventoRetorno.getAmbiente());
        c.setChave(infoEventoRetorno.getChave());
        c.setCodigoStatus(infoEventoRetorno.getCodigoStatus());
        c.setDataHoraRegistro(infoEventoRetorno.getDataHoraRegistro());
        c.setDescricaoEvento(infoEventoRetorno.getDescricaoEvento());
        c.setId(infoEventoRetorno.getId());
        c.setMotivo(infoEventoRetorno.getMotivo());
        c.setNumeroProtocolo(infoEventoRetorno.getNumeroProtocolo());
        c.setNumeroSequencialEvento(infoEventoRetorno.getNumeroSequencialEvento());
        c.setOrgao(infoEventoRetorno.getOrgao());
        c.setTipoEvento(infoEventoRetorno.getTipoEvento());
        c.setVersaoAplicativo(infoEventoRetorno.getVersaoAplicativo());
        return c;
    }
}

