/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.cte.cte400.enviocte400.impl;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.cte.CTTipoEmissao;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte400.classes.CTAutorizador400;
import com.fincatto.documentofiscal.cte400.classes.CTIndicadorTomador;
import com.fincatto.documentofiscal.cte400.classes.CTProcessoEmissao;
import com.fincatto.documentofiscal.cte400.classes.CTTomadorServico;
import com.fincatto.documentofiscal.cte400.classes.envio.CTeEnvioRetorno;
import com.fincatto.documentofiscal.cte400.classes.envio.CTeEnvioRetornoDados;
import com.fincatto.documentofiscal.cte400.classes.envio.CTeProtocolo;
import com.fincatto.documentofiscal.cte400.classes.envio.CTeProtocoloInfo;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNota;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaEndereco;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaEnderecoEmitente;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfo;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoAutorizacaoDownload;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeComplementar;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormal;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalDocumentosAnteriores;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalDocumentosAnterioresEmissorDocumentosAnteriores;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalDocumentosAnterioresEmissorDocumentosAnterioresIdentificacao;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalDocumentosAnterioresEmissorDocumentosAnterioresIdentificacaoEletronico;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalDocumentosAnterioresEmissorDocumentosAnterioresIdentificacaoPapel;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoCTeSubstituicao;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoCarga;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoCargaInformacoesQuantidadeCarga;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoDocumentos;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoDocumentosInfoNF;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoDocumentosInfoNFe;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoDocumentosInfoOutros;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoModal;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoModalAquaviario;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoModalAquaviarioBalsa;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoModalAquaviarioConteiner;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoModalAquaviarioConteinerInfoDocumentos;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoModalAquaviarioConteinerInfoDocumentosNF;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoModalAquaviarioConteinerInfoDocumentosNFe;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoModalAquaviarioConteinerLacre;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoModalRodoviario;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoModalRodoviarioOrdemColetaAssociadas;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoModalRodoviarioOrdemColetaAssociadasEmi;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoServicoVinculado;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoServicoVinculadoInfoCTeMultiModal;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalVeiculosTransportados;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoDadosComplementares;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoDadosComplementaresObservacaoContribuinte;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoDadosComplementaresObservacaoFisco;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoDestinatario;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoEmitente;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoExpedidorCarga;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoIdentificacao;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoIdentificacaoTomadorServico3;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoIdentificacaoTomadorServico4;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoInformacoesRelativasImpostos;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoInformacoesRelativasImpostosICMS;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoInformacoesRelativasImpostosICMS00;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoInformacoesRelativasImpostosICMS20;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoInformacoesRelativasImpostosICMS45;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoInformacoesRelativasImpostosICMS60;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoInformacoesRelativasImpostosICMS90;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoInformacoesRelativasImpostosICMSOutraUF;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoInformacoesRelativasImpostosICMSSN;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoRecebedorCarga;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoRemetente;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoResponsavelTecnico;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoSuplementares;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoValorPrestacaoServico;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoValorPrestacaoServicoComponentesValorPrestacao;
import com.fincatto.documentofiscal.cte400.webservices.WSFacade;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.cte.EnumConstCTeVersao;
import com.touchcomp.basementor.constants.enums.cte.EnumConstTipoAmbienteCTe;
import com.touchcomp.basementor.constants.enums.cte.aquaviario.EnumConstTipoNF;
import com.touchcomp.basementor.constants.enums.cte.sefaz.ConstCTeTipoServico;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstContrEstadoIcms;
import com.touchcomp.basementor.constants.enums.nfe.ConstantsNFeResponsavelTecnico;
import com.touchcomp.basementor.constants.enums.opcoesfaturamentotransp.EnumConstImpressaoObsContribFisco;
import com.touchcomp.basementor.model.vo.CTeAutDownloadXML;
import com.touchcomp.basementor.model.vo.CTeNFe;
import com.touchcomp.basementor.model.vo.CTeOutros;
import com.touchcomp.basementor.model.vo.CTeServVincMultimodal;
import com.touchcomp.basementor.model.vo.CTeVeiculosTransportados;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.CteBalsa;
import com.touchcomp.basementor.model.vo.CteCarga;
import com.touchcomp.basementor.model.vo.CteContainer;
import com.touchcomp.basementor.model.vo.CteInfNotaFiscal;
import com.touchcomp.basementor.model.vo.CteLacre;
import com.touchcomp.basementor.model.vo.CteNf;
import com.touchcomp.basementor.model.vo.CteOrdemColeta;
import com.touchcomp.basementor.model.vo.CteSeguro;
import com.touchcomp.basementor.model.vo.DocAntTransporteCTRC;
import com.touchcomp.basementor.model.vo.DocAntTransporteCTe;
import com.touchcomp.basementor.model.vo.EmissorDocAntCTe;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.FusoHorario;
import com.touchcomp.basementor.model.vo.ItemCte;
import com.touchcomp.basementor.model.vo.ObservacaoEstNota;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoTransp;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementorclientwebservices.cte.cte400.enviocte400.model.EnvioCte;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class UtilEnvioCte {
    public EnvioCte enviarCte400(CTeConfig config, Cte cte, OpcoesFaturamentoTransp opcoesFaturamentoTransp) throws Exception {
        config.setTipoEmissao(CTTipoEmissao.valueOfCodigo((String)cte.getPeriodoEmissaoCte().getTipoEmissaoCTe().getCodigo().toString()));
        return this.envioCte400(config, this.criarCteNota(cte, opcoesFaturamentoTransp));
    }

    private EnvioCte envioCte400(CTeConfig config, CTeNota cteNota) throws Exception {
        CTeEnvioRetornoDados retorno = new WSFacade(config).enviaCTe(cteNota);
        EnvioCte e = new EnvioCte();
        e.setRetorno(this.criarRetorno(retorno.getRetorno()));
        e.setXmlEnvio(retorno.getLoteAssinado().toString());
        if (ToolMethods.isNotNull((Object)retorno.getRetorno().getProtocolo()).booleanValue()) {
            e.setXmlRecebido(retorno.getRetorno().getProtocolo().getInfo().toString());
        }
        return e;
    }

    private EnvioCte.CTeEnvioRetorno criarRetorno(CTeEnvioRetorno retorno) {
        EnvioCte.CTeEnvioRetorno e = new EnvioCte.CTeEnvioRetorno();
        e.setAmbiente(retorno.getAmbiente());
        e.setMotivo(retorno.getMotivo());
        if (ToolMethods.isNotNull((Object)retorno.getProtocolo()).booleanValue()) {
            e.setProtocolo(this.criarProtocolo(retorno.getProtocolo()));
        }
        e.setStatus(retorno.getStatus());
        e.setUf(retorno.getUf());
        e.setVersao(retorno.getVersao());
        e.setVersaoAplicacao(retorno.getVersaoAplicacao());
        return e;
    }

    private EnvioCte.CTeProtocolo criarProtocolo(CTeProtocolo protocolo) {
        EnvioCte.CTeProtocolo e = new EnvioCte.CTeProtocolo();
        e.setInfo(this.criarInfo(protocolo.getInfo()));
        e.setVersao(protocolo.getVersao());
        return e;
    }

    private EnvioCte.CTeProtocoloInfo criarInfo(CTeProtocoloInfo info) {
        EnvioCte.CTeProtocoloInfo e = new EnvioCte.CTeProtocoloInfo();
        e.setAmbiente(info.getAmbiente());
        e.setChave(info.getChave());
        e.setDataRecebimento(info.getDataRecebimento());
        e.setId(info.getId());
        e.setMotivo(info.getMotivo());
        e.setNumeroProtocolo(info.getNumeroProtocolo());
        e.setStatus(info.getStatus());
        e.setValidador(info.getValidador());
        e.setVersaoAplicacao(info.getVersaoAplicacao());
        return e;
    }

    public String criarXmlCteNota(Cte get, OpcoesFaturamentoTransp opcoesFaturamentoTransp) {
        CTeNota c = this.criarCteNota(get, opcoesFaturamentoTransp);
        return c.toString();
    }

    public CTeNota criarCteNota(Cte cte, OpcoesFaturamentoTransp opcoesFaturamentoTransp) {
        CTeNota c = new CTeNota();
        c.setCteNotaInfo(this.criarCteNotaInfo(cte, opcoesFaturamentoTransp));
        c.setInfoSuplementares(this.getInfoSuplementares(cte, opcoesFaturamentoTransp));
        return c;
    }

    private CTeNotaInfo criarCteNotaInfo(Cte cte, OpcoesFaturamentoTransp opcoesFaturamentoTransp) {
        CTeNotaInfo c = new CTeNotaInfo();
        c.setIdentificador(cte.getChaveCte());
        c.setVersao(EnumConstCTeVersao.VERSAO_4_00.getCodigoStr());
        c.setIdentificacao(this.getIdentificacao(cte, opcoesFaturamentoTransp));
        c.setDadosComplementares(this.getDadosComplementares(cte, opcoesFaturamentoTransp));
        c.setEmitente(this.getEmitente(cte));
        if (ToolMethods.isEquals((Object)cte.getIndCteGlobalizado(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) && ToolMethods.isEquals((Object)c.getIdentificacao().getTomadorServico3().getTomadorServico(), (Object)CTTomadorServico.DESTINATARIO.getCodigo())) {
            c.setRemetente(this.getRemetente(c, opcoesFaturamentoTransp));
        } else {
            c.setRemetente(this.getRemetente(cte, opcoesFaturamentoTransp));
        }
        c.setExpedidorCarga(this.getExpedidorCarga(cte, opcoesFaturamentoTransp));
        c.setRecebedorCarga(this.getRecebedorCarga(cte, opcoesFaturamentoTransp));
        if (ToolMethods.isEquals((Object)cte.getIndCteGlobalizado(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) && ToolMethods.isEquals((Object)c.getIdentificacao().getTomadorServico3().getTomadorServico(), (Object)CTTomadorServico.REMETENTE.getCodigo())) {
            c.setDestinatario(this.getDestinatario(c, opcoesFaturamentoTransp));
        } else {
            c.setDestinatario(this.getDestinatario(cte, opcoesFaturamentoTransp));
        }
        c.setValorPrestacaoServico(this.getValorPrestacaoServico(cte));
        c.setInformacoesRelativasImpostos(this.getInformacoesRelativasImpostos(cte));
        if (ToolMethods.isEquals((Object)cte.getTipoCte().getCodigo(), (Object)0) || ToolMethods.isEquals((Object)cte.getTipoCte().getCodigo(), (Object)3)) {
            c.setCteNormal(this.getCteNormal(cte));
        } else if (ToolMethods.isEquals((Object)cte.getTipoCte().getCodigo(), (Object)1)) {
            c.setCteComplementar(this.getCteComplementar(cte));
        }
        c.setAutorizacaoDownload(this.getAutorizacaoDownload(cte));
        c.setInformacaoResposavelTecnico(this.getInformacaoResposavelTecnico(opcoesFaturamentoTransp));
        return c;
    }

    private CTeNotaInfoIdentificacao getIdentificacao(Cte cte, OpcoesFaturamentoTransp opcoesFaturamentoTransp) {
        CTeNotaInfoIdentificacao c = new CTeNotaInfoIdentificacao();
        c.setCodigoUF(DFUnidadeFederativa.valueOf((String)cte.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getSigla()));
        c.setCodigoNumerico(ToolString.completaZeros((String)ToolString.refina((String)cte.getCodChaveAcesso().toString()), (int)8, (boolean)true));
        c.setCfop(ToolString.refina((String)cte.getCfop().getCodigo()));
        c.setNaturezaOperacao(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)cte.getNaturezaOperacao().getDescricao()), (int)60));
        c.setModelo(DFModelo.valueOfCodigo((String)cte.getModeloDocFiscal().getCodigo()));
        c.setSerie(Integer.valueOf(cte.getSerie()));
        c.setNumero(Integer.valueOf(cte.getNumero().intValue()));
        c.setDataEmissao(ToolDate.dateToZonedDateTime((Date)cte.getDataEmissao(), (String)this.formatarFuso(cte.getEmpresa().getEmpresaDados().getTipoFusoHorario(), cte.getEmpresa().getEmpresaDados().getFusoHorario())));
        c.setTipoImpressao(cte.getCteInfo().getFormatoImpressao().toString());
        c.setTipoEmissao(cte.getPeriodoEmissaoCte().getTipoEmissaoCTe().getCodigo().toString());
        c.setDigitoVerificador(cte.getDigitoVerificador());
        c.setAmbiente(opcoesFaturamentoTransp.getTipoAmbiente().toString());
        c.setFinalidade(cte.getTipoCte().getCodigo().toString());
        c.setProcessoEmissao(CTProcessoEmissao.EMISSOR_CONTRIBUINTE.getCodigo());
        c.setVersaoProcessoEmissao("MENTOR_ERP_CTE_400");
        if (ToolMethods.isEquals((Object)cte.getIndCteGlobalizado(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            c.setIndicadorGlobalizado(Integer.valueOf(String.valueOf(cte.getIndCteGlobalizado())));
        }
        c.setCodigoMunicipioEnvio(cte.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getCodIbge() + cte.getEmpresa().getPessoa().getEndereco().getCidade().getCodIbge());
        c.setDescricaoMunicipioEnvio(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)cte.getEmpresa().getPessoa().getEndereco().getCidade().getDescricao()), (int)60));
        c.setSiglaUFEnvio(cte.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getSigla());
        c.setModalidadeFrete(cte.getModalCte().getCodigo());
        c.setTipoServico(cte.getModeloFiscalCte().getTipoServicoCte().getCodigo().toString());
        c.setCodigoMunicipioInicio(cte.getCidadeInicio().getUf().getCodIbge() + cte.getCidadeInicio().getCodIbge());
        c.setDescricaoMunicipioInicio(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)cte.getCidadeInicio().getDescricao()), (int)60));
        c.setSiglaUfInicio(cte.getCidadeInicio().getUf().getSigla());
        c.setCodigoMunicipioFim(cte.getCidadeFim().getUf().getCodIbge() + cte.getCidadeFim().getCodIbge());
        c.setDescricaoMunicipioFim(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)cte.getCidadeFim().getDescricao()), (int)60));
        c.setSiglaUfFim(cte.getCidadeFim().getUf().getSigla());
        c.setRetira(cte.getIndicadorRetira().toString());
        c.setIndIEToma(this.getIndIEToma(cte));
        c.setTomadorServico3(this.getTomadorServico3(cte));
        c.setTomadorServico4(this.getTomadorServico4(cte, c));
        return c;
    }

    private String getIndIEToma(Cte cte) {
        if (ToolMethods.isEquals((Object)cte.getClienteTomador().getCliente().getPessoa().getComplemento().getContribuinteEstado(), (Object)EnumConstContrEstadoIcms.CONTRIBUINTE.getEnumId())) {
            return CTIndicadorTomador.CONTRIBUINTE_ICMS.getCodigo();
        }
        if (ToolMethods.isEquals((Object)cte.getClienteTomador().getCliente().getPessoa().getComplemento().getContribuinteEstado(), (Object)EnumConstContrEstadoIcms.ISENTO.getEnumId())) {
            return CTIndicadorTomador.CONTRIBUINTE_ISENTO.getCodigo();
        }
        return CTIndicadorTomador.NAO_CONTRIBUINTE.getCodigo();
    }

    private CTeNotaInfoIdentificacaoTomadorServico3 getTomadorServico3(Cte cte) {
        CTeNotaInfoIdentificacaoTomadorServico3 c = new CTeNotaInfoIdentificacaoTomadorServico3();
        if (ToolMethods.isEquals((Object)cte.getClienteTomador().getCliente().getPessoa(), (Object)cte.getRemetenteDestinatario().getPessoaRemetente().getPessoaTransporte().getPessoa()) || ToolMethods.isEquals((Object)ToolString.refina((String)cte.getClienteTomador().getPessoa().getComplemento().getInscEst()), (Object)ToolString.refina((String)cte.getRemetenteDestinatario().getPessoaRemetente().getInscricaoEstadual()))) {
            c.setTomadorServico(CTTomadorServico.REMETENTE.getCodigo());
        } else if (ToolMethods.isNotNull((Object)cte.getUnidadeFatTransporteExpedidor()).booleanValue() && (ToolMethods.isEquals((Object)cte.getClienteTomador().getCliente().getPessoa(), (Object)cte.getUnidadeFatTransporteExpedidor().getPessoaTransporte().getPessoa()) || ToolMethods.isEquals((Object)ToolString.refina((String)cte.getClienteTomador().getPessoa().getComplemento().getInscEst()), (Object)ToolString.refina((String)cte.getUnidadeFatTransporteExpedidor().getInscricaoEstadual())))) {
            c.setTomadorServico(CTTomadorServico.EXPEDIDOR.getCodigo());
        } else if (ToolMethods.isNotNull((Object)cte.getUnidadeFatTransporteRecebedor()).booleanValue() && (ToolMethods.isEquals((Object)cte.getClienteTomador().getCliente().getPessoa(), (Object)cte.getUnidadeFatTransporteRecebedor().getPessoaTransporte().getPessoa()) || ToolMethods.isEquals((Object)ToolString.refina((String)cte.getClienteTomador().getPessoa().getComplemento().getInscEst()), (Object)ToolString.refina((String)cte.getUnidadeFatTransporteRecebedor().getInscricaoEstadual())))) {
            c.setTomadorServico(CTTomadorServico.RECEBEDOR.getCodigo());
        } else if (ToolMethods.isEquals((Object)cte.getClienteTomador().getCliente().getPessoa(), (Object)cte.getRemetenteDestinatario().getPessoaDestinatario().getPessoaTransporte().getPessoa()) || ToolMethods.isEquals((Object)ToolString.refina((String)cte.getClienteTomador().getPessoa().getComplemento().getInscEst()), (Object)ToolString.refina((String)cte.getRemetenteDestinatario().getPessoaDestinatario().getInscricaoEstadual()))) {
            c.setTomadorServico(CTTomadorServico.DESTINATARIO.getCodigo());
        } else {
            return null;
        }
        return c;
    }

    private CTeNotaInfoIdentificacaoTomadorServico4 getTomadorServico4(Cte cte, CTeNotaInfoIdentificacao cteNotaInfoIdentificacao) {
        if (ToolMethods.isNull((Object)cteNotaInfoIdentificacao.getTomadorServico3()).booleanValue()) {
            CTeNotaInfoIdentificacaoTomadorServico4 c = new CTeNotaInfoIdentificacaoTomadorServico4();
            c.setTomadorServico(CTTomadorServico.OUTROS.getCodigo());
            if (ToolString.refina((String)cte.getClienteTomador().getCliente().getPessoa().getComplemento().getCnpj()).length() > 11) {
                c.setCnpj(ToolString.refina((String)cte.getClienteTomador().getCliente().getPessoa().getComplemento().getCnpj()));
            } else {
                c.setCpf(ToolString.refina((String)cte.getClienteTomador().getCliente().getPessoa().getComplemento().getCnpj()));
            }
            if (ToolMethods.isStrWithData((String)cte.getClienteTomador().getPessoa().getComplemento().getInscEst())) {
                c.setInscricaoEstadual(ToolString.refina((String)cte.getClienteTomador().getPessoa().getComplemento().getInscEst()));
            }
            c.setRazaoSocial(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)cte.getClienteTomador().getCliente().getPessoa().getNome()), (int)60));
            if (ToolMethods.isStrWithData((String)cte.getClienteTomador().getCliente().getPessoa().getNomeFantasia())) {
                c.setNomeFantasia(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)cte.getClienteTomador().getCliente().getPessoa().getNomeFantasia()), (int)60));
            }
            if (ToolMethods.isStrWithData((String)cte.getClienteTomador().getCliente().getPessoa().getComplemento().getFone1())) {
                c.setTelefone(ToolString.refina((String)cte.getClienteTomador().getCliente().getPessoa().getComplemento().getFone1()));
            }
            c.setEnderTomadorServico(this.getCteNotaEndereco(cte.getClienteTomador().getPessoa().getEndereco()));
            if (ToolMethods.isStrWithData((String)cte.getClienteTomador().getCliente().getPessoa().getComplemento().getEmailPrincipal())) {
                c.setEmail(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)cte.getClienteTomador().getCliente().getPessoa().getComplemento().getEmailPrincipal()), (int)60));
            }
            return c;
        }
        return null;
    }

    private CTeNotaEndereco getCteNotaEndereco(Endereco endereco) {
        CTeNotaEndereco c = new CTeNotaEndereco();
        c.setLogradouro(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)endereco.getLogradouro()), (int)60));
        c.setNumero(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)ToolString.refina((String)endereco.getNumero())), (int)60));
        if (ToolMethods.isStrWithData((String)endereco.getComplemento())) {
            c.setComplemento(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)endereco.getComplemento()), (int)60));
        }
        c.setBairro(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)endereco.getBairro()), (int)60));
        c.setCodigoMunicipio(endereco.getCidade().getUf().getCodIbge() + endereco.getCidade().getCodIbge());
        c.setDescricaoMunicipio(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)endereco.getCidade().getDescricao()), (int)60));
        if (ToolMethods.isStrWithData((String)endereco.getCep())) {
            c.setCep(ToolString.refina((String)endereco.getCep()));
        }
        c.setSiglaUF(endereco.getCidade().getUf().getSigla());
        if (ToolMethods.isStrWithData((String)endereco.getCidade().getUf().getPais().getCodIbge())) {
            c.setCodigoPais(endereco.getCidade().getUf().getPais().getCodIbge());
        }
        if (ToolMethods.isStrWithData((String)endereco.getCidade().getUf().getPais().getDescricao())) {
            c.setDescricaoPais(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)endereco.getCidade().getUf().getPais().getDescricao()), (int)60));
        }
        return c;
    }

    private CTeNotaInfoDadosComplementares getDadosComplementares(Cte cte, OpcoesFaturamentoTransp opcoesFaturamentoTransp) {
        CTeNotaInfoDadosComplementares c = new CTeNotaInfoDadosComplementares();
        if (ToolMethods.isNotNull((Object)cte.getConjuntoTransportador()).booleanValue() && ToolMethods.isNotNull((Object)cte.getConjuntoTransportador().getTransportadorAgregado()).booleanValue() && ToolMethods.isStrWithData((String)cte.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getComplemento().getCnpj())) {
            c.setCaracteristicasTransporte(ToolString.refina((String)cte.getConjuntoTransportador().getTransportadorAgregado().getPessoa().getComplemento().getCnpj()));
        }
        if (ToolMethods.isStrWithData((String)cte.getObservacaoGeral())) {
            c.setObservacaoGeral(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)cte.getObservacaoGeral()), (int)2000));
        }
        c.setObservacaoContribuinte(this.getObservacaoContribuinte(cte, opcoesFaturamentoTransp));
        c.setObservacaoFisco(this.getObservacaoFisco(cte, opcoesFaturamentoTransp));
        if (cte.getCidadeInicio() != null) {
            c.setMunicipioOrigem(cte.getCidadeInicio().getDescricao());
        }
        if (cte.getCidadeFim() != null) {
            c.setMunicipioDestino(cte.getCidadeFim().getDescricao());
        }
        return c;
    }

    private List<CTeNotaInfoDadosComplementaresObservacaoContribuinte> getObservacaoContribuinte(Cte cte, OpcoesFaturamentoTransp opcoesFaturamentoTransp) {
        ArrayList<CTeNotaInfoDadosComplementaresObservacaoContribuinte> lista = new ArrayList<CTeNotaInfoDadosComplementaresObservacaoContribuinte>();
        for (ObservacaoEstNota observacaoEstNota : cte.getObservacaoEstNota()) {
            CTeNotaInfoDadosComplementaresObservacaoContribuinte c = new CTeNotaInfoDadosComplementaresObservacaoContribuinte();
            c.setCampo(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)this.getCampo(observacaoEstNota, opcoesFaturamentoTransp)), (int)20));
            c.setTexto(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)observacaoEstNota.getConteudo()), (int)160));
            lista.add(c);
        }
        return lista;
    }

    private String getCampo(ObservacaoEstNota observacaoEstNota, OpcoesFaturamentoTransp opcoesFaturamentoTransp) {
        if (ToolMethods.isEquals((Object)opcoesFaturamentoTransp.getImprimirObsContribFisco(), (Object)EnumConstImpressaoObsContribFisco.IMPRIMIR_OBS_IDENTIFICADOR.getValue())) {
            return observacaoEstNota.getObsFaturamento().getIdentificador().toString();
        }
        return ToolString.subString((String)ToolString.clearSpecialCharacXML((String)observacaoEstNota.getObsFaturamento().getNome()), (int)20);
    }

    private List<CTeNotaInfoDadosComplementaresObservacaoFisco> getObservacaoFisco(Cte cte, OpcoesFaturamentoTransp opcoesFaturamentoTransp) {
        ArrayList<CTeNotaInfoDadosComplementaresObservacaoFisco> lista = new ArrayList<CTeNotaInfoDadosComplementaresObservacaoFisco>();
        for (ObservacaoEstNota observacaoEstNota : cte.getObservacaoIntFisco()) {
            CTeNotaInfoDadosComplementaresObservacaoFisco c = new CTeNotaInfoDadosComplementaresObservacaoFisco();
            c.setCampo(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)this.getCampo(observacaoEstNota, opcoesFaturamentoTransp)), (int)20));
            c.setTexto(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)observacaoEstNota.getConteudo()), (int)60));
            lista.add(c);
        }
        return lista;
    }

    private CTeNotaInfoEmitente getEmitente(Cte cte) {
        CTeNotaInfoEmitente c = new CTeNotaInfoEmitente();
        c.setCnpj(ToolString.refina((String)cte.getEmpresa().getPessoa().getComplemento().getCnpj()));
        c.setInscricaoEstadual(ToolString.refina((String)cte.getEmpresa().getPessoa().getComplemento().getInscEst()));
        c.setRazaoSocial(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)cte.getEmpresa().getPessoa().getNome()), (int)60));
        if (ToolMethods.isStrWithData((String)cte.getEmpresa().getPessoa().getNomeFantasia())) {
            c.setNomeFantasia(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)cte.getEmpresa().getPessoa().getNome()), (int)60));
        }
        c.setEnderEmit(this.getEnderEmit(cte.getEmpresa().getPessoa()));
        c.setTipoRegimeTributario(cte.getEmpresa().getEmpresaDados().getRegimeTributario().getCodigo().toString());
        return c;
    }

    private CTeNotaEnderecoEmitente getEnderEmit(Pessoa pessoa) {
        CTeNotaEnderecoEmitente c = new CTeNotaEnderecoEmitente();
        c.setLogradouro(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)pessoa.getEndereco().getLogradouro()), (int)60));
        c.setNumero(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)ToolString.refina((String)pessoa.getEndereco().getNumero())), (int)60));
        if (ToolMethods.isStrWithData((String)pessoa.getEndereco().getComplemento())) {
            c.setComplemento(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)pessoa.getEndereco().getComplemento()), (int)60));
        }
        c.setBairro(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)pessoa.getEndereco().getBairro()), (int)60));
        c.setCodigoMunicipio(pessoa.getEndereco().getCidade().getUf().getCodIbge() + pessoa.getEndereco().getCidade().getCodIbge());
        c.setDescricaoMunicipio(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)pessoa.getEndereco().getCidade().getDescricao()), (int)60));
        if (ToolMethods.isStrWithData((String)pessoa.getEndereco().getCep())) {
            c.setCep(ToolString.refina((String)pessoa.getEndereco().getCep()));
        }
        c.setSiglaUF(pessoa.getEndereco().getCidade().getUf().getSigla());
        if (ToolMethods.isStrWithData((String)pessoa.getComplemento().getFone1())) {
            c.setTelefone(ToolString.refina((String)pessoa.getComplemento().getFone1()));
        }
        return c;
    }

    private CTeNotaInfoRemetente getRemetente(Cte cte, OpcoesFaturamentoTransp opcoesFaturamentoTransp) {
        CTeNotaInfoRemetente c = new CTeNotaInfoRemetente();
        if (ToolMethods.isEquals((Object)cte.getRemetenteDestinatario().getPessoaRemetente().getEndereco().getCidade().getUf().getSigla(), (Object)"EX")) {
            c.setCnpj("00000000000000");
        } else if (ToolString.refina((String)cte.getRemetenteDestinatario().getPessoaRemetente().getPessoaTransporte().getPessoa().getComplemento().getCnpj()).length() > 11) {
            c.setCnpj(ToolString.refina((String)cte.getRemetenteDestinatario().getPessoaRemetente().getPessoaTransporte().getPessoa().getComplemento().getCnpj()));
        } else {
            c.setCpf(ToolString.refina((String)cte.getRemetenteDestinatario().getPessoaRemetente().getPessoaTransporte().getPessoa().getComplemento().getCnpj()));
        }
        if (ToolMethods.isStrWithData((String)cte.getRemetenteDestinatario().getPessoaRemetente().getInscricaoEstadual())) {
            c.setInscricaoEstadual(ToolString.refina((String)cte.getRemetenteDestinatario().getPessoaRemetente().getInscricaoEstadual()));
        }
        if (ToolMethods.isEquals((Object)opcoesFaturamentoTransp.getTipoAmbiente(), (Object)EnumConstTipoAmbienteCTe.IDENT_AMBIENTE_HOMOLOGACAO.getValue())) {
            c.setRazaoSocial(ToolString.clearSpecialCharacXML((String)"CTE EMITIDO EM AMBIENTE DE HOMOLOGACAO - SEM VALOR FISCAL"));
        } else if (ToolMethods.isEquals((Object)cte.getModeloFiscalCte().getTipoServicoCte().getCodigo(), (Object)1) && ToolMethods.isEquals((Object)cte.getRemetenteDestinatario().getDescrAuxRem(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            c.setRazaoSocial(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)cte.getRemetenteDestinatario().getDescrAuxRem()), (int)60));
        } else {
            c.setRazaoSocial(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)cte.getRemetenteDestinatario().getPessoaRemetente().getPessoaTransporte().getPessoa().getNome()), (int)60));
        }
        if (ToolMethods.isStrWithData((String)cte.getRemetenteDestinatario().getPessoaRemetente().getPessoaTransporte().getPessoa().getNomeFantasia())) {
            c.setNomeFantasia(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)cte.getRemetenteDestinatario().getPessoaRemetente().getPessoaTransporte().getPessoa().getNomeFantasia()), (int)60));
        }
        if (ToolMethods.isStrWithData((String)cte.getRemetenteDestinatario().getPessoaRemetente().getPessoaTransporte().getPessoa().getComplemento().getFone1())) {
            c.setTelefone(ToolString.refina((String)cte.getRemetenteDestinatario().getPessoaRemetente().getPessoaTransporte().getPessoa().getComplemento().getFone1()));
        }
        c.setEndereco(this.getCteNotaEndereco(cte.getRemetenteDestinatario().getPessoaRemetente().getEndereco()));
        if (ToolMethods.isStrWithData((String)cte.getRemetenteDestinatario().getPessoaRemetente().getPessoaTransporte().getPessoa().getComplemento().getEmailPrincipal())) {
            c.setEmail(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)cte.getRemetenteDestinatario().getPessoaRemetente().getPessoaTransporte().getPessoa().getComplemento().getEmailPrincipal()), (int)60));
        }
        return c;
    }

    private CTeNotaInfoRemetente getRemetente(CTeNotaInfo cteNotaInfo, OpcoesFaturamentoTransp opcoesFaturamentoTransp) {
        CTeNotaInfoRemetente c = new CTeNotaInfoRemetente();
        if (ToolMethods.isEquals((Object)cteNotaInfo.getEmitente().getEnderEmit().getSiglaUF(), (Object)"EX")) {
            c.setCnpj("00000000000000");
        } else {
            c.setCnpj(cteNotaInfo.getEmitente().getCnpj());
        }
        c.setInscricaoEstadual(cteNotaInfo.getEmitente().getInscricaoEstadual());
        if (ToolMethods.isEquals((Object)opcoesFaturamentoTransp.getTipoAmbiente(), (Object)EnumConstTipoAmbienteCTe.IDENT_AMBIENTE_HOMOLOGACAO.getValue())) {
            c.setRazaoSocial(ToolString.clearSpecialCharacXML((String)"CTE EMITIDO EM AMBIENTE DE HOMOLOGACAO - SEM VALOR FISCAL"));
        } else {
            c.setRazaoSocial("DIVERSOS");
        }
        c.setNomeFantasia(cteNotaInfo.getEmitente().getNomeFantasia());
        c.setTelefone(cteNotaInfo.getEmitente().getEnderEmit().getTelefone());
        c.setEndereco(this.getCteNotaEndereco(cteNotaInfo.getEmitente().getEnderEmit()));
        return c;
    }

    private CTeNotaEndereco getCteNotaEndereco(CTeNotaEnderecoEmitente cTeNotaEnderecoEmitente) {
        CTeNotaEndereco c = new CTeNotaEndereco();
        c.setLogradouro(cTeNotaEnderecoEmitente.getLogradouro());
        c.setNumero(cTeNotaEnderecoEmitente.getNumero());
        c.setComplemento(cTeNotaEnderecoEmitente.getComplemento());
        c.setBairro(cTeNotaEnderecoEmitente.getBairro());
        c.setCodigoMunicipio(cTeNotaEnderecoEmitente.getCodigoMunicipio());
        c.setDescricaoMunicipio(cTeNotaEnderecoEmitente.getDescricaoMunicipio());
        c.setCep(cTeNotaEnderecoEmitente.getCep());
        c.setSiglaUF(cTeNotaEnderecoEmitente.getSiglaUF());
        return c;
    }

    private CTeNotaInfoExpedidorCarga getExpedidorCarga(Cte cte, OpcoesFaturamentoTransp opcoesFaturamentoTransp) {
        if (ToolMethods.isNotNull((Object)cte.getUnidadeFatTransporteExpedidor()).booleanValue()) {
            CTeNotaInfoExpedidorCarga c = new CTeNotaInfoExpedidorCarga();
            if (ToolMethods.isEquals((Object)cte.getUnidadeFatTransporteExpedidor().getEndereco().getCidade().getUf().getSigla(), (Object)"EX")) {
                c.setCnpj("00000000000000");
            } else if (ToolString.refina((String)cte.getUnidadeFatTransporteExpedidor().getPessoaTransporte().getPessoa().getComplemento().getCnpj()).length() > 11) {
                c.setCnpj(ToolString.refina((String)cte.getUnidadeFatTransporteExpedidor().getPessoaTransporte().getPessoa().getComplemento().getCnpj()));
            } else {
                c.setCpf(ToolString.refina((String)cte.getUnidadeFatTransporteExpedidor().getPessoaTransporte().getPessoa().getComplemento().getCnpj()));
            }
            if (ToolMethods.isStrWithData((String)cte.getUnidadeFatTransporteExpedidor().getInscricaoEstadual())) {
                c.setInscricaoEstadual(ToolString.refina((String)cte.getUnidadeFatTransporteExpedidor().getInscricaoEstadual()));
            }
            if (ToolMethods.isEquals((Object)opcoesFaturamentoTransp.getTipoAmbiente(), (Object)EnumConstTipoAmbienteCTe.IDENT_AMBIENTE_HOMOLOGACAO.getValue())) {
                c.setRazaoSocial(ToolString.clearSpecialCharacXML((String)"CTE EMITIDO EM AMBIENTE DE HOMOLOGACAO - SEM VALOR FISCAL"));
            } else {
                c.setRazaoSocial(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)cte.getUnidadeFatTransporteExpedidor().getPessoaTransporte().getPessoa().getNome()), (int)60));
            }
            if (ToolMethods.isStrWithData((String)cte.getUnidadeFatTransporteExpedidor().getPessoaTransporte().getPessoa().getComplemento().getFone1())) {
                c.setTelefone(ToolString.refina((String)cte.getUnidadeFatTransporteExpedidor().getPessoaTransporte().getPessoa().getComplemento().getFone1()));
            }
            c.setEndereco(this.getCteNotaEndereco(cte.getUnidadeFatTransporteExpedidor().getEndereco()));
            if (ToolMethods.isStrWithData((String)cte.getUnidadeFatTransporteExpedidor().getPessoaTransporte().getPessoa().getComplemento().getEmailPrincipal())) {
                c.setEmail(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)cte.getUnidadeFatTransporteExpedidor().getPessoaTransporte().getPessoa().getComplemento().getEmailPrincipal()), (int)60));
            }
            return c;
        }
        return null;
    }

    private CTeNotaInfoRecebedorCarga getRecebedorCarga(Cte cte, OpcoesFaturamentoTransp opcoesFaturamentoTransp) {
        if (ToolMethods.isNotNull((Object)cte.getUnidadeFatTransporteRecebedor()).booleanValue()) {
            CTeNotaInfoRecebedorCarga c = new CTeNotaInfoRecebedorCarga();
            if (ToolMethods.isEquals((Object)cte.getUnidadeFatTransporteRecebedor().getEndereco().getCidade().getUf().getSigla(), (Object)"EX")) {
                c.setCnpj("00000000000000");
            } else if (ToolString.refina((String)cte.getUnidadeFatTransporteRecebedor().getPessoaTransporte().getPessoa().getComplemento().getCnpj()).length() > 11) {
                c.setCnpj(ToolString.refina((String)cte.getUnidadeFatTransporteRecebedor().getPessoaTransporte().getPessoa().getComplemento().getCnpj()));
            } else {
                c.setCpf(ToolString.refina((String)cte.getUnidadeFatTransporteRecebedor().getPessoaTransporte().getPessoa().getComplemento().getCnpj()));
            }
            if (ToolMethods.isStrWithData((String)cte.getUnidadeFatTransporteRecebedor().getInscricaoEstadual())) {
                c.setInscricaoEstadual(ToolString.refina((String)cte.getUnidadeFatTransporteRecebedor().getInscricaoEstadual()));
            }
            if (ToolMethods.isEquals((Object)opcoesFaturamentoTransp.getTipoAmbiente(), (Object)EnumConstTipoAmbienteCTe.IDENT_AMBIENTE_HOMOLOGACAO.getValue())) {
                c.setRazaoSocial(ToolString.clearSpecialCharacXML((String)"CTE EMITIDO EM AMBIENTE DE HOMOLOGACAO - SEM VALOR FISCAL"));
            } else {
                c.setRazaoSocial(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)cte.getUnidadeFatTransporteRecebedor().getPessoaTransporte().getPessoa().getNome()), (int)60));
            }
            if (ToolMethods.isStrWithData((String)cte.getUnidadeFatTransporteRecebedor().getPessoaTransporte().getPessoa().getComplemento().getFone1())) {
                c.setTelefone(ToolString.refina((String)cte.getUnidadeFatTransporteRecebedor().getPessoaTransporte().getPessoa().getComplemento().getFone1()));
            }
            c.setEndereco(this.getCteNotaEndereco(cte.getUnidadeFatTransporteRecebedor().getEndereco()));
            if (ToolMethods.isStrWithData((String)cte.getUnidadeFatTransporteRecebedor().getPessoaTransporte().getPessoa().getComplemento().getEmailPrincipal())) {
                c.setEmail(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)cte.getUnidadeFatTransporteRecebedor().getPessoaTransporte().getPessoa().getComplemento().getEmailPrincipal()), (int)60));
            }
            return c;
        }
        return null;
    }

    private CTeNotaInfoDestinatario getDestinatario(Cte cte, OpcoesFaturamentoTransp opcoesFaturamentoTransp) {
        CTeNotaInfoDestinatario c = new CTeNotaInfoDestinatario();
        if (ToolMethods.isEquals((Object)cte.getRemetenteDestinatario().getPessoaDestinatario().getEndereco().getCidade().getUf().getSigla(), (Object)"EX")) {
            c.setCnpj("00000000000000");
        } else if (ToolString.refina((String)cte.getRemetenteDestinatario().getPessoaDestinatario().getPessoaTransporte().getPessoa().getComplemento().getCnpj()).length() > 11) {
            c.setCnpj(ToolString.refina((String)cte.getRemetenteDestinatario().getPessoaDestinatario().getPessoaTransporte().getPessoa().getComplemento().getCnpj()));
        } else {
            c.setCpf(ToolString.refina((String)cte.getRemetenteDestinatario().getPessoaDestinatario().getPessoaTransporte().getPessoa().getComplemento().getCnpj()));
        }
        if (ToolMethods.isStrWithData((String)cte.getRemetenteDestinatario().getPessoaDestinatario().getInscricaoEstadual())) {
            c.setInscricaoEstadual(ToolString.refina((String)cte.getRemetenteDestinatario().getPessoaDestinatario().getInscricaoEstadual()));
        }
        if (ToolMethods.isEquals((Object)opcoesFaturamentoTransp.getTipoAmbiente(), (Object)EnumConstTipoAmbienteCTe.IDENT_AMBIENTE_HOMOLOGACAO.getValue())) {
            c.setRazaoSocial(ToolString.clearSpecialCharacXML((String)"CTE EMITIDO EM AMBIENTE DE HOMOLOGACAO - SEM VALOR FISCAL"));
        } else if (ToolMethods.isEquals((Object)cte.getModeloFiscalCte().getTipoServicoCte().getCodigo(), (Object)1) && ToolMethods.isEquals((Object)cte.getRemetenteDestinatario().getDescrAuxDest(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            c.setRazaoSocial(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)cte.getRemetenteDestinatario().getDescrAuxRem()), (int)60));
        } else {
            c.setRazaoSocial(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)cte.getRemetenteDestinatario().getPessoaDestinatario().getPessoaTransporte().getPessoa().getNome()), (int)60));
        }
        if (ToolMethods.isStrWithData((String)cte.getRemetenteDestinatario().getPessoaDestinatario().getPessoaTransporte().getPessoa().getComplemento().getFone1())) {
            c.setTelefone(ToolString.refina((String)cte.getRemetenteDestinatario().getPessoaDestinatario().getPessoaTransporte().getPessoa().getComplemento().getFone1()));
        }
        if (ToolMethods.isStrWithData((String)cte.getRemetenteDestinatario().getPessoaDestinatario().getPessoaTransporte().getPessoa().getComplemento().getSuframa())) {
            c.setInscricaoSuframa(cte.getRemetenteDestinatario().getPessoaDestinatario().getPessoaTransporte().getPessoa().getComplemento().getSuframa());
        }
        c.setEndereco(this.getCteNotaEndereco(cte.getRemetenteDestinatario().getPessoaDestinatario().getEndereco()));
        if (ToolMethods.isStrWithData((String)cte.getRemetenteDestinatario().getPessoaDestinatario().getPessoaTransporte().getPessoa().getComplemento().getEmailPrincipal())) {
            c.setEmail(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)cte.getRemetenteDestinatario().getPessoaDestinatario().getPessoaTransporte().getPessoa().getComplemento().getEmailPrincipal()), (int)60));
        }
        return c;
    }

    private CTeNotaInfoDestinatario getDestinatario(CTeNotaInfo cteNotaInfo, OpcoesFaturamentoTransp opcoesFaturamentoTransp) {
        CTeNotaInfoDestinatario c = new CTeNotaInfoDestinatario();
        if (ToolMethods.isEquals((Object)cteNotaInfo.getEmitente().getEnderEmit().getSiglaUF(), (Object)"EX")) {
            c.setCnpj("00000000000000");
        } else {
            c.setCnpj(cteNotaInfo.getEmitente().getCnpj());
        }
        c.setInscricaoEstadual(cteNotaInfo.getEmitente().getInscricaoEstadual());
        if (ToolMethods.isEquals((Object)opcoesFaturamentoTransp.getTipoAmbiente(), (Object)EnumConstTipoAmbienteCTe.IDENT_AMBIENTE_HOMOLOGACAO.getValue())) {
            c.setRazaoSocial(ToolString.clearSpecialCharacXML((String)"CTE EMITIDO EM AMBIENTE DE HOMOLOGACAO - SEM VALOR FISCAL"));
        } else {
            c.setRazaoSocial("DIVERSOS");
        }
        c.setTelefone(cteNotaInfo.getEmitente().getEnderEmit().getTelefone());
        c.setEndereco(this.getCteNotaEndereco(cteNotaInfo.getEmitente().getEnderEmit()));
        return c;
    }

    private CTeNotaInfoValorPrestacaoServico getValorPrestacaoServico(Cte cte) {
        CTeNotaInfoValorPrestacaoServico c = new CTeNotaInfoValorPrestacaoServico();
        c.setValorTotalPrestacaoServico(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteVlrImpostos().getVrPrestacao(), (int)2));
        c.setValorReceber(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteVlrImpostos().getVrReceber(), (int)2));
        c.setComponentesValorPrestacao(this.getComponentesValorPrestacao(cte));
        return c;
    }

    private List<CTeNotaInfoValorPrestacaoServicoComponentesValorPrestacao> getComponentesValorPrestacao(Cte cte) {
        ArrayList<CTeNotaInfoValorPrestacaoServicoComponentesValorPrestacao> lista = new ArrayList<CTeNotaInfoValorPrestacaoServicoComponentesValorPrestacao>();
        for (ItemCte itemCte : cte.getItemCte()) {
            CTeNotaInfoValorPrestacaoServicoComponentesValorPrestacao c = new CTeNotaInfoValorPrestacaoServicoComponentesValorPrestacao();
            c.setNomeComponente(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)itemCte.getComponenteFrete().getDescricao()), (int)15));
            c.setValorComponente(ToolFormatter.arrredondarNumeroBigDecimal((Double)itemCte.getValor(), (int)2));
            lista.add(c);
        }
        return lista;
    }

    private CTeNotaInfoInformacoesRelativasImpostos getInformacoesRelativasImpostos(Cte cte) {
        CTeNotaInfoInformacoesRelativasImpostos c = new CTeNotaInfoInformacoesRelativasImpostos();
        c.setIcms(this.getIcms(cte));
        return c;
    }

    private CTeNotaInfoInformacoesRelativasImpostosICMS getIcms(Cte cte) {
        CTeNotaInfoInformacoesRelativasImpostosICMS c = new CTeNotaInfoInformacoesRelativasImpostosICMS();
        if (ToolMethods.isEquals((Object)cte.getCteVlrImpostos().getTipoTributacao(), (Object)1)) {
            switch (Integer.parseInt(cte.getCteVlrImpostos().getIncidenciaIcms().getCodigo())) {
                case 0: {
                    c.setIcms00(this.getIcms00(cte));
                    break;
                }
                case 20: {
                    c.setIcms20(this.getIcms20(cte));
                    break;
                }
                case 40: 
                case 41: 
                case 51: {
                    c.setIcms45(this.getIcms45(cte));
                    break;
                }
                case 60: {
                    c.setIcms60(this.getIcms60(cte));
                    break;
                }
                case 90: {
                    if (ToolMethods.isNull((Object)cte.getCteVlrImpostos().getIcmsOutraUf()).booleanValue() || ToolMethods.isEquals((Object)cte.getCteVlrImpostos().getIcmsOutraUf(), (Object)EnumConstantsMentorSimNao.NAO.getValue())) {
                        c.setIcms90(this.getIcms90(cte));
                        break;
                    }
                    c.setIcmsOutraUF(this.setIcmsOutraUF(cte));
                }
            }
        } else {
            c.setIcmssn(this.getIcmssn(cte));
        }
        return c;
    }

    private CTeNotaInfoInformacoesRelativasImpostosICMS00 getIcms00(Cte cte) {
        CTeNotaInfoInformacoesRelativasImpostosICMS00 c = new CTeNotaInfoInformacoesRelativasImpostosICMS00();
        c.setCodigoSituacaoTributaria(cte.getCteVlrImpostos().getIncidenciaIcms().getCodigo().substring(1));
        c.setBaseCalculoICMS(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteVlrImpostos().getVrIcmsTributado(), (int)2));
        c.setAliquotaICMS(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteVlrImpostos().getAliqIcms(), (int)2));
        c.setValorICMS(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteVlrImpostos().getVrIcms(), (int)2));
        return c;
    }

    private CTeNotaInfoInformacoesRelativasImpostosICMS20 getIcms20(Cte cte) {
        CTeNotaInfoInformacoesRelativasImpostosICMS20 c = new CTeNotaInfoInformacoesRelativasImpostosICMS20();
        c.setCodigoSituacaoTributaria(cte.getCteVlrImpostos().getIncidenciaIcms().getCodigo().substring(1));
        c.setAliquotaReducaoBaseCalculoICMS(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteVlrImpostos().getPercRedBaseCalcIcms(), (int)2));
        c.setBaseCalculoICMS(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteVlrImpostos().getVrIcmsTributado(), (int)2));
        c.setAliquotaICMS(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteVlrImpostos().getAliqIcms(), (int)2));
        c.setValorICMS(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteVlrImpostos().getVrIcms(), (int)2));
        if (ToolMethods.isWithData((Number)cte.getCteVlrImpostos().getVrIcmsDesonerado())) {
            c.setValorICMSDesoneracao(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteVlrImpostos().getVrIcmsDesonerado(), (int)2));
        }
        if (ToolMethods.isStrWithData((String)cte.getCteVlrImpostos().getCodigoBeneficioFiscal())) {
            c.setCodigoBeneficioFiscal(ToolString.refina((String)cte.getCteVlrImpostos().getCodigoBeneficioFiscal()));
        }
        return c;
    }

    private CTeNotaInfoInformacoesRelativasImpostosICMS45 getIcms45(Cte cte) {
        CTeNotaInfoInformacoesRelativasImpostosICMS45 c = new CTeNotaInfoInformacoesRelativasImpostosICMS45();
        c.setCodigoSituacaoTributaria(cte.getCteVlrImpostos().getIncidenciaIcms().getCodigo().substring(1));
        if (ToolMethods.isWithData((Number)cte.getCteVlrImpostos().getVrIcmsDesonerado())) {
            c.setValorICMSDesoneracao(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteVlrImpostos().getVrIcmsDesonerado(), (int)2));
        }
        if (ToolMethods.isStrWithData((String)cte.getCteVlrImpostos().getCodigoBeneficioFiscal())) {
            c.setCodigoBeneficioFiscal(ToolString.refina((String)cte.getCteVlrImpostos().getCodigoBeneficioFiscal()));
        }
        return c;
    }

    private CTeNotaInfoInformacoesRelativasImpostosICMS60 getIcms60(Cte cte) {
        CTeNotaInfoInformacoesRelativasImpostosICMS60 c = new CTeNotaInfoInformacoesRelativasImpostosICMS60();
        c.setCodigoSituacaoTributaria(cte.getCteVlrImpostos().getIncidenciaIcms().getCodigo().substring(1));
        c.setBaseCalculoICMSSTRetido(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteVlrImpostos().getVrIcmsTributado(), (int)2));
        c.setValorICMSSTRetido(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteVlrImpostos().getVrIcms(), (int)2));
        c.setAliquotaICMSSTRetido(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteVlrImpostos().getAliqIcms(), (int)2));
        if (ToolMethods.isWithData((Number)cte.getCteVlrImpostos().getVrIcmsDesonerado())) {
            c.setValorICMSDesoneracao(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteVlrImpostos().getVrIcmsDesonerado(), (int)2));
        }
        if (ToolMethods.isStrWithData((String)cte.getCteVlrImpostos().getCodigoBeneficioFiscal())) {
            c.setCodigoBeneficioFiscal(ToolString.refina((String)cte.getCteVlrImpostos().getCodigoBeneficioFiscal()));
        }
        return c;
    }

    private CTeNotaInfoInformacoesRelativasImpostosICMS90 getIcms90(Cte cte) {
        CTeNotaInfoInformacoesRelativasImpostosICMS90 c = new CTeNotaInfoInformacoesRelativasImpostosICMS90();
        c.setCodigoSituacaoTributaria(cte.getCteVlrImpostos().getIncidenciaIcms().getCodigo().substring(1));
        if (ToolMethods.isWithData((Number)cte.getCteVlrImpostos().getPercRedBaseCalcIcms())) {
            c.setAliquotaReducaoBaseCalculo(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteVlrImpostos().getPercRedBaseCalcIcms(), (int)2));
        }
        c.setBaseCalculoICMS(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteVlrImpostos().getVrIcmsOutros(), (int)2));
        c.setAliquotaICMS(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteVlrImpostos().getAliqIcms(), (int)2));
        c.setValorICMS(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteVlrImpostos().getVrIcms(), (int)2));
        if (ToolMethods.isWithData((Number)cte.getCteVlrImpostos().getVrIcmsDesonerado())) {
            c.setValorICMSDesoneracao(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteVlrImpostos().getVrIcmsDesonerado(), (int)2));
        }
        if (ToolMethods.isStrWithData((String)cte.getCteVlrImpostos().getCodigoBeneficioFiscal())) {
            c.setCodigoBeneficioFiscal(ToolString.refina((String)cte.getCteVlrImpostos().getCodigoBeneficioFiscal()));
        }
        return c;
    }

    private CTeNotaInfoInformacoesRelativasImpostosICMSOutraUF setIcmsOutraUF(Cte cte) {
        CTeNotaInfoInformacoesRelativasImpostosICMSOutraUF c = new CTeNotaInfoInformacoesRelativasImpostosICMSOutraUF();
        c.setCodigoSituacaoTributaria(cte.getCteVlrImpostos().getIncidenciaIcms().getCodigo().substring(1));
        if (ToolMethods.isWithData((Number)cte.getCteVlrImpostos().getPercRedBaseCalcIcmsOutraUf())) {
            c.setAliquotaReducaoBaseCalculoICMSOutraUF(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteVlrImpostos().getPercRedBaseCalcIcmsOutraUf(), (int)2));
        }
        c.setBaseCalculoICMSOutraUF(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteVlrImpostos().getVrIcmsOutros(), (int)2));
        c.setAliquotaICMSOutraUF(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteVlrImpostos().getAliqIcmsOutraUf(), (int)2));
        c.setValorICMSOutraUF(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteVlrImpostos().getVrIcmsOutraUf(), (int)2));
        if (ToolMethods.isWithData((Number)cte.getCteVlrImpostos().getVrIcmsDesonerado())) {
            c.setValorICMSDesoneracao(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteVlrImpostos().getVrIcmsDesonerado(), (int)2));
        }
        if (ToolMethods.isStrWithData((String)cte.getCteVlrImpostos().getCodigoBeneficioFiscal())) {
            c.setCodigoBeneficioFiscal(ToolString.refina((String)cte.getCteVlrImpostos().getCodigoBeneficioFiscal()));
        }
        return c;
    }

    private CTeNotaInfoInformacoesRelativasImpostosICMSSN getIcmssn(Cte cte) {
        CTeNotaInfoInformacoesRelativasImpostosICMSSN c = new CTeNotaInfoInformacoesRelativasImpostosICMSSN();
        c.setCodigoSituacaoTributaria(cte.getCteVlrImpostos().getIncidenciaIcms().getCodigo().substring(1));
        c.setIndicadorSN(String.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
        return c;
    }

    private CTeNotaInfoCTeNormal getCteNormal(Cte cte) {
        CTeNotaInfoCTeNormal c = new CTeNotaInfoCTeNormal();
        c.setInfoCarga(this.getInfoCarga(cte));
        if (!ToolMethods.isEquals((Object)cte.getModeloFiscalCte().getTipoServicoCte().getCodigo(), (Object)Integer.valueOf(ConstCTeTipoServico.REDESPACHO_INTERMEDIARIO.getCodigo())) && !ToolMethods.isEquals((Object)cte.getModeloFiscalCte().getTipoServicoCte().getCodigo(), (Object)Integer.valueOf(ConstCTeTipoServico.SERVICO_VINCULADO_A_MULTIMODAL.getCodigo()))) {
            c.setInfoDocumentos(this.getInfoDocumentos(cte));
        }
        c.setDocumentosAnteriores(this.getDocumentosAnteriores(cte));
        c.setInfoModal(this.getInfoModal(cte));
        c.setInfoCTeSubstituicao(this.getInfoCTeSubstituicao(cte));
        if (ToolMethods.isEquals((Object)cte.getModeloFiscalCte().getTipoServicoCte().getCodigo(), (Object)Integer.valueOf(ConstCTeTipoServico.SERVICO_VINCULADO_A_MULTIMODAL.getCodigo()))) {
            c.setInfoServicoVinculado(this.getInfoServiceVinculado(cte));
        }
        c.setVeiculosTransportados(this.getVeiculosTransportados(cte));
        return c;
    }

    private CTeNotaInfoCTeNormalInfoCarga getInfoCarga(Cte cte) {
        CTeNotaInfoCTeNormalInfoCarga c = new CTeNotaInfoCTeNormalInfoCarga();
        c.setValorTotalCarga(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteInfCarga().getValorTotalMercadorias(), (int)2));
        c.setDescricaoProdutoPredominante(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)cte.getCteInfCarga().getProdutoPredominante().getDescricao()), (int)60));
        if (ToolMethods.isStrWithData((String)cte.getCteInfCarga().getOutrasCaracteristicas())) {
            c.setDescricaoOutrasCaracteristicas(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)cte.getCteInfCarga().getOutrasCaracteristicas()), (int)30));
        }
        c.setInformacoesQuantidadeCarga(this.getInformacoesQuantidadeCarga(cte));
        c.setValorAverbacao(ToolFormatter.arrredondarNumeroBigDecimal((Double)this.getValorAverbacao(cte), (int)2));
        return c;
    }

    private List<CTeNotaInfoCTeNormalInfoCargaInformacoesQuantidadeCarga> getInformacoesQuantidadeCarga(Cte cte) {
        ArrayList<CTeNotaInfoCTeNormalInfoCargaInformacoesQuantidadeCarga> lista = new ArrayList<CTeNotaInfoCTeNormalInfoCargaInformacoesQuantidadeCarga>();
        for (CteCarga cteCarga : cte.getCteInfCarga().getCteCarga()) {
            CTeNotaInfoCTeNormalInfoCargaInformacoesQuantidadeCarga c = new CTeNotaInfoCTeNormalInfoCargaInformacoesQuantidadeCarga();
            c.setUnidadeMedida(cteCarga.getTipoMedidaCargaCte().getUnidadeMedidaCte().getCodigo());
            c.setTipoMedia(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)cteCarga.getTipoMedidaCargaCte().getDescricao()), (int)30));
            c.setQuantidade(ToolFormatter.arrredondarNumeroBigDecimal((Double)cteCarga.getQuantidade(), (int)4));
            lista.add(c);
        }
        return lista;
    }

    private Double getValorAverbacao(Cte cte) {
        Double valorAverbacao = 0.0;
        for (CteSeguro cteSeguro : cte.getCteSeguro()) {
            valorAverbacao = valorAverbacao + cteSeguro.getValor();
        }
        return valorAverbacao;
    }

    private CTeNotaInfoCTeNormalInfoDocumentos getInfoDocumentos(Cte cte) {
        CTeNotaInfoCTeNormalInfoDocumentos c = new CTeNotaInfoCTeNormalInfoDocumentos();
        c.setInfoNF(this.getInfoNf(cte));
        c.setInfoNFe(this.getInfoNfe(cte));
        c.setInfoOutros(this.getInfoOutros(cte));
        return c;
    }

    private List<CTeNotaInfoCTeNormalInfoDocumentosInfoNF> getInfoNf(Cte cte) {
        ArrayList<CTeNotaInfoCTeNormalInfoDocumentosInfoNF> lista = new ArrayList<CTeNotaInfoCTeNormalInfoDocumentosInfoNF>();
        for (CteNf cteNf : cte.getCteNf()) {
            CTeNotaInfoCTeNormalInfoDocumentosInfoNF c = new CTeNotaInfoCTeNormalInfoDocumentosInfoNF();
            if (ToolMethods.isStrWithData((String)cteNf.getNrRomaneio())) {
                c.setNumeroRomaneio(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)ToolString.refina((String)cteNf.getNrRomaneio())), (int)20));
            }
            if (ToolMethods.isStrWithData((String)cteNf.getNrPedido())) {
                c.setNumeroPedidoNF(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)ToolString.refina((String)cteNf.getNrPedido())), (int)20));
            }
            c.setModeloNF(cteNf.getModeloDocFiscal().getCodigo());
            c.setSerie(cteNf.getSerie());
            c.setNumeroDocumento(ToolString.refina((String)cteNf.getNumero().toString()));
            c.setDataEmissao(ToolDate.formatarLocalDate((Date)cteNf.getDataEmissao()));
            c.setValorBcICMS(ToolFormatter.arrredondarNumeroBigDecimal((Double)cteNf.getVrBcIcms(), (int)2));
            c.setValorICMS(ToolFormatter.arrredondarNumeroBigDecimal((Double)cteNf.getVrIcms(), (int)2));
            c.setValorBcICMSST(ToolFormatter.arrredondarNumeroBigDecimal((Double)cteNf.getVrBcIcmsSt(), (int)2));
            c.setValorICMSST(ToolFormatter.arrredondarNumeroBigDecimal((Double)cteNf.getVrIcmsSt(), (int)2));
            c.setValorTotalProdutos(ToolFormatter.arrredondarNumeroBigDecimal((Double)cteNf.getVrProdutos(), (int)2));
            c.setValorTotalNF(ToolFormatter.arrredondarNumeroBigDecimal((Double)cteNf.getVrTotal(), (int)2));
            c.setCFOP(ToolString.refina((String)cteNf.getCfop().getCodigo()));
            if (ToolMethods.isWithData((Number)cteNf.getPeso())) {
                c.setValorPesoTotal(ToolFormatter.arrredondarNumeroBigDecimal((Double)cteNf.getPeso(), (int)3));
            }
            if (ToolMethods.isStrWithData((String)cteNf.getPinSuframa())) {
                c.setPinSUFRAMA(ToolString.refina((String)cteNf.getPinSuframa()));
            }
            lista.add(c);
        }
        return lista;
    }

    private List<CTeNotaInfoCTeNormalInfoDocumentosInfoNFe> getInfoNfe(Cte cte) {
        ArrayList<CTeNotaInfoCTeNormalInfoDocumentosInfoNFe> lista = new ArrayList<CTeNotaInfoCTeNormalInfoDocumentosInfoNFe>();
        for (CTeNFe cteNfe : cte.getCteNfe()) {
            CTeNotaInfoCTeNormalInfoDocumentosInfoNFe c = new CTeNotaInfoCTeNormalInfoDocumentosInfoNFe();
            c.setChave(cteNfe.getChaveNFe());
            if (ToolMethods.isStrWithData((String)cteNfe.getPinNFe())) {
                c.setPinSUFRAMA(ToolString.refina((String)cteNfe.getPinNFe()));
            }
            lista.add(c);
        }
        return lista;
    }

    private List<CTeNotaInfoCTeNormalInfoDocumentosInfoOutros> getInfoOutros(Cte cte) {
        ArrayList<CTeNotaInfoCTeNormalInfoDocumentosInfoOutros> lista = new ArrayList<CTeNotaInfoCTeNormalInfoDocumentosInfoOutros>();
        for (CTeOutros cteOutros : cte.getCteOutros()) {
            CTeNotaInfoCTeNormalInfoDocumentosInfoOutros c = new CTeNotaInfoCTeNormalInfoDocumentosInfoOutros();
            c.setTipoDocumento(cteOutros.getTipoDoc().getCodigo());
            if (ToolMethods.isStrWithData((String)cteOutros.getDescricaoOutros())) {
                c.setDescricao(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)cteOutros.getDescricaoOutros()), (int)100));
            }
            if (ToolMethods.isStrWithData((String)cteOutros.getNumeroDocumento())) {
                c.setNumero(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)cteOutros.getNumeroDocumento()), (int)20));
            }
            if (ToolMethods.isNotNull((Object)cteOutros.getDataEmissao()).booleanValue()) {
                c.setDataEmissao(ToolDate.formatarLocalDate((Date)cteOutros.getDataEmissao()));
            }
            if (ToolMethods.isWithData((Number)cteOutros.getValorDocumento())) {
                c.setValorDocumentoFiscal(ToolFormatter.arrredondarNumeroBigDecimal((Double)cteOutros.getValorDocumento(), (int)2));
            }
            lista.add(c);
        }
        return lista;
    }

    private CTeNotaInfoCTeNormalDocumentosAnteriores getDocumentosAnteriores(Cte cte) {
        if (ToolMethods.isWithData((Collection)cte.getEmissorDocAntCTe())) {
            CTeNotaInfoCTeNormalDocumentosAnteriores c = new CTeNotaInfoCTeNormalDocumentosAnteriores();
            c.setEmissorDocumentosAnteriores(this.getEmissorDocumentosAnteriores(cte));
            return c;
        }
        return null;
    }

    private List<CTeNotaInfoCTeNormalDocumentosAnterioresEmissorDocumentosAnteriores> getEmissorDocumentosAnteriores(Cte cte) {
        ArrayList<CTeNotaInfoCTeNormalDocumentosAnterioresEmissorDocumentosAnteriores> lista = new ArrayList<CTeNotaInfoCTeNormalDocumentosAnterioresEmissorDocumentosAnteriores>();
        for (EmissorDocAntCTe emissorDocAntCte : cte.getEmissorDocAntCTe()) {
            CTeNotaInfoCTeNormalDocumentosAnterioresEmissorDocumentosAnteriores c = new CTeNotaInfoCTeNormalDocumentosAnterioresEmissorDocumentosAnteriores();
            if (ToolString.refina((String)emissorDocAntCte.getPessoa().getComplemento().getCnpj()).length() > 11) {
                c.setCnpj(ToolString.refina((String)emissorDocAntCte.getPessoa().getComplemento().getCnpj()));
            } else {
                c.setCpf(ToolString.refina((String)emissorDocAntCte.getPessoa().getComplemento().getCnpj()));
            }
            c.setInscricaoEstadual(ToolString.refina((String)emissorDocAntCte.getPessoa().getComplemento().getInscEst()));
            c.setSiglaUF(emissorDocAntCte.getPessoa().getEndereco().getCidade().getUf().getSigla());
            c.setRazaoSocial(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)emissorDocAntCte.getPessoa().getNome()), (int)60));
            c.setIdentificacaoDocumentosAnteriores(this.getIdentificacaoDocumentosAnteriores(emissorDocAntCte));
            lista.add(c);
        }
        return lista;
    }

    private List<CTeNotaInfoCTeNormalDocumentosAnterioresEmissorDocumentosAnterioresIdentificacao> getIdentificacaoDocumentosAnteriores(EmissorDocAntCTe emissorDocAntCte) {
        ArrayList<CTeNotaInfoCTeNormalDocumentosAnterioresEmissorDocumentosAnterioresIdentificacao> lista = new ArrayList<CTeNotaInfoCTeNormalDocumentosAnterioresEmissorDocumentosAnterioresIdentificacao>();
        CTeNotaInfoCTeNormalDocumentosAnterioresEmissorDocumentosAnterioresIdentificacao c = new CTeNotaInfoCTeNormalDocumentosAnterioresEmissorDocumentosAnterioresIdentificacao();
        c.setIdentificacaoPapel(this.getIdentificacaoPapel(emissorDocAntCte));
        c.setIdentificacaoEletronico(this.getIdentificacaoEletronico(emissorDocAntCte));
        lista.add(c);
        return lista;
    }

    private List<CTeNotaInfoCTeNormalDocumentosAnterioresEmissorDocumentosAnterioresIdentificacaoPapel> getIdentificacaoPapel(EmissorDocAntCTe emissorDocAntCte) {
        ArrayList<CTeNotaInfoCTeNormalDocumentosAnterioresEmissorDocumentosAnterioresIdentificacaoPapel> lista = new ArrayList<CTeNotaInfoCTeNormalDocumentosAnterioresEmissorDocumentosAnterioresIdentificacaoPapel>();
        for (DocAntTransporteCTRC docAntTransporteCtrc : emissorDocAntCte.getDocAnteriorCTRC()) {
            CTeNotaInfoCTeNormalDocumentosAnterioresEmissorDocumentosAnterioresIdentificacaoPapel c = new CTeNotaInfoCTeNormalDocumentosAnterioresEmissorDocumentosAnterioresIdentificacaoPapel();
            c.setTipoDocumentoAnterior(docAntTransporteCtrc.getTipoDocAntCTe().getCodigo());
            c.setSerie(docAntTransporteCtrc.getSerie());
            if (ToolMethods.isStrWithData((String)docAntTransporteCtrc.getSubSerie())) {
                c.setSubSerie(docAntTransporteCtrc.getSubSerie());
            }
            c.setNumeroDocumento(ToolString.refina((String)docAntTransporteCtrc.getNrDocumento().toString()));
            c.setDataEmissao(ToolDate.formatarLocalDate((Date)docAntTransporteCtrc.getDataEmissao()));
            lista.add(c);
        }
        return lista;
    }

    private List<CTeNotaInfoCTeNormalDocumentosAnterioresEmissorDocumentosAnterioresIdentificacaoEletronico> getIdentificacaoEletronico(EmissorDocAntCTe emissorDocAntCte) {
        ArrayList<CTeNotaInfoCTeNormalDocumentosAnterioresEmissorDocumentosAnterioresIdentificacaoEletronico> lista = new ArrayList<CTeNotaInfoCTeNormalDocumentosAnterioresEmissorDocumentosAnterioresIdentificacaoEletronico>();
        for (DocAntTransporteCTe docAntTransporteCte : emissorDocAntCte.getDocAnteriorCTe()) {
            CTeNotaInfoCTeNormalDocumentosAnterioresEmissorDocumentosAnterioresIdentificacaoEletronico c = new CTeNotaInfoCTeNormalDocumentosAnterioresEmissorDocumentosAnterioresIdentificacaoEletronico();
            c.setChaveCTe(docAntTransporteCte.getChaveCTe());
            lista.add(c);
        }
        return lista;
    }

    private CTeNotaInfoCTeNormalInfoModal getInfoModal(Cte cte) {
        CTeNotaInfoCTeNormalInfoModal c = new CTeNotaInfoCTeNormalInfoModal();
        if (ToolMethods.isEquals((Object)cte.getModalCte().getCodigo(), (Object)"01")) {
            c.setRodoviario(this.getRodoviario(cte));
        }
        if (ToolMethods.isEquals((Object)cte.getModalCte().getCodigo(), (Object)"03")) {
            c.setAquaviario(this.getAquaviario(cte));
        }
        c.setVersao(EnumConstCTeVersao.VERSAO_4_00.getCodigoStr());
        return c;
    }

    private CTeNotaInfoCTeNormalInfoModalRodoviario getRodoviario(Cte cte) {
        CTeNotaInfoCTeNormalInfoModalRodoviario c = new CTeNotaInfoCTeNormalInfoModalRodoviario();
        c.setRntrc(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)cte.getEmpresa().getEmpresaDados().getInscANTT()), (int)8));
        c.setOrdemColetaAssociadas(this.getOrdemColetaAssociadas(cte));
        return c;
    }

    private List<CTeNotaInfoCTeNormalInfoModalRodoviarioOrdemColetaAssociadas> getOrdemColetaAssociadas(Cte cte) {
        ArrayList<CTeNotaInfoCTeNormalInfoModalRodoviarioOrdemColetaAssociadas> lista = new ArrayList<CTeNotaInfoCTeNormalInfoModalRodoviarioOrdemColetaAssociadas>();
        for (CteOrdemColeta cteOrdemColeta : cte.getCteOrdemColeta()) {
            CTeNotaInfoCTeNormalInfoModalRodoviarioOrdemColetaAssociadas c = new CTeNotaInfoCTeNormalInfoModalRodoviarioOrdemColetaAssociadas();
            if (ToolMethods.isStrWithData((String)cteOrdemColeta.getSerie())) {
                c.setSerie(cteOrdemColeta.getSerie());
            }
            c.setNumeroOrdemColeta(ToolString.refina((String)cteOrdemColeta.getNumeroOC().toString()));
            c.setDataEmissao(ToolDate.formatarLocalDate((Date)cteOrdemColeta.getDataEmissaoOC()));
            c.setOrdemColetaAssociadasEmi(this.getOrdemColetaAssociadasEmi(cteOrdemColeta));
            lista.add(c);
        }
        return lista;
    }

    private CTeNotaInfoCTeNormalInfoModalRodoviarioOrdemColetaAssociadasEmi getOrdemColetaAssociadasEmi(CteOrdemColeta cteOrdemColeta) {
        CTeNotaInfoCTeNormalInfoModalRodoviarioOrdemColetaAssociadasEmi c = new CTeNotaInfoCTeNormalInfoModalRodoviarioOrdemColetaAssociadasEmi();
        c.setCnpj(ToolString.refina((String)cteOrdemColeta.getEmissorOC().getComplemento().getCnpj()));
        c.setCodigoInterno(ToolString.subString((String)ToolString.clearSpecialCharacXML((String)ToolString.refina((String)cteOrdemColeta.getEmissorOC().getIdentificador().toString())), (int)10));
        c.setInscricaoEstadual(ToolString.refina((String)cteOrdemColeta.getEmissorOC().getComplemento().getInscEst()));
        c.setSiglaUF(cteOrdemColeta.getEmissorOC().getEndereco().getCidade().getUf().getSigla());
        if (ToolMethods.isStrWithData((String)cteOrdemColeta.getEmissorOC().getComplemento().getFone1())) {
            c.setTelefone(ToolString.refina((String)cteOrdemColeta.getEmissorOC().getComplemento().getFone1()));
        }
        return c;
    }

    private CTeNotaInfoCTeNormalInfoCTeSubstituicao getInfoCTeSubstituicao(Cte cte) {
        if (ToolMethods.isEquals((Object)cte.getTipoCte().getCodigo(), (Object)3)) {
            CTeNotaInfoCTeNormalInfoCTeSubstituicao c = new CTeNotaInfoCTeNormalInfoCTeSubstituicao();
            c.setChaveCTe(cte.getChaveCteSubstituicao());
            if (!ToolMethods.isEquals((Object)cte.getClienteTomador(), (Object)cte.getCteSubstituicaoOriginal().getClienteTomador())) {
                c.setIndicadorAlteracaoTomador(String.valueOf(EnumConstantsMentorSimNao.SIM.getValue()));
            }
            return c;
        }
        return null;
    }

    private List<CTeNotaInfoCTeComplementar> getCteComplementar(Cte cte) {
        ArrayList<CTeNotaInfoCTeComplementar> lista = new ArrayList<CTeNotaInfoCTeComplementar>();
        CTeNotaInfoCTeComplementar c = new CTeNotaInfoCTeComplementar();
        c.setChave(cte.getChaveComplementar());
        lista.add(c);
        return lista;
    }

    private List<CTeNotaInfoAutorizacaoDownload> getAutorizacaoDownload(Cte cte) {
        ArrayList<CTeNotaInfoAutorizacaoDownload> lista = new ArrayList<CTeNotaInfoAutorizacaoDownload>();
        for (CTeAutDownloadXML cteAutDownloadXml : cte.getCteDownloadXML()) {
            CTeNotaInfoAutorizacaoDownload c = new CTeNotaInfoAutorizacaoDownload();
            if (ToolString.refina((String)cteAutDownloadXml.getCnpjCPF()).length() > 11) {
                c.setCnpj(ToolString.refina((String)cteAutDownloadXml.getCnpjCPF()));
            } else {
                c.setCpf(ToolString.refina((String)cteAutDownloadXml.getCnpjCPF()));
            }
            lista.add(c);
        }
        return lista;
    }

    private CTeNotaInfoResponsavelTecnico getInformacaoResposavelTecnico(OpcoesFaturamentoTransp opcoesFaturamentoTransp) {
        if (ToolMethods.isEquals((Object)opcoesFaturamentoTransp.getInformarDadosRespTecnico(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            CTeNotaInfoResponsavelTecnico c = new CTeNotaInfoResponsavelTecnico();
            c.setCnpj(ConstantsNFeResponsavelTecnico.CNPJ);
            c.setContatoNome(ConstantsNFeResponsavelTecnico.CONTATO);
            c.setEmail(ConstantsNFeResponsavelTecnico.EMAIL);
            c.setTelefone(ConstantsNFeResponsavelTecnico.TELEFONE);
            return c;
        }
        return null;
    }

    private CTeNotaInfoSuplementares getInfoSuplementares(Cte cte, OpcoesFaturamentoTransp opcoesFaturamentoTransp) {
        CTeNotaInfoSuplementares c = new CTeNotaInfoSuplementares();
        c.setQrCode(CTAutorizador400.valueOfTipoEmissao((CTTipoEmissao)CTTipoEmissao.EMISSAO_NORMAL, (DFUnidadeFederativa)DFUnidadeFederativa.valueOfCodigo((String)cte.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getSigla())).getCteQrCode(DFAmbiente.valueOfCodigo((String)opcoesFaturamentoTransp.getTipoAmbiente().toString())) + "?chCTe=" + cte.getChaveCte() + "&tpAmb=" + opcoesFaturamentoTransp.getTipoAmbiente().toString());
        return c;
    }

    private String formatarFuso(Short tipoFusoHorario, FusoHorario fusoHorario) {
        if (ToolMethods.isEquals((Object)tipoFusoHorario, (Object)0)) {
            if (ToolMethods.isEqualsIgnoreCase((String)TimeZone.getDefault().getID(), (String)"America/Manaus") || ToolMethods.isEqualsIgnoreCase((String)TimeZone.getDefault().getID(), (String)"America/Rio_Branco") || ToolMethods.isEqualsIgnoreCase((String)TimeZone.getDefault().getID(), (String)"America/Eirunepe") || ToolMethods.isEqualsIgnoreCase((String)TimeZone.getDefault().getID(), (String)"America/Boa_Vista") || ToolMethods.isEqualsIgnoreCase((String)TimeZone.getDefault().getID(), (String)"America/Porto_Velho") || ToolMethods.isEqualsIgnoreCase((String)TimeZone.getDefault().getID(), (String)"America/Santarem") || ToolMethods.isEqualsIgnoreCase((String)TimeZone.getDefault().getID(), (String)"America/Cuiaba") || ToolMethods.isEqualsIgnoreCase((String)TimeZone.getDefault().getID(), (String)"America/Campo_Grande")) {
                return this.formatarHorarioVerao("-03:00", "-04:00");
            }
            if (ToolMethods.isEqualsIgnoreCase((String)TimeZone.getDefault().getID(), (String)"America/Noronha") || ToolMethods.isEqualsIgnoreCase((String)TimeZone.getDefault().getID(), (String)"America/Belem") || ToolMethods.isEqualsIgnoreCase((String)TimeZone.getDefault().getID(), (String)"America/Fortaleza") || ToolMethods.isEqualsIgnoreCase((String)TimeZone.getDefault().getID(), (String)"America/Recife") || ToolMethods.isEqualsIgnoreCase((String)TimeZone.getDefault().getID(), (String)"America/Araguaina") || ToolMethods.isEqualsIgnoreCase((String)TimeZone.getDefault().getID(), (String)"America/Maceio")) {
                return this.formatarHorarioVerao("-01:00", "-02:00");
            }
            return this.formatarHorarioVerao("-02:00", "-03:00");
        }
        return fusoHorario.getCodigo();
    }

    private String formatarHorarioVerao(String horarioVerao, String horarioSemVerao) {
        if (ToolDate.isHorarioVerao()) {
            return horarioVerao;
        }
        return horarioSemVerao;
    }

    private CTeNotaInfoCTeNormalInfoModalAquaviario getAquaviario(Cte cte) {
        CTeNotaInfoCTeNormalInfoModalAquaviario c = new CTeNotaInfoCTeNormalInfoModalAquaviario();
        c.setBalsa(this.getBalsa(cte));
        if (ToolMethods.isEquals((Object)cte.getModeloFiscalCte().getTipoServicoCte().getCodigo(), (Object)Integer.valueOf(ConstCTeTipoServico.REDESPACHO_INTERMEDIARIO.getCodigo())) || ToolMethods.isEquals((Object)cte.getModeloFiscalCte().getTipoServicoCte().getCodigo(), (Object)Integer.valueOf(ConstCTeTipoServico.SERVICO_VINCULADO_A_MULTIMODAL.getCodigo()))) {
            c.setContainer(this.getContainer(cte));
        }
        c.setDirecao(cte.getCteAquaviario().getDirecao());
        c.setIdentificacaoNavio(cte.getCteAquaviario().getNavio().getDescricao());
        c.setIrin(cte.getCteAquaviario().getNavio().getIdentificacaoEmbarcacao());
        c.setNumeroViagem(String.valueOf(cte.getCteAquaviario().getNumeroViagem()));
        c.setValorPrestacao(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteAquaviario().getBcAfrmm(), (int)2));
        c.setValorAdicionalFrete(ToolFormatter.arrredondarNumeroBigDecimal((Double)cte.getCteAquaviario().getVlrAfrmm(), (int)2));
        return c;
    }

    private List<CTeNotaInfoCTeNormalInfoModalAquaviarioBalsa> getBalsa(Cte cte) {
        ArrayList<CTeNotaInfoCTeNormalInfoModalAquaviarioBalsa> lista = new ArrayList<CTeNotaInfoCTeNormalInfoModalAquaviarioBalsa>();
        for (CteBalsa cteBalsa : cte.getCteAquaviario().getBalsas()) {
            CTeNotaInfoCTeNormalInfoModalAquaviarioBalsa c = new CTeNotaInfoCTeNormalInfoModalAquaviarioBalsa();
            c.setDescricao(cteBalsa.getEmbarcacao().getIdentificacaoEmbarcacao());
            lista.add(c);
        }
        return lista;
    }

    private List<CTeNotaInfoCTeNormalInfoModalAquaviarioConteiner> getContainer(Cte cte) {
        ArrayList<CTeNotaInfoCTeNormalInfoModalAquaviarioConteiner> lista = new ArrayList<CTeNotaInfoCTeNormalInfoModalAquaviarioConteiner>();
        for (CteContainer cteContainer : cte.getCteAquaviario().getContainers()) {
            CTeNotaInfoCTeNormalInfoModalAquaviarioConteiner c = new CTeNotaInfoCTeNormalInfoModalAquaviarioConteiner();
            c.setIdentificacao(cteContainer.getIdentificacaoContainer());
            c.setLacre(this.getLacre(cteContainer));
            c.setInfoDocumentos(this.getInfoDocumentos(cteContainer));
            lista.add(c);
        }
        return lista;
    }

    private List<CTeNotaInfoCTeNormalInfoModalAquaviarioConteinerLacre> getLacre(CteContainer cteContainer) {
        ArrayList<CTeNotaInfoCTeNormalInfoModalAquaviarioConteinerLacre> lista = new ArrayList<CTeNotaInfoCTeNormalInfoModalAquaviarioConteinerLacre>();
        for (CteLacre cteLacre : cteContainer.getLacres()) {
            CTeNotaInfoCTeNormalInfoModalAquaviarioConteinerLacre c = new CTeNotaInfoCTeNormalInfoModalAquaviarioConteinerLacre();
            c.setNumeroLacre(cteLacre.getIdentificacaoLacre());
            lista.add(c);
        }
        return lista;
    }

    private CTeNotaInfoCTeNormalInfoModalAquaviarioConteinerInfoDocumentos getInfoDocumentos(CteContainer cteContainer) {
        CTeNotaInfoCTeNormalInfoModalAquaviarioConteinerInfoDocumentos c = new CTeNotaInfoCTeNormalInfoModalAquaviarioConteinerInfoDocumentos();
        c.setInfoDocumentosNF(this.getInfoDocumentosNF(cteContainer));
        c.setInfoDocumentosNFe(this.getInfoDocumentosNFe(cteContainer));
        return c;
    }

    private List<CTeNotaInfoCTeNormalInfoModalAquaviarioConteinerInfoDocumentosNF> getInfoDocumentosNF(CteContainer cteContainer) {
        ArrayList<CTeNotaInfoCTeNormalInfoModalAquaviarioConteinerInfoDocumentosNF> lista = new ArrayList<CTeNotaInfoCTeNormalInfoModalAquaviarioConteinerInfoDocumentosNF>();
        for (CteInfNotaFiscal cteInfNotaFiscal : cteContainer.getNotasFiscais()) {
            if (!ToolMethods.isEquals((Object)cteInfNotaFiscal.getTipoNf(), (Object)EnumConstTipoNF.TIPO_NF.getEnumId())) continue;
            CTeNotaInfoCTeNormalInfoModalAquaviarioConteinerInfoDocumentosNF c = new CTeNotaInfoCTeNormalInfoModalAquaviarioConteinerInfoDocumentosNF();
            c.setNumero(String.valueOf(cteInfNotaFiscal.getNumeroNota()));
            c.setSerie(cteInfNotaFiscal.getSerie());
            c.setUnidadeRateada(ToolFormatter.arrredondarNumeroBigDecimal((Double)cteInfNotaFiscal.getUnidMedidaRat(), (int)2));
            lista.add(c);
        }
        return lista;
    }

    private List<CTeNotaInfoCTeNormalInfoModalAquaviarioConteinerInfoDocumentosNFe> getInfoDocumentosNFe(CteContainer cteContainer) {
        ArrayList<CTeNotaInfoCTeNormalInfoModalAquaviarioConteinerInfoDocumentosNFe> lista = new ArrayList<CTeNotaInfoCTeNormalInfoModalAquaviarioConteinerInfoDocumentosNFe>();
        for (CteInfNotaFiscal cteInfNotaFiscal : cteContainer.getNotasFiscais()) {
            if (!ToolMethods.isEquals((Object)cteInfNotaFiscal.getTipoNf(), (Object)EnumConstTipoNF.TIPO_NFE.getEnumId())) continue;
            CTeNotaInfoCTeNormalInfoModalAquaviarioConteinerInfoDocumentosNFe c = new CTeNotaInfoCTeNormalInfoModalAquaviarioConteinerInfoDocumentosNFe();
            c.setChave(cteInfNotaFiscal.getChaveAcesso());
            c.setUnidadeRateada(ToolFormatter.arrredondarNumeroBigDecimal((Double)cteInfNotaFiscal.getUnidMedidaRat(), (int)2));
            lista.add(c);
        }
        return lista;
    }

    private CTeNotaInfoCTeNormalInfoServicoVinculado getInfoServiceVinculado(Cte cte) {
        CTeNotaInfoCTeNormalInfoServicoVinculado c = new CTeNotaInfoCTeNormalInfoServicoVinculado();
        c.setInfoCTeMultiModal(this.getInfoCteMultimodal(cte));
        return c;
    }

    private List<CTeNotaInfoCTeNormalInfoServicoVinculadoInfoCTeMultiModal> getInfoCteMultimodal(Cte cte) {
        ArrayList<CTeNotaInfoCTeNormalInfoServicoVinculadoInfoCTeMultiModal> lista = new ArrayList<CTeNotaInfoCTeNormalInfoServicoVinculadoInfoCTeMultiModal>();
        for (CTeServVincMultimodal cteServVincMultimodal : cte.getCteServVincMultimodal()) {
            CTeNotaInfoCTeNormalInfoServicoVinculadoInfoCTeMultiModal c = new CTeNotaInfoCTeNormalInfoServicoVinculadoInfoCTeMultiModal();
            c.setChaveCTeMultiModal(cteServVincMultimodal.getChave());
            lista.add(c);
        }
        return lista;
    }

    private List<CTeNotaInfoCTeNormalVeiculosTransportados> getVeiculosTransportados(Cte cte) {
        ArrayList<CTeNotaInfoCTeNormalVeiculosTransportados> lista = new ArrayList<CTeNotaInfoCTeNormalVeiculosTransportados>();
        for (CTeVeiculosTransportados cteVeiculosTransportados : cte.getCteVeiculosTransportados()) {
            CTeNotaInfoCTeNormalVeiculosTransportados c = new CTeNotaInfoCTeNormalVeiculosTransportados();
            c.setChassi(cteVeiculosTransportados.getChassiVeiculo());
            c.setCodigoCor(cteVeiculosTransportados.getCodigoVeiculo());
            c.setCodigoMarcaModelo(cteVeiculosTransportados.getCodigoMarcaModelo());
            c.setDescricaoCor(cteVeiculosTransportados.getDescricaoCor());
            c.setValorUnitario(ToolFormatter.arrredondarNumeroBigDecimal((Double)cteVeiculosTransportados.getValorUnitarioVeiculo(), (int)2));
            c.setValorFrete(ToolFormatter.arrredondarNumeroBigDecimal((Double)cteVeiculosTransportados.getFreteUnitario(), (int)2));
            lista.add(c);
        }
        return lista;
    }
}

