/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.enviomensagens;

import com.touchcomp.basementorclientwebservices.enviomensagens.constants.ConstEnumMessage;
import com.touchcomp.basementorclientwebservices.enviomensagens.constants.ConstEnumMessageProvider;
import com.touchcomp.basementorclientwebservices.enviomensagens.impl.apibrasil.WebAPIBrasil;
import com.touchcomp.basementorclientwebservices.enviomensagens.impl.zenvia.zenvia2.WEBZenviaSender2;
import com.touchcomp.basementorclientwebservices.enviomensagens.model.WebEnvMensagem;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementortools.tools.string.TString;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class WEBEnvioMensagens {
    public void enviarMensagens(Config configuracao, List<WebEnvMensagem> mensagens) throws ExceptionIO, ExceptionInvalidData {
        this.ajustarNrs(mensagens);
        switch (configuracao.provider) {
            case ZENVIA: {
                new WEBZenviaSender2().sendMessages(configuracao, mensagens);
                break;
            }
            case API_BRASIL: {
                new WebAPIBrasil().sendMessages(configuracao, mensagens);
                break;
            }
            default: {
                throw new ExceptionErroProgramacao("Provedor nao mapeado " + String.valueOf((Object)configuracao.provider));
            }
        }
    }

    private void ajustarNrs(List<WebEnvMensagem> mensagens) {
        for (WebEnvMensagem msg : mensagens) {
            for (WebEnvMensagem.DTORecipients rec : msg.getRecipients()) {
                Object dest = rec.getRecipientIdentifier();
                if (TString.isAIntNumber((String)rec.getRecipientIdentifier())) {
                    dest = String.valueOf(TString.removerZerosAEsquerda((String)dest));
                }
                if (dest != null && !((String)dest).startsWith("55")) {
                    dest = "55" + (String)dest;
                }
                rec.setRecipientIdentifier((String)dest);
            }
        }
    }

    public static class Config {
        private String user;
        private String pass;
        private String token;
        private String tokenIdTemplate;
        private ConstEnumMessage tipoEnvio;
        private ConstEnumMessageProvider provider;

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public ConstEnumMessage getTipoEnvio() {
            return this.tipoEnvio;
        }

        public void setTipoEnvio(ConstEnumMessage tipoEnvio) {
            this.tipoEnvio = tipoEnvio;
        }

        public ConstEnumMessageProvider getProvider() {
            return this.provider;
        }

        public void setProvider(ConstEnumMessageProvider provider) {
            this.provider = provider;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getPass() {
            return this.pass;
        }

        public void setPass(String pass) {
            this.pass = pass;
        }

        public String getTokenIdTemplate() {
            return this.tokenIdTemplate;
        }

        public void setTokenIdTemplate(String tokenIdTemplate) {
            this.tokenIdTemplate = tokenIdTemplate;
        }
    }
}

