/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.enviomensagens.impl.apibrasil;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementorclientwebservices.enviomensagens.WEBEnvioMensagens;
import com.touchcomp.basementorclientwebservices.enviomensagens.constants.ConstEnumMessage;
import com.touchcomp.basementorclientwebservices.enviomensagens.model.WebEnvMensagem;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.base64.ToolBase64;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class WebAPIBrasil {
    private static final String URL_ENVIO_MSG_WHATS = "https://gateway.apibrasil.io/api/v2/whatsapp/sendText";
    private static final String URL_SEND_FILE_WHATSAPP = "https://gateway.apibrasil.io/api/v2/whatsapp/sendFile64";
    private static final String URL_LOGIN = "https://gateway.apibrasil.io/api/v2/login";
    private static final String URL_LOGOUT = "https://gateway.apibrasil.io/api/v2/logout";
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");

    public void sendMessages(WEBEnvioMensagens.Config configEnvio, WebEnvMensagem mensagens) throws ExceptionIO, ExceptionInvalidData {
        this.sendMessages(configEnvio, ToolMethods.toList((Object[])new Object[]{mensagens}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessages(WEBEnvioMensagens.Config configEnvio, List<WebEnvMensagem> mensagens) throws ExceptionIO, ExceptionInvalidData {
        String loginToken = this.getToken(configEnvio);
        try {
            for (WebEnvMensagem msg : mensagens) {
                for (WebEnvMensagem.DTORecipients recipient : msg.getRecipients()) {
                    try {
                        ConstEnumMessage type = configEnvio.getTipoEnvio();
                        if (msg.getTipoEnvio() != null) {
                            type = msg.getTipoEnvio();
                        }
                        switch (type) {
                            case SMS: {
                                throw new ExceptionInvalidData("Tipo de envio nao suportado.", new Object[0]);
                            }
                            case WHATSAPP: {
                                InternalWhats internalmsg = new InternalWhats();
                                internalmsg.setText(msg.getMessage());
                                internalmsg.setNumber(recipient.getRecipientIdentifier());
                                String toSend = ToolJson.toJson((Object)internalmsg);
                                this.sendMessage(loginToken, configEnvio.getToken(), msg, toSend, URL_ENVIO_MSG_WHATS);
                                this.sendFiles(loginToken, configEnvio.getToken(), msg.getRecipients(), msg, msg.getAnexos());
                                break;
                            }
                            default: {
                                throw new ExceptionErroProgramacao("tipo mensagem nao mapeado " + String.valueOf((Object)msg.getTipoEnvio()));
                            }
                        }
                    }
                    catch (ExceptionIO ex) {
                        TLogger.get(this.getClass()).error((Throwable)ex);
                        msg.setStatus(EnumConstantsMentorStatus.ERRO);
                    }
                }
            }
        }
        finally {
            this.logout(loginToken);
        }
    }

    private String login(String message, String deviceToken) throws ExceptionIO {
        String string;
        block9: {
            OkHttpClient client = new OkHttpClient();
            RequestBody body = RequestBody.create((MediaType)JSON, (String)message);
            Request request = new Request.Builder().url(URL_LOGIN).post(body).addHeader("DeviceToken", deviceToken).build();
            Response response = client.newCall(request).execute();
            try {
                String ret;
                string = ret = response.body().string();
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MalformedURLException ex) {
                    throw new ExceptionIO((IOException)ex);
                }
                catch (IOException ex) {
                    throw new ExceptionIO(ex);
                }
            }
            response.close();
        }
        return string;
    }

    private String sendMessage(String token, String deviceToken, WebEnvMensagem envMsg, String message, String urlPath) throws ExceptionIO {
        String string;
        block11: {
            OkHttpClient client = new OkHttpClient.Builder().connectTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).writeTimeout(1L, TimeUnit.MINUTES).build();
            RequestBody body = RequestBody.create((MediaType)JSON, (String)message);
            Request request = new Request.Builder().url(urlPath).post(body).addHeader("DeviceToken", deviceToken).addHeader("Authorization", "Bearer " + token).build();
            Response response = client.newCall(request).execute();
            try {
                String ret = response.body().string();
                Map m = ToolJson.readJsonAsMap((String)ret);
                if (TMethods.isEquals((Object)String.valueOf(Boolean.TRUE), (Object)String.valueOf(m.get("error")))) {
                    envMsg.setStatus(EnumConstantsMentorStatus.ERRO);
                    envMsg.setErrorMessage(String.valueOf(m.get("device_ip")) + "/" + String.valueOf(m.get("message")));
                } else {
                    envMsg.setStatus(EnumConstantsMentorStatus.SUCESSO);
                }
                string = ret;
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MalformedURLException ex) {
                    throw new ExceptionIO((IOException)ex);
                }
                catch (IOException ex) {
                    throw new ExceptionIO(ex);
                }
            }
            response.close();
        }
        return string;
    }

    private void sendFiles(String token, String deviceToken, List<WebEnvMensagem.DTORecipients> destNumber, WebEnvMensagem envMsg, List<WebEnvMensagem.DTOFileDetails> files) throws ExceptionIO {
        try {
            if (!TMethods.isEquals((Object)envMsg.getStatus(), (Object)EnumConstantsMentorStatus.SUCESSO)) {
                return;
            }
            OkHttpClient client = new OkHttpClient.Builder().connectTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).writeTimeout(1L, TimeUnit.MINUTES).build();
            for (WebEnvMensagem.DTOFileDetails file : files) {
                byte[] data = ToolFile.getBytesFromFile((File)file.getFile());
                InternalFile aux = new InternalFile();
                aux.setCaption(file.getFileName());
                aux.setPath("data:application/pdf;base64," + ToolBase64.encodeBase64((byte[])data));
                for (WebEnvMensagem.DTORecipients dest : destNumber) {
                    aux.setNumber(dest.getRecipientIdentifier());
                    RequestBody body = RequestBody.create((MediaType)JSON, (String)ToolJson.toJson((Object)aux));
                    Request request = new Request.Builder().url(URL_SEND_FILE_WHATSAPP).post(body).addHeader("DeviceToken", deviceToken).addHeader("Authorization", "Bearer " + token).build();
                    Response response = client.newCall(request).execute();
                    try {
                        String ret = response.body().string();
                        Map m = ToolJson.readJsonAsMap((String)ret);
                        if (TMethods.isEquals((Object)String.valueOf(Boolean.TRUE), (Object)String.valueOf(m.get("error")))) {
                            envMsg.setStatus(EnumConstantsMentorStatus.ERRO);
                            envMsg.setErrorMessage(String.valueOf(m.get("device_ip")) + "/" + String.valueOf(m.get("message")));
                            return;
                        }
                        envMsg.setStatus(EnumConstantsMentorStatus.SUCESSO);
                    }
                    finally {
                        if (response == null) continue;
                        response.close();
                    }
                }
            }
        }
        catch (MalformedURLException ex) {
            throw new ExceptionIO((IOException)ex);
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex);
        }
    }

    private String getToken(WEBEnvioMensagens.Config configEnvio) throws ExceptionIO, ExceptionInvalidData {
        if (!TMethods.isStrWithData((String)configEnvio.getPass()) && TMethods.isStrWithData((String)configEnvio.getUser())) {
            return configEnvio.getUser();
        }
        InternalLogin login = new InternalLogin();
        login.setEmail(configEnvio.getUser());
        login.setPassword(configEnvio.getPass());
        String toSend = ToolJson.toJson((Object)login);
        String ret = this.login(toSend, configEnvio.getToken());
        Map map = ToolJson.readJsonAsMap((String)ret);
        Boolean error = (Boolean)map.get("error");
        if (error == null || error.booleanValue()) {
            throw new ExceptionInvalidData("E.ERP.1838.002", new Object[]{map.get("message")});
        }
        Map auth = (Map)map.get("authorization");
        return (String)auth.get("token");
    }

    private void logout(String token) throws ExceptionIO {
        try {
            OkHttpClient client = new OkHttpClient();
            RequestBody body = RequestBody.create((MediaType)JSON, (String)"");
            Request request = new Request.Builder().url(URL_LOGOUT).post(body).addHeader("DeviceToken", token).build();
            Response response = client.newCall(request).execute();
            if (response != null) {
                response.close();
            }
            return;
        }
        catch (MalformedURLException ex) {
            throw new ExceptionIO((IOException)ex);
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex);
        }
    }

    static class InternalWhats {
        private String number;
        private String text;
        private int timeTyping = 1;

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public int getTimeTyping() {
            return this.timeTyping;
        }

        public void setTimeTyping(int timeTyping) {
            this.timeTyping = timeTyping;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }

    static class InternalFile {
        private String number;
        private String path;
        private String caption;

        InternalFile() {
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getCaption() {
            return this.caption;
        }

        public void setCaption(String caption) {
            this.caption = caption;
        }
    }

    static class InternalLogin {
        private String email;
        private String password;

        InternalLogin() {
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String pass) {
            this.password = pass;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }
    }

    static class InternalSMS {
        private String number;
        private String message;

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

