/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.enviomensagens.impl.zenvia.zenvia1.sms.multiple;

import com.touchcomp.basementorclientwebservices.enviomensagens.impl.zenvia.zenvia1.ZenviaSender;
import com.touchcomp.basementorclientwebservices.enviomensagens.impl.zenvia.zenvia1.model.DTOMessageResp;
import com.touchcomp.basementorclientwebservices.enviomensagens.impl.zenvia.zenvia1.model.DTOMultipleMSGResp;
import com.touchcomp.basementorclientwebservices.enviomensagens.impl.zenvia.zenvia1.model.ZenviaConfig;
import com.touchcomp.basementorclientwebservices.enviomensagens.impl.zenvia.zenvia1.sms.multiple.DTOSimpleMultipleMsg;
import com.touchcomp.basementorclientwebservices.enviomensagens.impl.zenvia.zenvia1.sms.multiple.WebZenviaSMSInterface;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.springframework.stereotype.Component;
import retrofit2.Call;
import retrofit2.Response;

@Component
public class WEBZenviaSMSMultiple
extends ZenviaSender {
    private final String STATUS_OK = "00";

    public DTOMultipleMSGResp sendMultipleMsg(ZenviaConfig config, DTOSimpleMultipleMsg msgs) throws ExceptionIO {
        List<DTOSimpleMultipleMsg.DTOMessage> aux = msgs.getSendSmsMultiRequest().getSendSmsRequestList();
        List[] packs = ToolMethods.splitList(aux, (int)100);
        LinkedList<DTOMessageResp> respMsg = new LinkedList<DTOMessageResp>();
        DTOMultipleMSGResp mult = null;
        for (List pack : packs) {
            msgs.getSendSmsMultiRequest().setSendSmsRequestList(pack);
            try {
                this.normalizarNumeros(msgs);
                WebZenviaSMSInterface resource = (WebZenviaSMSInterface)this.getRetrofit(config).create(WebZenviaSMSInterface.class);
                Call<DTOMultipleMSGResp> books = resource.sendSmsMultiple(msgs);
                Response res = books.execute();
                if (!res.isSuccessful()) {
                    throw new Exception("Ocorreu um erro ao processar a requisicao: " + res.code() + " Mensagem: " + res.message());
                }
                mult = (DTOMultipleMSGResp)res.body();
                if (mult == null || mult.getSendSmsMultiResponse() == null) continue;
                respMsg.addAll(mult.getSendSmsMultiResponse().getSendSmsResponseList());
            }
            catch (Exception ex) {
                TLogger.get(this.getClass()).error((Throwable)ex);
                throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
            }
        }
        this.translateRespMessages(respMsg);
        for (int i = 0; i < msgs.getSendSmsMultiRequest().getSendSmsRequestList().size(); ++i) {
            if (i >= respMsg.size()) continue;
            DTOMessageResp resp = (DTOMessageResp)respMsg.get(i);
            DTOSimpleMultipleMsg.DTOMessage dto = msgs.getSendSmsMultiRequest().getSendSmsRequestList().get(i);
            resp.setSuccess(this.checkIt(resp));
            resp.setIdentificador(dto.getId());
        }
        if (mult != null) {
            mult.getSendSmsMultiResponse().setSendSmsResponseList(respMsg);
        }
        return mult;
    }

    private void normalizarNumeros(DTOSimpleMultipleMsg msgs) {
        for (DTOSimpleMultipleMsg.DTOMessage msg : msgs.getSendSmsMultiRequest().getSendSmsRequestList()) {
            msg.setTo(this.normalizarNrTelefone(msg.getTo()));
            msg.setFrom(this.normalizarNrTelefone(msg.getFrom()));
        }
    }

    private boolean checkIt(DTOMessageResp resp) {
        return ToolMethods.isEquals((Object)"00", (Object)resp.getStatusCode());
    }

    protected void translateRespMessages(List<DTOMessageResp> respMsg) {
        try {
            Properties statusCode = new Properties();
            Properties statusDetailCode = new Properties();
            statusCode.load(this.getClass().getResourceAsStream("/com/touchcomp/basementorclientwebservices/zenvia/sms/multiple/zenvia_status_code.properties"));
            statusDetailCode.load(this.getClass().getResourceAsStream("/com/touchcomp/basementorclientwebservices/zenvia/sms/multiple/zenvia_status_detail_code.properties"));
            for (DTOMessageResp d : respMsg) {
                String status = statusCode.getProperty(d.getStatusCode(), d.getStatusDescription());
                String detail = statusDetailCode.getProperty(d.getDetailCode(), d.getDetailDescription());
                d.setDetailDescriptionTrad(detail);
                d.setStatusDescriptionTrad(status);
            }
        }
        catch (IOException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
        }
    }
}

