/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.enviomensagens.impl.zenvia.zenvia2;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementorclientwebservices.enviomensagens.WEBEnvioMensagens;
import com.touchcomp.basementorclientwebservices.enviomensagens.constants.ConstEnumMessage;
import com.touchcomp.basementorclientwebservices.enviomensagens.impl.UtilMessages;
import com.touchcomp.basementorclientwebservices.enviomensagens.model.WebEnvMensagem;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.zenvia.api.sdk.client.Channel;
import com.zenvia.api.sdk.client.ChannelType;
import com.zenvia.api.sdk.client.apache.Client;
import com.zenvia.api.sdk.client.exceptions.ApiException;
import com.zenvia.api.sdk.client.exceptions.UnsuccessfulRequestException;
import com.zenvia.api.sdk.contents.Content;
import com.zenvia.api.sdk.contents.TemplateContent;
import com.zenvia.api.sdk.contents.TextContent;
import com.zenvia.api.sdk.messages.Message;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class WEBZenviaSender2 {
    public void sendMessages(WEBEnvioMensagens.Config configEnvio, WebEnvMensagem mensagens) throws ExceptionIO {
        this.sendMessages(configEnvio, ToolMethods.toList((Object[])new Object[]{mensagens}));
    }

    public void sendMessages(WEBEnvioMensagens.Config configEnvio, List<WebEnvMensagem> mensagens) throws ExceptionIO {
        Client client = new Client(configEnvio.getToken());
        for (WebEnvMensagem msg : mensagens) {
            Channel channel = this.getChannel(configEnvio, msg, client);
            LinkedList<Content> data = new LinkedList<Content>();
            HashMap<String, String> tokens = new HashMap<String, String>();
            Object arquivos = "";
            for (WebEnvMensagem.DTOFileDetails anexo : msg.getAnexos()) {
                arquivos = (String)arquivos + anexo.getUrlArquivo() + "; ";
            }
            data.add(this.getMensagemByType(configEnvio, msg, tokens));
            for (WebEnvMensagem.DTORecipients recipient : msg.getRecipients()) {
                try {
                    Message response = channel.sendMessage(UtilMessages.getNumberWithCountryCode(msg.getSenderIdentifier()), UtilMessages.getNumberWithCountryCode(recipient.getRecipientIdentifier()), data);
                    msg.setStatus(EnumConstantsMentorStatus.SUCESSO);
                }
                catch (UnsuccessfulRequestException exception) {
                    TLogger.get(this.getClass()).error((Throwable)exception);
                    msg.setStatus(EnumConstantsMentorStatus.ERRO);
                    msg.setErrorMessage(exception.body.message);
                }
                catch (ApiException exception) {
                    TLogger.get(this.getClass()).error((Throwable)exception);
                    msg.setStatus(EnumConstantsMentorStatus.ERRO);
                    msg.setErrorMessage(exception.message);
                }
            }
        }
    }

    private Channel getChannel(WEBEnvioMensagens.Config configEnvio, WebEnvMensagem msg, Client client) {
        ConstEnumMessage tipo = msg.getTipoEnvio();
        if (tipo == null) {
            tipo = configEnvio.getTipoEnvio();
        }
        switch (tipo) {
            case SMS: {
                return client.getChannel(ChannelType.sms);
            }
            case WHATSAPP: {
                return client.getChannel(ChannelType.whatsapp);
            }
        }
        throw new ExceptionErroProgramacao("Tipo de envio ainda nao programado: " + String.valueOf((Object)tipo));
    }

    private Content getMensagemByType(WEBEnvioMensagens.Config configEnvio, WebEnvMensagem msg, HashMap<String, String> tokens) {
        switch (msg.getTipoMensagem()) {
            case TEMPLATE: {
                return new TemplateContent(configEnvio.getTokenIdTemplate(), tokens);
            }
        }
        return new TextContent(msg.getMessage());
    }
}

