/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.enviomensagens.model;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementorclientwebservices.enviomensagens.constants.ConstEnumMessage;
import com.touchcomp.basementorclientwebservices.enviomensagens.constants.ConstEnumMessageType;
import com.touchcomp.basementortools.tools.string.TString;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public class WebEnvMensagem {
    private String idMessage;
    private ConstEnumMessage tipoEnvio;
    private ConstEnumMessageType tipoMensagem;
    private String senderIdentifier;
    private List<DTORecipients> recipients = new LinkedList<DTORecipients>();
    private List<DTOFileDetails> anexos = new LinkedList<DTOFileDetails>();
    private String message;
    private EnumConstantsMentorStatus status;
    private String errorMessage;

    public WebEnvMensagem() {
        this.tipoMensagem = ConstEnumMessageType.TEXT;
    }

    public void addFile(DTOFileDetails file) {
        this.getAnexos().add(file);
    }

    public void addRecipients(String ... recipients) {
        if (recipients == null) {
            return;
        }
        for (String recipient : recipients) {
            String[] data;
            for (String rec : data = TString.splitString((String)recipient, (char[])new char[0])) {
                this.recipients.add(new DTORecipients(rec));
            }
        }
    }

    public String getIdMessage() {
        return this.idMessage;
    }

    public void setIdMessage(String idMessage) {
        this.idMessage = idMessage;
    }

    public String getSenderIdentifier() {
        return this.senderIdentifier;
    }

    public void setSenderIdentifier(String senderIdentifier) {
        this.senderIdentifier = senderIdentifier;
    }

    public List<DTORecipients> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<DTORecipients> recipients) {
        this.recipients = recipients;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ConstEnumMessage getTipoEnvio() {
        return this.tipoEnvio;
    }

    public void setTipoEnvio(ConstEnumMessage tipoEnvio) {
        this.tipoEnvio = tipoEnvio;
    }

    public EnumConstantsMentorStatus getStatus() {
        return this.status;
    }

    public void setStatus(EnumConstantsMentorStatus status) {
        this.status = status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public List<DTOFileDetails> getAnexos() {
        return this.anexos;
    }

    public void setAnexos(List<DTOFileDetails> anexos) {
        this.anexos = anexos;
    }

    public ConstEnumMessageType getTipoMensagem() {
        return this.tipoMensagem;
    }

    public void setTipoMensagem(ConstEnumMessageType tipoMensagem) {
        this.tipoMensagem = tipoMensagem;
    }

    public static class DTORecipients {
        private String recipientIdentifier;

        public DTORecipients(String recipientIdentifier) {
            this.recipientIdentifier = recipientIdentifier;
        }

        public String getRecipientIdentifier() {
            return this.recipientIdentifier;
        }

        public void setRecipientIdentifier(String recipientIdentifier) {
            this.recipientIdentifier = recipientIdentifier;
        }
    }

    public static class DTOFileDetails {
        private File file;
        private String urlArquivo;
        private String fileName;

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public String getUrlArquivo() {
            return this.urlArquivo;
        }

        public void setUrlArquivo(String urlArquivo) {
            this.urlArquivo = urlArquivo;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }
    }
}

