/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial;

import com.touchcomp.basementorclientwebservices.certificado.CertificadoConfClienteWebservice;
import com.touchcomp.basementorclientwebservices.constants.EnumTipoCertificado;
import com.touchcomp.basementorexceptions.exceptions.impl.assinaturaxml.ExceptionAssinaturaXML;
import com.touchcomp.basementorexceptions.exceptions.impl.certificado.EnumCertificado;
import com.touchcomp.basementorexceptions.exceptions.impl.certificado.ExceptionCertificado;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SignatureXmlEsocial {
    public static String assinarXMLEsocial(String xmlEnt) throws ExceptionCertificado, ExceptionAssinaturaXML, ExceptionIO {
        try {
            return SignatureXmlEsocial.assinarXML(xmlEnt);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (UnrecoverableEntryException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (KeyStoreException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (CertificateException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (MarshalException ex) {
            throw new ExceptionAssinaturaXML(ex);
        }
        catch (XMLSignatureException ex) {
            throw new ExceptionAssinaturaXML(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new ExceptionAssinaturaXML(ex);
        }
        catch (TransformerException ex) {
            throw new ExceptionAssinaturaXML(ex);
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex);
        }
        catch (SAXException ex) {
            throw new ExceptionAssinaturaXML(ex);
        }
    }

    private static KeyStore.PrivateKeyEntry getKeyEntry() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableEntryException, ExceptionCertificado {
        KeyStore ks;
        CertificadoConfClienteWebservice se = CertificadoConfClienteWebservice.getConfiguracaoCertificado();
        Provider p = se.getProvider();
        if (se.getParams().getTipoCertificado() == EnumTipoCertificado.CERTIFICADO_A3) {
            ks = KeyStore.getInstance("pkcs11", p);
            ks.load(null, se.getParams().getSenhaCertificado().toCharArray());
        } else {
            ks = KeyStore.getInstance("PKCS12");
            ks.load(new ByteArrayInputStream(se.getParams().getPathCertificadoA1()), se.getParams().getSenhaCertificado().toCharArray());
        }
        KeyStore.PrivateKeyEntry pkEntry = null;
        Enumeration<String> aliasesEnum = ks.aliases();
        while (aliasesEnum.hasMoreElements()) {
            String alias = aliasesEnum.nextElement();
            System.out.println(alias);
            if (!ks.isKeyEntry(alias)) continue;
            pkEntry = (KeyStore.PrivateKeyEntry)ks.getEntry(alias, new KeyStore.PasswordProtection(se.getParams().getSenhaCertificado().toCharArray()));
            return pkEntry;
        }
        throw new ExceptionCertificado(EnumCertificado.CERTIFICADO_NAO_CONFIGURADO, new Object[0]);
    }

    private static String assinarXML(String xml) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableEntryException, ExceptionCertificado, InvalidAlgorithmParameterException, ParserConfigurationException, SAXException, MarshalException, XMLSignatureException, TransformerConfigurationException, TransformerException {
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        ArrayList<Transform> transforms = new ArrayList<Transform>();
        transforms.add(fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
        transforms.add(fac.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (TransformParameterSpec)null));
        Reference ref = fac.newReference("", fac.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null), transforms, null, null);
        SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), fac.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", null), Collections.singletonList(ref));
        KeyStore.PrivateKeyEntry keyEntry = SignatureXmlEsocial.getKeyEntry();
        X509Certificate cert = (X509Certificate)keyEntry.getCertificate();
        KeyInfoFactory kif = fac.getKeyInfoFactory();
        ArrayList<X509Certificate> x509Content = new ArrayList<X509Certificate>();
        x509Content.add(cert);
        X509Data xd = kif.newX509Data(x509Content);
        KeyInfo ki = kif.newKeyInfo(Collections.singletonList(xd));
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        InputSource is = new InputSource(new StringReader(xml));
        Document doc = dbf.newDocumentBuilder().parse(is);
        Element esocialNode = doc.getDocumentElement();
        DOMSignContext dsc = new DOMSignContext(keyEntry.getPrivateKey(), (Node)esocialNode);
        XMLSignature signature = fac.newXMLSignature(si, ki);
        signature.sign(dsc);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        trans.transform(new DOMSource(doc), new StreamResult(writer));
        String output = writer.getBuffer().toString();
        return output;
    }
}

