/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evtTabCargo;

import com.touchcomp.basementor.constants.enums.EnumEsocialTipoEvento;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evttabcargo.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evttabcargo.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evttabcargo.TDadosCargo;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evttabcargo.TEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evttabcargo.TIdeCadastro;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evttabcargo.TPeriodoValidade;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evttabcargo.TideCargo;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Date;

public class ImpTabCargo
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoesEsocial) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoesEsocial);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoesEsocial) throws ExceptionEsocial {
        Funcao funcao = preEvento.getFuncao();
        ESocial root = this.getFact().createESocial();
        root.setEvtTabCargo(this.getEvtTabCargo(funcao, opcoesEsocial, preEvento));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtTabCargo getEvtTabCargo(Funcao funcao, OpcoesESocial opcoesEsocial, EsocPreEvento preEvento) throws ExceptionEsocial {
        ESocial.EvtTabCargo evt = this.getFact().createESocialEvtTabCargo();
        evt.setIdeEmpregador(this.getIdEmpregador(opcoesEsocial));
        evt.setIdeEvento(this.getIdEvento(opcoesEsocial, preEvento.getEsocEvento()));
        evt.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evt.setInfoCargo(this.getInfoCargo(funcao, preEvento));
        return evt;
    }

    private TEmpregador getIdEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TEmpregador tEmpregador = this.getFact().createTEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private TIdeCadastro getIdEvento(OpcoesESocial opcoes, EsocEvento esoc) {
        TIdeCadastro cadastro = this.getFact().createTIdeCadastro();
        cadastro.setTpAmb(Byte.parseByte(esoc.getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        cadastro.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        cadastro.setVerProc(this.getVersaoEsocialSistema());
        return cadastro;
    }

    private ESocial.EvtTabCargo.InfoCargo getInfoCargo(Funcao funcao, EsocPreEvento preEvento) {
        ESocial.EvtTabCargo.InfoCargo info = this.getFact().createESocialEvtTabCargoInfoCargo();
        if (preEvento.getTipoEvento() == EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value) {
            info.setInclusao(this.getInclusao(funcao, preEvento));
        } else if (preEvento.getTipoEvento() == EnumEsocialTipoEvento.TIPO_EVENTO_ALTERACAO.value) {
            info.setAlteracao(this.getAlteracao(funcao, preEvento));
        } else if (preEvento.getTipoEvento() == EnumEsocialTipoEvento.TIPO_EVENTO_EXLUSAO.value) {
            info.setExclusao(this.getExclusao(funcao, preEvento));
        }
        return info;
    }

    private ESocial.EvtTabCargo.InfoCargo.Inclusao getInclusao(Funcao funcao, EsocPreEvento preEvento) {
        ESocial.EvtTabCargo.InfoCargo.Inclusao inclusao = this.getFact().createESocialEvtTabCargoInfoCargoInclusao();
        inclusao.setIdeCargo(this.getIdeCargo(funcao, preEvento));
        inclusao.setDadosCargo(this.getDadosCargo(funcao));
        return inclusao;
    }

    private TideCargo getIdeCargo(Funcao funcao, EsocPreEvento preEvento) {
        TideCargo tiCargo = this.getFact().createTideCargo();
        tiCargo.setCodCargo(funcao.getCodigoCargo());
        tiCargo.setIniValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataInicioVal()));
        if (preEvento.getDataFimVal() != null) {
            tiCargo.setFimValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataFimVal()));
        }
        return tiCargo;
    }

    private TDadosCargo getDadosCargo(Funcao funcao) {
        TDadosCargo tDados = this.getFact().createTDadosCargo();
        tDados.setNmCargo(this.clearInvalidUTF8Char(funcao.getDescricao()));
        tDados.setCodCBO(this.clearInvalidUTF8Char(ToolString.refina((String)funcao.getCbo().getCodigo())));
        return tDados;
    }

    private ESocial.EvtTabCargo.InfoCargo.Alteracao getAlteracao(Funcao funcao, EsocPreEvento preEvento) {
        ESocial.EvtTabCargo.InfoCargo.Alteracao alteracao = this.getFact().createESocialEvtTabCargoInfoCargoAlteracao();
        alteracao.setIdeCargo(this.getIdeCargoAlteracao(funcao, preEvento));
        alteracao.setDadosCargo(this.getDadosCargo(funcao));
        alteracao.setNovaValidade(this.getNovaValidade(preEvento));
        return alteracao;
    }

    private TideCargo getIdeCargoAlteracao(Funcao funcao, EsocPreEvento preEvento) {
        TideCargo tiCargo = this.getFact().createTideCargo();
        tiCargo.setCodCargo(funcao.getCodigoCargo());
        tiCargo.setIniValid(ToolDate.formatDateAnoMes((Date)preEvento.getEventoAnterior().getDataInicioVal()));
        if (preEvento.getEventoAnterior().getDataFimVal() != null) {
            tiCargo.setFimValid(ToolDate.formatDateAnoMes((Date)preEvento.getEventoAnterior().getDataFimVal()));
        }
        return tiCargo;
    }

    private TPeriodoValidade getNovaValidade(EsocPreEvento preEvento) {
        TPeriodoValidade tPeriodo = this.getFact().createTPeriodoValidade();
        tPeriodo.setIniValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataInicioVal()));
        if (preEvento.getDataFimVal() != null) {
            tPeriodo.setIniValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataFimVal()));
        }
        return tPeriodo;
    }

    private ESocial.EvtTabCargo.InfoCargo.Exclusao getExclusao(Funcao funcao, EsocPreEvento preEvento) {
        ESocial.EvtTabCargo.InfoCargo.Exclusao exclusao = this.getFact().createESocialEvtTabCargoInfoCargoExclusao();
        exclusao.setIdeCargo(this.getIdeCargo(funcao, preEvento));
        return exclusao;
    }
}

