/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evtafasttemp;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.model.vo.AfastamentoColaborador;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtafasttemp.v_s_01_03_00.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtafasttemp.v_s_01_03_00.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtafasttemp.v_s_01_03_00.TIdeEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtafasttemp.v_s_01_03_00.TIdeEventoTrab;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtafasttemp.v_s_01_03_00.TSSimNao;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Date;

public class ImpEvtAfastTemp
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        AfastamentoColaborador af = preEvento.getAfastamentoColaborador();
        ESocial root = this.getFact().createESocial();
        root.setEvtAfastTemp(this.getEvtAfastTemp(preEvento, opcoes, af));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtAfastTemp getEvtAfastTemp(EsocPreEvento preEvento, OpcoesESocial opcoes, AfastamentoColaborador af) throws ExceptionEsocial {
        ESocial.EvtAfastTemp evt = this.getFact().createESocialEvtAfastTemp();
        evt.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evt.setIdeEmpregador(this.getIdEmpregador(opcoes));
        evt.setIdeEvento(this.getIdEvento(opcoes, preEvento.getEsocEvento()));
        evt.setIdeVinculo(this.getIdVinculo(af));
        evt.setInfoAfastamento(this.getInfoAfastamento(preEvento, af));
        return evt;
    }

    private TIdeEmpregador getIdEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TIdeEmpregador tEmpregador = this.getFact().createTIdeEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private TIdeEventoTrab getIdEvento(OpcoesESocial opcoes, EsocEvento esocEvento) {
        TIdeEventoTrab tiTrab = this.getFact().createTIdeEventoTrab();
        tiTrab.setTpAmb(Byte.parseByte(esocEvento.getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        tiTrab.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        tiTrab.setVerProc(this.getVersaoEsocialSistema());
        if (esocEvento.getPreEvento().getEventoRetificacao().equals((short)1)) {
            tiTrab.setIndRetif(Byte.parseByte("2"));
            tiTrab.setNrRecibo(esocEvento.getPreEvento().getNumeroReciboRetificado());
        } else {
            tiTrab.setIndRetif(Byte.parseByte("1"));
        }
        return tiTrab;
    }

    private ESocial.EvtAfastTemp.IdeVinculo getIdVinculo(AfastamentoColaborador af) {
        ESocial.EvtAfastTemp.IdeVinculo vinculo = this.getFact().createESocialEvtAfastTempIdeVinculo();
        vinculo.setCpfTrab(af.getColaborador().getPessoa().getComplemento().getCnpj());
        vinculo.setMatricula(af.getColaborador().getNumeroRegistroESocial());
        return vinculo;
    }

    private ESocial.EvtAfastTemp.InfoAfastamento getInfoAfastamento(EsocPreEvento preEvento, AfastamentoColaborador af) {
        ESocial.EvtAfastTemp.InfoAfastamento info = this.getFact().createESocialEvtAfastTempInfoAfastamento();
        if (af.getEsocMotivoAfastamento().getCodigo().equals("06")) {
            info.setIniAfastamento(this.getInicioAfastamento(af));
            return info;
        }
        if (af.getQtdadeDiasConcedidos() > 15 || af.getDataAfastamento() != null) {
            if (preEvento.getTipoAfastamento().equals(ConstantsESocial.AF_RETORNO)) {
                info.setFimAfastamento(this.getFimAfastamento(af));
            } else {
                info.setIniAfastamento(this.getInicioAfastamento(af));
            }
        } else {
            if (!preEvento.getTipoAfastamento().equals(ConstantsESocial.AF_RETORNO)) {
                info.setIniAfastamento(this.getInicioAfastamento(af));
            }
            if (af.getDataRetorno() != null) {
                info.setFimAfastamento(this.getFimAfastamento(af));
            }
        }
        return info;
    }

    private ESocial.EvtAfastTemp.InfoAfastamento.IniAfastamento getInicioAfastamento(AfastamentoColaborador af) {
        ESocial.EvtAfastTemp.InfoAfastamento.IniAfastamento i = this.getFact().createESocialEvtAfastTempInfoAfastamentoIniAfastamento();
        i.setDtIniAfast(ToolEsocial.converteData(af.getDataInicio()));
        i.setCodMotAfast(af.getEsocMotivoAfastamento().getCodigo());
        if (af.getEsocMotivoAfastamento().getCodigo().equals("21")) {
            i.setObservacao(af.getObservacao());
        }
        if (af.getEsocMotivoAfastamento().getCodigo().equals("03") || af.getEsocMotivoAfastamento().getCodigo().equals("01")) {
            i.setInfoMesmoMtv(this.getSimOrNao(af.getInfoMesmoMotivo()));
            if (af.getEsocTipoAcidente() != null) {
                i.setTpAcidTransito(Byte.valueOf(af.getEsocTipoAcidente().getCodigo()));
            }
        }
        return i;
    }

    private TSSimNao getSimOrNao(Short campo) {
        if (campo.equals((short)1)) {
            return TSSimNao.S;
        }
        return TSSimNao.N;
    }

    private ESocial.EvtAfastTemp.InfoAfastamento.FimAfastamento getFimAfastamento(AfastamentoColaborador af) {
        ESocial.EvtAfastTemp.InfoAfastamento.FimAfastamento f = this.getFact().createESocialEvtAfastTempInfoAfastamentoFimAfastamento();
        f.setDtTermAfast(ToolEsocial.converteData(ToolDate.nextDays((Date)af.getDataRetorno(), (int)-1)));
        return f;
    }
}

