/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evtaquisicaoprodrural;

import com.touchcomp.basementor.model.vo.EsocAquisicaoProducaoRural;
import com.touchcomp.basementor.model.vo.EsocClienteProducaoRural;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocFornecedorProducaoRural;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.NotaAquisicaoProdRural;
import com.touchcomp.basementor.model.vo.NotaPropriaAquisicaoProdRural;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evtaqprod.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evtaqprod.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evtaqprod.TEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evtaqprod.TIdeEveFopagMensal;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Date;
import org.apache.commons.httpclient.util.DateUtil;

public class ImpEvtAquisicaoProdRural
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial root = this.getFact().createESocial();
        root.setEvtAqProd(this.getEvtAqProdRural(preEvento, opcoes));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtAqProd getEvtAqProdRural(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial.EvtAqProd evt = this.getFact().createESocialEvtAqProd();
        evt.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evt.setIdeEmpregador(this.getEmpregador(opcoes));
        evt.setIdeEvento(this.getIdeEvento(preEvento, opcoes));
        evt.setInfoAquisProd(this.getInfoAquisicao(preEvento));
        return evt;
    }

    private TEmpregador getEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TEmpregador tEmpregador = this.getFact().createTEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private TIdeEveFopagMensal getIdeEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) {
        TIdeEveFopagMensal ti = this.getFact().createTIdeEveFopagMensal();
        ti.setTpAmb(Byte.parseByte(preEvento.getEsocEvento().getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        ti.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        ti.setVerProc(this.getVersaoEsocialSistema());
        if (preEvento.getEventoRetificacao().equals((short)1)) {
            ti.setIndRetif(Byte.parseByte("2"));
            ti.setNrRecibo(preEvento.getNumeroReciboRetificado());
        } else {
            ti.setIndRetif(Byte.parseByte("1"));
        }
        ti.setIndApuracao(Byte.parseByte("1"));
        ti.setPerApur(DateUtil.formatDate((Date)preEvento.getAquisicaoProducaoRural().getPeriodoReferencia(), (String)"yyyy-MM"));
        return ti;
    }

    private ESocial.EvtAqProd.InfoAquisProd getInfoAquisicao(EsocPreEvento preEvento) {
        ESocial.EvtAqProd.InfoAquisProd info = this.getFact().createESocialEvtAqProdInfoAquisProd();
        info.setIdeEstabAdquir(this.getEstabelecimento(preEvento));
        return info;
    }

    private ESocial.EvtAqProd.InfoAquisProd.IdeEstabAdquir getEstabelecimento(EsocPreEvento preEvento) {
        ESocial.EvtAqProd.InfoAquisProd.IdeEstabAdquir ide = this.getFact().createESocialEvtAqProdInfoAquisProdIdeEstabAdquir();
        ide.setTpInscAdq(Byte.parseByte("1"));
        ide.setNrInscAdq(ToolString.refina((String)preEvento.getAquisicaoProducaoRural().getEmpresa().getPessoa().getComplemento().getCnpj()));
        ide.getTpAquis().add(this.getTpAquisicao(preEvento));
        return ide;
    }

    private ESocial.EvtAqProd.InfoAquisProd.IdeEstabAdquir.TpAquis getTpAquisicao(EsocPreEvento preEvento) {
        EsocAquisicaoProducaoRural aq = preEvento.getAquisicaoProducaoRural();
        ESocial.EvtAqProd.InfoAquisProd.IdeEstabAdquir.TpAquis tpAquisicao = this.getFact().createESocialEvtAqProdInfoAquisProdIdeEstabAdquirTpAquis();
        tpAquisicao.setIndAquis(Byte.parseByte(aq.getIndicativoProdRural().getCodigo()));
        tpAquisicao.setVlrTotAquis(ToolFormatter.arrredondarNumeroBigDecimal((Double)this.getValorTotal(aq), (int)2));
        for (EsocFornecedorProducaoRural aqui : aq.getFornecedorProdRural()) {
            tpAquisicao.getIdeProdutor().add(this.getProdutor(aqui));
        }
        for (EsocClienteProducaoRural esoc : aq.getClienteProdRural()) {
            tpAquisicao.getIdeProdutor().add(this.getProdutorNFEPropria(esoc));
        }
        return tpAquisicao;
    }

    private Double getValorTotal(EsocAquisicaoProducaoRural aq) {
        Double valor = 0.0;
        for (EsocFornecedorProducaoRural item : aq.getFornecedorProdRural()) {
            valor = valor + ToolFormatter.arrredondarNumero((Double)item.getValorBrutoAquisicao(), (int)2);
        }
        for (EsocFornecedorProducaoRural item : aq.getClienteProdRural()) {
            valor = valor + ToolFormatter.arrredondarNumero((Double)item.getValorBrutoAquisicao(), (int)2);
        }
        return valor;
    }

    private ESocial.EvtAqProd.InfoAquisProd.IdeEstabAdquir.TpAquis.IdeProdutor getProdutor(EsocFornecedorProducaoRural aqui) {
        ESocial.EvtAqProd.InfoAquisProd.IdeEstabAdquir.TpAquis.IdeProdutor produtor = this.getFact().createESocialEvtAqProdInfoAquisProdIdeEstabAdquirTpAquisIdeProdutor();
        produtor.setTpInscProd(Byte.parseByte("2"));
        produtor.setNrInscProd(ToolString.refina((String)aqui.getFornecedor().getPessoa().getComplemento().getCnpj()));
        produtor.setVlrBruto(ToolFormatter.arrredondarNumeroBigDecimal((Double)aqui.getValorBrutoAquisicao(), (int)2));
        produtor.setVrCPDescPR(ToolFormatter.arrredondarNumeroBigDecimal((Double)this.getInss(aqui), (int)2));
        produtor.setVrRatDescPR(ToolFormatter.arrredondarNumeroBigDecimal((Double)this.getRat(aqui), (int)2));
        produtor.setVrSenarDesc(ToolFormatter.arrredondarNumeroBigDecimal((Double)this.getSenar(aqui), (int)2));
        produtor.setIndOpcCP(Byte.parseByte(aqui.getFornecedor().getEsocIndicativoContPrev().getCodigo()));
        return produtor;
    }

    private ESocial.EvtAqProd.InfoAquisProd.IdeEstabAdquir.TpAquis.IdeProdutor getProdutorNFEPropria(EsocClienteProducaoRural esoc) {
        ESocial.EvtAqProd.InfoAquisProd.IdeEstabAdquir.TpAquis.IdeProdutor produtor = this.getFact().createESocialEvtAqProdInfoAquisProdIdeEstabAdquirTpAquisIdeProdutor();
        produtor.setTpInscProd(Byte.parseByte("2"));
        produtor.setNrInscProd(ToolString.refina((String)esoc.getCliente().getPessoa().getComplemento().getCnpj()));
        produtor.setVlrBruto(ToolFormatter.arrredondarNumeroBigDecimal((Double)esoc.getValorBrutoAquisicao(), (int)2));
        produtor.setVrCPDescPR(ToolFormatter.arrredondarNumeroBigDecimal((Double)this.getInss(esoc), (int)2));
        produtor.setVrRatDescPR(ToolFormatter.arrredondarNumeroBigDecimal((Double)this.getRat(esoc), (int)2));
        produtor.setVrSenarDesc(ToolFormatter.arrredondarNumeroBigDecimal((Double)this.getSenar(esoc), (int)2));
        produtor.setIndOpcCP(Byte.parseByte(esoc.getCliente().getEsocIndicativoContPrev().getCodigo()));
        return produtor;
    }

    private ESocial.EvtAqProd.InfoAquisProd.IdeEstabAdquir.TpAquis.IdeProdutor.Nfs getNfe(NotaAquisicaoProdRural item) {
        ESocial.EvtAqProd.InfoAquisProd.IdeEstabAdquir.TpAquis.IdeProdutor.Nfs nfe = this.getFact().createESocialEvtAqProdInfoAquisProdIdeEstabAdquirTpAquisIdeProdutorNfs();
        nfe.setSerie(item.getNotaTerceiros().getSerie());
        nfe.setNrDocto(item.getNotaTerceiros().getNumeroNota().toString());
        nfe.setDtEmisNF(ToolEsocial.converteData(item.getNotaTerceiros().getDataEmissao()));
        nfe.setVlrBruto(ToolFormatter.arrredondarNumeroBigDecimal((Double)item.getNotaTerceiros().getValoresNfTerceiros().getValorTotal(), (int)2));
        nfe.setVrCPDescPR(ToolFormatter.arrredondarNumeroBigDecimal((Double)0.0, (int)2));
        nfe.setVrRatDescPR(ToolFormatter.arrredondarNumeroBigDecimal((Double)0.0, (int)2));
        nfe.setVrSenarDesc(ToolFormatter.arrredondarNumeroBigDecimal((Double)0.0, (int)2));
        return nfe;
    }

    private Double getInss(EsocClienteProducaoRural esoc) {
        Double valor = 0.0;
        for (NotaPropriaAquisicaoProdRural nota : esoc.getNotas()) {
            valor = valor + ToolFormatter.arrredondarNumero((Double)nota.getNotaPropria().getValoresNfPropria().getValorInss(), (int)2);
            valor = ToolFormatter.arrredondarNumero((Double)valor, (int)2);
        }
        return valor;
    }

    private Double getRat(EsocClienteProducaoRural esoc) {
        Double valor = 0.0;
        for (NotaPropriaAquisicaoProdRural nota : esoc.getNotas()) {
            valor = valor + ToolFormatter.arrredondarNumero((Double)nota.getNotaPropria().getValoresNfPropria().getValorRAT(), (int)2);
            valor = ToolFormatter.arrredondarNumero((Double)valor, (int)2);
        }
        return valor;
    }

    private Double getSenar(EsocClienteProducaoRural esoc) {
        Double valor = 0.0;
        for (NotaPropriaAquisicaoProdRural nota : esoc.getNotas()) {
            valor = valor + ToolFormatter.arrredondarNumero((Double)nota.getNotaPropria().getValoresNfPropria().getValorSenar(), (int)2);
            valor = ToolFormatter.arrredondarNumero((Double)valor, (int)2);
        }
        return valor;
    }

    private Double getInss(EsocFornecedorProducaoRural esoc) {
        Double valor = 0.0;
        for (NotaAquisicaoProdRural nota : esoc.getNotasAqProdRural()) {
            valor = valor + ToolFormatter.arrredondarNumero((Double)nota.getNotaTerceiros().getValoresNfTerceiros().getValorInss(), (int)2);
            valor = ToolFormatter.arrredondarNumero((Double)valor, (int)2);
        }
        return valor;
    }

    private Double getRat(EsocFornecedorProducaoRural esoc) {
        Double valor = 0.0;
        for (NotaAquisicaoProdRural nota : esoc.getNotasAqProdRural()) {
            valor = valor + ToolFormatter.arrredondarNumero((Double)nota.getNotaTerceiros().getValoresNfTerceiros().getValorRat(), (int)2);
            valor = ToolFormatter.arrredondarNumero((Double)valor, (int)2);
        }
        return valor;
    }

    private Double getSenar(EsocFornecedorProducaoRural esoc) {
        Double valor = 0.0;
        for (NotaAquisicaoProdRural nota : esoc.getNotasAqProdRural()) {
            valor = valor + ToolFormatter.arrredondarNumero((Double)nota.getNotaTerceiros().getValoresNfTerceiros().getValorSenar(), (int)2);
            valor = ToolFormatter.arrredondarNumero((Double)valor, (int)2);
        }
        return valor;
    }
}

