/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evtavisoprevio;

import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evtavprevio.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evtavprevio.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evtavprevio.TEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evtavprevio.TIdeEveTrab;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evtavprevio.TIdeVinculoNisObrig;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;

public class ImpEvtAvisoPrevio
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial root = this.getFact().createESocial();
        root.setEvtAvPrevio(this.getAvisoPrevio(preEvento, opcoes));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtAvPrevio getAvisoPrevio(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial.EvtAvPrevio evtAviso = this.getFact().createESocialEvtAvPrevio();
        evtAviso.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evtAviso.setIdeEmpregador(this.getEmpregador(opcoes));
        evtAviso.setIdeEvento(this.getIdeEvento(preEvento.getEsocEvento(), opcoes));
        evtAviso.setIdeVinculo(this.getVinculo(preEvento));
        evtAviso.setInfoAvPrevio(this.getInfoAviso(preEvento));
        return evtAviso;
    }

    private TEmpregador getEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TEmpregador tEmpregador = this.getFact().createTEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private TIdeEveTrab getIdeEvento(EsocEvento esocEvento, OpcoesESocial opcoes) {
        TIdeEveTrab tiTrab = this.getFact().createTIdeEveTrab();
        tiTrab.setTpAmb(Byte.parseByte(esocEvento.getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        tiTrab.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        tiTrab.setVerProc(this.getVersaoEsocialSistema());
        if (esocEvento.getPreEvento().getEventoRetificacao().equals((short)1)) {
            tiTrab.setIndRetif(Byte.parseByte("2"));
            tiTrab.setNrRecibo(esocEvento.getPreEvento().getNumeroReciboRetificado());
        } else {
            tiTrab.setIndRetif(Byte.parseByte("1"));
        }
        return tiTrab;
    }

    private TIdeVinculoNisObrig getVinculo(EsocPreEvento preEvento) {
        TIdeVinculoNisObrig vinculo = this.getFact().createTIdeVinculoNisObrig();
        vinculo.setCpfTrab(preEvento.getEmissaoAviso().getColaborador().getPessoa().getComplemento().getCnpj());
        vinculo.setMatricula(preEvento.getEmissaoAviso().getColaborador().getNumeroRegistroESocial());
        vinculo.setNisTrab(preEvento.getEmissaoAviso().getColaborador().getNumeroPis());
        return vinculo;
    }

    private ESocial.EvtAvPrevio.InfoAvPrevio getInfoAviso(EsocPreEvento preEvento) {
        ESocial.EvtAvPrevio.InfoAvPrevio infoAviso = this.getFact().createESocialEvtAvPrevioInfoAvPrevio();
        if (preEvento.getEmissaoAviso().getMotivoCancelamentoAviso() == null) {
            infoAviso.setDetAvPrevio(this.getDetAviso(preEvento));
        } else {
            infoAviso.setCancAvPrevio(this.getCancelamentoAviso(preEvento));
        }
        return infoAviso;
    }

    private ESocial.EvtAvPrevio.InfoAvPrevio.DetAvPrevio getDetAviso(EsocPreEvento preEvento) {
        ESocial.EvtAvPrevio.InfoAvPrevio.DetAvPrevio det = this.getFact().createESocialEvtAvPrevioInfoAvPrevioDetAvPrevio();
        det.setDtAvPrv(ToolEsocial.converteData(preEvento.getEmissaoAviso().getDataEmissaoAviso()));
        det.setDtPrevDeslig(ToolEsocial.converteData(preEvento.getEmissaoAviso().getDataAfastamento()));
        det.setTpAvPrevio(Byte.parseByte(preEvento.getEmissaoAviso().getTipoAviso().getCodigo()));
        return det;
    }

    private ESocial.EvtAvPrevio.InfoAvPrevio.CancAvPrevio getCancelamentoAviso(EsocPreEvento preEvento) {
        ESocial.EvtAvPrevio.InfoAvPrevio.CancAvPrevio c = this.getFact().createESocialEvtAvPrevioInfoAvPrevioCancAvPrevio();
        c.setDtCancAvPrv(ToolEsocial.converteData(preEvento.getEmissaoAviso().getDataCancelamento()));
        c.setMtvCancAvPrevio(Byte.parseByte(preEvento.getEmissaoAviso().getMotivoCancelamentoAviso().getCodigo()));
        return c;
    }
}

