/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evtpagamentorendimento;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorDependente;
import com.touchcomp.basementor.model.vo.ESocS1020;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocItemS1020;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.EsocRubricaIrrf;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.FolhaComplementarPeriodo;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementor.model.vo.RecisaoComplementar;
import com.touchcomp.basementor.model.vo.RecisaoComplementarPeriodo;
import com.touchcomp.basementor.model.vo.Rubricas1200;
import com.touchcomp.basementor.model.vo.Rubricas1210;
import com.touchcomp.basementor.model.vo.Rubricas2299;
import com.touchcomp.basementor.model.vo.RubricasFerias;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtpgtos.v_s_01_03_00.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtpgtos.v_s_01_03_00.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtpgtos.v_s_01_03_00.TIdeEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtpgtos.v_s_01_03_00.TIdeEventoFolhaMensal;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.httpclient.util.DateUtil;

public class ImpEvtPagamentoRendimento
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        try {
            ESocial root = this.getFact().createESocial();
            root.setEvtPgtos(this.getEvtPagamentos(preEvento, opcoes));
            return root;
        }
        catch (UnsupportedEncodingException ex) {
            throw new ExceptionEsocial("ERro ao gerar evento");
        }
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtPgtos getEvtPagamentos(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial, UnsupportedEncodingException {
        ESocial.EvtPgtos evt = this.getFact().createESocialEvtPgtos();
        evt.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evt.setIdeEmpregador(this.getEmpregador(opcoes));
        evt.setIdeEvento(this.getIdEvento(opcoes, preEvento));
        evt.setIdeBenef(this.getIdeBeneficiario(preEvento, opcoes));
        return evt;
    }

    private TIdeEmpregador getEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TIdeEmpregador tEmpregador = this.getFact().createTIdeEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private TIdeEventoFolhaMensal getIdEvento(OpcoesESocial opcoes, EsocPreEvento preEvento) {
        TIdeEventoFolhaMensal tiTrab = this.getFact().createTIdeEventoFolhaMensal();
        tiTrab.setTpAmb(Byte.parseByte(preEvento.getEsocEvento().getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        tiTrab.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        tiTrab.setVerProc(this.getVersaoEsocialSistema());
        if (preEvento.getEventoRetificacao().equals((short)1)) {
            tiTrab.setIndRetif(Byte.parseByte("2"));
            tiTrab.setNrRecibo(preEvento.getNumeroReciboRetificado());
        } else {
            tiTrab.setIndRetif(Byte.parseByte("1"));
        }
        tiTrab.setPerApur(DateUtil.formatDate((Date)preEvento.getEsocS1210().getEsocFechamento().getPeriodoApuracao(), (String)"yyyy-MM"));
        return tiTrab;
    }

    private ESocial.EvtPgtos.IdeBenef getIdeBeneficiario(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial, UnsupportedEncodingException {
        ESocS1020 esoc = preEvento.getEsocS1210();
        ESocial.EvtPgtos.IdeBenef ide = this.getFact().createESocialEvtPgtosIdeBenef();
        Double valorPlanoSaude = 0.0;
        TipoCalculoEvento tpSaude = null;
        TipoCalculoEvento tpPensao = null;
        Colaborador colaborador = null;
        Double valorPensao = 0.0;
        ide.setCpfBenef(ToolString.refina((String)esoc.getColaborador().getPessoa().getComplemento().getCnpj()));
        boolean existeDesligamento = false;
        if (esoc.getColaborador().getDataDemissao() != null) {
            existeDesligamento = ToolDate.dateBetween((Date)esoc.getColaborador().getDataDemissao(), (Date)ToolDate.getFirtDateOnMonth((Date)esoc.getEsocFechamento().getPeriodoApuracao()), (Date)ToolDate.getLastDateOnMonth((Date)esoc.getEsocFechamento().getPeriodoApuracao()));
        }
        for (EsocItemS1020 item : esoc.getItensS1020()) {
            if (item.getMovimentoFolha() != null) {
                item.getMovimentoFolha().getIdentificador();
                if (item.getMovimentoFolha().getAberturaPeriodo().getDataFinal().after(this.getInicioObrigatoriedadeProducao(opcoes))) {
                    if (!this.existeInfoPagamento(ide, item.getMovimentoFolha(), opcoes, existeDesligamento)) {
                        ide.getInfoPgto().add(this.getInfoPgto(item.getMovimentoFolha(), opcoes, null, existeDesligamento));
                    }
                } else if (this.existeEventoIrrf(item.getMovimentoFolha())) {
                    ide.getInfoPgto().add(this.getInfoPgto(item.getMovimentoFolha(), opcoes, null, existeDesligamento));
                } else {
                    ide.getInfoPgto().add(this.getInfoPgtoZerado(item.getMovimentoFolha()));
                }
                colaborador = item.getMovimentoFolha().getColaborador();
                for (Rubricas2299 r : item.getMovimentoFolha().getRubricas1200()) {
                    if (!r.getTipoCalculo().getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.CODIGO_RUBRICA_PLANO_SAUDE) && !r.getTipoCalculo().getEsocRubricaIrrf().getCodigo().equals("67") || !(r.getValorRubrica() > 0.0)) continue;
                    valorPlanoSaude = valorPlanoSaude + r.getValorRubrica();
                    tpSaude = r.getTipoCalculo();
                }
                for (RubricasFerias rubrica : item.getMovimentoFolha().getRubricas1200()) {
                    if (!rubrica.getTipoCalculo().getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.CODIGO_PENSAO_ALIMENTICIA)) continue;
                    valorPensao = valorPensao + rubrica.getValorRubrica();
                    tpPensao = rubrica.getTipoCalculo();
                }
                continue;
            }
            if (item.getFeriasColaborador() != null) {
                if (!this.existePagamentoFerias(ide, item.getFeriasColaborador())) {
                    ide.getInfoPgto().add(this.getInfoPgto(item.getFeriasColaborador()));
                }
                for (RubricasFerias rubrica : item.getFeriasColaborador().getRubricasFerias()) {
                    if (!rubrica.getTipoCalculo().getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.CODIGO_PENSAO_ALIMENTICIA)) continue;
                    valorPensao = valorPensao + rubrica.getValorRubrica();
                    tpPensao = rubrica.getTipoCalculo();
                }
                continue;
            }
            if (item.getRescisao() == null) continue;
            if (item.getRescisao().getDataAfastamento().after(this.getInicioObrigatoriedadeProducao(opcoes))) {
                if (item.getRescisao().getRecisaoComplementarAc() == null) {
                    ide.getInfoPgto().add(this.getInfoPgto(item.getRescisao()));
                } else {
                    ide.getInfoPgto().add(this.getInfoPgtoRecisaoComp(item.getRescisao()));
                }
            }
            colaborador = item.getRescisao().getColaborador();
            for (Rubricas2299 r : item.getRescisao().getRubricas()) {
                if (!r.getTipoCalculo().getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.CODIGO_RUBRICA_PLANO_SAUDE) && !r.getTipoCalculo().getEsocRubricaIrrf().getCodigo().equals("67") || !(r.getValorRubrica() > 0.0)) continue;
                valorPlanoSaude = valorPlanoSaude + r.getValorRubrica();
                tpSaude = r.getTipoCalculo();
            }
            for (RubricasFerias rubrica : item.getRescisao().getRubricas()) {
                if (!rubrica.getTipoCalculo().getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.CODIGO_PENSAO_ALIMENTICIA)) continue;
                valorPensao = valorPensao + rubrica.getValorRubrica();
                tpPensao = rubrica.getTipoCalculo();
            }
        }
        if (valorPlanoSaude > 0.0 || valorPensao > 0.0) {
            ide.getInfoIRComplem().add(this.getInfoComplementarPlanoSaude(valorPlanoSaude, colaborador, tpSaude, valorPensao));
        }
        return ide;
    }

    private ESocial.EvtPgtos.IdeBenef.InfoPgto getInfoPgto(MovimentoFolha movimentoFolha, OpcoesESocial opcoes, Date dataPagamento, boolean existeDesligamento) throws ExceptionEsocial {
        ESocial.EvtPgtos.IdeBenef.InfoPgto infoPgto = this.getFact().createESocialEvtPgtosIdeBenefInfoPgto();
        if (dataPagamento != null) {
            infoPgto.setDtPgto(ToolEsocial.converteData(dataPagamento));
        } else {
            infoPgto.setDtPgto(ToolEsocial.converteData(movimentoFolha.getAberturaPeriodo().getDataPagamento()));
        }
        if (movimentoFolha.getAberturaPeriodo().getDataFinal().after(this.getInicioObrigatoriedadeProducao(opcoes)) && movimentoFolha.getPagamentoFolhaComplementar() == null) {
            movimentoFolha.getIdentificador();
            if (existeDesligamento) {
                if (!movimentoFolha.getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_ADIANTAMENTO_SALARIO.getValue())) {
                    infoPgto.setTpPgto(Byte.parseByte("1"));
                } else {
                    infoPgto.setTpPgto(Byte.parseByte("2"));
                }
            } else {
                infoPgto.setTpPgto(Byte.parseByte("1"));
            }
            if (!movimentoFolha.getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue())) {
                infoPgto.setPerRef(DateUtil.formatDate((Date)movimentoFolha.getAberturaPeriodo().getDataInicio(), (String)"yyyy-MM"));
            } else {
                infoPgto.setPerRef(DateUtil.formatDate((Date)movimentoFolha.getAberturaPeriodo().getDataInicio(), (String)"yyyy"));
            }
            infoPgto.setIdeDmDev(movimentoFolha.getIdentificador().toString());
            infoPgto.setVrLiq(ToolFormatter.arrredondarNumeroBigDecimal((Double)this.getLiquido(movimentoFolha), (int)2));
        } else if (movimentoFolha.getAberturaPeriodo().getDataFinal().after(this.getInicioObrigatoriedadeProducao(opcoes)) && movimentoFolha.getPagamentoFolhaComplementar() != null) {
            infoPgto.setTpPgto(Byte.parseByte("1"));
            infoPgto.setPerRef(DateUtil.formatDate((Date)movimentoFolha.getAberturaPeriodo().getDataInicio(), (String)"yyyy-MM"));
            infoPgto.setIdeDmDev(movimentoFolha.getIdentificador().toString());
            infoPgto.setVrLiq(ToolFormatter.arrredondarNumeroBigDecimal((Double)this.getLiquido(movimentoFolha), (int)2));
        }
        return infoPgto;
    }

    private Date getInicioObrigatoriedadeProducao(OpcoesESocial opcoes) throws ExceptionEsocial {
        if (opcoes.getDataTerceiraFase() == null) {
            throw new ExceptionEsocial("Informe as datas de inicio da obrigatoriedade no Cadastro da Tabela S-1000");
        }
        return opcoes.getDataTerceiraFase();
    }

    private ESocial.EvtPgtos.IdeBenef.InfoPgto getInfoPgto(FeriasColaborador ferias) {
        ESocial.EvtPgtos.IdeBenef.InfoPgto infoPag = this.getFact().createESocialEvtPgtosIdeBenefInfoPgto();
        infoPag.setDtPgto(ToolEsocial.converteData(ferias.getDataPagamento()));
        infoPag.setTpPgto(Byte.parseByte("1"));
        infoPag.setIdeDmDev(ferias.getIdentificador().toString());
        infoPag.setVrLiq(ToolFormatter.arrredondarNumeroBigDecimal((Double)ferias.getVrLiquidoFerias(), (int)2));
        infoPag.setPerRef(DateUtil.formatDate((Date)ferias.getDataPagamento(), (String)"yyyy-MM"));
        return infoPag;
    }

    private ESocial.EvtPgtos.IdeBenef.InfoPgto getInfoPgto(Recisao rescisao) {
        ESocial.EvtPgtos.IdeBenef.InfoPgto info = this.getFact().createESocialEvtPgtosIdeBenefInfoPgto();
        info.setDtPgto(ToolEsocial.converteData(rescisao.getDataPagamento()));
        info.setTpPgto(Byte.parseByte("2"));
        info.setIdeDmDev(rescisao.getIdentificador().toString());
        info.setPerRef(DateUtil.formatDate((Date)rescisao.getDataAfastamento(), (String)"yyyy-MM"));
        info.setVrLiq(ToolFormatter.arrredondarNumeroBigDecimal((Double)rescisao.getVlrLiquido(), (int)2));
        return info;
    }

    private boolean getRubricaDifIrrf(EsocRubricaIrrf esocRubricaIrrf) {
        String codigoIrrf = esocRubricaIrrf.getCodigo();
        return codigoIrrf.equals("31") || codigoIrrf.equals("32") || codigoIrrf.equals("33") || codigoIrrf.equals("34") || codigoIrrf.equals("35") || codigoIrrf.equals("51") || codigoIrrf.equals("52") || codigoIrrf.equals("53") || codigoIrrf.equals("54") || codigoIrrf.equals("55") || codigoIrrf.equals("81") || codigoIrrf.equals("82") || codigoIrrf.equals("83");
    }

    private boolean existeEventoIrrf(MovimentoFolha movimentoFolha) {
        for (Rubricas1210 item : movimentoFolha.getRubricas1210()) {
            if (!item.getTipoCalculo().getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.CODIGO_PENSAO_ALIMENTICIA) && !this.getRubricaDifIrrf(item.getTipoCalculo().getEsocRubricaIrrf()) || !(item.getValorRubrica() > 0.0)) continue;
            return true;
        }
        return false;
    }

    private ESocial.EvtPgtos.IdeBenef.InfoPgto getInfoPgtoZerado(MovimentoFolha movimentoFolha) {
        ESocial.EvtPgtos.IdeBenef.InfoPgto infoPgto = this.getFact().createESocialEvtPgtosIdeBenefInfoPgto();
        infoPgto.setDtPgto(ToolEsocial.converteData(movimentoFolha.getAberturaPeriodo().getDataPagamento()));
        infoPgto.setPerRef(DateUtil.formatDate((Date)movimentoFolha.getAberturaPeriodo().getDataInicio(), (String)"yyyy-MM"));
        infoPgto.setIdeDmDev(movimentoFolha.getIdentificador().toString());
        infoPgto.setVrLiq(ToolFormatter.arrredondarNumeroBigDecimal((Double)movimentoFolha.getVrSalarioLiquido(), (int)2));
        infoPgto.setTpPgto(Byte.parseByte("1"));
        return infoPgto;
    }

    private Double getLiquido(MovimentoFolha movimentoFolha) {
        Double liquido = 0.0;
        for (Rubricas1200 rubrica : movimentoFolha.getRubricas1200()) {
            if (rubrica.getTipoCalculo().getEsocTipoRubrica().getCodigo().equals("1")) {
                liquido = liquido + ToolFormatter.arrredondarNumero((Double)rubrica.getValorRubrica(), (int)2);
                liquido = ToolFormatter.arrredondarNumero((Double)liquido, (int)2);
                System.out.println(liquido);
                continue;
            }
            if (!rubrica.getTipoCalculo().getEsocTipoRubrica().getCodigo().equals("2")) continue;
            liquido = liquido - ToolFormatter.arrredondarNumero((Double)rubrica.getValorRubrica(), (int)2);
            liquido = ToolFormatter.arrredondarNumero((Double)liquido, (int)2);
            System.out.println(liquido);
        }
        for (Rubricas1200 rubrica : movimentoFolha.getRubricas1210()) {
            if (rubrica.getTipoCalculo().getEsocTipoRubrica().getCodigo().equals("1")) {
                liquido = liquido + ToolFormatter.arrredondarNumero((Double)rubrica.getValorRubrica(), (int)2);
                liquido = ToolFormatter.arrredondarNumero((Double)liquido, (int)2);
                continue;
            }
            if (!rubrica.getTipoCalculo().getEsocTipoRubrica().getCodigo().equals("2")) continue;
            liquido = liquido - ToolFormatter.arrredondarNumero((Double)rubrica.getValorRubrica(), (int)2);
            liquido = ToolFormatter.arrredondarNumero((Double)liquido, (int)2);
        }
        liquido = ToolFormatter.arrredondarNumero((Double)liquido, (int)2);
        return liquido;
    }

    private Double getLiquidoFolhaComp(MovimentoFolha movimentoFolha) {
        Double liquido = 0.0;
        for (FolhaComplementarPeriodo folhaComplementar : movimentoFolha.getPagamentoFolhaComplementar().getFolhaComplementares()) {
            for (Rubricas1200 rubrica : folhaComplementar.getRubricas1200()) {
                if (rubrica.getTipoCalculo().getEsocTipoRubrica().getCodigo().equals("1")) {
                    liquido = liquido + ToolFormatter.arrredondarNumero((Double)rubrica.getValorRubrica(), (int)2);
                    liquido = ToolFormatter.arrredondarNumero((Double)liquido, (int)2);
                    System.out.println(liquido);
                    continue;
                }
                if (!rubrica.getTipoCalculo().getEsocTipoRubrica().getCodigo().equals("2")) continue;
                liquido = liquido - ToolFormatter.arrredondarNumero((Double)rubrica.getValorRubrica(), (int)2);
                liquido = ToolFormatter.arrredondarNumero((Double)liquido, (int)2);
                System.out.println(liquido);
            }
            for (Rubricas1200 rubrica : folhaComplementar.getRubricas1210()) {
                if (rubrica.getTipoCalculo().getEsocTipoRubrica().getCodigo().equals("1")) {
                    liquido = liquido + ToolFormatter.arrredondarNumero((Double)rubrica.getValorRubrica(), (int)2);
                    liquido = ToolFormatter.arrredondarNumero((Double)liquido, (int)2);
                    continue;
                }
                if (!rubrica.getTipoCalculo().getEsocTipoRubrica().getCodigo().equals("2")) continue;
                liquido = liquido - ToolFormatter.arrredondarNumero((Double)rubrica.getValorRubrica(), (int)2);
                liquido = ToolFormatter.arrredondarNumero((Double)liquido, (int)2);
            }
        }
        liquido = ToolFormatter.arrredondarNumero((Double)liquido, (int)2);
        return liquido;
    }

    private ESocial.EvtPgtos.IdeBenef.InfoPgto getInfoPgtoRecisaoComp(Recisao rescisao) {
        ESocial.EvtPgtos.IdeBenef.InfoPgto info = this.getFact().createESocialEvtPgtosIdeBenefInfoPgto();
        info.setDtPgto(ToolEsocial.converteData(rescisao.getDataPagamento()));
        info.setTpPgto(Byte.parseByte("1"));
        info.setPerRef(DateUtil.formatDate((Date)rescisao.getDataPagamento(), (String)"yyyy-MM"));
        info.setIdeDmDev(rescisao.getIdentificador().toString());
        info.setVrLiq(ToolFormatter.arrredondarNumeroBigDecimal((Double)rescisao.getVlrLiquido(), (int)2));
        return info;
    }

    private Double getLiquidoRescisaoomp(RecisaoComplementar r) {
        Double liquido = 0.0;
        for (RecisaoComplementarPeriodo recComplementar : r.getRecisaoPeriodo()) {
            for (Rubricas1200 rubrica : recComplementar.getRubricas1200()) {
                if (rubrica.getTipoCalculo().getEsocTipoRubrica().getCodigo().equals("1")) {
                    liquido = liquido + ToolFormatter.arrredondarNumero((Double)rubrica.getValorRubrica(), (int)2);
                    liquido = ToolFormatter.arrredondarNumero((Double)liquido, (int)2);
                    System.out.println(liquido);
                    continue;
                }
                if (!rubrica.getTipoCalculo().getEsocTipoRubrica().getCodigo().equals("2")) continue;
                liquido = liquido - ToolFormatter.arrredondarNumero((Double)rubrica.getValorRubrica(), (int)2);
                liquido = ToolFormatter.arrredondarNumero((Double)liquido, (int)2);
                System.out.println(liquido);
            }
            for (Rubricas1200 rubrica : recComplementar.getRubricas1210()) {
                if (rubrica.getTipoCalculo().getEsocTipoRubrica().getCodigo().equals("1")) {
                    liquido = liquido + ToolFormatter.arrredondarNumero((Double)rubrica.getValorRubrica(), (int)2);
                    liquido = ToolFormatter.arrredondarNumero((Double)liquido, (int)2);
                    continue;
                }
                if (!rubrica.getTipoCalculo().getEsocTipoRubrica().getCodigo().equals("2")) continue;
                liquido = liquido - ToolFormatter.arrredondarNumero((Double)rubrica.getValorRubrica(), (int)2);
                liquido = ToolFormatter.arrredondarNumero((Double)liquido, (int)2);
            }
        }
        liquido = ToolFormatter.arrredondarNumero((Double)liquido, (int)2);
        return liquido;
    }

    private boolean existeInfoPagamento(ESocial.EvtPgtos.IdeBenef ide, MovimentoFolha movimentoFolha, OpcoesESocial opcoes, boolean e) throws UnsupportedEncodingException, ExceptionEsocial {
        Date dataPagamento = movimentoFolha.getAberturaPeriodo().getDataPagamento();
        for (ESocial.EvtPgtos.IdeBenef.InfoPgto infoPgto : ide.getInfoPgto()) {
            XMLGregorianCalendar dataPagamentoXml = infoPgto.getDtPgto();
            Integer diaXml = dataPagamentoXml.getDay();
            Integer diaPag = ToolDate.dayFromDate((Date)dataPagamento);
            byte[] bytes = new byte[]{infoPgto.getTpPgto()};
            byte[] tpFolha = new byte[]{1};
            if (!diaXml.equals(diaPag) || bytes[0] != tpFolha[0]) continue;
            ide.getInfoPgto().add(this.getInfoPgto(movimentoFolha, opcoes, ToolDate.nextDays((Date)movimentoFolha.getAberturaPeriodo().getDataPagamento(), (int)1), e));
            return true;
        }
        return false;
    }

    private Double getLiquidoFerias(FeriasColaborador ferias) {
        Double liquido = 0.0;
        for (RubricasFerias rubrica : ferias.getRubricasFerias()) {
            if (rubrica.getTipoCalculo().getEsocRubricasFolhaPagamento().getCodigo().equals(9221L)) continue;
            if (rubrica.getTipoCalculo().getEsocTipoRubrica().getCodigo().equals("1")) {
                liquido = liquido + ToolFormatter.arrredondarNumero((Double)rubrica.getValorRubrica(), (int)2);
                liquido = ToolFormatter.arrredondarNumero((Double)liquido, (int)2);
                System.out.println(liquido);
                continue;
            }
            if (!rubrica.getTipoCalculo().getEsocTipoRubrica().getCodigo().equals("2")) continue;
            liquido = liquido - ToolFormatter.arrredondarNumero((Double)rubrica.getValorRubrica(), (int)2);
            liquido = ToolFormatter.arrredondarNumero((Double)liquido, (int)2);
            System.out.println(liquido);
        }
        liquido = ToolFormatter.arrredondarNumero((Double)liquido, (int)2);
        return liquido;
    }

    private boolean existePagamentoFerias(ESocial.EvtPgtos.IdeBenef ide, FeriasColaborador feriasColaborador) {
        Date dataPagamento = feriasColaborador.getDataPagamento();
        for (ESocial.EvtPgtos.IdeBenef.InfoPgto infoPgto : ide.getInfoPgto()) {
            XMLGregorianCalendar dataPagamentoXml = infoPgto.getDtPgto();
            Integer diaXml = dataPagamentoXml.getDay();
            Integer diaPag = ToolDate.dayFromDate((Date)dataPagamento);
            byte[] bytes = new byte[]{infoPgto.getTpPgto()};
            byte[] tpFolha = new byte[]{7};
            if (!diaXml.equals(diaPag) || bytes[0] != tpFolha[0]) continue;
            infoPgto.setDtPgto(ToolEsocial.converteData(feriasColaborador.getDataPagamento()));
            infoPgto.setTpPgto(Byte.parseByte("1"));
            infoPgto.setPerRef(DateUtil.formatDate((Date)feriasColaborador.getDataPagamento(), (String)"yyyy-MM"));
            infoPgto.setIdeDmDev(feriasColaborador.getIdentificador().toString());
            infoPgto.setVrLiq(ToolFormatter.arrredondarNumeroBigDecimal((Double)feriasColaborador.getVrLiquidoFerias(), (int)2));
            return true;
        }
        return false;
    }

    private ESocial.EvtPgtos.IdeBenef.InfoIRComplem getInfoComplementarPlanoSaude(Double valorSaude, Colaborador colaborador, TipoCalculoEvento tpSaude, Double valorPensao) throws ExceptionEsocial {
        if (valorSaude > 0.0 && tpSaude != null && (tpSaude.getEvento().getDeParaTipoEventoDirf() == null || tpSaude.getEvento().getDeParaTipoEventoDirf().getConvenioPlanoSaude() == null)) {
            throw new ExceptionEsocial("Informe a Parametriza\u00e7\u00e3o correta referente a DIRF para o plano de saude " + tpSaude.getEvento().getDescricao().toUpperCase());
        }
        ESocial.EvtPgtos.IdeBenef.InfoIRComplem in = this.getFact().createESocialEvtPgtosIdeBenefInfoIRComplem();
        if (valorSaude > 0.0) {
            ESocial.EvtPgtos.IdeBenef.InfoIRComplem.PlanSaude plano = this.getFact().createESocialEvtPgtosIdeBenefInfoIRComplemPlanSaude();
            plano.setCnpjOper(ToolString.refina((String)tpSaude.getEvento().getDeParaTipoEventoDirf().getConvenioPlanoSaude().getPessoa().getComplemento().getCnpj()));
            plano.setRegANS(ToolString.refina((String)tpSaude.getEvento().getDeParaTipoEventoDirf().getConvenioPlanoSaude().getCodigoANS()));
            plano.setVlrSaudeTit(ToolFormatter.arrredondarNumeroBigDecimal((Double)valorSaude, (int)2));
            in.getPlanSaude().add(plano);
        }
        if (valorPensao > 0.0) {
            ESocial.EvtPgtos.IdeBenef.InfoIRComplem.InfoIRCR inf = this.getFact().createESocialEvtPgtosIdeBenefInfoIRComplemInfoIRCR();
            inf.setTpCR("056107");
            if (colaborador.getDependentesColaborador().isEmpty()) {
                throw new ExceptionEsocial("Cadastre os Beneficiarios de Pens\u00e3o do colaborador:" + colaborador.toString());
            }
            for (ColaboradorDependente b : colaborador.getDependentesColaborador()) {
                ESocial.EvtPgtos.IdeBenef.InfoIRComplem.InfoIRCR.PenAlim pensao = this.getFact().createESocialEvtPgtosIdeBenefInfoIRComplemInfoIRCRPenAlim();
                pensao.setCpfDep(ToolString.refina((String)b.getCpf()));
                pensao.setTpRend(Byte.parseByte("11"));
                pensao.setVlrDedPenAlim(ToolFormatter.arrredondarNumeroBigDecimal((Double)valorPensao, (int)2));
                inf.getPenAlim().add(pensao);
            }
            in.getInfoIRCR().add(inf);
        }
        return in;
    }

    private ESocial.EvtPgtos.IdeBenef.InfoIRComplem getInfoComplementarPensao(Double valorPensao, Colaborador colaborador) throws ExceptionEsocial {
        ESocial.EvtPgtos.IdeBenef.InfoIRComplem info = this.getFact().createESocialEvtPgtosIdeBenefInfoIRComplem();
        ESocial.EvtPgtos.IdeBenef.InfoIRComplem.InfoIRCR inf = this.getFact().createESocialEvtPgtosIdeBenefInfoIRComplemInfoIRCR();
        inf.setTpCR("056107");
        ESocial.EvtPgtos.IdeBenef.InfoIRComplem.InfoIRCR.PenAlim pensao = this.getFact().createESocialEvtPgtosIdeBenefInfoIRComplemInfoIRCRPenAlim();
        if (colaborador.getDependentesColaborador().isEmpty()) {
            throw new ExceptionEsocial("Cadastre os Beneficiarios de Pens\u00e3o do colaborador:" + colaborador.toString());
        }
        for (ColaboradorDependente b : colaborador.getDependentesColaborador()) {
            pensao.setCpfDep(ToolString.refina((String)b.getCpf()));
            pensao.setTpRend(Byte.parseByte("11"));
            pensao.setVlrDedPenAlim(ToolFormatter.arrredondarNumeroBigDecimal((Double)valorPensao, (int)2));
            inf.getPenAlim().add(pensao);
        }
        info.getInfoIRCR().add(inf);
        return info;
    }
}

