/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evtproctrab;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.EsocProcessoTrabalhista;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.Remuneracao;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtproctrab.v_s_01_03_00.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtproctrab.v_s_01_03_00.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtproctrab.v_s_01_03_00.TIdeEventoTrab;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtproctrab.v_s_01_03_00.TSSimNao;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtproctrab.v_s_01_03_00.TSUf;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.math.BigInteger;

public class ImpEvtProcTrab
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        EsocProcessoTrabalhista procTrab = preEvento.getProcessoTrabalhista();
        ESocial root = this.getFact().createESocial();
        root.setEvtProcTrab(this.getEvtProcTrab(opcoes, preEvento, procTrab));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtProcTrab getEvtProcTrab(OpcoesESocial opcoes, EsocPreEvento preEvento, EsocProcessoTrabalhista procTrab) throws ExceptionEsocial {
        ESocial.EvtProcTrab e = new ESocial.EvtProcTrab();
        e.setIdeEmpregador(this.getIdeEmpregador(opcoes));
        e.setIdeEvento(this.getIdeEvento(preEvento.getEsocEvento(), opcoes));
        e.setInfoProcesso(this.getInfoProcesso(procTrab));
        e.setIdeTrab(this.getIdeTrab(procTrab));
        e.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        return e;
    }

    private ESocial.EvtProcTrab.IdeEmpregador getIdeEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial.EvtProcTrab.IdeEmpregador i = new ESocial.EvtProcTrab.IdeEmpregador();
        i.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        i.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return i;
    }

    private TIdeEventoTrab getIdeEvento(EsocEvento esocEvento, OpcoesESocial opcoes) {
        TIdeEventoTrab t = new TIdeEventoTrab();
        t.setTpAmb(Byte.parseByte(esocEvento.getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        t.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        t.setVerProc(this.getVersaoEsocialSistema());
        if (ToolMethods.isEquals((Object)esocEvento.getPreEvento().getEventoRetificacao(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            t.setIndRetif(Byte.parseByte("2"));
            t.setNrRecibo(esocEvento.getPreEvento().getNumeroReciboRetificado());
        } else {
            t.setIndRetif(Byte.parseByte("1"));
        }
        return t;
    }

    private ESocial.EvtProcTrab.InfoProcesso getInfoProcesso(EsocProcessoTrabalhista procTrab) {
        ESocial.EvtProcTrab.InfoProcesso i = new ESocial.EvtProcTrab.InfoProcesso();
        i.setOrigem(Byte.parseByte(String.valueOf(procTrab.getOrigem())));
        i.setNrProcTrab(procTrab.getNrProcTrab());
        i.setObsProcTrab(procTrab.getObsProcTrab());
        i.setDadosCompl(this.getDadosCompl(procTrab));
        return i;
    }

    private ESocial.EvtProcTrab.InfoProcesso.DadosCompl getDadosCompl(EsocProcessoTrabalhista procTrab) {
        ESocial.EvtProcTrab.InfoProcesso.DadosCompl d = new ESocial.EvtProcTrab.InfoProcesso.DadosCompl();
        d.setInfoProcJud(this.getInfoProcJud(procTrab));
        d.setInfoCCP(this.getInfoCCP(procTrab));
        return d;
    }

    private ESocial.EvtProcTrab.InfoProcesso.DadosCompl.InfoProcJud getInfoProcJud(EsocProcessoTrabalhista procTrab) {
        ESocial.EvtProcTrab.InfoProcesso.DadosCompl.InfoProcJud i = new ESocial.EvtProcTrab.InfoProcesso.DadosCompl.InfoProcJud();
        i.setDtSent(ToolEsocial.converteData(procTrab.getDtSent()));
        i.setUfVara(TSUf.valueOf(procTrab.getCidade().getUf().getSigla()));
        i.setCodMunic(new BigInteger(procTrab.getCidade().getUf().getCodIbge()));
        i.setIdVara(new BigInteger(String.valueOf(procTrab.getIdVara())));
        return i;
    }

    private ESocial.EvtProcTrab.InfoProcesso.DadosCompl.InfoCCP getInfoCCP(EsocProcessoTrabalhista procTrab) {
        ESocial.EvtProcTrab.InfoProcesso.DadosCompl.InfoCCP i = new ESocial.EvtProcTrab.InfoProcesso.DadosCompl.InfoCCP();
        i.setCnpjCCP(procTrab.getCnpjCCP());
        i.setTpCCP(Byte.parseByte(String.valueOf(procTrab.getTpCCP())));
        i.setDtCCP(ToolEsocial.converteData(procTrab.getDtCCP()));
        return i;
    }

    private ESocial.EvtProcTrab.IdeTrab getIdeTrab(EsocProcessoTrabalhista procTrab) {
        ESocial.EvtProcTrab.IdeTrab i = new ESocial.EvtProcTrab.IdeTrab();
        i.setCpfTrab(procTrab.getRecisao().getColaborador().getPessoa().getComplemento().getCnpj());
        i.setNmTrab(procTrab.getRecisao().getColaborador().getPessoa().getNome());
        i.setDtNascto(ToolEsocial.converteData(procTrab.getRecisao().getColaborador().getPessoa().getComplemento().getDataNascimento()));
        i.getInfoContr().add(this.getInfoContr(procTrab));
        return i;
    }

    private ESocial.EvtProcTrab.IdeTrab.InfoContr getInfoContr(EsocProcessoTrabalhista procTrab) {
        ESocial.EvtProcTrab.IdeTrab.InfoContr i = new ESocial.EvtProcTrab.IdeTrab.InfoContr();
        i.setTpContr(Byte.parseByte(procTrab.getTipoContrato().getCodigo()));
        if (ToolMethods.isEquals((Object)procTrab.getIndContr(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            i.setIndContr(TSSimNao.S);
        } else {
            i.setIndContr(TSSimNao.N);
        }
        i.setDtAdmOrig(ToolEsocial.converteData(procTrab.getRecisao().getColaborador().getDataAdmissao()));
        if (ToolMethods.isEquals((Object)procTrab.getIndReint(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            i.setIndReint(TSSimNao.S);
        } else {
            i.setIndReint(TSSimNao.N);
        }
        if (ToolMethods.isEquals((Object)procTrab.getIndCateg(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            i.setIndCateg(TSSimNao.S);
        } else {
            i.setIndCateg(TSSimNao.N);
        }
        if (ToolMethods.isEquals((Object)procTrab.getIndNatAtiv(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            i.setIndNatAtiv(TSSimNao.S);
        } else {
            i.setIndNatAtiv(TSSimNao.N);
        }
        if (ToolMethods.isEquals((Object)procTrab.getIndMotDelisg(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            i.setIndMotDeslig(TSSimNao.S);
        } else {
            i.setIndMotDeslig(TSSimNao.N);
        }
        i.setMatricula(procTrab.getRecisao().getColaborador().getNumeroRegistro());
        i.setCodCateg(new BigInteger(procTrab.getRecisao().getColaborador().getEsocCategoriaTrabalhador().getCodigo()));
        i.setDtInicio(ToolEsocial.converteData(procTrab.getRecisao().getColaborador().getDataAdmissao()));
        i.setInfoCompl(this.getInfoCompl(procTrab));
        return i;
    }

    private ESocial.EvtProcTrab.IdeTrab.InfoContr.InfoCompl getInfoCompl(EsocProcessoTrabalhista procTrab) {
        ESocial.EvtProcTrab.IdeTrab.InfoContr.InfoCompl i = new ESocial.EvtProcTrab.IdeTrab.InfoContr.InfoCompl();
        i.setCodCBO(procTrab.getRecisao().getColaborador().getFuncao().getCbo().getCodigo());
        i.setNatAtividade(Byte.valueOf(procTrab.getRecisao().getColaborador().getNaturezaAtividade().getCodigo()));
        for (Remuneracao remuneracao : procTrab.getRemuneracoes()) {
            i.getRemuneracao().add(this.getRemuneracao(remuneracao));
        }
        i.setInfoVinc(this.getInfoVinc(procTrab));
        i.setInfoTerm(this.getInfoTerm(procTrab));
        return i;
    }

    private ESocial.EvtProcTrab.IdeTrab.InfoContr.InfoCompl.Remuneracao getRemuneracao(Remuneracao remuneracao) {
        ESocial.EvtProcTrab.IdeTrab.InfoContr.InfoCompl.Remuneracao r = new ESocial.EvtProcTrab.IdeTrab.InfoContr.InfoCompl.Remuneracao();
        r.setDtRemun(ToolEsocial.converteData(remuneracao.getDtRemun()));
        r.setVrSalFx(ToolFormatter.arrredondarNumeroBigDecimal((Double)remuneracao.getVrSalFx(), (int)2));
        r.setUndSalFixo(Byte.parseByte(remuneracao.getUnidadePagamento().getCodigo()));
        r.setDscSalVar(remuneracao.getDscSalVar());
        return r;
    }

    private ESocial.EvtProcTrab.IdeTrab.InfoContr.InfoCompl.InfoVinc getInfoVinc(EsocProcessoTrabalhista procTrab) {
        ESocial.EvtProcTrab.IdeTrab.InfoContr.InfoCompl.InfoVinc i = new ESocial.EvtProcTrab.IdeTrab.InfoContr.InfoCompl.InfoVinc();
        i.setTpRegTrab(Byte.parseByte(procTrab.getRecisao().getColaborador().getRegimeTrabalhista().getCodigo()));
        i.setTpRegPrev(Byte.parseByte(procTrab.getRecisao().getColaborador().getRegimePrevidenciario().getCodigo()));
        i.setDtAdm(ToolEsocial.converteData(procTrab.getRecisao().getColaborador().getDataAdmissao()));
        i.setTmpParc(Byte.valueOf(procTrab.getRecisao().getColaborador().getHorarioTrabalho().getEsocCadastroHorario().getEsocTipoContrato().getCodigo()));
        i.setDuracao(this.getDuracao(procTrab));
        i.setInfoDeslig(this.getInfoDeslig(procTrab));
        return i;
    }

    private ESocial.EvtProcTrab.IdeTrab.InfoContr.InfoCompl.InfoVinc.Duracao getDuracao(EsocProcessoTrabalhista procTrab) {
        ESocial.EvtProcTrab.IdeTrab.InfoContr.InfoCompl.InfoVinc.Duracao d = new ESocial.EvtProcTrab.IdeTrab.InfoContr.InfoCompl.InfoVinc.Duracao();
        d.setTpContr(Byte.parseByte(procTrab.getTipoContrato().getCodigo()));
        d.setDtTerm(ToolEsocial.converteData(procTrab.getRecisao().getColaborador().getDataDemissao()));
        if (ToolMethods.isEquals((Object)procTrab.getRecisao().getColaborador().getClausulaAssecuratoria(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            d.setClauAssec(TSSimNao.S);
        } else {
            d.setClauAssec(TSSimNao.N);
        }
        return d;
    }

    private ESocial.EvtProcTrab.IdeTrab.InfoContr.InfoCompl.InfoVinc.InfoDeslig getInfoDeslig(EsocProcessoTrabalhista procTrab) {
        ESocial.EvtProcTrab.IdeTrab.InfoContr.InfoCompl.InfoVinc.InfoDeslig i = new ESocial.EvtProcTrab.IdeTrab.InfoContr.InfoCompl.InfoVinc.InfoDeslig();
        i.setDtDeslig(ToolEsocial.converteData(procTrab.getRecisao().getDataDemissao()));
        i.setDtProjFimAPI(ToolEsocial.converteData(procTrab.getRecisao().getDataFimAviso()));
        i.setPercAliment(ToolFormatter.arrredondarNumeroBigDecimal((Double)procTrab.getRecisao().getColaborador().getPercentualPensao(), (int)2));
        i.setVrAlim(ToolFormatter.arrredondarNumeroBigDecimal((Double)procTrab.getRecisao().getColaborador().getValorFixoPensao(), (int)2));
        return i;
    }

    private ESocial.EvtProcTrab.IdeTrab.InfoContr.InfoCompl.InfoTerm getInfoTerm(EsocProcessoTrabalhista procTrab) {
        ESocial.EvtProcTrab.IdeTrab.InfoContr.InfoCompl.InfoTerm i = new ESocial.EvtProcTrab.IdeTrab.InfoContr.InfoCompl.InfoTerm();
        i.setDtTerm(ToolEsocial.converteData(procTrab.getRecisao().getDataDemissao()));
        return i;
    }
}

