/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evtreintegracao;

import com.touchcomp.basementor.model.vo.EsocCadastroReintegracao2298;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evtreintegr.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evtreintegr.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evtreintegr.TEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evtreintegr.TIdeEveTrab;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evtreintegr.TIdeVinculoNisObrig;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;

public class ImpEvtReintegracao
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial root = this.getFact().createESocial();
        root.setEvtReintegr(this.getEvtReintegracao(preEvento, opcoes));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtReintegr getEvtReintegracao(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial.EvtReintegr evt = this.getFact().createESocialEvtReintegr();
        evt.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evt.setIdeEmpregador(this.getEmpregador(opcoes));
        evt.setIdeEvento(this.getIdEvento(opcoes, preEvento));
        evt.setIdeVinculo(this.getVinculo(preEvento));
        evt.setInfoReintegr(this.getInfoReintegracao(preEvento));
        return evt;
    }

    private TEmpregador getEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TEmpregador tEmpregador = this.getFact().createTEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private TIdeVinculoNisObrig getVinculo(EsocPreEvento preEvento) {
        TIdeVinculoNisObrig vinculo = this.getFact().createTIdeVinculoNisObrig();
        EsocCadastroReintegracao2298 esoc = preEvento.getEsocCadastroReintegracao();
        vinculo.setCpfTrab(esoc.getRescisao().getColaborador().getPessoa().getComplemento().getCnpj());
        vinculo.setMatricula(esoc.getRescisao().getColaborador().getNumeroRegistroESocial());
        vinculo.setNisTrab(esoc.getRescisao().getColaborador().getNumeroPis());
        return vinculo;
    }

    private TIdeEveTrab getIdEvento(OpcoesESocial opcoes, EsocPreEvento preEvento) {
        TIdeEveTrab tiTrab = this.getFact().createTIdeEveTrab();
        tiTrab.setTpAmb(Byte.parseByte(preEvento.getEsocEvento().getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        tiTrab.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        tiTrab.setVerProc(this.getVersaoEsocialSistema());
        if (preEvento.getEventoRetificacao().equals((short)1)) {
            tiTrab.setIndRetif(Byte.parseByte("2"));
            tiTrab.setNrRecibo(preEvento.getNumeroReciboRetificado());
        } else {
            tiTrab.setIndRetif(Byte.parseByte("1"));
        }
        return tiTrab;
    }

    private ESocial.EvtReintegr.InfoReintegr getInfoReintegracao(EsocPreEvento preEvento) {
        EsocCadastroReintegracao2298 esoc = preEvento.getEsocCadastroReintegracao();
        ESocial.EvtReintegr.InfoReintegr info = this.getFact().createESocialEvtReintegrInfoReintegr();
        info.setTpReint(Byte.parseByte(esoc.getEsocTipoReintegracao().getCodigo()));
        info.setDtEfetRetorno(ToolEsocial.converteData(esoc.getDataEfetivaRetorno()));
        info.setDtEfeito(ToolEsocial.converteData(esoc.getDataEfeito()));
        if (esoc.getEsocTipoReintegracao().getCodigo().equals("1")) {
            info.setNrProcJud(esoc.getNumeroProcesso());
        }
        if (esoc.getIndPagamentoJuizo().equals((short)1)) {
            info.setIndPagtoJuizo("S");
        } else {
            info.setIndPagtoJuizo("N");
        }
        return info;
    }
}

