/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evtremuneracaotrabalhador;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstESocialStatus;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EsocCadastroLotacaoTributaria;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocItemS1010;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.EsocS1010;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.FolhaComplementarPeriodo;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.MultiplosVinculosFolha;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.Rubricas1200;
import com.touchcomp.basementor.model.vo.RubricasFerias;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementor.model.vo.TransferenciaColaborador;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtremun.v_s_01_03_00.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtremun.v_s_01_03_00.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtremun.v_s_01_03_00.TDescFolha;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtremun.v_s_01_03_00.TIdeEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtremun.v_s_01_03_00.TIdeEventoFolha;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtremun.v_s_01_03_00.TInfoAgNocivo;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtremun.v_s_01_03_00.TInfoInterm;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtremun.v_s_01_03_00.TItensRemun;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtremun.v_s_01_03_00.TItensRemunDescFolha;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtremun.v_s_01_03_00.TSSimNao;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtremun.v_s_01_03_00.TSTpAcConv;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.httpclient.util.DateUtil;

public class ImpEvtRemuneracaoTrabalhador
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial root = this.getFact().createESocial();
        root.setEvtRemun(this.getEvtRemuneracao(preEvento, opcoes));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtRemun getEvtRemuneracao(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        EsocS1010 esoc = preEvento.getEsocS1200();
        ESocial.EvtRemun evt = this.getFact().createESocialEvtRemun();
        evt.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evt.setIdeEmpregador(this.getEmpregador(opcoes));
        evt.setIdeEvento(this.getIdEvento(opcoes, preEvento));
        evt.setIdeTrabalhador(this.getEvtTrabalhador(preEvento));
        if (!esoc.getItensS1010().isEmpty()) {
            for (EsocItemS1010 item : esoc.getItensS1010()) {
                evt.getDmDev().add(this.getDmDev(item));
            }
        }
        return evt;
    }

    private TIdeEmpregador getEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TIdeEmpregador tEmpregador = this.getFact().createTIdeEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private TIdeEventoFolha getIdEvento(OpcoesESocial opcoes, EsocPreEvento preEvento) {
        EsocS1010 esocS1010 = preEvento.getEsocS1200();
        TIdeEventoFolha tiTrab = this.getFact().createTIdeEventoFolha();
        tiTrab.setTpAmb(Byte.parseByte(preEvento.getEsocEvento().getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        tiTrab.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        tiTrab.setVerProc(this.getVersaoEsocialSistema());
        if (preEvento.getEventoRetificacao().equals((short)1)) {
            tiTrab.setIndRetif(Byte.parseByte("2"));
            tiTrab.setNrRecibo(preEvento.getNumeroReciboRetificado());
        } else {
            tiTrab.setIndRetif(Byte.parseByte("1"));
        }
        if (esocS1010.getEsocFechamentoFolha().getTipoFolha() != null && esocS1010.getEsocFechamentoFolha().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue())) {
            tiTrab.setIndApuracao(Byte.parseByte("2"));
            tiTrab.setPerApur(DateUtil.formatDate((Date)preEvento.getEsocS1200().getEsocFechamentoFolha().getPeriodoApuracao(), (String)"yyyy"));
        } else {
            tiTrab.setIndApuracao(Byte.parseByte("1"));
            tiTrab.setPerApur(DateUtil.formatDate((Date)preEvento.getEsocS1200().getEsocFechamentoFolha().getPeriodoApuracao(), (String)"yyyy-MM"));
        }
        return tiTrab;
    }

    private ESocial.EvtRemun.IdeTrabalhador getEvtTrabalhador(EsocPreEvento preEvento) throws ExceptionEsocial {
        MovimentoFolha mov = null;
        ESocial.EvtRemun.IdeTrabalhador evt = this.getFact().createESocialEvtRemunIdeTrabalhador();
        EsocS1010 esocS1010 = preEvento.getEsocS1200();
        evt.setCpfTrab(ToolString.refina((String)esocS1010.getColaborador().getPessoa().getComplemento().getCnpj()));
        if (esocS1010.getColaborador().getEsocCategoriaTrabalhador() == null) {
            throw new ExceptionEsocial("Colaborador: " + esocS1010.getColaborador().toString() + " sem Categoria do eSocial informada");
        }
        for (EsocItemS1010 item : esocS1010.getItensS1010()) {
            MovimentoFolha movLista = item.getMovimentoFolha();
            mov = item.getMovimentoFolha();
            if (mov == null || !movLista.getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue())) continue;
            mov = movLista;
            break;
        }
        if (mov != null && !mov.getMultiplosVinculos().isEmpty()) {
            evt.setInfoMV(this.getMultiplosVinculos(mov));
        }
        if (mov != null && (mov.getColaborador().getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.AUTONOMO.getValue()) || mov.getColaborador().getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.AUTONOMO_FRETE.getValue())) && this.getColaboradorNaoEnviado(mov.getColaborador())) {
            evt.setInfoComplem(this.getInfoComplementar(esocS1010, mov));
        }
        if (esocS1010.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("111")) {
            evt.getInfoInterm().add(this.getInfoIntermitente(mov));
        }
        return evt;
    }

    private ESocial.EvtRemun.IdeTrabalhador.InfoMV getMultiplosVinculos(MovimentoFolha mov) {
        ESocial.EvtRemun.IdeTrabalhador.InfoMV m = this.getFact().createESocialEvtRemunIdeTrabalhadorInfoMV();
        m.setIndMV(Byte.parseByte(mov.getEsocIndInssMv().getCodigo()));
        for (MultiplosVinculosFolha mul : mov.getMultiplosVinculos()) {
            m.getRemunOutrEmpr().add(this.dadosOutrasEmpresas(mul));
        }
        return m;
    }

    private ESocial.EvtRemun.IdeTrabalhador.InfoMV.RemunOutrEmpr dadosOutrasEmpresas(MultiplosVinculosFolha mul) {
        ESocial.EvtRemun.IdeTrabalhador.InfoMV.RemunOutrEmpr remuneracao = this.getFact().createESocialEvtRemunIdeTrabalhadorInfoMVRemunOutrEmpr();
        remuneracao.setTpInsc(Byte.parseByte("1"));
        remuneracao.setNrInsc(ToolString.refina((String)mul.getCnpj()));
        remuneracao.setCodCateg(new BigInteger(mul.getEsocCategoria().getCodigo()));
        remuneracao.setVlrRemunOE(ToolFormatter.arrredondarNumeroBigDecimal((Double)mul.getValorRemuneracaoRecebida(), (int)2));
        return remuneracao;
    }

    private ESocial.EvtRemun.IdeTrabalhador.InfoComplem getInfoComplementar(EsocS1010 esocS1010, MovimentoFolha mov) throws ExceptionEsocial {
        ESocial.EvtRemun.IdeTrabalhador.InfoComplem infoComplem = this.getFact().createESocialEvtRemunIdeTrabalhadorInfoComplem();
        infoComplem.setNmTrab(ToolString.clearInvalidUTF8Char((String)esocS1010.getColaborador().getPessoa().getNome()));
        if (esocS1010.getColaborador().getPessoa().getComplemento().getDataNascimento() == null) {
            throw new ExceptionEsocial("Colaborador: " + esocS1010.getColaborador().toString() + " sem Data de Nascimento");
        }
        infoComplem.setDtNascto(ToolEsocial.converteData(esocS1010.getColaborador().getPessoa().getComplemento().getDataNascimento()));
        if (mov.getTransferenciaColaborador() != null) {
            infoComplem.setSucessaoVinc(this.getSucessaoVinculo(mov.getTransferenciaColaborador()));
        }
        return infoComplem;
    }

    private ESocial.EvtRemun.IdeTrabalhador.InfoComplem.SucessaoVinc getSucessaoVinculo(TransferenciaColaborador t) {
        ESocial.EvtRemun.IdeTrabalhador.InfoComplem.SucessaoVinc s = this.getFact().createESocialEvtRemunIdeTrabalhadorInfoComplemSucessaoVinc();
        s.setMatricAnt(t.getMatriculaAnterior());
        s.setDtAdm(ToolEsocial.converteData(t.getColaborador().getDataAdmissao()));
        if (t.getObservacao() != null && t.getObservacao().length() > 1) {
            s.setObservacao(t.getObservacao());
        }
        return s;
    }

    private TInfoInterm getInfoIntermitente(MovimentoFolha mov) {
        TInfoInterm i = this.getFact().createTInfoInterm();
        Integer dias = mov.getNumeroDiasIntermitente().intValue();
        i.setDia(Byte.parseByte(dias.toString()));
        return i;
    }

    private ESocial.EvtRemun.DmDev getDmDev(EsocItemS1010 item) throws ExceptionEsocial {
        ESocial.EvtRemun.DmDev dmDev = this.getFact().createESocialEvtRemunDmDev();
        if (item.getMovimentoFolha() != null) {
            dmDev.setIdeDmDev(item.getMovimentoFolha().getIdentificador().toString());
            dmDev.setCodCateg(new BigInteger(item.getMovimentoFolha().getColaborador().getEsocCategoriaTrabalhador().getCodigo()));
            if (!item.getMovimentoFolha().getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_FOLHA_COMPLEMENTAR.getValue()) || item.getMovimentoFolha().getPagamentoFolhaComplementar() == null) {
                dmDev.setInfoPerApur(this.getInfoPeriodoApuracao(item));
                if ((item.getMovimentoFolha().getColaborador().getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.AUTONOMO.getValue()) || item.getMovimentoFolha().getColaborador().getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.AUTONOMO_FRETE.getValue())) && this.getColaboradorNaoEnviado(item.getMovimentoFolha().getColaborador())) {
                    dmDev.setInfoComplCont(this.getInfoComp(item));
                }
            } else {
                dmDev.setInfoPerAnt(this.getInfoPeriodoAnterior(item));
            }
        } else {
            dmDev.setIdeDmDev(item.getFerias().getIdentificador().toString());
            dmDev.setCodCateg(new BigInteger(item.getFerias().getPeriodoAqFeriasColab().getColaborador().getEsocCategoriaTrabalhador().getCodigo()));
            dmDev.setInfoPerApur(this.getInfoPeriodoApuracaoFerias(item));
        }
        return dmDev;
    }

    private ESocial.EvtRemun.DmDev.InfoPerApur getInfoPeriodoApuracao(EsocItemS1010 item) throws ExceptionEsocial {
        ESocial.EvtRemun.DmDev.InfoPerApur infoPeriodo = this.getFact().createESocialEvtRemunDmDevInfoPerApur();
        infoPeriodo.getIdeEstabLot().add(this.getEstLot(item.getMovimentoFolha()));
        return infoPeriodo;
    }

    private ESocial.EvtRemun.DmDev.InfoPerApur getInfoPeriodoApuracaoFerias(EsocItemS1010 item) throws ExceptionEsocial {
        ESocial.EvtRemun.DmDev.InfoPerApur infoPeriodo = this.getFact().createESocialEvtRemunDmDevInfoPerApur();
        infoPeriodo.getIdeEstabLot().add(this.getEstLotFerias(item.getFerias()));
        return infoPeriodo;
    }

    private ESocial.EvtRemun.DmDev.InfoPerApur.IdeEstabLot getEstLotFerias(FeriasColaborador ferias) throws ExceptionEsocial {
        if (ferias.getPeriodoAqFeriasColab().getColaborador().getLotacaoTributaria() == null) {
            throw new ExceptionEsocial("Folha do Colaborador: " + ferias.getPeriodoAqFeriasColab().getColaborador().toString() + " sem Lota\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo Informada");
        }
        ESocial.EvtRemun.DmDev.InfoPerApur.IdeEstabLot id = this.getFact().createESocialEvtRemunDmDevInfoPerApurIdeEstabLot();
        if (ferias.getPeriodoAqFeriasColab().getColaborador().getEstabelecimento().getInformarDadosCAEPF().equals((short)0)) {
            id.setTpInsc(Byte.parseByte("1"));
            id.setNrInsc(ToolString.refina((String)ferias.getPeriodoAqFeriasColab().getColaborador().getEmpresa().getPessoa().getComplemento().getCnpj()));
        } else {
            if (ferias.getPeriodoAqFeriasColab().getColaborador().getEstabelecimento().getCaepf() != null && ferias.getPeriodoAqFeriasColab().getColaborador().getEstabelecimento().getCaepf().getCodigo().equals("4")) {
                id.setTpInsc(Byte.parseByte("4"));
            } else {
                id.setTpInsc(Byte.parseByte("3"));
            }
            id.setNrInsc(ToolString.refina((String)ferias.getPeriodoAqFeriasColab().getColaborador().getEstabelecimento().getEmpresa().getPessoa().getComplemento().getCodCei()));
        }
        id.setCodLotacao(ferias.getPeriodoAqFeriasColab().getColaborador().getLotacaoTributaria().getCodigo());
        id.getRemunPerApur().add(this.getRemuneracaoPeriodoFerias(ferias));
        return id;
    }

    private ESocial.EvtRemun.DmDev.InfoPerApur.IdeEstabLot.RemunPerApur getRemuneracaoPeriodoFerias(FeriasColaborador ferias) throws ExceptionEsocial {
        Colaborador colaborador = ferias.getPeriodoAqFeriasColab().getColaborador();
        ESocial.EvtRemun.DmDev.InfoPerApur.IdeEstabLot.RemunPerApur remuneracao = this.getFact().createESocialEvtRemunDmDevInfoPerApurIdeEstabLotRemunPerApur();
        remuneracao.setMatricula(colaborador.getNumeroRegistroESocial());
        if (ferias.getRubricasFerias().isEmpty()) {
            throw new ExceptionEsocial("Ferias do colaborador: " + colaborador.toString() + " sem Rubricas informadas");
        }
        List<RubricasFerias> rubricas = this.rubricasOrdenadasFerias(ferias.getRubricasFerias());
        for (RubricasFerias r : rubricas) {
            if (!(r.getValorRubrica() > 0.0)) continue;
            if (r.getTipoCalculo().getEsocRubricasFolhaPagamento() == null) {
                throw new ExceptionEsocial("Rubrica: " + r.getTipoCalculo().getEvento().getDescricao() + " sem configura\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo do eSocial");
            }
            remuneracao.getItensRemun().add(this.getItemRemuneracaoFerias(r));
        }
        if (colaborador.getEsocCategoriaTrabalhador().getCodigo().equals("101") || colaborador.getEsocCategoriaTrabalhador().getCodigo().equals("103") || colaborador.getEsocCategoriaTrabalhador().getCodigo().equals("111")) {
            remuneracao.setInfoAgNocivo(this.getInfoAgNocivo(colaborador));
        }
        return remuneracao;
    }

    private ESocial.EvtRemun.DmDev.InfoPerApur.IdeEstabLot getEstLot(MovimentoFolha movimentoFolha) throws ExceptionEsocial {
        if (movimentoFolha.getLotacaoTributaria() == null) {
            throw new ExceptionEsocial("Folha do Colaborador: " + movimentoFolha.getColaborador().toString() + " sem Lota\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo Informada");
        }
        ESocial.EvtRemun.DmDev.InfoPerApur.IdeEstabLot id = this.getFact().createESocialEvtRemunDmDevInfoPerApurIdeEstabLot();
        if (movimentoFolha.getEstabelecimento().getInformarDadosCAEPF().equals((short)0)) {
            id.setTpInsc(Byte.parseByte("1"));
            id.setNrInsc(ToolString.refina((String)movimentoFolha.getEmpresa().getPessoa().getComplemento().getCnpj()));
        } else {
            if (movimentoFolha.getEstabelecimento().getCaepf() != null && movimentoFolha.getEstabelecimento().getCaepf().getCodigo().equals("4")) {
                id.setTpInsc(Byte.parseByte("4"));
            } else {
                id.setTpInsc(Byte.parseByte("3"));
            }
            id.setNrInsc(ToolString.refina((String)movimentoFolha.getColaborador().getEstabelecimento().getEmpresa().getPessoa().getComplemento().getCodCei()));
        }
        id.setCodLotacao(movimentoFolha.getColaborador().getLotacaoTributaria().getCodigo());
        id.getRemunPerApur().add(this.getRemuneracaoPeriodo(movimentoFolha));
        return id;
    }

    private ESocial.EvtRemun.DmDev.InfoPerApur.IdeEstabLot.RemunPerApur getRemuneracaoPeriodo(MovimentoFolha mov) throws ExceptionEsocial {
        ESocial.EvtRemun.DmDev.InfoPerApur.IdeEstabLot.RemunPerApur remuneracao = this.getFact().createESocialEvtRemunDmDevInfoPerApurIdeEstabLotRemunPerApur();
        if (mov.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("101") || mov.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("103") || mov.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("111")) {
            remuneracao.setMatricula(mov.getColaborador().getNumeroRegistroESocial());
        } else if (mov.getColaborador().getNumeroRegistroESocial() == null || !mov.getColaborador().getNumeroRegistroESocial().isEmpty()) {
            remuneracao.setMatricula(mov.getColaborador().getNumeroRegistroESocial());
        }
        System.err.println(mov.getIdentificador());
        List<Rubricas1200> rubricas = this.rubricasOrdenadas(mov.getRubricas1200());
        for (Rubricas1200 r : rubricas) {
            if (r.getTipoCalculo().getEsocRubricasFolhaPagamento() == null) {
                throw new ExceptionEsocial("Rubrica: " + r.getTipoCalculo().getEvento().getDescricao() + " sem configura\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo do eSocial");
            }
            if (r.getTipoCalculo().getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.CODIGO_PENSAO_ALIMENTICIA) || !(r.getValorRubrica() > 0.0)) continue;
            remuneracao.getItensRemun().add(this.getItemRemuneracao(r));
        }
        if (mov.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("101") || mov.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("103") || mov.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("111")) {
            remuneracao.setInfoAgNocivo(this.getInfoAgNocivo(mov.getColaborador()));
        }
        return remuneracao;
    }

    private TItensRemunDescFolha getItemRemuneracao(Rubricas1200 r) throws ExceptionEsocial {
        TipoCalculoEvento tipoCalculo = r.getTipoCalculo();
        TItensRemunDescFolha det = this.getFact().createTItensRemunDescFolha();
        if (tipoCalculo.getEvento().getInformarCodigoEsocial().equals((short)0)) {
            det.setCodRubr(tipoCalculo.getEvento().getCodigo().toString());
            det.setIdeTabRubr(tipoCalculo.getEvento().getIdentificador().toString());
        } else {
            det.setCodRubr(tipoCalculo.getEvento().getCodigoEsocial());
            det.setIdeTabRubr(tipoCalculo.getEvento().getIdeTabelaRubrica());
        }
        if (r.getFatorRubrica() > 0.0) {
            det.setQtdRubr(ToolFormatter.arrredondarNumeroBigDecimal((Double)r.getFatorRubrica(), (int)2));
        }
        det.setIndApurIR(Byte.valueOf("0"));
        det.setVrRubr(ToolFormatter.arrredondarNumeroBigDecimal((Double)r.getValorRubrica(), (int)2));
        if (r.getTipoCalculo().getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.EMPRESTIMO_ESOCIAL_ECONSIGNADO) && r.getConsignado() == null) {
            throw new ExceptionEsocial("Emprestimo Consignado nao informado na Folha.");
        }
        if (r.getTipoCalculo().getEsocRubricasFolhaPagamento().getCodigo().equals(ConstantsESocial.EMPRESTIMO_ESOCIAL_ECONSIGNADO)) {
            det.setDescFolha(this.getDescFolha(r));
        }
        return det;
    }

    private TDescFolha getDescFolha(Rubricas1200 r) throws ExceptionEsocial {
        TDescFolha dest = this.getFact().createTDescFolha();
        if (r.getConsignado().getCodigoBanco().isEmpty()) {
            throw new ExceptionEsocial("Informe o Codigo do Banco no Cadastro do Emprestimo referente ao evento:" + r.getTipoCalculo().getEvento().getDescricao());
        }
        if (r.getConsignado().getNumeroContratoEmprestimo().isEmpty()) {
            throw new ExceptionEsocial("Informe o numero do Contrato no Cadastro do Emprestimo referente ao evento:" + r.getTipoCalculo().getEvento().getDescricao());
        }
        dest.setInstFinanc(r.getConsignado().getCodigoBanco());
        dest.setNrDoc(r.getConsignado().getNumeroContratoEmprestimo());
        dest.setTpDesc(Byte.parseByte("1"));
        return dest;
    }

    private TItensRemunDescFolha getItemRemuneracaoFerias(RubricasFerias r) {
        TipoCalculoEvento tipoCalculo = r.getTipoCalculo();
        TItensRemunDescFolha det = this.getFact().createTItensRemunDescFolha();
        if (tipoCalculo.getEvento().getInformarCodigoEsocial().equals((short)0)) {
            det.setCodRubr(tipoCalculo.getEvento().getCodigo().toString());
            det.setIdeTabRubr(tipoCalculo.getEvento().getIdentificador().toString());
        } else {
            det.setCodRubr(tipoCalculo.getEvento().getCodigoEsocial());
            det.setIdeTabRubr(tipoCalculo.getEvento().getIdeTabelaRubrica());
        }
        if (r.getFatorRubrica() > 0.0) {
            det.setQtdRubr(ToolFormatter.arrredondarNumeroBigDecimal((Double)r.getFatorRubrica(), (int)2));
        }
        det.setIndApurIR(Byte.valueOf("0"));
        det.setVrRubr(ToolFormatter.arrredondarNumeroBigDecimal((Double)r.getValorRubrica(), (int)2));
        return det;
    }

    private TInfoAgNocivo getInfoAgNocivo(Colaborador colaborador) throws ExceptionEsocial {
        if (colaborador.getGrauExposicao() == null) {
            throw new ExceptionEsocial("Colaborador: " + colaborador.toString() + " sem Grau de Exposi\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo informado");
        }
        TInfoAgNocivo infoAg = this.getFact().createTInfoAgNocivo();
        infoAg.setGrauExp(Byte.parseByte(colaborador.getGrauExposicao().getCodigo()));
        return infoAg;
    }

    private List<Rubricas1200> rubricasOrdenadas(List<Rubricas1200> rubricas1200) {
        if (rubricas1200 != null) {
            Collections.sort(rubricas1200, (o1, o2) -> {
                Rubricas1200 item1 = (Rubricas1200)o1;
                Rubricas1200 item2 = (Rubricas1200)o2;
                System.out.println(item1.getTipoCalculo().getEvento().toString());
                Integer vlr1 = Integer.valueOf(item1.getTipoCalculo().getEsocTipoRubrica().getCodigo());
                Integer vlr2 = Integer.valueOf(item2.getTipoCalculo().getEsocTipoRubrica().getCodigo());
                return vlr2.compareTo(vlr1);
            });
            return rubricas1200;
        }
        return null;
    }

    private List<RubricasFerias> rubricasOrdenadasFerias(List<RubricasFerias> rubricas) {
        if (rubricas != null) {
            Collections.sort(rubricas, (o1, o2) -> {
                RubricasFerias item1 = (RubricasFerias)o1;
                RubricasFerias item2 = (RubricasFerias)o2;
                System.out.println(item1.getTipoCalculo().getEvento().toString());
                Integer vlr1 = Integer.valueOf(item1.getTipoCalculo().getEsocTipoRubrica().getCodigo());
                Integer vlr2 = Integer.valueOf(item2.getTipoCalculo().getEsocTipoRubrica().getCodigo());
                return vlr2.compareTo(vlr1);
            });
            return rubricas;
        }
        return null;
    }

    private ESocial.EvtRemun.DmDev.InfoComplCont getInfoComp(EsocItemS1010 item) {
        ESocial.EvtRemun.DmDev.InfoComplCont i = this.getFact().createESocialEvtRemunDmDevInfoComplCont();
        i.setCodCBO(ToolString.refina((String)item.getMovimentoFolha().getColaborador().getFuncao().getCbo().getCodigo()));
        return i;
    }

    private boolean getColaboradorNaoEnviado(Colaborador colaborador) {
        if (colaborador.getPreEventosEsocial().isEmpty()) {
            return true;
        }
        if (colaborador.getInformarReciboManual().equals((short)1)) {
            return false;
        }
        for (EsocPreEvento preEvento : colaborador.getPreEventosEsocial()) {
            if (!preEvento.getTipoEventoEsocial().getIdentificador().equals(ConstantsESocial.REGISTRO_2300) || preEvento.getEsocEvento() == null || !preEvento.getEsocEvento().getStatus().equals(EnumConstESocialStatus.STATUS_SUCESSO.getValue()) && !preEvento.getEsocEvento().getStatus().equals(EnumConstESocialStatus.STATUS_SUCESSO_ADVERTENCIA.getValue())) continue;
            return false;
        }
        return true;
    }

    private ESocial.EvtRemun.DmDev.InfoPerAnt getInfoPeriodoAnterior(EsocItemS1010 item) {
        ESocial.EvtRemun.DmDev.InfoPerAnt infoPeriodo = this.getFact().createESocialEvtRemunDmDevInfoPerAnt();
        infoPeriodo.getIdeADC().add(this.getIdeAC(item));
        return infoPeriodo;
    }

    private ESocial.EvtRemun.DmDev.InfoPerAnt.IdeADC getIdeAC(EsocItemS1010 item) {
        ESocial.EvtRemun.DmDev.InfoPerAnt.IdeADC ideAdc = this.getFact().createESocialEvtRemunDmDevInfoPerAntIdeADC();
        ideAdc.setDtAcConv(ToolEsocial.converteData(item.getMovimentoFolha().getPagamentoFolhaComplementar().getCalculoComplementoSalario().getDataAcordo()));
        ideAdc.setTpAcConv(this.getCreateTSTpAcConv());
        ideAdc.setDsc(item.getMovimentoFolha().getPagamentoFolhaComplementar().getCalculoComplementoSalario().getDescricao());
        for (FolhaComplementarPeriodo folhaComp : item.getMovimentoFolha().getPagamentoFolhaComplementar().getFolhaComplementares()) {
            ideAdc.getIdePeriodo().add(this.getPeriodoAnterior(folhaComp, item.getMovimentoFolha().getLotacaoTributaria(), item.getMovimentoFolha()));
        }
        ideAdc.setRemunSuc(this.getSimNao());
        return ideAdc;
    }

    private ESocial.EvtRemun.DmDev.InfoPerAnt.IdeADC.IdePeriodo getPeriodoAnterior(FolhaComplementarPeriodo folhaComp, EsocCadastroLotacaoTributaria lotacao, MovimentoFolha movimentoFolha) {
        ESocial.EvtRemun.DmDev.InfoPerAnt.IdeADC.IdePeriodo idePeriodo = this.getFact().createESocialEvtRemunDmDevInfoPerAntIdeADCIdePeriodo();
        idePeriodo.setPerRef(ToolDate.formatDateAnoMes((Date)folhaComp.getPeriodo()));
        idePeriodo.getIdeEstabLot().add(this.getIdeEstabelecimentoAnterior(folhaComp, lotacao, movimentoFolha));
        return idePeriodo;
    }

    private ESocial.EvtRemun.DmDev.InfoPerAnt.IdeADC.IdePeriodo.IdeEstabLot getIdeEstabelecimentoAnterior(FolhaComplementarPeriodo folhaComp, EsocCadastroLotacaoTributaria lotacao, MovimentoFolha movimentoFolha) {
        ESocial.EvtRemun.DmDev.InfoPerAnt.IdeADC.IdePeriodo.IdeEstabLot ideEstabelecimento = this.getFact().createESocialEvtRemunDmDevInfoPerAntIdeADCIdePeriodoIdeEstabLot();
        ideEstabelecimento.setCodLotacao(lotacao.getCodigo());
        ideEstabelecimento.setTpInsc(Byte.parseByte("1"));
        ideEstabelecimento.setNrInsc(ToolString.refina((String)movimentoFolha.getEmpresa().getPessoa().getComplemento().getCnpj()));
        ideEstabelecimento.getRemunPerAnt().add(this.getRemuneracaoAnterior(folhaComp));
        return ideEstabelecimento;
    }

    private ESocial.EvtRemun.DmDev.InfoPerAnt.IdeADC.IdePeriodo.IdeEstabLot.RemunPerAnt getRemuneracaoAnterior(FolhaComplementarPeriodo folhaComp) {
        ESocial.EvtRemun.DmDev.InfoPerAnt.IdeADC.IdePeriodo.IdeEstabLot.RemunPerAnt remunAnt = this.getFact().createESocialEvtRemunDmDevInfoPerAntIdeADCIdePeriodoIdeEstabLotRemunPerAnt();
        remunAnt.setMatricula(folhaComp.getPagamentoComplementar().getColaborador().getNumeroRegistroESocial());
        remunAnt.setInfoAgNocivo(this.getInfoAgNocivoAnterior(folhaComp.getPagamentoComplementar().getColaborador()));
        for (Rubricas1200 r : folhaComp.getRubricas1200()) {
            remunAnt.getItensRemun().add(this.getRubrica1200Anterior(r));
        }
        return remunAnt;
    }

    private TInfoAgNocivo getInfoAgNocivoAnterior(Colaborador colaborador) {
        TInfoAgNocivo infoAgNocivo = this.getFact().createTInfoAgNocivo();
        infoAgNocivo.setGrauExp(Byte.parseByte(colaborador.getGrauExposicao().getCodigo()));
        return infoAgNocivo;
    }

    private TItensRemun getRubrica1200Anterior(Rubricas1200 r) {
        TipoCalculoEvento tipoCalculo = r.getTipoCalculo();
        TItensRemun det = this.getFact().createTItensRemun();
        if (tipoCalculo.getEvento().getInformarCodigoEsocial().equals((short)0)) {
            det.setCodRubr(tipoCalculo.getEvento().getCodigo().toString());
            det.setIdeTabRubr(tipoCalculo.getEvento().getIdentificador().toString());
        } else {
            det.setCodRubr(tipoCalculo.getEvento().getCodigoEsocial());
            det.setIdeTabRubr(tipoCalculo.getEvento().getIdeTabelaRubrica());
        }
        if (r.getFatorRubrica() > 0.0) {
            det.setQtdRubr(ToolFormatter.arrredondarNumeroBigDecimal((Double)r.getFatorRubrica(), (int)2));
        }
        det.setIndApurIR(Byte.valueOf("0"));
        det.setVrRubr(ToolFormatter.arrredondarNumeroBigDecimal((Double)r.getValorRubrica(), (int)2));
        return det;
    }

    private TSTpAcConv getCreateTSTpAcConv() {
        return TSTpAcConv.E;
    }

    private TSSimNao getSimNao() {
        return TSSimNao.N;
    }
}

