/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evtsuspensaoferias;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.SuspensaoFerias;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_02_00.evt.evtafasttemp.v_s_01_02_00.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_02_00.evt.evtafasttemp.v_s_01_02_00.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_02_00.evt.evtafasttemp.v_s_01_02_00.TIdeEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_02_00.evt.evtafasttemp.v_s_01_02_00.TIdeEventoTrab;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Date;

public class ImpEvtSuspensaoFerias
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        SuspensaoFerias suspensao = preEvento.getSuspensaoFerias();
        ESocial root = this.getFact().createESocial();
        root.setEvtAfastTemp(this.getEvtAfastTemp(preEvento, opcoes, suspensao));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtAfastTemp getEvtAfastTemp(EsocPreEvento preEvento, OpcoesESocial opcoes, SuspensaoFerias suspensao) throws ExceptionEsocial {
        ESocial.EvtAfastTemp evt = this.getFact().createESocialEvtAfastTemp();
        evt.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evt.setIdeEmpregador(this.getIdEmpregador(opcoes));
        evt.setIdeEvento(this.getIdEvento(opcoes, preEvento.getEsocEvento()));
        evt.setIdeVinculo(this.getIdVinculo(suspensao));
        evt.setInfoAfastamento(this.getInfoAfastamento(preEvento, suspensao));
        return evt;
    }

    private TIdeEmpregador getIdEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TIdeEmpregador tEmpregador = this.getFact().createTIdeEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private TIdeEventoTrab getIdEvento(OpcoesESocial opcoes, EsocEvento esocEvento) {
        TIdeEventoTrab tiTrab = this.getFact().createTIdeEventoTrab();
        tiTrab.setTpAmb(Byte.parseByte(esocEvento.getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        tiTrab.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        tiTrab.setVerProc(this.getVersaoEsocialSistema());
        if (esocEvento.getPreEvento().getEventoRetificacao().equals((short)1)) {
            tiTrab.setIndRetif(Byte.parseByte("2"));
            tiTrab.setNrRecibo(esocEvento.getPreEvento().getNumeroReciboRetificado());
        } else {
            tiTrab.setIndRetif(Byte.parseByte("1"));
        }
        return tiTrab;
    }

    private ESocial.EvtAfastTemp.IdeVinculo getIdVinculo(SuspensaoFerias suspensao) {
        FeriasColaborador ferias = suspensao.getFerias();
        ESocial.EvtAfastTemp.IdeVinculo vinculo = this.getFact().createESocialEvtAfastTempIdeVinculo();
        vinculo.setCpfTrab(ferias.getPeriodoAqFeriasColab().getColaborador().getPessoa().getComplemento().getCnpj());
        vinculo.setMatricula(ferias.getPeriodoAqFeriasColab().getColaborador().getNumeroRegistroESocial());
        return vinculo;
    }

    private ESocial.EvtAfastTemp.InfoAfastamento getInfoAfastamento(EsocPreEvento preEvento, SuspensaoFerias suspensao) {
        ESocial.EvtAfastTemp.InfoAfastamento info = this.getFact().createESocialEvtAfastTempInfoAfastamento();
        if (preEvento.getTipoAfastamento().equals(ConstantsESocial.SUSPENSAO_FERIAS_INICIO)) {
            info.setIniAfastamento(this.getInicioAfastamento(suspensao.getFerias(), suspensao.getFerias().getDataGozoInicial()));
            info.setFimAfastamento(this.getFimAfastamento(suspensao.getDataSuspensao()));
        } else {
            info.setIniAfastamento(this.getInicioAfastamento(suspensao.getFerias(), suspensao.getDataFimSuspensao()));
            info.setFimAfastamento(this.getFimAfastamento(ToolDate.nextDays((Date)suspensao.getDataFimSuspensao(), (int)suspensao.getDiasRestanteFerias().intValue())));
        }
        return info;
    }

    private ESocial.EvtAfastTemp.InfoAfastamento.IniAfastamento getInicioAfastamento(FeriasColaborador ferias, Date dataInicio) {
        ESocial.EvtAfastTemp.InfoAfastamento.IniAfastamento i = this.getFact().createESocialEvtAfastTempInfoAfastamentoIniAfastamento();
        i.setDtIniAfast(ToolEsocial.converteData(dataInicio));
        i.setCodMotAfast("15");
        i.setPerAquis(this.getPeriodoAquisitivo(ferias));
        return i;
    }

    private ESocial.EvtAfastTemp.InfoAfastamento.FimAfastamento getFimAfastamento(Date dataTermino) {
        ESocial.EvtAfastTemp.InfoAfastamento.FimAfastamento f = this.getFact().createESocialEvtAfastTempInfoAfastamentoFimAfastamento();
        f.setDtTermAfast(ToolEsocial.converteData(dataTermino));
        return f;
    }

    private ESocial.EvtAfastTemp.InfoAfastamento.IniAfastamento.PerAquis getPeriodoAquisitivo(FeriasColaborador ferias) {
        ESocial.EvtAfastTemp.InfoAfastamento.IniAfastamento.PerAquis p = this.getFact().createESocialEvtAfastTempInfoAfastamentoIniAfastamentoPerAquis();
        p.setDtInicio(ToolEsocial.converteData(ferias.getPeriodoAqFeriasColab().getDataInicial()));
        p.setDtFim(ToolEsocial.converteData(ferias.getPeriodoAqFeriasColab().getDataFinal()));
        return p;
    }
}

