/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evttabestab;

import com.touchcomp.basementor.constants.enums.EnumEsocialTipoEvento;
import com.touchcomp.basementor.model.vo.EsocCadastroEstabelcimento;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttabestab.v_s_01_03_00.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttabestab.v_s_01_03_00.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttabestab.v_s_01_03_00.TDadosEstab;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttabestab.v_s_01_03_00.TIdeEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttabestab.v_s_01_03_00.TIdeEstab;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttabestab.v_s_01_03_00.TIdeEventoEvtTabInicial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttabestab.v_s_01_03_00.TNovaValidade;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Date;

public class ImpEvtTabEst
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        EsocCadastroEstabelcimento estabelecimento = preEvento.getEstabelecimento();
        ESocial root = this.getFact().createESocial();
        root.setEvtTabEstab(this.getEvtTabEstabelecimento(estabelecimento, opcoes, preEvento));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtTabEstab getEvtTabEstabelecimento(EsocCadastroEstabelcimento estabelecimento, OpcoesESocial opcoes, EsocPreEvento preEvento) throws ExceptionEsocial {
        ESocial.EvtTabEstab evtTabEst = this.getFact().createESocialEvtTabEstab();
        evtTabEst.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evtTabEst.setIdeEvento(this.getIdEvento(opcoes, preEvento.getEsocEvento()));
        evtTabEst.setIdeEmpregador(this.getIdEmpregador(opcoes));
        evtTabEst.setInfoEstab(this.getInfoEstabelecimento(estabelecimento, opcoes, preEvento));
        return evtTabEst;
    }

    private TIdeEventoEvtTabInicial getIdEvento(OpcoesESocial opcoes, EsocEvento esoc) {
        TIdeEventoEvtTabInicial cadastro = this.getFact().createTIdeEventoEvtTabInicial();
        cadastro.setTpAmb(Byte.parseByte(esoc.getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        cadastro.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        cadastro.setVerProc(this.getVersaoEsocialSistema());
        return cadastro;
    }

    private TIdeEmpregador getIdEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TIdeEmpregador tEmpregador = this.getFact().createTIdeEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private ESocial.EvtTabEstab.InfoEstab getInfoEstabelecimento(EsocCadastroEstabelcimento estabelecimento, OpcoesESocial opcoes, EsocPreEvento preEvento) throws ExceptionEsocial {
        ESocial.EvtTabEstab.InfoEstab infoEst = this.getFact().createESocialEvtTabEstabInfoEstab();
        if (preEvento.getTipoEvento() == EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value) {
            infoEst.setInclusao(this.getInclusao(opcoes, estabelecimento, preEvento));
        } else if (preEvento.getTipoEvento() == EnumEsocialTipoEvento.TIPO_EVENTO_ALTERACAO.value) {
            infoEst.setAlteracao(this.getAlteracao(opcoes, estabelecimento, preEvento));
        } else if (preEvento.getTipoEvento() == EnumEsocialTipoEvento.TIPO_EVENTO_EXLUSAO.value) {
            infoEst.setExclusao(this.getExclusao(opcoes, preEvento));
        }
        return infoEst;
    }

    private ESocial.EvtTabEstab.InfoEstab.Inclusao getInclusao(OpcoesESocial opcoes, EsocCadastroEstabelcimento estabelecimento, EsocPreEvento preEvento) throws ExceptionEsocial {
        ESocial.EvtTabEstab.InfoEstab.Inclusao inclusao = this.getFact().createESocialEvtTabEstabInfoEstabInclusao();
        inclusao.setIdeEstab(this.getIdeEst(preEvento, opcoes));
        inclusao.setDadosEstab(this.getDadosEst(estabelecimento));
        return inclusao;
    }

    private TDadosEstab getDadosEst(EsocCadastroEstabelcimento estabelecimento) {
        TDadosEstab dados = this.getFact().createTDadosEstab();
        if (estabelecimento.getAjusteRat() > 0.0) {
            dados.setAliqGilrat(this.getAliqGilRat(estabelecimento));
        }
        dados.setCnaePrep(estabelecimento.getCnae().getCodigo());
        return dados;
    }

    private TIdeEstab getIdeEst(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        TIdeEstab tiEst = this.getFact().createTIdeEstab();
        tiEst.setIniValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataInicioVal()));
        if (preEvento.getDataFimVal() != null) {
            tiEst.setFimValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataFimVal()));
        }
        if (preEvento.getEstabelecimento().getInformarDadosCAEPF().equals((short)0)) {
            tiEst.setNrInsc(ToolString.refina((String)preEvento.getEstabelecimento().getEmpresa().getPessoa().getComplemento().getCnpj()));
            tiEst.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        } else {
            tiEst.setTpInsc(Byte.parseByte("4"));
            tiEst.setNrInsc(ToolString.refina((String)preEvento.getEstabelecimento().getEmpresa().getPessoa().getComplemento().getCodCei()));
        }
        return tiEst;
    }

    private TIdeEstab getIdeEstAlteracao(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        TIdeEstab tiEst = this.getFact().createTIdeEstab();
        tiEst.setIniValid(ToolDate.formatDateAnoMes((Date)preEvento.getEventoAnterior().getDataInicioVal()));
        if (preEvento.getDataFimVal() != null) {
            tiEst.setFimValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataFimVal()));
        }
        tiEst.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tiEst.setNrInsc(ToolString.refina((String)preEvento.getEstabelecimento().getEmpresa().getPessoa().getComplemento().getCnpj()));
        return tiEst;
    }

    private TDadosEstab.InfoCaepf getInfoCaePF(EsocCadastroEstabelcimento estabelecimento) {
        TDadosEstab.InfoCaepf info = this.getFact().createTDadosEstabInfoCaepf();
        info.setTpCaepf(Byte.parseByte(estabelecimento.getCaepf().getCodigo()));
        return info;
    }

    private TDadosEstab.InfoTrab getInfoTrab(EsocCadastroEstabelcimento estabelecimento) {
        TDadosEstab.InfoTrab infoTrab = this.getFact().createTDadosEstabInfoTrab();
        infoTrab.setInfoApr(this.getInfoAprendiz(estabelecimento));
        return infoTrab;
    }

    private TDadosEstab.InfoTrab.InfoPCD getInfoPCD(EsocCadastroEstabelcimento estabelecimento) {
        TDadosEstab.InfoTrab.InfoPCD infoPcd = this.getFact().createTDadosEstabInfoTrabInfoPCD();
        infoPcd.setNrProcJud(estabelecimento.getIndicativoPdo().getCodigo());
        return infoPcd;
    }

    private TDadosEstab.InfoTrab.InfoApr getInfoAprendiz(EsocCadastroEstabelcimento estabelecimento) {
        TDadosEstab.InfoTrab.InfoApr infoApr = this.getFact().createTDadosEstabInfoTrabInfoApr();
        infoApr.setNrProcJud(estabelecimento.getContracaoMenorAprendiz().getCodigo());
        return infoApr;
    }

    private ESocial.EvtTabEstab.InfoEstab.Alteracao getAlteracao(OpcoesESocial opcoes, EsocCadastroEstabelcimento estabelecimento, EsocPreEvento preEvento) throws ExceptionEsocial {
        ESocial.EvtTabEstab.InfoEstab.Alteracao alteracao = this.getFact().createESocialEvtTabEstabInfoEstabAlteracao();
        alteracao.setIdeEstab(this.getIdeEstAlteracao(preEvento, opcoes));
        alteracao.setDadosEstab(this.getDadosEst(estabelecimento));
        alteracao.setNovaValidade(this.getNovaValidade(preEvento));
        return alteracao;
    }

    private TNovaValidade getNovaValidade(EsocPreEvento preEvento) {
        TNovaValidade validade = this.getFact().createTNovaValidade();
        validade.setIniValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataInicioVal()));
        if (preEvento.getDataFimVal() != null) {
            // empty if block
        }
        return validade;
    }

    private ESocial.EvtTabEstab.InfoEstab.Exclusao getExclusao(OpcoesESocial opcoes, EsocPreEvento preEvento) throws ExceptionEsocial {
        ESocial.EvtTabEstab.InfoEstab.Exclusao exclusao = this.getFact().createESocialEvtTabEstabInfoEstabExclusao();
        exclusao.setIdeEstab(this.getIdeEst(preEvento, opcoes));
        return exclusao;
    }

    private TDadosEstab.AliqGilrat getAliqGilRat(EsocCadastroEstabelcimento estabelecimento) {
        TDadosEstab.AliqGilrat t = new TDadosEstab.AliqGilrat();
        t.setFap(ToolFormatter.arrredondarNumeroBigDecimal((Double)estabelecimento.getFat(), (int)4));
        t.getFap();
        return t;
    }
}

