/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evttabhortur;

import com.touchcomp.basementor.constants.enums.EnumEsocialTipoEvento;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.InfoHorarioTrabalho;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.impl.EsocialEvento;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evttabhortur.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evttabhortur.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evttabhortur.TDadosHorContratual;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evttabhortur.TEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evttabhortur.TIdeCadastro;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evttabhortur.TIdeHorContratual;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evttabhortur.TPeriodoValidade;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.math.BigInteger;
import java.util.Date;

public class ImpTabHorTur
extends DocEsocialBaseImpl {
    @Override
    public EsocialEvento getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        InfoHorarioTrabalho info = preEvento.getInfoHorario();
        ESocial root = this.getFact().createESocial();
        root.setEvtTabHorTur(this.getEvtHorTur(preEvento, info, opcoes));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtTabHorTur getEvtHorTur(EsocPreEvento preEvento, InfoHorarioTrabalho info, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial.EvtTabHorTur evtTabHor = this.getFact().createESocialEvtTabHorTur();
        evtTabHor.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evtTabHor.setIdeEvento(this.getIdEvento(opcoes, preEvento));
        evtTabHor.setIdeEmpregador(this.getIdEmpregador(opcoes));
        evtTabHor.setInfoHorContratual(this.getInfoHorContratual(info, preEvento));
        return evtTabHor;
    }

    private TIdeCadastro getIdEvento(OpcoesESocial opcoes, EsocPreEvento esoc) {
        TIdeCadastro cadastro = this.getFact().createTIdeCadastro();
        cadastro.setTpAmb(Byte.parseByte(esoc.getEsocEvento().getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        cadastro.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        cadastro.setVerProc(this.getVersaoEsocialSistema());
        return cadastro;
    }

    private TEmpregador getIdEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TEmpregador tEmpregador = this.getFact().createTEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private ESocial.EvtTabHorTur.InfoHorContratual getInfoHorContratual(InfoHorarioTrabalho info, EsocPreEvento preEvento) {
        ESocial.EvtTabHorTur.InfoHorContratual infoHorario = this.getFact().createESocialEvtTabHorTurInfoHorContratual();
        if (preEvento.getTipoEvento() == EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value) {
            infoHorario.setInclusao(this.getInclusao(info, preEvento));
        } else if (preEvento.getTipoEvento() == EnumEsocialTipoEvento.TIPO_EVENTO_ALTERACAO.value) {
            infoHorario.setAlteracao(this.getAlteracao(info, preEvento));
        } else if (preEvento.getTipoEvento() == EnumEsocialTipoEvento.TIPO_EVENTO_EXLUSAO.value) {
            infoHorario.setExclusao(this.getExclusao(info, preEvento));
        }
        return infoHorario;
    }

    private ESocial.EvtTabHorTur.InfoHorContratual.Inclusao getInclusao(InfoHorarioTrabalho info, EsocPreEvento preEvento) {
        ESocial.EvtTabHorTur.InfoHorContratual.Inclusao inclusao = this.getFact().createESocialEvtTabHorTurInfoHorContratualInclusao();
        inclusao.setIdeHorContratual(this.getIdeHorario(preEvento, info));
        inclusao.setDadosHorContratual(this.getTDadosContratual(info));
        return inclusao;
    }

    private TIdeHorContratual getIdeHorario(EsocPreEvento preEvento, InfoHorarioTrabalho info) {
        TIdeHorContratual tiHorario = this.getFact().createTIdeHorContratual();
        tiHorario.setCodHorContrat(info.getCodigoEsocial());
        tiHorario.setIniValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataInicioVal()));
        if (preEvento.getDataFimVal() != null) {
            tiHorario.setFimValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataFimVal()));
        }
        return tiHorario;
    }

    private TIdeHorContratual getIdeHorarioAlteracao(EsocPreEvento preEvento, InfoHorarioTrabalho info) {
        TIdeHorContratual tiHorario = this.getFact().createTIdeHorContratual();
        tiHorario.setCodHorContrat(info.getCodigoEsocial());
        tiHorario.setIniValid(ToolDate.formatDateAnoMes((Date)preEvento.getEventoAnterior().getDataInicioVal()));
        if (preEvento.getEventoAnterior().getDataFimVal() != null) {
            tiHorario.setFimValid(ToolDate.formatDateAnoMes((Date)preEvento.getEventoAnterior().getDataFimVal()));
        }
        return tiHorario;
    }

    private TDadosHorContratual getTDadosContratual(InfoHorarioTrabalho info) {
        TDadosHorContratual dados = this.getFact().createTDadosHorContratual();
        Integer aux = info.getTotalHoras().intValue();
        dados.setDurJornada(new BigInteger(aux.toString()));
        dados.setHrEntr(ToolString.refina((String)ToolString.formatarHorario((String)info.getHorarioInicial().toString())).substring(0, 4));
        dados.setHrSaida(ToolString.refina((String)ToolString.formatarHorario((String)info.getHorarioFinal().toString())).substring(0, 4));
        info.getIdentificador();
        if (info.getEsocCadastroHorario() != null && info.getEsocCadastroHorario().getPermiteFlexibilidade().equals((short)1) || info.getEsocAux() != null && info.getEsocAux().getPermiteFlexibilidade().equals((short)1)) {
            dados.setPerHorFlexivel("S");
        } else {
            dados.setPerHorFlexivel("N");
        }
        dados.getHorarioIntervalo().add(this.createHorarioIntervalo(info));
        return dados;
    }

    private TDadosHorContratual.HorarioIntervalo createHorarioIntervalo(InfoHorarioTrabalho info) {
        TDadosHorContratual.HorarioIntervalo horarioIntervalo = this.getFact().createTDadosHorContratualHorarioIntervalo();
        Integer aux = info.getTotalIntervalo().intValue();
        horarioIntervalo.setDurInterv(new BigInteger(aux.toString()));
        if (info.getEsocCadastroHorario() != null && info.getEsocCadastroHorario().getIntervaloHorarioFixo().equals((short)1) || info.getEsocAux() != null && info.getEsocAux().getIntervaloHorarioFixo().equals((short)1)) {
            horarioIntervalo.setIniInterv(ToolString.refina((String)ToolString.formatarHorario((String)info.getInicioIntervalo().toString())).substring(0, 4));
            horarioIntervalo.setTermInterv(ToolString.refina((String)ToolString.formatarHorario((String)info.getFinalIntervalo().toString())).substring(0, 4));
            horarioIntervalo.setTpInterv(Byte.parseByte("1"));
        } else {
            horarioIntervalo.setTpInterv(Byte.parseByte("2"));
        }
        return horarioIntervalo;
    }

    private ESocial.EvtTabHorTur.InfoHorContratual.Alteracao getAlteracao(InfoHorarioTrabalho info, EsocPreEvento preEvento) {
        ESocial.EvtTabHorTur.InfoHorContratual.Alteracao alteracao = this.getFact().createESocialEvtTabHorTurInfoHorContratualAlteracao();
        alteracao.setIdeHorContratual(this.getIdeHorarioAlteracao(preEvento, info));
        alteracao.setDadosHorContratual(this.getTDadosContratual(info));
        alteracao.setNovaValidade(this.getNovaValidade(preEvento));
        return alteracao;
    }

    private TPeriodoValidade getNovaValidade(EsocPreEvento preEvento) {
        TPeriodoValidade tPeriodo = this.getFact().createTPeriodoValidade();
        tPeriodo.setIniValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataInicioVal()));
        if (preEvento.getDataFimVal() != null) {
            tPeriodo.setIniValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataFimVal()));
        }
        return tPeriodo;
    }

    private ESocial.EvtTabHorTur.InfoHorContratual.Exclusao getExclusao(InfoHorarioTrabalho info, EsocPreEvento preEvento) {
        ESocial.EvtTabHorTur.InfoHorContratual.Exclusao exclusao = this.getFact().createESocialEvtTabHorTurInfoHorContratualExclusao();
        exclusao.setIdeHorContratual(this.getIdeHorarioAlteracao(preEvento, info));
        return exclusao;
    }
}

