/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evttoxic;

import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocExameToxicologico;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttoxic.v_s_01_03_00.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttoxic.v_s_01_03_00.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttoxic.v_s_01_03_00.TIdeEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttoxic.v_s_01_03_00.TIdeEventoTrabPJSemSimplificado;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttoxic.v_s_01_03_00.TSUf;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;

public class ImpEvtToxic
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        EsocExameToxicologico exame = preEvento.getExameToxicologico();
        ESocial root = this.getFact().createESocial();
        root.setEvtToxic(this.getEvtToxic(preEvento, opcoes, exame));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtToxic getEvtToxic(EsocPreEvento preEvento, OpcoesESocial opcoes, EsocExameToxicologico exame) throws ExceptionEsocial {
        ESocial.EvtToxic e = new ESocial.EvtToxic();
        e.setIdeEmpregador(this.getIdEmpregador(opcoes));
        e.setIdeEvento(this.getIdEvento(opcoes, preEvento.getEsocEvento()));
        e.setIdeVinculo(this.getIdeVinculo(exame));
        e.setToxicologico(this.getToxicologico(exame));
        e.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        return e;
    }

    private TIdeEmpregador getIdEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TIdeEmpregador empregador = this.getFact().createTIdeEmpregador();
        empregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        empregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return empregador;
    }

    private TIdeEventoTrabPJSemSimplificado getIdEvento(OpcoesESocial opcoes, EsocEvento esocEvento) {
        TIdeEventoTrabPJSemSimplificado cadastro = this.getFact().createTIdeEventoTrabPJSemSimplificado();
        cadastro.setTpAmb(Byte.parseByte(esocEvento.getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        cadastro.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        cadastro.setVerProc(this.getVersaoEsocialSistema());
        if (esocEvento.getPreEvento().getEventoRetificacao().equals((short)1)) {
            cadastro.setIndRetif(Byte.parseByte("2"));
            cadastro.setNrRecibo(esocEvento.getPreEvento().getNumeroReciboRetificado());
        } else {
            cadastro.setIndRetif(Byte.parseByte("1"));
        }
        return cadastro;
    }

    private ESocial.EvtToxic.IdeVinculo getIdeVinculo(EsocExameToxicologico exame) {
        ESocial.EvtToxic.IdeVinculo vinculo = new ESocial.EvtToxic.IdeVinculo();
        vinculo.setCpfTrab(exame.getColaborador().getPessoa().getComplemento().getCnpj());
        vinculo.setMatricula(exame.getColaborador().getNumeroRegistroESocial());
        return vinculo;
    }

    private ESocial.EvtToxic.Toxicologico getToxicologico(EsocExameToxicologico exame) {
        ESocial.EvtToxic.Toxicologico tox = new ESocial.EvtToxic.Toxicologico();
        tox.setDtExame(ToolEsocial.converteData(exame.getDataExame()));
        tox.setCnpjLab(exame.getPessoaLaboratorio().getComplemento().getCnpj());
        tox.setCodSeqExame(exame.getCodigoExame());
        tox.setNmMed(exame.getEsocCadastroMedicoResponsavel().getPessoa().getNome());
        tox.setNrCRM(exame.getEsocCadastroMedicoResponsavel().getNumeroOrgaoClasse());
        tox.setUfCRM(this.getUf(exame.getEsocCadastroMedicoResponsavel().getUfOrgaoClasse().getSigla()));
        return tox;
    }

    private TSUf getUf(String sigla) {
        return TSUf.fromValue(sigla);
    }
}

