/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evttsvInicio;

import com.touchcomp.basementor.helper.impl.colaborador.HelperColaborador;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorDependente;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvinicio.v_s_01_03_00.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvinicio.v_s_01_03_00.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvinicio.v_s_01_03_00.TContato;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvinicio.v_s_01_03_00.TEnderecoBrasil;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvinicio.v_s_01_03_00.TIdeEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvinicio.v_s_01_03_00.TIdeEventoTrab;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvinicio.v_s_01_03_00.TInfoEstagiario;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvinicio.v_s_01_03_00.TLocalTrabGeral;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvinicio.v_s_01_03_00.TNascimento;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvinicio.v_s_01_03_00.TRemuneracao;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvinicio.v_s_01_03_00.TSSexo;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvinicio.v_s_01_03_00.TSSimNao;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvinicio.v_s_01_03_00.TSUf;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class ImpEvtTSVInicio
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial root = this.getFact().createESocial();
        root.setEvtTSVInicio(this.getEvtTSVInicio(preEvento, opcoes));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtTSVInicio getEvtTSVInicio(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial.EvtTSVInicio evt = this.getFact().createESocialEvtTSVInicio();
        evt.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evt.setIdeEmpregador(this.getIdEmpregador(opcoes));
        evt.setIdeEvento(this.getIdEvento(opcoes, preEvento.getEsocEvento()));
        evt.setTrabalhador(this.getTrabalhador(preEvento));
        evt.setInfoTSVInicio(this.getInfoTSVinculo(preEvento, opcoes));
        return evt;
    }

    private TIdeEmpregador getIdEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TIdeEmpregador tEmpregador = this.getFact().createTIdeEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private TIdeEventoTrab getIdEvento(OpcoesESocial opcoes, EsocEvento esocEvento) {
        TIdeEventoTrab tiTrab = this.getFact().createTIdeEventoTrab();
        tiTrab.setTpAmb(Byte.parseByte(esocEvento.getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        tiTrab.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        tiTrab.setVerProc(this.getVersaoEsocialSistema());
        if (esocEvento.getPreEvento().getEventoRetificacao().equals((short)1)) {
            tiTrab.setIndRetif(Byte.parseByte("2"));
            tiTrab.setNrRecibo(esocEvento.getPreEvento().getNumeroReciboRetificado());
        } else {
            tiTrab.setIndRetif(Byte.parseByte("1"));
        }
        return tiTrab;
    }

    private ESocial.EvtTSVInicio.Trabalhador getTrabalhador(EsocPreEvento preEvento) {
        Colaborador c = preEvento.getColaborador();
        ESocial.EvtTSVInicio.Trabalhador trabalhador = this.getFact().createESocialEvtTSVInicioTrabalhador();
        trabalhador.setCpfTrab(preEvento.getColaborador().getPessoa().getComplemento().getCnpj());
        trabalhador.setNmTrab(ToolString.clearInvalidUTF8Char((String)c.getPessoa().getNome()));
        trabalhador.setSexo(this.getSexo(c.getSexo()));
        trabalhador.setRacaCor(Byte.parseByte(c.getRacaCor().getCodigoEsocial()));
        if (c.getEstadoCivil() != null) {
            trabalhador.setEstCiv(Byte.valueOf(c.getEstadoCivil().getCodigoEsocial()));
        }
        trabalhador.setGrauInstr(c.getGrauInstrucao().getCodigo());
        if (c.getNomeSocialTravesti() != null && c.getNomeSocialTravesti().length() > 0) {
            trabalhador.setNmSoc(c.getNomeSocialTravesti());
        }
        trabalhador.setNascimento(this.getNascimento(c));
        trabalhador.setEndereco(this.getEndereco(c));
        if (c.getTipoDeficiencia() != null) {
            trabalhador.setInfoDeficiencia(this.getInfoDeficiencia(c));
        }
        HelperColaborador helper = new HelperColaborador();
        List deps = helper.build(c).getDependentesSalFamIRRF(new Date());
        for (ColaboradorDependente dep : deps) {
            ESocial.EvtTSVInicio.Trabalhador.Dependente d = this.getFact().createESocialEvtTSVInicioTrabalhadorDependente();
            d.setTpDep(dep.getTipoDependente().getCodigo());
            d.setNmDep(ToolString.clearInvalidUTF8Char((String)dep.getNomeDependente()));
            d.setDtNascto(ToolEsocial.converteData(dep.getDataNascimento()));
            if (ToolMethods.isStrWithData((String)dep.getCpf())) {
                d.setCpfDep(ToolString.refina((String)dep.getCpf()));
            }
            d.setDepSF(this.getSimOrNao(dep.getDependenteSalarioFamilia()));
            d.setDepIRRF(this.getSimOrNao(dep.getDependenteIRRF()));
            d.setIncTrab(this.getSimOrNao(dep.getDependenteIncapacitado()));
            trabalhador.getDependente().add(d);
        }
        if (c.getContato() != null && c.getContato().length() > 0) {
            trabalhador.setContato(this.getContato(c));
        }
        return trabalhador;
    }

    private TSSexo getSexo(Short sexo) {
        if (sexo.equals((short)1)) {
            return TSSexo.F;
        }
        return TSSexo.M;
    }

    private TNascimento getNascimento(Colaborador colaborador) {
        TNascimento nascimento = this.getFact().createTNascimento();
        nascimento.setDtNascto(ToolEsocial.converteData(colaborador.getPessoa().getComplemento().getDataNascimento()));
        if (colaborador.getCidadeNascimento() != null) {
            nascimento.setPaisNac("105");
            nascimento.setPaisNascto("105");
        } else {
            nascimento.setPaisNac(colaborador.getNacionalidade().getCodigoESocial());
            nascimento.setPaisNac(colaborador.getNacionalidade().getCodigoESocial());
        }
        return nascimento;
    }

    private ESocial.EvtTSVInicio.Trabalhador.Endereco getEndereco(Colaborador c) {
        ESocial.EvtTSVInicio.Trabalhador.Endereco endereco = this.getFact().createESocialEvtTSVInicioTrabalhadorEndereco();
        if (c.getNacionalidade().getCodigoESocial().equals("105")) {
            endereco.setBrasil(this.getEnderecoBrasil(c));
        }
        return endereco;
    }

    private TEnderecoBrasil getEnderecoBrasil(Colaborador colaborador) {
        TEnderecoBrasil endereco = this.getFact().createTEnderecoBrasil();
        endereco.setBairro(ToolString.clearInvalidUTF8Char((String)colaborador.getPessoa().getEndereco().getBairro()));
        endereco.setCep(ToolString.clearInvalidUTF8Char((String)colaborador.getPessoa().getEndereco().getCep()));
        endereco.setCodMunic(new BigInteger(colaborador.getPessoa().getEndereco().getCidade().getCodIbgeCompleto()));
        if (colaborador.getPessoa().getEndereco().getComplemento() != null && colaborador.getPessoa().getEndereco().getComplemento().length() > 0) {
            endereco.setComplemento(ToolString.clearInvalidUTF8Char((String)colaborador.getPessoa().getEndereco().getComplemento()));
        }
        endereco.setDscLograd(ToolString.clearInvalidUTF8Char((String)colaborador.getPessoa().getEndereco().getLogradouro()));
        endereco.setNrLograd(colaborador.getPessoa().getEndereco().getNumero());
        endereco.setTpLograd(colaborador.getTipoLogradouroEndereco().getSigla());
        endereco.setUf(TSUf.fromValue(colaborador.getPessoa().getEndereco().getCidade().getUf().getSigla()));
        return endereco;
    }

    private ESocial.EvtTSVInicio.Trabalhador.InfoDeficiencia getInfoDeficiencia(Colaborador colaborador) {
        ESocial.EvtTSVInicio.Trabalhador.InfoDeficiencia infoDeficiencia = this.getFact().createESocialEvtTSVInicioTrabalhadorInfoDeficiencia();
        if (colaborador.getTipoDeficiencia().getCodigo().equals("2")) {
            infoDeficiencia.setDefAuditiva(TSSimNao.S);
            infoDeficiencia.setDefFisica(TSSimNao.N);
            infoDeficiencia.setDefIntelectual(TSSimNao.N);
            infoDeficiencia.setDefMental(TSSimNao.N);
            infoDeficiencia.setDefVisual(TSSimNao.N);
            infoDeficiencia.setReabReadap(TSSimNao.N);
        } else if (colaborador.getTipoDeficiencia().getCodigo().equals("1")) {
            infoDeficiencia.setDefAuditiva(TSSimNao.N);
            infoDeficiencia.setDefFisica(TSSimNao.S);
            infoDeficiencia.setDefIntelectual(TSSimNao.N);
            infoDeficiencia.setDefMental(TSSimNao.N);
            infoDeficiencia.setDefVisual(TSSimNao.N);
            infoDeficiencia.setReabReadap(TSSimNao.N);
        } else if (colaborador.getTipoDeficiencia().getCodigo().equals("7")) {
            infoDeficiencia.setDefAuditiva(TSSimNao.N);
            infoDeficiencia.setDefFisica(TSSimNao.N);
            infoDeficiencia.setDefIntelectual(TSSimNao.S);
            infoDeficiencia.setDefMental(TSSimNao.N);
            infoDeficiencia.setDefVisual(TSSimNao.N);
            infoDeficiencia.setReabReadap(TSSimNao.N);
        } else if (colaborador.getTipoDeficiencia().getCodigo().equals("4")) {
            infoDeficiencia.setDefAuditiva(TSSimNao.N);
            infoDeficiencia.setDefFisica(TSSimNao.N);
            infoDeficiencia.setDefIntelectual(TSSimNao.N);
            infoDeficiencia.setDefMental(TSSimNao.S);
            infoDeficiencia.setDefVisual(TSSimNao.N);
            infoDeficiencia.setReabReadap(TSSimNao.N);
        } else if (colaborador.getTipoDeficiencia().getCodigo().equals("6")) {
            infoDeficiencia.setDefAuditiva(TSSimNao.N);
            infoDeficiencia.setDefFisica(TSSimNao.N);
            infoDeficiencia.setDefIntelectual(TSSimNao.N);
            infoDeficiencia.setDefMental(TSSimNao.N);
            infoDeficiencia.setDefVisual(TSSimNao.N);
            infoDeficiencia.setReabReadap(TSSimNao.S);
        } else if (colaborador.getTipoDeficiencia().getCodigo().equals("3")) {
            infoDeficiencia.setDefAuditiva(TSSimNao.N);
            infoDeficiencia.setDefFisica(TSSimNao.N);
            infoDeficiencia.setDefIntelectual(TSSimNao.N);
            infoDeficiencia.setDefMental(TSSimNao.N);
            infoDeficiencia.setDefVisual(TSSimNao.S);
            infoDeficiencia.setReabReadap(TSSimNao.N);
        }
        return infoDeficiencia;
    }

    private TSSimNao getSimOrNao(Short campo) {
        if (campo.equals((short)1)) {
            return TSSimNao.S;
        }
        return TSSimNao.N;
    }

    private TContato getContato(Colaborador colaborador) {
        TContato contato = this.getFact().createTContato();
        if (colaborador.getFoneFixo() != null && colaborador.getFoneFixo().length() > 0) {
            contato.setFonePrinc(ToolString.refina((String)colaborador.getFoneFixo()));
        }
        if (colaborador.getEmailPessoal() != null && colaborador.getEmailPessoal().length() > 0) {
            contato.setEmailPrinc(colaborador.getEmailPessoal());
        }
        return contato;
    }

    private Date getInicioObrigatoriedadeProducao(OpcoesESocial opcoes) {
        return opcoes.getDataSegundaFase();
    }

    private Date getInicioObrigatoriedadeProducaoRestrita() {
        GregorianCalendar g = new GregorianCalendar();
        g.set(6, 1);
        g.set(2, 0);
        g.set(1, 2017);
        return g.getTime();
    }

    private ESocial.EvtTSVInicio.InfoTSVInicio getInfoTSVinculo(EsocPreEvento preEvento, OpcoesESocial opcoes) {
        Date inicioObrigatoriedadeProducao = this.getInicioObrigatoriedadeProducao(opcoes);
        Date inicioObrigatoriedadeProducaoRestrita = this.getInicioObrigatoriedadeProducaoRestrita();
        ESocial.EvtTSVInicio.InfoTSVInicio infoInicio = this.getFact().createESocialEvtTSVInicioInfoTSVInicio();
        if (preEvento.getEsocEvento().getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo().equals("1")) {
            if (preEvento.getColaborador().getDataAdmissao().before(inicioObrigatoriedadeProducao)) {
                infoInicio.setCadIni("S");
            } else {
                infoInicio.setCadIni("N");
            }
        } else if (preEvento.getColaborador().getDataAdmissao().before(inicioObrigatoriedadeProducaoRestrita)) {
            infoInicio.setCadIni("S");
        } else {
            infoInicio.setCadIni("N");
        }
        infoInicio.setCodCateg(new BigInteger(preEvento.getColaborador().getEsocCategoriaTrabalhador().getCodigo()));
        infoInicio.setMatricula(preEvento.getColaborador().getNumeroRegistro());
        infoInicio.setDtInicio(ToolEsocial.converteData(preEvento.getColaborador().getDataAdmissao()));
        if (preEvento.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("202")) {
            infoInicio.setNatAtividade(Byte.valueOf(preEvento.getColaborador().getNaturezaAtividade().getCodigo()));
        }
        infoInicio.setInfoComplementares(this.getInfoComplementares(preEvento));
        return infoInicio;
    }

    private Date getInicioObrigatoriedade() {
        GregorianCalendar g = new GregorianCalendar();
        g.set(7, 1);
        g.set(2, 9);
        g.set(1, 2018);
        return g.getTime();
    }

    private ESocial.EvtTSVInicio.InfoTSVInicio.InfoComplementares getInfoComplementares(EsocPreEvento preEvento) {
        ESocial.EvtTSVInicio.InfoTSVInicio.InfoComplementares infoC = this.getFact().createESocialEvtTSVInicioInfoTSVInicioInfoComplementares();
        if (preEvento.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("202") || preEvento.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("722") || preEvento.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("723") || preEvento.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("712") || preEvento.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("701") || preEvento.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("741") || preEvento.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("721")) {
            infoC.setCargoFuncao(this.getCargoFuncao(preEvento.getColaborador()));
        }
        if (preEvento.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("722") || preEvento.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("721")) {
            infoC.setRemuneracao(this.getRemuneracao(preEvento));
        }
        if (preEvento.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("901")) {
            infoC.setInfoEstagiario(this.getInfoEstagiario(preEvento.getColaborador()));
        }
        if (preEvento.getColaborador().getLocalTrabalhoColaboradorCidade() != null) {
            infoC.setLocalTrabGeral(this.getTrabGeral(preEvento.getColaborador()));
        }
        return infoC;
    }

    private ESocial.EvtTSVInicio.InfoTSVInicio.InfoComplementares.CargoFuncao getCargoFuncao(Colaborador colaborador) {
        ESocial.EvtTSVInicio.InfoTSVInicio.InfoComplementares.CargoFuncao cargoFuncao = this.getFact().createESocialEvtTSVInicioInfoTSVInicioInfoComplementaresCargoFuncao();
        cargoFuncao.setCBOCargo(ToolString.refina((String)colaborador.getFuncao().getCbo().getCodigo()));
        cargoFuncao.setNmCargo(colaborador.getFuncao().getDescricao());
        return cargoFuncao;
    }

    private TRemuneracao getRemuneracao(EsocPreEvento preEvento) {
        Colaborador colaborador = preEvento.getColaborador();
        TRemuneracao r = this.getFact().createTRemuneracao();
        r.setUndSalFixo(Byte.parseByte(colaborador.getTipoSalario().getCodigoEsocial()));
        if (colaborador.getTipoSalario().getCodigoEsocial().equals("7")) {
            r.setDscSalVar(colaborador.getDescricaoSalario());
            r.setVrSalFx(new BigDecimal(0));
        } else {
            Double valorSalario = preEvento.getSalarioColaborador();
            r.setVrSalFx(new BigDecimal(valorSalario));
        }
        return r;
    }

    private TInfoEstagiario getInfoEstagiario(Colaborador colaborador) {
        TInfoEstagiario estagio = this.getFact().createTInfoEstagiario();
        if (colaborador.getNaturezaEstagio().equals((short)1)) {
            estagio.setNatEstagio("O");
        } else {
            estagio.setNatEstagio("N");
        }
        estagio.setNivEstagio(Byte.valueOf(colaborador.getNivelEstagio().getCodigo()));
        if (colaborador.getAreaAtuacaoEstagio() != null && colaborador.getAreaAtuacaoEstagio().length() > 0) {
            estagio.setAreaAtuacao(colaborador.getAreaAtuacaoEstagio());
        }
        if (colaborador.getNrApoliceSeguroEstagio() != null && colaborador.getNrApoliceSeguroEstagio().length() > 0) {
            estagio.setNrApol(colaborador.getNrApoliceSeguroEstagio());
        }
        estagio.setDtPrevTerm(ToolEsocial.converteData(colaborador.getDataTerminoEstagio()));
        estagio.setInstEnsino(this.getInstEnsino(colaborador));
        if (colaborador.getAgenteEstagio() != null) {
            estagio.setAgeIntegracao(this.getAgenteIntegracao(colaborador));
        }
        if (colaborador.getNomeSupervisorEstagio() != null && colaborador.getNomeSupervisorEstagio().length() > 0) {
            estagio.setSupervisorEstagio(this.getSupervisorEstagio(colaborador));
        }
        return estagio;
    }

    private TInfoEstagiario.InstEnsino getInstEnsino(Colaborador colaborador) {
        TInfoEstagiario.InstEnsino inst = this.getFact().createTInfoEstagiarioInstEnsino();
        inst.setCnpjInstEnsino(ToolString.clearInvalidUTF8Char((String)colaborador.getInstituicaoEnsinoEstagio().getPessoa().getComplemento().getCnpj()));
        if (colaborador.getInstituicaoEnsinoEstagio().getPessoa().getComplemento().getCnpj() == null || colaborador.getInstituicaoEnsinoEstagio().getPessoa().getComplemento().getCnpj().isEmpty()) {
            inst.setNmRazao(ToolString.clearInvalidUTF8Char((String)colaborador.getInstituicaoEnsinoEstagio().getPessoa().getNome()));
            inst.setDscLograd(ToolString.clearInvalidUTF8Char((String)colaborador.getInstituicaoEnsinoEstagio().getPessoa().getEndereco().getLogradouro()));
            inst.setNrLograd(ToolString.clearInvalidUTF8Char((String)colaborador.getInstituicaoEnsinoEstagio().getPessoa().getEndereco().getNumero()));
            inst.setBairro(ToolString.clearInvalidUTF8Char((String)colaborador.getInstituicaoEnsinoEstagio().getPessoa().getEndereco().getBairro()));
            inst.setCep(ToolString.clearInvalidUTF8Char((String)colaborador.getInstituicaoEnsinoEstagio().getPessoa().getEndereco().getCep()));
            inst.setCodMunic(new BigInteger(colaborador.getInstituicaoEnsinoEstagio().getPessoa().getEndereco().getCidade().getCodIbgeCompleto()));
            inst.setUf(TSUf.fromValue(colaborador.getInstituicaoEnsinoEstagio().getPessoa().getEndereco().getCidade().getUf().getSigla()));
        }
        return inst;
    }

    private TInfoEstagiario.AgeIntegracao getAgenteIntegracao(Colaborador colaborador) {
        Pessoa pessoa = colaborador.getAgenteEstagio();
        TInfoEstagiario.AgeIntegracao agente = this.getFact().createTInfoEstagiarioAgeIntegracao();
        agente.setCnpjAgntInteg(pessoa.getComplemento().getCnpj());
        return agente;
    }

    private TInfoEstagiario.SupervisorEstagio getSupervisorEstagio(Colaborador colaborador) {
        TInfoEstagiario.SupervisorEstagio sup = this.getFact().createTInfoEstagiarioSupervisorEstagio();
        sup.setCpfSupervisor(colaborador.getCpfSupervisorEstagio());
        return sup;
    }

    private TLocalTrabGeral getTrabGeral(Colaborador colaborador) {
        TLocalTrabGeral l = this.getFact().createTLocalTrabGeral();
        l.setTpInsc(Byte.parseByte("1"));
        l.setNrInsc(ToolString.refina((String)colaborador.getEmpresa().getPessoa().getComplemento().getCnpj()));
        return l;
    }
}

