/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evttsvtermino;

import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.ItemTerminoTrabalhadorSemVinculo;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.TerminoTrabalhadorSemVinculo;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvtermino.v_s_01_03_00.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvtermino.v_s_01_03_00.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvtermino.v_s_01_03_00.TIdeEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvtermino.v_s_01_03_00.TIdeEventoTrabIndGuia;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvtermino.v_s_01_03_00.TIdeTrabSemVinculo;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvtermino.v_s_01_03_00.TInfoSimples;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.math.BigInteger;

public class ImpEvtEvtTSVTermino
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial root = this.getFact().createESocial();
        root.setEvtTSVTermino(this.getEvtTerminoTSV(preEvento, opcoes));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtTSVTermino getEvtTerminoTSV(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial.EvtTSVTermino termino = this.getFact().createESocialEvtTSVTermino();
        termino.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        termino.setIdeEmpregador(this.getIdeEmpregado(opcoes));
        termino.setIdeEvento(this.getIdEvento(opcoes, preEvento.getEsocEvento()));
        termino.setIdeTrabSemVinculo(this.getIdeTrabSemVinculo(preEvento));
        termino.setInfoTSVTermino(this.getInfoTermino(preEvento, opcoes));
        return termino;
    }

    private TIdeEmpregador getIdeEmpregado(OpcoesESocial opcoes) throws ExceptionEsocial {
        TIdeEmpregador tEmpregador = this.getFact().createTIdeEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private TIdeEventoTrabIndGuia getIdEvento(OpcoesESocial opcoes, EsocEvento esocEvento) {
        TIdeEventoTrabIndGuia tiTrab = this.getFact().createTIdeEventoTrabIndGuia();
        tiTrab.setTpAmb(Byte.parseByte(esocEvento.getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        tiTrab.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        tiTrab.setVerProc(this.getVersaoEsocialSistema());
        if (esocEvento.getPreEvento().getEventoRetificacao().equals((short)1)) {
            tiTrab.setIndRetif(Byte.parseByte("2"));
            tiTrab.setNrRecibo(esocEvento.getPreEvento().getNumeroReciboRetificado());
        } else {
            tiTrab.setIndRetif(Byte.parseByte("1"));
        }
        return tiTrab;
    }

    private TIdeTrabSemVinculo getIdeTrabSemVinculo(EsocPreEvento preEvento) {
        TerminoTrabalhadorSemVinculo termino = preEvento.getTerminoTsv();
        TIdeTrabSemVinculo ideVinculo = this.getFact().createTIdeTrabSemVinculo();
        ideVinculo.setCpfTrab(ToolString.refina((String)termino.getColaborador().getPessoa().getComplemento().getCnpj()));
        if (termino.getColaborador().getNumeroRegistroESocial() != null && termino.getColaborador().getNumeroRegistroESocial().length() > 0) {
            ideVinculo.setMatricula(termino.getColaborador().getNumeroRegistroESocial());
        } else {
            ideVinculo.setCodCateg(new BigInteger(termino.getColaborador().getEsocCategoriaTrabalhador().getCodigo()));
        }
        return ideVinculo;
    }

    private ESocial.EvtTSVTermino.InfoTSVTermino getInfoTermino(EsocPreEvento preEvento, OpcoesESocial opcoes) {
        TerminoTrabalhadorSemVinculo termino = preEvento.getTerminoTsv();
        ESocial.EvtTSVTermino.InfoTSVTermino info = this.getFact().createESocialEvtTSVTerminoInfoTSVTermino();
        info.setDtTerm(ToolEsocial.converteData(termino.getDataTermino()));
        if (termino.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("721")) {
            info.setMtvDesligTSV(termino.getEsocMotivoDesligamento().getCodigo());
        }
        if (!termino.getItensTerminoTsv().isEmpty() && termino.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("721")) {
            info.setVerbasResc(this.getVerbasRescisorias(termino, opcoes));
        }
        return info;
    }

    private ESocial.EvtTSVTermino.InfoTSVTermino.VerbasResc getVerbasRescisorias(TerminoTrabalhadorSemVinculo termino, OpcoesESocial opcoes) {
        ESocial.EvtTSVTermino.InfoTSVTermino.VerbasResc verba = this.getFact().createESocialEvtTSVTerminoInfoTSVTerminoVerbasResc();
        verba.getDmDev().add(this.getDmDev(termino, opcoes));
        return verba;
    }

    private ESocial.EvtTSVTermino.InfoTSVTermino.VerbasResc.DmDev getDmDev(TerminoTrabalhadorSemVinculo termino, OpcoesESocial opcoes) {
        ESocial.EvtTSVTermino.InfoTSVTermino.VerbasResc.DmDev dmDev = this.getFact().createESocialEvtTSVTerminoInfoTSVTerminoVerbasRescDmDev();
        dmDev.setIdeDmDev(termino.getIdentificador().toString());
        dmDev.getIdeEstabLot().add(this.getEstabelecimento(termino, opcoes));
        return dmDev;
    }

    private ESocial.EvtTSVTermino.InfoTSVTermino.VerbasResc.DmDev.IdeEstabLot getEstabelecimento(TerminoTrabalhadorSemVinculo termino, OpcoesESocial opcoes) {
        ESocial.EvtTSVTermino.InfoTSVTermino.VerbasResc.DmDev.IdeEstabLot ide = this.getFact().createESocialEvtTSVTerminoInfoTSVTerminoVerbasRescDmDevIdeEstabLot();
        ide.setCodLotacao(termino.getColaborador().getLotacaoTributaria().getCodigo());
        ide.setTpInsc(Byte.parseByte("1"));
        ide.setNrInsc(termino.getColaborador().getEstabelecimento().getEmpresa().getPessoa().getComplemento().getCnpj());
        if (opcoes.getClassificacaoTributaria().getCodigo().equals("01") || opcoes.getClassificacaoTributaria().getCodigo().equals("02") || opcoes.getClassificacaoTributaria().getCodigo().equals("03")) {
            ide.setInfoSimples(this.getInfoSimples(opcoes.getClassificacaoTributaria().getCodigo()));
        }
        for (ItemTerminoTrabalhadorSemVinculo item : termino.getItensTerminoTsv()) {
            ide.getDetVerbas().add(this.getDetVerbas(item));
        }
        return ide;
    }

    private TInfoSimples getInfoSimples(String codigo) {
        TInfoSimples info = this.getFact().createTInfoSimples();
        info.setIndSimples(Byte.parseByte(codigo));
        return info;
    }

    private ESocial.EvtTSVTermino.InfoTSVTermino.VerbasResc.DmDev.IdeEstabLot.DetVerbas getDetVerbas(ItemTerminoTrabalhadorSemVinculo item) {
        ESocial.EvtTSVTermino.InfoTSVTermino.VerbasResc.DmDev.IdeEstabLot.DetVerbas det = this.getFact().createESocialEvtTSVTerminoInfoTSVTerminoVerbasRescDmDevIdeEstabLotDetVerbas();
        if (item.getEventoColaborador().getTipoCalculoEvento().getEvento().getInformarCodigoEsocial().equals((short)0)) {
            det.setCodRubr(item.getEventoColaborador().getTipoCalculoEvento().getEvento().getCodigo().toString());
            det.setIdeTabRubr(item.getEventoColaborador().getTipoCalculoEvento().getEvento().getIdentificador().toString());
        } else {
            det.setCodRubr(item.getEventoColaborador().getTipoCalculoEvento().getEvento().getCodigoEsocial());
            det.setIdeTabRubr(item.getEventoColaborador().getTipoCalculoEvento().getEvento().getIdeTabelaRubrica());
        }
        if (item.getReferencia() > 0.0) {
            det.setQtdRubr(ToolFormatter.arrredondarNumeroBigDecimal((Double)item.getReferencia(), (int)2));
        }
        det.setVrRubr(ToolFormatter.arrredondarNumeroBigDecimal((Double)item.getValor(), (int)2));
        det.setIndApurIR(Byte.valueOf("0"));
        return det;
    }
}

