/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.nfe.impl.consultanota;

import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.nota.consulta.NFNotaConsultaRetorno;
import com.fincatto.documentofiscal.nfe400.webservices.WSFacade;
import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.constants.enums.uf.EnumConstUF;
import com.touchcomp.basementor.model.vo.NFCe;
import com.touchcomp.basementorclientwebservices.certificado.ConfigCertificateNFCe;
import com.touchcomp.basementorclientwebservices.certificado.ConfigCertificateNFe;
import com.touchcomp.basementorclientwebservices.nfe.model.env.consultanota.ConsultaNFeRet;
import com.touchcomp.basementorclientwebservices.nfe.model.env.consultanota.NFEventoInfoRet;
import com.touchcomp.basementorclientwebservices.nfe.model.env.consultanota.NFeConsultaNota;
import com.touchcomp.basementorclientwebservices.nfe.model.env.consultanota.NFeProtocolo;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorxml.model.XMLNFCe;
import com.touchcomp.basementorxml.service.impl.xmlnfce.ServiceXMLNFCeImpl;

public class UtilNfeSendWebServices {
    public static ConsultaNFeRet consultarNFCe(ConfigCertificateNFCe config, NFeConsultaNota dados) throws Exception {
        return UtilNfeSendWebServices.consultarNota(config, dados);
    }

    public static ConsultaNFeRet consultarNFe(ConfigCertificateNFe config, NFeConsultaNota dados) throws Exception {
        return UtilNfeSendWebServices.consultarNota(config, dados);
    }

    public static ConsultaNFeRet consultarNota(NFeConfig config, NFeConsultaNota dados) throws Exception {
        NFNotaConsultaRetorno retorno = new WSFacade(config).consultaNota(dados.getChaveNFe());
        if (EnumConstNFeStatus.getByCodigo((String)retorno.getStatus()) == EnumConstNFeStatus.REJ_FALHA_SCHEMA_XML) {
            throw new Exception("Houve falha ao consultar o status da NFe: " + retorno.getMotivo());
        }
        ConsultaNFeRet ret = new ConsultaNFeRet();
        ret.setAmbiente(ConstAmbiente.valueOfCodigo((String)retorno.getAmbiente().getCodigo()));
        ret.setChave(retorno.getChave());
        ret.setDataHoraRecibo(retorno.getDataHoraRecibo());
        ret.setMotivo(retorno.getMotivo());
        if (retorno.getProtocolo() != null) {
            ret.setProtocolo(new NFeProtocolo());
            ret.getProtocolo().setAmbiente(ConstAmbiente.valueOfCodigo((String)retorno.getProtocolo().getProtocoloInfo().getAmbiente().getCodigo()));
            ret.getProtocolo().setChave(retorno.getProtocolo().getProtocoloInfo().getChave());
            ret.getProtocolo().setDataRecebimento(retorno.getProtocolo().getProtocoloInfo().getDataRecebimento());
            ret.getProtocolo().setIdentificador(retorno.getProtocolo().getProtocoloInfo().getIdentificador());
            ret.getProtocolo().setMotivo(retorno.getProtocolo().getProtocoloInfo().getMotivo());
            ret.getProtocolo().setNumeroProtocolo(retorno.getProtocolo().getProtocoloInfo().getNumeroProtocolo());
            ret.getProtocolo().setStatus(retorno.getProtocolo().getProtocoloInfo().getStatus());
            ret.getProtocolo().setValidador(retorno.getProtocolo().getProtocoloInfo().getValidador());
            ret.getProtocolo().setVersao(retorno.getProtocolo().getVersao());
            ret.getProtocolo().setVersaoAplicacao(retorno.getProtocolo().getProtocoloInfo().getVersaoAplicacao());
            ret.getProtocolo().setXml(retorno.getProtocolo().toString());
        }
        if (retorno.getProtocoloCancelamento() != null) {
            ret.setProtocoloCancelamento(new NFeProtocolo());
            ret.getProtocoloCancelamento().setAmbiente(ConstAmbiente.valueOfCodigo((String)retorno.getProtocoloCancelamento().getInfoCancelamento().getAmbiente().getCodigo()));
            ret.getProtocoloCancelamento().setChave(retorno.getProtocoloCancelamento().getInfoCancelamento().getChave());
            ret.getProtocoloCancelamento().setDataRecebimento(retorno.getProtocoloCancelamento().getInfoCancelamento().getDatahoraRecebimento());
            ret.getProtocoloCancelamento().setIdentificador(retorno.getProtocoloCancelamento().getInfoCancelamento().getIdentificador());
            ret.getProtocoloCancelamento().setMotivo(retorno.getProtocoloCancelamento().getInfoCancelamento().getMotivo());
            ret.getProtocoloCancelamento().setNumeroProtocolo(retorno.getProtocoloCancelamento().getInfoCancelamento().getNumeroProtocolo());
            ret.getProtocoloCancelamento().setStatus(retorno.getProtocoloCancelamento().getInfoCancelamento().getCodigoStatus());
            ret.getProtocoloCancelamento().setVersao(retorno.getProtocoloCancelamento().getVersao());
            ret.getProtocoloCancelamento().setVersaoAplicacao(retorno.getProtocoloCancelamento().getInfoCancelamento().getVersaoAplicacao());
            ret.getProtocoloCancelamento().setXml(retorno.getProtocolo().toString());
        }
        ret.setUf(EnumConstUF.get((Object)retorno.getUf().getCodigo()));
        ret.setStatus(retorno.getStatus());
        ret.setVersao(retorno.getVersao());
        ret.setVersaoAplicacao(retorno.getVersaoAplicacao());
        if (retorno.getProtocoloEvento() != null) {
            retorno.getProtocoloEvento().forEach(i -> {
                NFEventoInfoRet prot = new NFEventoInfoRet();
                if (i.getEvento() != null) {
                    prot.setEvento(new NFEventoInfoRet.NFeEvento());
                    prot.getEvento().setAmbiente(ConstAmbiente.valueOfCodigo((String)i.getEvento().getInfoEvento().getAmbiente().getCodigo()));
                    prot.getEvento().setChave(i.getEvento().getInfoEvento().getChave());
                    prot.getEvento().setCnpj(i.getEvento().getInfoEvento().getCnpj());
                    prot.getEvento().setCodigoEvento(i.getEvento().getInfoEvento().getCodigoEvento());
                    prot.getEvento().setCpf(i.getEvento().getInfoEvento().getCpf());
                    prot.getEvento().setDataHoraEvento(i.getEvento().getInfoEvento().getDataHoraEvento());
                    prot.getEvento().setId(i.getEvento().getInfoEvento().getId());
                    prot.getEvento().setNumeroSequencialEvento(i.getEvento().getInfoEvento().getNumeroSequencialEvento());
                    prot.getEvento().setOrgao(EnumConstUF.valueOfCodigoIbge((String)i.getEvento().getInfoEvento().getOrgao().getCodigoIbge()));
                    prot.getEvento().setVersao(i.getEvento().getVersao());
                    prot.getEvento().setVersaoEvento(i.getEvento().getInfoEvento().getVersaoEvento());
                }
                if (i.getInfoEventoRetorno() != null) {
                    prot.setEventoRetorno(new NFEventoInfoRet.NFEventoRet());
                    prot.getEventoRetorno().setAmbiente(ConstAmbiente.valueOfCodigo((String)i.getInfoEventoRetorno().getInfoEventoRetorno().getAmbiente().getCodigo()));
                    prot.getEventoRetorno().setChave(i.getInfoEventoRetorno().getInfoEventoRetorno().getChave());
                    prot.getEventoRetorno().setCodigoStatus(i.getInfoEventoRetorno().getInfoEventoRetorno().getCodigoStatus());
                    prot.getEventoRetorno().setCpf(i.getInfoEventoRetorno().getInfoEventoRetorno().getCpf());
                    prot.getEventoRetorno().setCpnj(i.getInfoEventoRetorno().getInfoEventoRetorno().getCnpj());
                    prot.getEventoRetorno().setDataHoraRegistro(i.getInfoEventoRetorno().getInfoEventoRetorno().getDataHoraRegistro().toLocalDate().atStartOfDay());
                    prot.getEventoRetorno().setDescricaoEvento(i.getInfoEventoRetorno().getInfoEventoRetorno().getDescricaoEvento());
                    prot.getEventoRetorno().setEmail(i.getInfoEventoRetorno().getInfoEventoRetorno().getEmail());
                    prot.getEventoRetorno().setId(i.getInfoEventoRetorno().getInfoEventoRetorno().getId());
                    prot.getEventoRetorno().setMotivo(i.getInfoEventoRetorno().getInfoEventoRetorno().getMotivo());
                    prot.getEventoRetorno().setNumeroProtocolo(i.getInfoEventoRetorno().getInfoEventoRetorno().getNumeroProtocolo());
                    prot.getEventoRetorno().setNumeroSequencialEvento(i.getInfoEventoRetorno().getInfoEventoRetorno().getNumeroSequencialEvento());
                    prot.getEventoRetorno().setOrgao(EnumConstUF.valueOfCodigoIbge((String)i.getInfoEventoRetorno().getInfoEventoRetorno().getOrgao().getCodigoIbge()));
                    prot.getEventoRetorno().setTipoEvento(i.getInfoEventoRetorno().getInfoEventoRetorno().getTipoEvento());
                    prot.getEventoRetorno().setVersaoAplicativo(i.getInfoEventoRetorno().getInfoEventoRetorno().getVersaoAplicativo());
                }
                prot.setVersao(i.getVersao());
                ret.getProtocoloEvento().add(prot);
            });
        }
        return ret;
    }

    public static void atualizarXML(NFeConfig config, NFCe nfce) throws Exception {
        XMLNFCe x;
        StringBuilder sb;
        NFNotaConsultaRetorno retorno = new WSFacade(config).consultaNota(nfce.getChaveNFCe());
        if (EnumConstNFeStatus.getByCodigo((String)retorno.getStatus()) == EnumConstNFeStatus.REJ_FALHA_SCHEMA_XML) {
            throw new Exception("Houve falha ao consultar o status da NFe: " + retorno.getMotivo());
        }
        ServiceXMLNFCeImpl serviceXMLNFCeImpl = (ServiceXMLNFCeImpl)ConfApplicationContext.getBean(ServiceXMLNFCeImpl.class);
        if (retorno.getProtocolo() != null) {
            sb = new StringBuilder();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
            sb.append(retorno.getProtocolo().toString());
            x = serviceXMLNFCeImpl.getOrCreateXMLNFCe(nfce.getIdentificador());
            x.setIdNFCe(nfce.getIdentificador());
            x.setConteudoAprovacao(sb.toString());
            serviceXMLNFCeImpl.saveOrUpdate((Object)x);
        }
        if (retorno.getProtocoloCancelamento() != null) {
            sb = new StringBuilder();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
            sb.append(retorno.getProtocoloCancelamento().toString());
            x = serviceXMLNFCeImpl.getOrCreateXMLNFCe(nfce.getIdentificador());
            x.setIdNFCe(nfce.getIdentificador());
            x.setConteudoCancelamento(sb.toString());
            serviceXMLNFCeImpl.saveOrUpdate((Object)x);
        }
    }
}

