/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.nfe.impl.distribuicaonfe;

import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe.classes.distribuicao.NFDistribuicaoIntRetorno;
import com.fincatto.documentofiscal.nfe400.webservices.WSFacade;
import com.touchcomp.basementorclientwebservices.certificado.CertificadoConfClienteWebservice;
import com.touchcomp.basementorclientwebservices.certificado.CertificadoConfigNFeCTe;
import com.touchcomp.basementorclientwebservices.certificado.model.ParamsCertificado;
import com.touchcomp.basementorclientwebservices.nfe.model.env.distdocxmlnfe.ParamsDistribDocXMLNFe;
import com.touchcomp.basementortools.tools.exception.ToolException;
import com.touchcomp.basementortools.tools.logcronoanalise.ToolLogCronoAnalise;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import org.springframework.stereotype.Component;

@Component
public class WebDistribuicaoDocXMLNFe {
    public NFDistribuicaoIntRetorno consultarDistribuicaoXML(ParamsCertificado paramsCertificado, ParamsDistribDocXMLNFe paramsDist) throws Exception {
        NFDistribuicaoIntRetorno ret;
        CertificadoConfigNFeCTe nfc = new CertificadoConfigNFeCTe(this, paramsCertificado, paramsDist.getCodIbgeUF()){

            public int getSoTimeoutEmMillis() {
                return 120000;
            }

            public int getTimeoutRequisicaoEmMillis() {
                return 120000;
            }
        };
        String cpfCnpj = ToolMethods.isStrWithData((String)paramsDist.getCpf()) ? paramsDist.getCpf() : paramsDist.getCnpj();
        String chaveAcesso = paramsDist.getChaveAcesso() == null ? "" : paramsDist.getChaveAcesso();
        String ultNSU = paramsDist.getUltimoNSU();
        String nsuEspecifico = paramsDist.getNsuEpecifico();
        if (TMethods.isStrWithData((String)nsuEspecifico) && Long.parseLong(nsuEspecifico) > 0L) {
            nsuEspecifico = ToolString.completaZeros((String)nsuEspecifico, (int)15, (boolean)true);
            ultNSU = null;
        } else {
            ultNSU = ToolString.completaZeros((String)ultNSU, (int)15, (boolean)true);
            nsuEspecifico = null;
        }
        new CertificadoConfClienteWebservice().configuraSocketFactoryDinamico(paramsCertificado.getKeystoreCertificado(), paramsCertificado.getSenhaCertificado());
        ToolLogCronoAnalise.addTask((String)("NSU especifico " + nsuEspecifico + ", ultimo NSU " + ultNSU + ", chave: " + chaveAcesso));
        try {
            ret = new WSFacade((NFeConfig)nfc).consultarDistribuicaoDFe(cpfCnpj, DFUnidadeFederativa.valueOfCodigo((String)paramsDist.getCodIbgeUF()), chaveAcesso, nsuEspecifico, ultNSU);
        }
        catch (Exception e) {
            if (ToolException.findMessage((Throwable)e, (String)"Unabletosatisfy@org.simpleframework.xml.Attribute(name=NSU", (boolean)true).booleanValue()) {
                ret = new NFDistribuicaoIntRetorno();
                ret.setCodigoStatusReposta("999");
                ret.setMotivo("XML ainda nao liberado para Download. tente mais tarde.");
            }
            throw e;
        }
        ToolLogCronoAnalise.addTask((String)("Retorno " + nsuEspecifico + ", ultimo NSU " + ultNSU + ", chave: " + chaveAcesso));
        return ret;
    }
}

