/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.nfe.nfe;

import com.fincatto.documentofiscal.nfe400.classes.NFEndereco;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFInfoCupomFiscalReferenciado;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFInfoModelo1Por1AReferenciada;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFInfoProdutorRuralReferenciada;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFInfoReferenciada;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNota;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfo;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoAvulsa;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoCartao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoCobranca;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoCompra;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoDestinatario;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoEmitente;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoExportacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoFatura;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoFormaPagamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoICMSTotal;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoISSQNTotal;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoIdentificacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoInformacoesAdicionais;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoLacre;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoLocal;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoObservacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoPagamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoParcela;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoProcessoReferenciado;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoReboque;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoResponsavelTecnico;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoRetencaoICMSTransporte;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoRetencoesTributos;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoSuplementar;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoTotal;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoTransportador;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoTransporte;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoVeiculo;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoVolume;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaProcessada;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFPessoaAutorizadaDownloadNFe;
import com.fincatto.documentofiscal.utils.DFPersister;
import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementor.constants.enums.modelodocfiscal.EnumConstModDocFiscal;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeFinalidade;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeIdentificacaoLocalDestOperacao;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeIndicadorFormaPag;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeIndicadorIEDest;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeIndicadorPresenca;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeInfoRegimeEspTributacao;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeIntermediadorComerical;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeMeioPagamento;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeModalidadeFrete;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeOperacaoConsumidorFinal;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeOperadoraCartao;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeOrigemProcesso;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeProgramaEmissor;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeTipoEmissao;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeTipoEntSai;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeTipoImpressao;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeTipoIntegracaoPagamento;
import com.touchcomp.basementorclientwebservices.UtilMethods;
import com.touchcomp.basementorclientwebservices.nfe.model.env.nfe.NFeNotaFiscalPropria;
import com.touchcomp.basementorclientwebservices.nfe.nfe.WebNFeItem;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.LinkedList;
import java.util.List;

public class WebNFe {
    WebNFeItem webNFeItem = new WebNFeItem();

    public NFeNotaFiscalPropria readXMLNFe(String xmlNota) throws Exception {
        try {
            NFNota nota = (NFNota)new DFPersister().read(NFNota.class, xmlNota, false);
            return this.convertNota(nota);
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw ex;
        }
    }

    public NFeNotaFiscalPropria readXMLNFeProc(String xmlNota) throws Exception {
        try {
            NFNotaProcessada nota = (NFNotaProcessada)new DFPersister().read(NFNotaProcessada.class, xmlNota, false);
            return this.convertNota(nota.getNota());
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw ex;
        }
    }

    public NFeNotaFiscalPropria convertNota(NFNota nota) {
        if (nota == null || nota.getInfo() == null) {
            return null;
        }
        NFNotaInfo info = nota.getInfo();
        NFeNotaFiscalPropria nf = new NFeNotaFiscalPropria();
        nf.setChaveNFe(info.getChaveAcesso());
        nf.setEmitente(this.getEmitente(info.getEmitente()));
        nf.setEnderecoEntrega(this.getEnderecoEntrega(info.getEntrega()));
        nf.setIdentificacao(this.getIdentificacao(info.getIdentificacao()));
        nf.setIdentificador(nota.getIdentificadorLocal());
        nf.setInfoCobranca(this.getCobranca(info.getCobranca()));
        nf.setInfoCompra(this.getInfoCompra(info.getCompra()));
        nf.setInfoDestinatario(this.getInfoDest(info.getDestinatario()));
        nf.setInfoExportacao(this.getExportacao(info.getExportacao()));
        nf.setInfoPagamento(this.getInfoPagamento(info.getPagamento()));
        nf.setInfoSuplementar(this.getInfoSup(nota.getInfoSuplementar()));
        nf.setInfoTransporte(this.getInfoTransporte(info.getTransporte()));
        nf.setInformacoesAdicionais(this.getInfoAdicional(info.getInformacoesAdicionais()));
        nf.setItens(this.webNFeItem.getItens(info.getItens()));
        nf.setLocalRetirada(this.getLocalRetirada(info.getRetirada()));
        nf.setPessoasAutorizadasDowXML(this.getPessoasAuto(info.getPessoasAutorizadasDownloadNFe()));
        nf.setRespTecnico(this.getRespTecnico(info.getInformacaoResposavelTecnico()));
        nf.setTotal(this.getTotais(info.getTotal()));
        nf.setVersaoNFe(info.getVersao());
        nf.setNfeAvulsa(this.getAvulsa(info.getAvulsa()));
        return nf;
    }

    protected NFeNotaFiscalPropria.NFeEmitente getEmitente(NFNotaInfoEmitente aux) {
        NFeNotaFiscalPropria.NFeEmitente em = new NFeNotaFiscalPropria.NFeEmitente();
        em.setClassificacaoNacionalAtividadesEconomicas(aux.getClassificacaoNacionalAtividadesEconomicas());
        if (ToolMethods.isStrWithData((String)aux.getCnpj())) {
            em.setCnpjCpf(aux.getCnpj());
        } else {
            em.setCnpjCpf(aux.getCpf());
        }
        if (aux.getRegimeTributario() != null) {
            em.setCodRegimeTributario(aux.getRegimeTributario().getCodigo());
        }
        em.setInscricaoEstadual(aux.getInscricaoEstadual());
        em.setInscricaoEstadualSubstituicaoTributaria(aux.getInscricaoEstadualSubstituicaoTributaria());
        em.setInscricaoMunicipal(aux.getInscricaoMunicipal());
        em.setNomeFantasia(aux.getNomeFantasia());
        em.setRazaoSocial(aux.getRazaoSocial());
        em.setEndereco(this.getEndereco(aux.getEndereco()));
        return em;
    }

    protected NFeNotaFiscalPropria.NFeEndereco getEndereco(NFEndereco aux) {
        if (aux == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeEndereco end = new NFeNotaFiscalPropria.NFeEndereco();
        end.setBairro(aux.getBairro());
        end.setCep(aux.getCep());
        end.setCodigoMunicipio(aux.getCodigoMunicipio());
        if (aux.getCodigoPais() != null) {
            end.setCodigoPais(String.valueOf(aux.getCodigoPais().getCodigo()));
        }
        end.setCodigoUF(aux.getUf());
        end.setComplemento(aux.getComplemento());
        end.setDescricaoMunicipio(aux.getDescricaoMunicipio());
        end.setLogradouro(aux.getLogradouro());
        end.setNumero(aux.getNumero());
        end.setTelefone(aux.getTelefone());
        return end;
    }

    protected NFeNotaFiscalPropria.NFeEnderecoEntrega getEnderecoEntrega(NFNotaInfoLocal aux) {
        if (aux == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeEnderecoEntrega i = new NFeNotaFiscalPropria.NFeEnderecoEntrega();
        i.setBairro(aux.getBairro());
        if (ToolMethods.isStrWithData((String)aux.getCnpj())) {
            i.setCnpjCpf(aux.getCnpj());
        } else {
            i.setCnpjCpf(aux.getCpf());
        }
        i.setCep(aux.getCep());
        i.setCodigoMunicipio(aux.getCodigoMunicipio());
        if (aux.getCodigoPais() != null) {
            i.setCodigoPais(aux.getCodigoPais().getCodigo().toString());
        }
        i.setComplemento(aux.getComplemento());
        i.setDescricaoPais(aux.getDescricaoPais());
        i.setLogradouro(aux.getLogradouro());
        i.setEmail(aux.getEmail());
        i.setInscricaoEstadual(aux.getInscricaoEstadual());
        i.setNome(aux.getNome());
        i.setNomeMunicipio(aux.getNomeMunicipio());
        i.setNumero(aux.getNumero());
        i.setTelefone(aux.getTelefone());
        i.setUf(aux.getUf());
        return i;
    }

    protected NFeNotaFiscalPropria.NFeIdentificacao getIdentificacao(NFNotaInfoIdentificacao aux) {
        NFeNotaFiscalPropria.NFeIdentificacao ident = new NFeNotaFiscalPropria.NFeIdentificacao();
        if (aux.getAmbiente() != null) {
            ident.setAmbiente(ConstAmbiente.valueOfCodigo((String)aux.getAmbiente().getCodigo()));
        }
        ident.setCodigoMunicipio(aux.getCodigoMunicipio());
        ident.setCodigoRandomico(aux.getCodigoRandomico());
        ident.setCodigoUf(aux.getUf().getCodigoIbge());
        ident.setDataHoraContigencia(aux.getDataHoraContigencia());
        ident.setDataHoraEmissao(aux.getDataHoraEmissao());
        ident.setDataHoraSaidaOuEntrada(aux.getDataHoraSaidaOuEntrada());
        ident.setDigitoVerificador(aux.getDigitoVerificador());
        if (aux.getFinalidade() != null) {
            ident.setFinalidade(ConstNFeFinalidade.valueOfCodigo((String)aux.getFinalidade().getCodigo()));
        }
        if (aux.getIdentificadorLocalDestinoOperacao() != null) {
            ident.setIdentificadorLocalDestinoOperacao(ConstNFeIdentificacaoLocalDestOperacao.valueOfCodigo((String)aux.getIdentificadorLocalDestinoOperacao().getCodigo()));
        }
        if (aux.getIndicadorPresencaComprador() != null) {
            ident.setIndicadorPresencaComprador(ConstNFeIndicadorPresenca.valueOfCodigo((String)aux.getIndicadorPresencaComprador().getCodigo()));
        }
        ident.setJustificativaEntradaContingencia(aux.getJustificativaEntradaContingencia());
        if (aux.getModelo() != null) {
            ident.setModelo(EnumConstModDocFiscal.get((Object)aux.getModelo().getCodigo()));
        }
        ident.setNaturezaOperacao(aux.getNaturezaOperacao());
        ident.setNumeroNota(Long.valueOf(aux.getNumeroNota()));
        if (aux.getOperacaoConsumidorFinal() != null) {
            ident.setOperacaoConsumidorFinal(ConstNFeOperacaoConsumidorFinal.valueOfCodigo((String)aux.getOperacaoConsumidorFinal().getCodigo()));
        }
        ident.setProgramaEmissor(ConstNFeProgramaEmissor.valueOfCodigo((String)aux.getProgramaEmissor().getCodigo()));
        ident.setReferenciadas(this.getReferenciadas(aux.getReferenciadas()));
        ident.setSerie(aux.getSerie());
        if (aux.getTipo() != null) {
            ident.setTipo(ConstNFeTipoEntSai.valueOfCodigo((String)aux.getTipo().getCodigo()));
        }
        if (aux.getTipoEmissao() != null) {
            ident.setTipoEmissao(ConstNFeTipoEmissao.valueOfCodigo((String)aux.getTipoEmissao().getCodigo()));
        }
        if (aux.getTipoImpressao() != null) {
            ident.setTipoImpressao(ConstNFeTipoImpressao.valueOfCodigo((String)aux.getTipoImpressao().getCodigo()));
        }
        if (aux.getIndIntermed() != null) {
            ident.setTipoIntermediador(ConstNFeIntermediadorComerical.valueOfCodigo((String)aux.getIndIntermed().getCodigo()));
        }
        ident.setVersaoEmissor(aux.getVersaoEmissor());
        return ident;
    }

    protected List<NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada> getReferenciadas(List<NFInfoReferenciada> referenciadas) {
        LinkedList<NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada> ret = new LinkedList<NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada>();
        if (referenciadas == null) {
            return ret;
        }
        for (NFInfoReferenciada ref : referenciadas) {
            NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada i = new NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada();
            i.setChaveAcesso(ref.getChaveAcesso());
            i.setChaveAcessoCTReferenciada(ref.getChaveAcessoCTReferenciada());
            i.setCupomFiscalReferenciado(this.getCupomRef(ref.getCupomFiscalReferenciado()));
            i.setInfoNFProdutorRuralReferenciada(this.getNFProdRef(ref.getInfoNFProdutorRuralReferenciada()));
            i.setModelo1por1Referenciada(this.getMod1Ref(ref.getModelo1por1Referenciada()));
            ret.add(i);
        }
        return ret;
    }

    protected NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada.NFeInfoCupomFiscalReferenciado getCupomRef(NFInfoCupomFiscalReferenciado aux) {
        if (aux == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada.NFeInfoCupomFiscalReferenciado c = new NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada.NFeInfoCupomFiscalReferenciado();
        c.setModeloDocumentoFiscal(aux.getModeloDocumentoFiscal());
        c.setNumeroContadorOrdemOperacao(aux.getNumeroContadorOrdemOperacao());
        c.setNumeroOrdemSequencialECF(aux.getNumeroOrdemSequencialECF());
        return c;
    }

    protected NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada.NFeInfoProdutorRuralReferenciada getNFProdRef(NFInfoProdutorRuralReferenciada aux) {
        if (aux == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada.NFeInfoProdutorRuralReferenciada i = new NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada.NFeInfoProdutorRuralReferenciada();
        i.setAnoMesEmissao(aux.getAnoMesEmissao());
        i.setCnpjCpfEmitente(aux.getCnpjEmitente());
        if (aux.getUfEmitente() != null) {
            i.setCodigoUfEmitente(aux.getUfEmitente().getCodigoIbge());
        }
        i.setIeEmitente(aux.getIeEmitente());
        i.setModeloDocumentoFiscal(aux.getModeloDocumentoFiscal());
        i.setNumeroDocumentoFiscal(aux.getNumeroDocumentoFiscal());
        i.setSerieDocumentoFiscal(aux.getSerieDocumentoFiscal());
        return i;
    }

    protected NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada.NFeInfoModelo1Por1AReferenciada getMod1Ref(NFInfoModelo1Por1AReferenciada aux) {
        if (aux == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada.NFeInfoModelo1Por1AReferenciada i = new NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada.NFeInfoModelo1Por1AReferenciada();
        i.setAnoMesEmissaoNFe(aux.getAnoMesEmissaoNFe());
        i.setCnpj(aux.getCnpj());
        if (aux.getUf() != null) {
            i.setCodigoUf(aux.getUf().getCodigoIbge());
        }
        i.setModeloDocumentoFiscal(aux.getModeloDocumentoFiscal());
        i.setNumeroDocumentoFiscal(aux.getNumeroDocumentoFiscal());
        i.setSerie(aux.getSerie());
        return i;
    }

    protected NFeNotaFiscalPropria.NFNotaInfoCobranca getCobranca(NFNotaInfoCobranca aux) {
        if (aux == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFNotaInfoCobranca i = new NFeNotaFiscalPropria.NFNotaInfoCobranca();
        i.setInfoFatura(this.getInfoFatura(aux.getFatura()));
        i.setParcelas(this.getParcelas(aux.getParcelas()));
        return i;
    }

    protected NFeNotaFiscalPropria.NFNotaInfoFatura getInfoFatura(NFNotaInfoFatura aux) {
        if (aux == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFNotaInfoFatura fat = new NFeNotaFiscalPropria.NFNotaInfoFatura();
        fat.setNumeroFatura(aux.getNumeroFatura());
        fat.setValorDesconto(UtilMethods.valueOfDouble(aux.getValorDesconto()));
        fat.setValorLiquidoFatura(UtilMethods.valueOfDouble(aux.getValorLiquidoFatura()));
        fat.setValorOriginalFatura(UtilMethods.valueOfDouble(aux.getValorOriginalFatura()));
        return fat;
    }

    protected List<NFeNotaFiscalPropria.NFNotaInfoParcela> getParcelas(List<NFNotaInfoParcela> aux) {
        LinkedList<NFeNotaFiscalPropria.NFNotaInfoParcela> ret = new LinkedList<NFeNotaFiscalPropria.NFNotaInfoParcela>();
        if (aux == null) {
            return ret;
        }
        for (NFNotaInfoParcela a : aux) {
            NFeNotaFiscalPropria.NFNotaInfoParcela i = new NFeNotaFiscalPropria.NFNotaInfoParcela();
            i.setDataVencimento(a.getDataVencimento());
            i.setNumeroParcela(a.getNumeroParcela());
            i.setValorParcela(UtilMethods.valueOfDouble(a.getValorParcela()));
            ret.add(i);
        }
        return ret;
    }

    protected NFeNotaFiscalPropria.NFeInfoCompra getInfoCompra(NFNotaInfoCompra aux) {
        if (aux == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeInfoCompra i = new NFeNotaFiscalPropria.NFeInfoCompra();
        i.setContrato(aux.getContrato());
        i.setNotaDeEmpenho(aux.getNotaDeEmpenho());
        i.setPedido(aux.getPedido());
        return i;
    }

    protected NFeNotaFiscalPropria.NFeDestinatario getInfoDest(NFNotaInfoDestinatario aux) {
        if (aux == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeDestinatario i = new NFeNotaFiscalPropria.NFeDestinatario();
        i.setCnpjCpf(aux.getCnpj());
        i.setEmail(aux.getEmail());
        i.setEndereco(this.getEndereco(aux.getEndereco()));
        i.setIdEstrangeiro(aux.getIdEstrangeiro());
        if (aux.getIndicadorIEDestinatario() != null) {
            i.setIndicadorIEDestinatario(ConstNFeIndicadorIEDest.valueOfCodigo((String)aux.getIndicadorIEDestinatario().getCodigo()));
        }
        i.setInscricaoEstadual(aux.getInscricaoEstadual());
        i.setInscricaoMunicipal(aux.getInscricaoMunicipal());
        i.setInscricaoSuframa(aux.getInscricaoSuframa());
        i.setRazaoSocial(aux.getRazaoSocial());
        return i;
    }

    protected NFeNotaFiscalPropria.NFeNotaInfoExportacao getExportacao(NFNotaInfoExportacao aux) {
        if (aux == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeNotaInfoExportacao i = new NFeNotaFiscalPropria.NFeNotaInfoExportacao();
        i.setCodigoUfEmbarqueProduto(aux.getUfEmbarqueProduto());
        i.setLocalDespachoProdutos(aux.getLocalDespachoProdutos());
        i.setLocalEmbarqueProdutos(aux.getLocalEmbarqueProdutos());
        return i;
    }

    protected NFeNotaFiscalPropria.NFeNotaInfoPagamento getInfoPagamento(NFNotaInfoPagamento aux) {
        if (aux == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeNotaInfoPagamento inf = new NFeNotaFiscalPropria.NFeNotaInfoPagamento();
        inf.setValorTroco(UtilMethods.valueOfDouble(aux.getValorTroco()));
        LinkedList<NFeNotaFiscalPropria.NFeNotaInfoPagamento.NFeNotaInfoFormaPagamento> ret = new LinkedList<NFeNotaFiscalPropria.NFeNotaInfoPagamento.NFeNotaInfoFormaPagamento>();
        for (NFNotaInfoFormaPagamento a : aux.getDetalhamentoFormasPagamento()) {
            NFeNotaFiscalPropria.NFeNotaInfoPagamento.NFeNotaInfoFormaPagamento i = new NFeNotaFiscalPropria.NFeNotaInfoPagamento.NFeNotaInfoFormaPagamento();
            i.setCartao(this.getInfoCartao(a.getCartao()));
            if (a.getIndicadorFormaPagamento() != null) {
                i.setIndicadorFormaPagamento(ConstNFeIndicadorFormaPag.valueOfCodigo((String)a.getIndicadorFormaPagamento().getCodigo()));
            }
            if (a.getMeioPagamento() != null) {
                i.setMeioPagamento(ConstNFeMeioPagamento.valueOfCodigo((String)a.getMeioPagamento().getCodigo()));
            }
            i.setValorPagamento(UtilMethods.valueOfDouble(a.getValorPagamento()));
            i.setDescricaoMeioPagamento(a.getDescricaoMeioPagamento());
            ret.add(i);
        }
        inf.setDetalhamentoFormasPagamento(ret);
        return inf;
    }

    protected NFeNotaFiscalPropria.NFeNotaInfoPagamento.NFeNotaInfoFormaPagamento.NFeNotaInfoCartao getInfoCartao(NFNotaInfoCartao aux) {
        if (aux == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeNotaInfoPagamento.NFeNotaInfoFormaPagamento.NFeNotaInfoCartao i = new NFeNotaFiscalPropria.NFeNotaInfoPagamento.NFeNotaInfoFormaPagamento.NFeNotaInfoCartao();
        i.setCnpj(aux.getCnpj());
        i.setNumeroAutorizacaoOperacaoCartao(aux.getNumeroAutorizacaoOperacaoCartao());
        if (aux.getOperadoraCartao() != null) {
            i.setOperadoraCartao(ConstNFeOperadoraCartao.valueOfCodigo((String)aux.getOperadoraCartao().getCodigo()));
        }
        if (aux.getTipoIntegracao() != null) {
            i.setTipoIntegracao(ConstNFeTipoIntegracaoPagamento.valueOfCodigo((String)aux.getTipoIntegracao().getCodigo()));
        }
        return i;
    }

    protected NFeNotaFiscalPropria.NFeNotaInfoSuplementar getInfoSup(NFNotaInfoSuplementar aux) {
        if (aux == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeNotaInfoSuplementar i = new NFeNotaFiscalPropria.NFeNotaInfoSuplementar();
        i.setQrCode(aux.getQrCode());
        i.setUrlConsultaChaveAcesso(aux.getUrlConsultaChaveAcesso());
        return i;
    }

    protected NFeNotaFiscalPropria.NFeNotaInfoTransporte getInfoTransporte(NFNotaInfoTransporte aux) {
        if (aux == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeNotaInfoTransporte i = new NFeNotaFiscalPropria.NFeNotaInfoTransporte();
        i.setBalsa(aux.getBalsa());
        i.setIcmsTransporte(this.getIcmsTransp(aux.getIcmsTransporte()));
        if (aux.getModalidadeFrete() != null) {
            i.setModalidadeFrete(ConstNFeModalidadeFrete.valueOfCodigo((String)aux.getModalidadeFrete().getCodigo()));
        }
        i.setReboques(this.getReboques(aux.getReboques()));
        i.setTransportador(this.getTransportador(aux.getTransportador()));
        i.setVagao(aux.getVagao());
        i.setVeiculo(this.getVeiculo(aux.getVeiculo()));
        i.setVolumes(this.getVolumes(aux.getVolumes()));
        return i;
    }

    protected NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoRetencaoICMSTransporte getIcmsTransp(NFNotaInfoRetencaoICMSTransporte aux) {
        if (aux == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoRetencaoICMSTransporte i = new NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoRetencaoICMSTransporte();
        i.setAliquotaRetencao(UtilMethods.valueOfDouble(aux.getAliquotaRetencao()));
        i.setBcRetencaoICMS(UtilMethods.valueOfDouble(aux.getBcRetencaoICMS()));
        i.setCfop(aux.getCfop());
        i.setCodigoMunicipio(aux.getCodigoMunicipioOcorrenciaFatoGeradorICMSTransporte());
        i.setValorICMSRetido(UtilMethods.valueOfDouble(aux.getValorICMSRetido()));
        i.setValorServico(UtilMethods.valueOfDouble(aux.getValorServico()));
        return i;
    }

    protected List<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoReboque> getReboques(List<NFNotaInfoReboque> aux) {
        if (aux == null) {
            return null;
        }
        LinkedList<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoReboque> ret = new LinkedList<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoReboque>();
        for (NFNotaInfoReboque a : aux) {
            NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoReboque i = new NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoReboque();
            i.setCodigoUf(a.getUf());
            i.setPlacaVeiculo(a.getPlacaVeiculo());
            i.setRegistroNacionalTransportadorCarga(a.getRegistroNacionalTransportadorCarga());
            ret.add(i);
        }
        return ret;
    }

    protected NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeInfoTransportador getTransportador(NFNotaInfoTransportador aux) {
        if (aux == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeInfoTransportador i = new NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeInfoTransportador();
        if (ToolMethods.isStrWithData((String)aux.getCnpj())) {
            i.setCnpjCpf(aux.getCnpj());
        } else {
            i.setCnpjCpf(aux.getCpf());
        }
        i.setEnderecoComplemento(aux.getEnderecoComplemento());
        i.setInscricaoEstadual(aux.getInscricaoEstadual());
        i.setNomeMunicipio(aux.getNomeMunicipio());
        i.setRazaoSocial(aux.getRazaoSocial());
        i.setUf(aux.getUf());
        return i;
    }

    protected NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVeiculo getVeiculo(NFNotaInfoVeiculo aux) {
        if (aux == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVeiculo i = new NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVeiculo();
        i.setPlacaVeiculo(aux.getPlacaVeiculo());
        i.setRegistroNacionalTransportadorCarga(aux.getRegistroNacionalTransportadorCarga());
        i.setUf(aux.getUf());
        return i;
    }

    protected List<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume> getVolumes(List<NFNotaInfoVolume> aux) {
        if (aux == null) {
            return null;
        }
        LinkedList<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume> ret = new LinkedList<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume>();
        for (NFNotaInfoVolume a : aux) {
            NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume i = new NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume();
            i.setEspecieVolumesTransportados(a.getEspecieVolumesTransportados());
            i.setLacres(this.getLacres(a.getLacres()));
            i.setMarca(a.getMarca());
            i.setNumeracaoVolumesTransportados(a.getNumeracaoVolumesTransportados());
            i.setPesoBruto(UtilMethods.valueOfDouble(a.getPesoBruto()));
            i.setPesoLiquido(UtilMethods.valueOfDouble(a.getPesoLiquido()));
            if (a.getQuantidadeVolumesTransportados() != null) {
                i.setQuantidadeVolumesTransportados(a.getQuantidadeVolumesTransportados().longValue());
            }
            ret.add(i);
        }
        return ret;
    }

    protected List<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume.NFeNotaInfoLacre> getLacres(List<NFNotaInfoLacre> aux) {
        if (aux == null) {
            return null;
        }
        LinkedList<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume.NFeNotaInfoLacre> ret = new LinkedList<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume.NFeNotaInfoLacre>();
        for (NFNotaInfoLacre a : aux) {
            NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume.NFeNotaInfoLacre i = new NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume.NFeNotaInfoLacre();
            i.setNumeroLacres(a.getNumeroLacres());
            ret.add(i);
        }
        return ret;
    }

    protected NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais getInfoAdicional(NFNotaInfoInformacoesAdicionais aux) {
        if (aux == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais i = new NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais();
        i.setInformacoesAdicionaisInteresseFisco(aux.getInformacoesAdicionaisInteresseFisco());
        i.setInformacoesComplementaresInteresseContribuinte(aux.getInformacoesComplementaresInteresseContribuinte());
        i.setObservacoesContribuinte(this.getObsContrib(aux.getObservacoesContribuinte()));
        i.setObservacoesFisco(this.getObsFisco(aux.getObservacoesFisco()));
        i.setProcessosRefenciado(this.getProcRef(aux.getProcessosRefenciado()));
        return i;
    }

    protected List<NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao> getObsContrib(List<NFNotaInfoObservacao> aux) {
        if (aux == null) {
            return null;
        }
        LinkedList<NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao> ret = new LinkedList<NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao>();
        for (NFNotaInfoObservacao a : aux) {
            NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao i = new NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao();
            i.setConteudoCampo(a.getConteudoCampo());
            i.setIdentificacaoCampo(a.getIdentificacaoCampo());
            ret.add(i);
        }
        return ret;
    }

    protected List<NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao> getObsFisco(List<NFNotaInfoObservacao> aux) {
        if (aux == null) {
            return null;
        }
        LinkedList<NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao> ret = new LinkedList<NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao>();
        for (NFNotaInfoObservacao a : aux) {
            NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao i = new NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao();
            i.setConteudoCampo(a.getConteudoCampo());
            i.setIdentificacaoCampo(a.getIdentificacaoCampo());
            ret.add(i);
        }
        return ret;
    }

    protected List<NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoProcessoReferenciado> getProcRef(List<NFNotaInfoProcessoReferenciado> aux) {
        if (aux == null) {
            return null;
        }
        LinkedList<NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoProcessoReferenciado> ret = new LinkedList<NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoProcessoReferenciado>();
        for (NFNotaInfoProcessoReferenciado a : aux) {
            NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoProcessoReferenciado i = new NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoProcessoReferenciado();
            i.setIdentificadorProcessoOuAtoConcessorio(a.getIdentificadorProcessoOuAtoConcessorio());
            if (a.getIndicadorOrigemProcesso() != null) {
                i.setIndicadorOrigemProcesso(ConstNFeOrigemProcesso.valueOfCodigo((String)a.getIndicadorOrigemProcesso().getCodigo()));
            }
            ret.add(i);
        }
        return ret;
    }

    protected NFeNotaFiscalPropria.NFeLocalRetirada getLocalRetirada(NFNotaInfoLocal aux) {
        if (aux == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeLocalRetirada i = new NFeNotaFiscalPropria.NFeLocalRetirada();
        i.setBairro(aux.getBairro());
        if (ToolMethods.isStrWithData((String)aux.getCnpj())) {
            i.setCnpjCpf(aux.getCnpj());
        } else {
            i.setCnpjCpf(aux.getCpf());
        }
        i.setCep(aux.getCep());
        i.setCodigoMunicipio(aux.getCodigoMunicipio());
        if (aux.getCodigoPais() != null) {
            i.setCodigoPais(aux.getCodigoPais().getCodigo().toString());
        }
        i.setComplemento(aux.getComplemento());
        i.setDescricaoPais(aux.getDescricaoPais());
        i.setLogradouro(aux.getLogradouro());
        i.setEmail(aux.getEmail());
        i.setInscricaoEstadual(aux.getInscricaoEstadual());
        i.setNome(aux.getNome());
        i.setNomeMunicipio(aux.getNomeMunicipio());
        i.setNumero(aux.getNumero());
        i.setTelefone(aux.getTelefone());
        i.setUf(aux.getUf());
        return i;
    }

    protected List<NFeNotaFiscalPropria.NFePessoaAutorizadaDownloadNFe> getPessoasAuto(List<NFPessoaAutorizadaDownloadNFe> aux) {
        if (aux == null) {
            return null;
        }
        LinkedList<NFeNotaFiscalPropria.NFePessoaAutorizadaDownloadNFe> ret = new LinkedList<NFeNotaFiscalPropria.NFePessoaAutorizadaDownloadNFe>();
        for (NFPessoaAutorizadaDownloadNFe a : aux) {
            NFeNotaFiscalPropria.NFePessoaAutorizadaDownloadNFe nFePessoaAutorizadaDownloadNFe = new NFeNotaFiscalPropria.NFePessoaAutorizadaDownloadNFe();
        }
        return ret;
    }

    protected NFeNotaFiscalPropria.NFeNotaInfoRespTecnico getRespTecnico(NFNotaInfoResponsavelTecnico aux) {
        if (aux == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeNotaInfoRespTecnico i = new NFeNotaFiscalPropria.NFeNotaInfoRespTecnico();
        i.setCnpj(aux.getCnpj());
        i.setContatoNome(aux.getContatoNome());
        i.setEmail(aux.getEmail());
        i.setHashCSRT(aux.getHashCSRT());
        i.setIdCSRT(aux.getIdCSRT());
        i.setTelefone(aux.getTelefone());
        return i;
    }

    protected NFeNotaFiscalPropria.NFeNotaInfoTotal getTotais(NFNotaInfoTotal aux) {
        if (aux == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeNotaInfoTotal t = new NFeNotaFiscalPropria.NFeNotaInfoTotal();
        t.setIcmsTotal(this.getIcmsTot(aux.getIcmsTotal()));
        t.setIssqnTotal(this.getIssTot(aux.getIssqnTotal()));
        t.setRetencoesTributos(this.getRetTrib(aux.getRetencoesTributos()));
        return t;
    }

    protected NFeNotaFiscalPropria.NFeNotaInfoTotal.NFeNotaInfoICMSTotal getIcmsTot(NFNotaInfoICMSTotal aux) {
        if (aux == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeNotaInfoTotal.NFeNotaInfoICMSTotal t = new NFeNotaFiscalPropria.NFeNotaInfoTotal.NFeNotaInfoICMSTotal();
        t.setBaseCalculoICMS(UtilMethods.valueOfDouble(aux.getBaseCalculoICMS()));
        t.setBaseCalculoICMSST(UtilMethods.valueOfDouble(aux.getBaseCalculoICMSST()));
        t.setOutrasDespesasAcessorias(UtilMethods.valueOfDouble(aux.getOutrasDespesasAcessorias()));
        t.setValorCOFINS(UtilMethods.valueOfDouble(aux.getValorCOFINS()));
        t.setValorICMSDesonerado(UtilMethods.valueOfDouble(aux.getValorICMSDesonerado()));
        t.setValorICMSFundoCombatePobreza(UtilMethods.valueOfDouble(aux.getValorICMSFundoCombatePobreza()));
        t.setValorICMSPartilhaDestinatario(UtilMethods.valueOfDouble(aux.getValorICMSPartilhaDestinatario()));
        t.setValorICMSPartilhaRementente(UtilMethods.valueOfDouble(aux.getValorICMSPartilhaRementente()));
        t.setValorPIS(UtilMethods.valueOfDouble(aux.getValorPIS()));
        t.setValorTotalDesconto(UtilMethods.valueOfDouble(aux.getValorTotalDesconto()));
        t.setValorTotalDosProdutosServicos(UtilMethods.valueOfDouble(aux.getValorTotalDosProdutosServicos()));
        t.setValorTotalFrete(UtilMethods.valueOfDouble(aux.getValorTotalFrete()));
        t.setValorTotalFundoCombatePobreza(UtilMethods.valueOfDouble(aux.getValorTotalFundoCombatePobreza()));
        t.setValorTotalFundoCombatePobrezaST(UtilMethods.valueOfDouble(aux.getValorTotalFundoCombatePobrezaST()));
        t.setValorTotalFundoCombatePobrezaSTRetido(UtilMethods.valueOfDouble(aux.getValorTotalFundoCombatePobrezaSTRetido()));
        t.setValorTotalICMS(UtilMethods.valueOfDouble(aux.getValorTotalICMS()));
        t.setValorTotalICMSST(UtilMethods.valueOfDouble(aux.getValorTotalICMSST()));
        t.setValorTotalII(UtilMethods.valueOfDouble(aux.getValorTotalII()));
        t.setValorTotalIPI(UtilMethods.valueOfDouble(aux.getValorTotalIPI()));
        t.setValorTotalIPIDevolvido(UtilMethods.valueOfDouble(aux.getValorTotalIPIDevolvido()));
        t.setValorTotalNFe(UtilMethods.valueOfDouble(aux.getValorTotalNFe()));
        t.setValorTotalSeguro(UtilMethods.valueOfDouble(aux.getValorTotalSeguro()));
        t.setValorTotalTributos(UtilMethods.valueOfDouble(aux.getValorTotalTributos()));
        return t;
    }

    protected NFeNotaFiscalPropria.NFeNotaInfoTotal.NFeNotaInfoISSQNTotal getIssTot(NFNotaInfoISSQNTotal aux) {
        if (aux == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeNotaInfoTotal.NFeNotaInfoISSQNTotal i = new NFeNotaFiscalPropria.NFeNotaInfoTotal.NFeNotaInfoISSQNTotal();
        i.setBaseCalculoISS(UtilMethods.valueOfDouble(aux.getBaseCalculoISS()));
        i.setDataPrestacaoServico(aux.getDataPrestacaoServico());
        if (aux.getTributacao() != null) {
            i.setTributacao(ConstNFeInfoRegimeEspTributacao.valueOfCodigo((String)aux.getTributacao().getCodigo()));
        }
        i.setValorCOFINSsobreServicos(UtilMethods.valueOfDouble(aux.getValorCOFINSsobreServicos()));
        i.setValorDeducao(UtilMethods.valueOfDouble(aux.getValorDeducao()));
        i.setValorOutros(UtilMethods.valueOfDouble(aux.getValorOutros()));
        i.setValorPISsobreServicos(UtilMethods.valueOfDouble(aux.getValorPISsobreServicos()));
        i.setValorTotalDescontoCondicionado(UtilMethods.valueOfDouble(aux.getValorTotalDescontoCondicionado()));
        i.setValorTotalDescontoIncondicionado(UtilMethods.valueOfDouble(aux.getValorTotalDescontoIncondicionado()));
        i.setValorTotalISS(UtilMethods.valueOfDouble(aux.getValorTotalISS()));
        i.setValorTotalRetencaoISS(UtilMethods.valueOfDouble(aux.getValorTotalRetencaoISS()));
        i.setValorTotalServicosSobNaoIncidenciaNaoTributadosICMS(UtilMethods.valueOfDouble(aux.getValorTotalServicosSobNaoIncidenciaNaoTributadosICMS()));
        return i;
    }

    protected NFeNotaFiscalPropria.NFeNotaInfoTotal.NFeNotaInfoRetencoesTributos getRetTrib(NFNotaInfoRetencoesTributos aux) {
        if (aux == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeNotaInfoTotal.NFeNotaInfoRetencoesTributos i = new NFeNotaFiscalPropria.NFeNotaInfoTotal.NFeNotaInfoRetencoesTributos();
        i.setBaseCalculoIRRF(UtilMethods.valueOfDouble(aux.getBaseCalculoIRRF()));
        i.setBaseCalculoRetencaoPrevidenciaSocial(UtilMethods.valueOfDouble(aux.getBaseCalculoRetencaoPrevidenciaSocial()));
        i.setValorRetencaoPrevidenciaSocial(UtilMethods.valueOfDouble(aux.getValorRetencaoPrevidenciaSocial()));
        i.setValorRetidoCOFINS(UtilMethods.valueOfDouble(aux.getValorRetidoCOFINS()));
        i.setValorRetidoCSLL(UtilMethods.valueOfDouble(aux.getValorRetidoCSLL()));
        i.setValorRetidoIRRF(UtilMethods.valueOfDouble(aux.getValorRetidoIRRF()));
        i.setValorRetidoPIS(UtilMethods.valueOfDouble(aux.getValorRetidoPIS()));
        return i;
    }

    protected NFeNotaFiscalPropria.NFeAvulsa getAvulsa(NFNotaInfoAvulsa aux) {
        if (aux == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFeAvulsa a = new NFeNotaFiscalPropria.NFeAvulsa();
        a.setCnpj(aux.getCnpj());
        a.setDataEmissaoDocumentoArrecadacao(aux.getDataEmissaoDocumentoArrecadacao());
        a.setDataPagamentoDocumentoArrecadacao(aux.getDataPagamentoDocumentoArrecadacao());
        a.setFone(aux.getFone());
        a.setMatriculaAgente(aux.getMatriculaAgente());
        a.setNomeAgente(aux.getNomeAgente());
        a.setNumeroDocumentoArrecadacaoReceita(aux.getNumeroDocumentoArrecadacaoReceita());
        a.setOrgaoEmitente(aux.getOrgaoEmitente());
        a.setReparticaoFiscalEmitente(aux.getReparticaoFiscalEmitente());
        a.setUf(aux.getUf());
        a.setValorTotalConstanteDocumentoArrecadacaoReceita(UtilMethods.valueOfDouble(aux.getValorTotalConstanteDocumentoArrecadacaoReceita()));
        return a;
    }
}

