/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.nfe.nfe.tofincatto;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFTipoEmissao;
import com.fincatto.documentofiscal.nfe400.classes.NFEndereco;
import com.fincatto.documentofiscal.nfe400.classes.NFFinalidade;
import com.fincatto.documentofiscal.nfe400.classes.NFIndicadorFormaPagamento;
import com.fincatto.documentofiscal.nfe400.classes.NFModalidadeFrete;
import com.fincatto.documentofiscal.nfe400.classes.NFOrigemProcesso;
import com.fincatto.documentofiscal.nfe400.classes.NFProcessoEmissor;
import com.fincatto.documentofiscal.nfe400.classes.NFRegimeTributario;
import com.fincatto.documentofiscal.nfe400.classes.NFTipo;
import com.fincatto.documentofiscal.nfe400.classes.NFTipoImpressao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFIdentificadorLocalDestinoOperacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFIndicadorIEDestinatario;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFIndicadorIntermediador;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFIndicadorPresencaComprador;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFInfoCupomFiscalReferenciado;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFInfoModelo1Por1AReferenciada;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFInfoProdutorRuralReferenciada;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFInfoReferenciada;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFMeioPagamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNota;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfo;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoAvulsa;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoCartao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoCobranca;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoCompra;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoDestinatario;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoEmitente;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoExportacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoFatura;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoFormaPagamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoICMSTotal;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoISSQNTotal;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoIdentificacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoInformacoesAdicionais;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoLacre;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoLocal;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoObservacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoPagamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoParcela;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoProcessoReferenciado;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoReboque;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoRegimeEspecialTributacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoResponsavelTecnico;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoRetencaoICMSTransporte;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoRetencoesTributos;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoSuplementar;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoTotal;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoTransportador;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoTransporte;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoVeiculo;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoVolume;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFOperacaoConsumidorFinal;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFOperadoraCartao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFPessoaAutorizadaDownloadNFe;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFTipoIntegracaoPagamento;
import com.touchcomp.basementorclientwebservices.UtilMethods;
import com.touchcomp.basementorclientwebservices.nfe.model.env.nfe.NFeNotaFiscalPropria;
import com.touchcomp.basementorclientwebservices.nfe.nfe.tofincatto.WebNFeItemNotaPropria;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.LinkedList;
import java.util.List;

public class WebNFeNotaPropria {
    public NFNota convertNota(NFeNotaFiscalPropria nota) {
        if (nota == null) {
            return null;
        }
        NFNotaInfo info = new NFNotaInfo();
        WebNFeItemNotaPropria webNFeItem = new WebNFeItemNotaPropria();
        NFNota nf = new NFNota();
        info.setEmitente(this.getEmitente(nota.getEmitente()));
        info.setEntrega(this.getEnderecoEntrega(nota.getEnderecoEntrega()));
        info.setIdentificacao(this.getIdentificacao(nota.getIdentificacao()));
        nf.setIdentificadorLocal(nota.getIdentificador().longValue());
        info.setCobranca(this.getCobranca(nota.getInfoCobranca()));
        info.setCompra(this.getInfoCompra(nota.getInfoCompra()));
        info.setDestinatario(this.getInfoDest(nota.getInfoDestinatario()));
        info.setExportacao(this.getExportacao(nota.getInfoExportacao()));
        info.setPagamento(this.getInfoPagamento(nota.getInfoPagamento()));
        nf.setInfoSuplementar(this.getInfoSup(nota.getInfoSuplementar()));
        info.setTransporte(this.getInfoTransporte(nota.getInfoTransporte()));
        info.setInformacoesAdicionais(this.getInfoAdicional(nota.getInformacoesAdicionais()));
        info.setItens(webNFeItem.getItens(nota.getItens()));
        info.setRetirada(this.getLocalRetirada(nota.getLocalRetirada()));
        info.setPessoasAutorizadasDownloadNFe(this.getPessoasAuto(nota.getPessoasAutorizadasDowXML()));
        info.setInformacaoResposavelTecnico(this.getRespTecnico(nota.getRespTecnico()));
        info.setTotal(this.getTotais(nota.getTotal()));
        info.setVersao(UtilMethods.valueOfBigDecimal(nota.getVersaoNFe()));
        info.setAvulsa(this.getAvulsa(nota.getNfeAvulsa()));
        nf.setInfo(info);
        return nf;
    }

    protected NFNotaInfoEmitente getEmitente(NFeNotaFiscalPropria.NFeEmitente aux) {
        NFNotaInfoEmitente em = new NFNotaInfoEmitente();
        em.setClassificacaoNacionalAtividadesEconomicas(aux.getClassificacaoNacionalAtividadesEconomicas());
        if (ToolMethods.isStrWithData((String)aux.getCnpjCpf())) {
            if (aux.getCnpjCpf().length() > 11) {
                em.setCnpj(aux.getCnpjCpf());
            } else {
                em.setCpf(aux.getCnpjCpf());
            }
        }
        if (aux.getCodRegimeTributario() != null) {
            em.setRegimeTributario(NFRegimeTributario.valueOfCodigo((String)aux.getCodRegimeTributario()));
        }
        em.setInscricaoEstadual(aux.getInscricaoEstadual());
        em.setInscricaoEstadualSubstituicaoTributaria(aux.getInscricaoEstadualSubstituicaoTributaria());
        em.setInscricaoMunicipal(aux.getInscricaoMunicipal());
        em.setNomeFantasia(aux.getNomeFantasia());
        em.setRazaoSocial(aux.getRazaoSocial());
        em.setEndereco(this.getEndereco(aux.getEndereco()));
        return em;
    }

    protected NFEndereco getEndereco(NFeNotaFiscalPropria.NFeEndereco aux) {
        if (aux == null) {
            return null;
        }
        NFEndereco end = new NFEndereco();
        end.setBairro(aux.getBairro());
        end.setCep(aux.getCep());
        end.setCodigoMunicipio(aux.getCodigoMunicipio());
        end.setCodigoPais(aux.getCodigoPais());
        end.setComplemento(aux.getComplemento());
        end.setDescricaoMunicipio(aux.getDescricaoMunicipio());
        end.setLogradouro(aux.getLogradouro());
        end.setNumero(aux.getNumero());
        end.setTelefone(aux.getTelefone());
        end.setUf(DFUnidadeFederativa.valueOfCodigo((String)aux.getCodigoUF()));
        return end;
    }

    protected NFNotaInfoLocal getEnderecoEntrega(NFeNotaFiscalPropria.NFeEnderecoEntrega aux) {
        if (aux == null) {
            return null;
        }
        NFNotaInfoLocal i = new NFNotaInfoLocal();
        i.setBairro(aux.getBairro());
        if (ToolMethods.isStrWithData((String)aux.getCnpjCpf())) {
            if (aux.getCnpjCpf().length() > 11) {
                i.setCnpj(aux.getCnpjCpf());
            } else {
                i.setCpf(aux.getCnpjCpf());
            }
        }
        i.setCep(aux.getCep());
        i.setCodigoMunicipio(aux.getCodigoMunicipio());
        if (aux.getCodigoPais() != null) {
            i.setCodigoPais(aux.getCodigoPais());
        }
        i.setComplemento(aux.getComplemento());
        i.setDescricaoPais(aux.getDescricaoPais());
        i.setLogradouro(aux.getLogradouro());
        i.setEmail(aux.getEmail());
        i.setInscricaoEstadual(aux.getInscricaoEstadual());
        i.setNome(aux.getNome());
        i.setNomeMunicipio(aux.getNomeMunicipio());
        i.setNumero(aux.getNumero());
        i.setTelefone(aux.getTelefone());
        i.setUf(DFUnidadeFederativa.valueOfCodigo((String)aux.getUf()));
        return i;
    }

    protected NFNotaInfoIdentificacao getIdentificacao(NFeNotaFiscalPropria.NFeIdentificacao aux) {
        NFNotaInfoIdentificacao ident = new NFNotaInfoIdentificacao();
        if (aux.getAmbiente() != null) {
            ident.setAmbiente(DFAmbiente.valueOfCodigo((String)aux.getAmbiente().getCodigo()));
        }
        ident.setCodigoMunicipio(aux.getCodigoMunicipio());
        ident.setCodigoRandomico(aux.getCodigoRandomico());
        ident.setUf(DFUnidadeFederativa.valueOfCodigo((String)aux.getCodigoUf()));
        ident.setDataHoraContigencia(aux.getDataHoraContigencia());
        ident.setDataHoraEmissao(aux.getDataHoraEmissao());
        ident.setDataHoraSaidaOuEntrada(aux.getDataHoraSaidaOuEntrada());
        ident.setDigitoVerificador(aux.getDigitoVerificador());
        if (aux.getFinalidade() != null) {
            ident.setFinalidade(NFFinalidade.valueOfCodigo((String)aux.getFinalidade().getCodigo()));
        }
        if (aux.getIdentificadorLocalDestinoOperacao() != null) {
            ident.setIdentificadorLocalDestinoOperacao(NFIdentificadorLocalDestinoOperacao.valueOfCodigo((String)aux.getIdentificadorLocalDestinoOperacao().getCodigo()));
        }
        if (aux.getIndicadorPresencaComprador() != null) {
            ident.setIndicadorPresencaComprador(NFIndicadorPresencaComprador.valueOfCodigo((String)aux.getIndicadorPresencaComprador().getCodigo()));
        }
        ident.setJustificativaEntradaContingencia(aux.getJustificativaEntradaContingencia());
        if (aux.getModelo() != null) {
            ident.setModelo(DFModelo.valueOfCodigo((String)aux.getModelo().getCodigo()));
        }
        ident.setNaturezaOperacao(aux.getNaturezaOperacao());
        ident.setNumeroNota(aux.getNumeroNota().toString());
        if (aux.getOperacaoConsumidorFinal() != null) {
            ident.setOperacaoConsumidorFinal(NFOperacaoConsumidorFinal.valueOfCodigo((String)aux.getOperacaoConsumidorFinal().getCodigo()));
        }
        ident.setProgramaEmissor(NFProcessoEmissor.valueOfCodigo((String)aux.getProgramaEmissor().getCodigo()));
        ident.setReferenciadas(this.getReferenciadas(aux.getReferenciadas()));
        ident.setSerie(aux.getSerie());
        if (aux.getTipo() != null) {
            ident.setTipo(NFTipo.valueOfCodigo((String)aux.getTipo().getCodigo()));
        }
        if (aux.getTipoEmissao() != null) {
            ident.setTipoEmissao(NFTipoEmissao.valueOfCodigo((String)aux.getTipoEmissao().getCodigo()));
        }
        if (aux.getTipoImpressao() != null) {
            ident.setTipoImpressao(NFTipoImpressao.valueOfCodigo((String)aux.getTipoImpressao().getCodigo()));
        }
        if (aux.getTipoIntermediador() != null) {
            ident.setIndIntermed(NFIndicadorIntermediador.valueOfCodigo((String)aux.getTipoIntermediador().getCodigo()));
        }
        ident.setVersaoEmissor(aux.getVersaoEmissor());
        return ident;
    }

    protected List<NFInfoReferenciada> getReferenciadas(List<NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada> referenciadas) {
        LinkedList<NFInfoReferenciada> ret = new LinkedList<NFInfoReferenciada>();
        if (referenciadas == null) {
            return ret;
        }
        for (NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada ref : referenciadas) {
            NFInfoReferenciada i = new NFInfoReferenciada();
            i.setChaveAcesso(ref.getChaveAcesso());
            if (i.getChaveAcesso() == null) {
                i.setChaveAcessoCTReferenciada(ref.getChaveAcessoCTReferenciada());
                i.setCupomFiscalReferenciado(this.getCupomRef(ref.getCupomFiscalReferenciado()));
                if (i.getCupomFiscalReferenciado() == null) {
                    i.setInfoNFProdutorRuralReferenciada(this.getNFProdRef(ref.getInfoNFProdutorRuralReferenciada()));
                }
                i.setModelo1por1Referenciada(this.getMod1Ref(ref.getModelo1por1Referenciada()));
            }
            ret.add(i);
        }
        return ret;
    }

    protected NFInfoCupomFiscalReferenciado getCupomRef(NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada.NFeInfoCupomFiscalReferenciado aux) {
        if (aux == null) {
            return null;
        }
        NFInfoCupomFiscalReferenciado c = new NFInfoCupomFiscalReferenciado();
        c.setModeloDocumentoFiscal(aux.getModeloDocumentoFiscal());
        c.setNumeroContadorOrdemOperacao(aux.getNumeroContadorOrdemOperacao());
        c.setNumeroOrdemSequencialECF(aux.getNumeroOrdemSequencialECF());
        return c;
    }

    protected NFInfoProdutorRuralReferenciada getNFProdRef(NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada.NFeInfoProdutorRuralReferenciada aux) {
        if (aux == null) {
            return null;
        }
        NFInfoProdutorRuralReferenciada i = new NFInfoProdutorRuralReferenciada();
        i.setAnoMesEmissao(aux.getAnoMesEmissao());
        if (ToolMethods.isStrWithData((String)aux.getCnpjCpfEmitente())) {
            if (aux.getCnpjCpfEmitente().length() > 11) {
                i.setCnpjEmitente(aux.getCnpjCpfEmitente());
            } else {
                i.setCpfEmitente(aux.getCnpjCpfEmitente());
            }
        }
        if (aux.getCodigoUfEmitente() != null) {
            i.setUfEmitente(DFUnidadeFederativa.valueOfCodigo((String)aux.getCodigoUfEmitente()));
        }
        i.setIeEmitente(aux.getIeEmitente());
        i.setModeloDocumentoFiscal(aux.getModeloDocumentoFiscal());
        i.setNumeroDocumentoFiscal(aux.getNumeroDocumentoFiscal());
        i.setSerieDocumentoFiscal(aux.getSerieDocumentoFiscal());
        return i;
    }

    protected NFInfoModelo1Por1AReferenciada getMod1Ref(NFeNotaFiscalPropria.NFeIdentificacao.NFeInfoReferenciada.NFeInfoModelo1Por1AReferenciada aux) {
        if (aux == null) {
            return null;
        }
        NFInfoModelo1Por1AReferenciada i = new NFInfoModelo1Por1AReferenciada();
        i.setAnoMesEmissaoNFe(aux.getAnoMesEmissaoNFe());
        i.setCnpj(aux.getCnpj());
        if (aux.getCodigoUf() != null) {
            i.setUf(DFUnidadeFederativa.valueOfCodigo((String)aux.getCodigoUf()));
        }
        i.setModeloDocumentoFiscal(aux.getModeloDocumentoFiscal());
        i.setNumeroDocumentoFiscal(aux.getNumeroDocumentoFiscal());
        i.setSerie(aux.getSerie());
        return i;
    }

    protected NFNotaInfoCobranca getCobranca(NFeNotaFiscalPropria.NFNotaInfoCobranca aux) {
        if (aux == null) {
            return null;
        }
        NFNotaInfoCobranca i = new NFNotaInfoCobranca();
        i.setFatura(this.getInfoFatura(aux.getInfoFatura()));
        i.setParcelas(this.getParcelas(aux.getParcelas()));
        return i;
    }

    protected NFNotaInfoFatura getInfoFatura(NFeNotaFiscalPropria.NFNotaInfoFatura aux) {
        if (aux == null) {
            return null;
        }
        NFNotaInfoFatura fat = new NFNotaInfoFatura();
        fat.setNumeroFatura(aux.getNumeroFatura());
        fat.setValorDesconto(UtilMethods.valueOfBigDecimal(aux.getValorDesconto()));
        fat.setValorLiquidoFatura(UtilMethods.valueOfBigDecimal(aux.getValorLiquidoFatura()));
        fat.setValorOriginalFatura(UtilMethods.valueOfBigDecimal(aux.getValorOriginalFatura()));
        return fat;
    }

    protected List<NFNotaInfoParcela> getParcelas(List<NFeNotaFiscalPropria.NFNotaInfoParcela> aux) {
        LinkedList<NFNotaInfoParcela> ret = new LinkedList<NFNotaInfoParcela>();
        if (aux == null) {
            return ret;
        }
        for (NFeNotaFiscalPropria.NFNotaInfoParcela a : aux) {
            NFNotaInfoParcela i = new NFNotaInfoParcela();
            i.setDataVencimento(a.getDataVencimento());
            i.setNumeroParcela(a.getNumeroParcela());
            i.setValorParcela(UtilMethods.valueOfBigDecimal(a.getValorParcela()));
            ret.add(i);
        }
        return ret;
    }

    protected NFNotaInfoCompra getInfoCompra(NFeNotaFiscalPropria.NFeInfoCompra aux) {
        if (aux == null) {
            return null;
        }
        NFNotaInfoCompra i = new NFNotaInfoCompra();
        i.setContrato(aux.getContrato());
        i.setNotaDeEmpenho(aux.getNotaDeEmpenho());
        i.setPedido(aux.getPedido());
        return i;
    }

    protected NFNotaInfoDestinatario getInfoDest(NFeNotaFiscalPropria.NFeDestinatario aux) {
        if (aux == null) {
            return null;
        }
        NFNotaInfoDestinatario i = new NFNotaInfoDestinatario();
        if (ToolMethods.isStrWithData((String)aux.getCnpjCpf())) {
            if (aux.getCnpjCpf().length() > 11) {
                i.setCnpj(aux.getCnpjCpf());
            } else {
                i.setCpf(aux.getCnpjCpf());
            }
        }
        i.setEmail(aux.getEmail());
        i.setEndereco(this.getEndereco(aux.getEndereco()));
        i.setIdEstrangeiro(aux.getIdEstrangeiro());
        if (aux.getIndicadorIEDestinatario() != null) {
            i.setIndicadorIEDestinatario(NFIndicadorIEDestinatario.valueOfCodigo((String)aux.getIndicadorIEDestinatario().getCodigo()));
        }
        i.setInscricaoEstadual(aux.getInscricaoEstadual());
        i.setInscricaoMunicipal(aux.getInscricaoMunicipal());
        i.setInscricaoSuframa(aux.getInscricaoSuframa());
        i.setRazaoSocial(aux.getRazaoSocial());
        return i;
    }

    protected NFNotaInfoExportacao getExportacao(NFeNotaFiscalPropria.NFeNotaInfoExportacao aux) {
        if (aux == null) {
            return null;
        }
        NFNotaInfoExportacao i = new NFNotaInfoExportacao();
        i.setUfEmbarqueProduto(DFUnidadeFederativa.valueOfCodigo((String)aux.getCodigoUfEmbarqueProduto()));
        i.setLocalDespachoProdutos(aux.getLocalDespachoProdutos());
        i.setLocalEmbarqueProdutos(aux.getLocalEmbarqueProdutos());
        return i;
    }

    protected NFNotaInfoPagamento getInfoPagamento(NFeNotaFiscalPropria.NFeNotaInfoPagamento aux) {
        if (aux == null) {
            return null;
        }
        NFNotaInfoPagamento inf = new NFNotaInfoPagamento();
        inf.setValorTroco(UtilMethods.valueOfBigDecimal(aux.getValorTroco()));
        LinkedList<NFNotaInfoFormaPagamento> ret = new LinkedList<NFNotaInfoFormaPagamento>();
        for (NFeNotaFiscalPropria.NFeNotaInfoPagamento.NFeNotaInfoFormaPagamento a : aux.getDetalhamentoFormasPagamento()) {
            NFNotaInfoFormaPagamento i = new NFNotaInfoFormaPagamento();
            i.setCartao(this.getInfoCartao(a.getCartao()));
            if (a.getIndicadorFormaPagamento() != null) {
                i.setIndicadorFormaPagamento(NFIndicadorFormaPagamento.valueOfCodigo((String)a.getIndicadorFormaPagamento().getCodigo()));
            }
            if (a.getMeioPagamento() != null) {
                i.setMeioPagamento(NFMeioPagamento.valueOfCodigo((String)a.getMeioPagamento().getCodigo()));
            }
            i.setValorPagamento(UtilMethods.valueOfBigDecimal(a.getValorPagamento()));
            i.setDescricaoMeioPagamento(a.getDescricaoMeioPagamento());
            ret.add(i);
        }
        inf.setDetalhamentoFormasPagamento(ret);
        return inf;
    }

    protected NFNotaInfoCartao getInfoCartao(NFeNotaFiscalPropria.NFeNotaInfoPagamento.NFeNotaInfoFormaPagamento.NFeNotaInfoCartao aux) {
        if (aux == null) {
            return null;
        }
        NFNotaInfoCartao i = new NFNotaInfoCartao();
        i.setCnpj(aux.getCnpj());
        i.setNumeroAutorizacaoOperacaoCartao(aux.getNumeroAutorizacaoOperacaoCartao());
        if (aux.getOperadoraCartao() != null) {
            i.setOperadoraCartao(NFOperadoraCartao.valueOfCodigo((String)aux.getOperadoraCartao().getCodigo()));
        }
        if (aux.getTipoIntegracao() != null) {
            i.setTipoIntegracao(NFTipoIntegracaoPagamento.valueOfCodigo((String)aux.getTipoIntegracao().getCodigo()));
        }
        return i;
    }

    protected NFNotaInfoSuplementar getInfoSup(NFeNotaFiscalPropria.NFeNotaInfoSuplementar aux) {
        if (aux == null) {
            return null;
        }
        NFNotaInfoSuplementar i = new NFNotaInfoSuplementar();
        i.setQrCode(aux.getQrCode());
        i.setUrlConsultaChaveAcesso(aux.getUrlConsultaChaveAcesso());
        return i;
    }

    protected NFNotaInfoTransporte getInfoTransporte(NFeNotaFiscalPropria.NFeNotaInfoTransporte aux) {
        if (aux == null) {
            return null;
        }
        NFNotaInfoTransporte i = new NFNotaInfoTransporte();
        i.setBalsa(aux.getBalsa());
        i.setIcmsTransporte(this.getIcmsTransp(aux.getIcmsTransporte()));
        if (aux.getModalidadeFrete() != null) {
            i.setModalidadeFrete(NFModalidadeFrete.valueOfCodigo((String)aux.getModalidadeFrete().getCodigo()));
        }
        i.setReboques(this.getReboques(aux.getReboques()));
        i.setTransportador(this.getTransportador(aux.getTransportador()));
        i.setVagao(aux.getVagao());
        i.setVeiculo(this.getVeiculo(aux.getVeiculo()));
        i.setVolumes(this.getVolumes(aux.getVolumes()));
        return i;
    }

    protected NFNotaInfoRetencaoICMSTransporte getIcmsTransp(NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoRetencaoICMSTransporte aux) {
        if (aux == null) {
            return null;
        }
        NFNotaInfoRetencaoICMSTransporte i = new NFNotaInfoRetencaoICMSTransporte();
        i.setAliquotaRetencao(UtilMethods.valueOfBigDecimal(aux.getAliquotaRetencao()));
        i.setBcRetencaoICMS(UtilMethods.valueOfBigDecimal(aux.getBcRetencaoICMS()));
        i.setCfop(aux.getCfop());
        i.setCodigoMunicipioOcorrenciaFatoGeradorICMSTransporte(aux.getCodigoMunicipio());
        i.setValorICMSRetido(UtilMethods.valueOfBigDecimal(aux.getValorICMSRetido()));
        i.setValorServico(UtilMethods.valueOfBigDecimal(aux.getValorServico()));
        return i;
    }

    protected List<NFNotaInfoReboque> getReboques(List<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoReboque> aux) {
        if (aux == null) {
            return null;
        }
        LinkedList<NFNotaInfoReboque> ret = new LinkedList<NFNotaInfoReboque>();
        for (NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoReboque a : aux) {
            NFNotaInfoReboque i = new NFNotaInfoReboque();
            i.setUf(DFUnidadeFederativa.valueOfCodigo((String)a.getCodigoUf()));
            i.setPlacaVeiculo(a.getPlacaVeiculo());
            i.setRegistroNacionalTransportadorCarga(a.getRegistroNacionalTransportadorCarga());
            ret.add(i);
        }
        return ret;
    }

    protected NFNotaInfoTransportador getTransportador(NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeInfoTransportador aux) {
        if (aux == null) {
            return null;
        }
        NFNotaInfoTransportador i = new NFNotaInfoTransportador();
        if (ToolMethods.isStrWithData((String)aux.getCnpjCpf())) {
            if (aux.getCnpjCpf().length() > 11) {
                i.setCnpj(aux.getCnpjCpf());
            } else {
                i.setCpf(aux.getCnpjCpf());
            }
        }
        i.setEnderecoComplemento(aux.getEnderecoComplemento());
        i.setInscricaoEstadual(aux.getInscricaoEstadual());
        i.setNomeMunicipio(aux.getNomeMunicipio());
        i.setRazaoSocial(aux.getRazaoSocial());
        i.setUf(DFUnidadeFederativa.valueOfCodigo((String)aux.getUf()));
        return i;
    }

    protected NFNotaInfoVeiculo getVeiculo(NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVeiculo aux) {
        if (aux == null) {
            return null;
        }
        NFNotaInfoVeiculo i = new NFNotaInfoVeiculo();
        i.setPlacaVeiculo(aux.getPlacaVeiculo());
        i.setRegistroNacionalTransportadorCarga(aux.getRegistroNacionalTransportadorCarga());
        i.setUf(DFUnidadeFederativa.valueOfCodigo((String)aux.getUf()));
        return i;
    }

    protected List<NFNotaInfoVolume> getVolumes(List<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume> aux) {
        if (aux == null) {
            return null;
        }
        LinkedList<NFNotaInfoVolume> ret = new LinkedList<NFNotaInfoVolume>();
        for (NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume a : aux) {
            NFNotaInfoVolume i = new NFNotaInfoVolume();
            i.setEspecieVolumesTransportados(a.getEspecieVolumesTransportados());
            i.setLacres(this.getLacres(a.getLacres()));
            i.setMarca(a.getMarca());
            i.setNumeracaoVolumesTransportados(a.getNumeracaoVolumesTransportados());
            i.setPesoBruto(UtilMethods.valueOfBigDecimal(a.getPesoBruto()));
            i.setPesoLiquido(UtilMethods.valueOfBigDecimal(a.getPesoLiquido()));
            i.setQuantidadeVolumesTransportados(UtilMethods.valueOfBigInteger(a.getQuantidadeVolumesTransportados()));
            ret.add(i);
        }
        return ret;
    }

    protected List<NFNotaInfoLacre> getLacres(List<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume.NFeNotaInfoLacre> aux) {
        if (aux == null) {
            return null;
        }
        LinkedList<NFNotaInfoLacre> ret = new LinkedList<NFNotaInfoLacre>();
        for (NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume.NFeNotaInfoLacre a : aux) {
            NFNotaInfoLacre i = new NFNotaInfoLacre();
            i.setNumeroLacre(a.getNumeroLacres());
            ret.add(i);
        }
        return ret;
    }

    protected NFNotaInfoInformacoesAdicionais getInfoAdicional(NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais aux) {
        if (aux == null) {
            return null;
        }
        NFNotaInfoInformacoesAdicionais i = new NFNotaInfoInformacoesAdicionais();
        i.setInformacoesAdicionaisInteresseFisco(aux.getInformacoesAdicionaisInteresseFisco());
        i.setInformacoesComplementaresInteresseContribuinte(aux.getInformacoesComplementaresInteresseContribuinte());
        i.setObservacoesContribuinte(this.getObsContrib(aux.getObservacoesContribuinte()));
        i.setObservacoesFisco(this.getObsFisco(aux.getObservacoesFisco()));
        i.setProcessosRefenciado(this.getProcRef(aux.getProcessosRefenciado()));
        return i;
    }

    protected List<NFNotaInfoObservacao> getObsContrib(List<NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao> aux) {
        if (aux == null) {
            return null;
        }
        LinkedList<NFNotaInfoObservacao> ret = new LinkedList<NFNotaInfoObservacao>();
        for (NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao a : aux) {
            NFNotaInfoObservacao i = new NFNotaInfoObservacao();
            i.setConteudoCampo(a.getConteudoCampo());
            i.setIdentificacaoCampo(a.getIdentificacaoCampo());
            ret.add(i);
        }
        return ret;
    }

    protected List<NFNotaInfoObservacao> getObsFisco(List<NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao> aux) {
        if (aux == null) {
            return null;
        }
        LinkedList<NFNotaInfoObservacao> ret = new LinkedList<NFNotaInfoObservacao>();
        for (NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoObservacao a : aux) {
            NFNotaInfoObservacao i = new NFNotaInfoObservacao();
            i.setConteudoCampo(a.getConteudoCampo());
            i.setIdentificacaoCampo(a.getIdentificacaoCampo());
            ret.add(i);
        }
        return ret;
    }

    protected List<NFNotaInfoProcessoReferenciado> getProcRef(List<NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoProcessoReferenciado> aux) {
        if (aux == null) {
            return null;
        }
        LinkedList<NFNotaInfoProcessoReferenciado> ret = new LinkedList<NFNotaInfoProcessoReferenciado>();
        for (NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais.NFeNotaInfoProcessoReferenciado a : aux) {
            NFNotaInfoProcessoReferenciado i = new NFNotaInfoProcessoReferenciado();
            i.setIdentificadorProcessoOuAtoConcessorio(a.getIdentificadorProcessoOuAtoConcessorio());
            if (a.getIndicadorOrigemProcesso() != null) {
                i.setIndicadorOrigemProcesso(NFOrigemProcesso.valueOfCodigo((String)a.getIndicadorOrigemProcesso().getCodigo()));
            }
            ret.add(i);
        }
        return ret;
    }

    protected NFNotaInfoLocal getLocalRetirada(NFeNotaFiscalPropria.NFeLocalRetirada aux) {
        if (aux == null) {
            return null;
        }
        NFNotaInfoLocal i = new NFNotaInfoLocal();
        i.setBairro(aux.getBairro());
        if (ToolMethods.isStrWithData((String)aux.getCnpjCpf())) {
            if (aux.getCnpjCpf().length() > 11) {
                i.setCnpj(aux.getCnpjCpf());
            } else {
                i.setCpf(aux.getCnpjCpf());
            }
        }
        i.setCep(aux.getCep());
        i.setCodigoMunicipio(aux.getCodigoMunicipio());
        if (aux.getCodigoPais() != null) {
            i.setCodigoPais(aux.getCodigoPais());
        }
        i.setComplemento(aux.getComplemento());
        i.setDescricaoPais(aux.getDescricaoPais());
        i.setLogradouro(aux.getLogradouro());
        i.setEmail(aux.getEmail());
        i.setInscricaoEstadual(aux.getInscricaoEstadual());
        i.setNome(aux.getNome());
        i.setNomeMunicipio(aux.getNomeMunicipio());
        i.setNumero(aux.getNumero());
        i.setTelefone(aux.getTelefone());
        i.setUf(DFUnidadeFederativa.valueOfCodigo((String)aux.getUf()));
        return i;
    }

    protected List<NFPessoaAutorizadaDownloadNFe> getPessoasAuto(List<NFeNotaFiscalPropria.NFePessoaAutorizadaDownloadNFe> aux) {
        if (aux == null) {
            return null;
        }
        LinkedList<NFPessoaAutorizadaDownloadNFe> ret = new LinkedList<NFPessoaAutorizadaDownloadNFe>();
        for (NFeNotaFiscalPropria.NFePessoaAutorizadaDownloadNFe a : aux) {
            NFPessoaAutorizadaDownloadNFe i = new NFPessoaAutorizadaDownloadNFe();
            if (!ToolMethods.isStrWithData((String)a.getCnpjCpf())) continue;
            if (a.getCnpjCpf().length() > 11) {
                i.setCnpj(a.getCnpjCpf());
                continue;
            }
            i.setCpf(a.getCnpjCpf());
        }
        return ret;
    }

    protected NFNotaInfoResponsavelTecnico getRespTecnico(NFeNotaFiscalPropria.NFeNotaInfoRespTecnico aux) {
        if (aux == null) {
            return null;
        }
        NFNotaInfoResponsavelTecnico i = new NFNotaInfoResponsavelTecnico();
        i.setCnpj(aux.getCnpj());
        i.setContatoNome(aux.getContatoNome());
        i.setEmail(aux.getEmail());
        i.setHashCSRT(aux.getHashCSRT());
        i.setIdCSRT(aux.getIdCSRT());
        i.setTelefone(aux.getTelefone());
        return i;
    }

    protected NFNotaInfoTotal getTotais(NFeNotaFiscalPropria.NFeNotaInfoTotal aux) {
        if (aux == null) {
            return null;
        }
        NFNotaInfoTotal t = new NFNotaInfoTotal();
        t.setIcmsTotal(this.getIcmsTot(aux.getIcmsTotal()));
        t.setIssqnTotal(this.getIssTot(aux.getIssqnTotal()));
        t.setRetencoesTributos(this.getRetTrib(aux.getRetencoesTributos()));
        return t;
    }

    protected NFNotaInfoICMSTotal getIcmsTot(NFeNotaFiscalPropria.NFeNotaInfoTotal.NFeNotaInfoICMSTotal aux) {
        if (aux == null) {
            return null;
        }
        NFNotaInfoICMSTotal t = new NFNotaInfoICMSTotal();
        t.setBaseCalculoICMS(UtilMethods.valueOfBigDecimal(aux.getBaseCalculoICMS()));
        t.setBaseCalculoICMSST(UtilMethods.valueOfBigDecimal(aux.getBaseCalculoICMSST()));
        t.setOutrasDespesasAcessorias(UtilMethods.valueOfBigDecimal(aux.getOutrasDespesasAcessorias()));
        t.setValorCOFINS(UtilMethods.valueOfBigDecimal(aux.getValorCOFINS()));
        t.setValorICMSDesonerado(UtilMethods.valueOfBigDecimal(aux.getValorICMSDesonerado()));
        t.setValorICMSFundoCombatePobreza(UtilMethods.valueOfBigDecimal(aux.getValorICMSFundoCombatePobreza()));
        t.setValorICMSPartilhaDestinatario(UtilMethods.valueOfBigDecimal(aux.getValorICMSPartilhaDestinatario()));
        t.setValorICMSPartilhaRementente(UtilMethods.valueOfBigDecimal(aux.getValorICMSPartilhaRementente()));
        t.setValorPIS(UtilMethods.valueOfBigDecimal(aux.getValorPIS()));
        t.setValorTotalDesconto(UtilMethods.valueOfBigDecimal(aux.getValorTotalDesconto()));
        t.setValorTotalDosProdutosServicos(UtilMethods.valueOfBigDecimal(aux.getValorTotalDosProdutosServicos()));
        t.setValorTotalFrete(UtilMethods.valueOfBigDecimal(aux.getValorTotalFrete()));
        t.setValorTotalFundoCombatePobreza(UtilMethods.valueOfBigDecimal(aux.getValorTotalFundoCombatePobreza()));
        t.setValorTotalFundoCombatePobrezaST(UtilMethods.valueOfBigDecimal(aux.getValorTotalFundoCombatePobrezaST()));
        t.setValorTotalFundoCombatePobrezaSTRetido(UtilMethods.valueOfBigDecimal(aux.getValorTotalFundoCombatePobrezaSTRetido()));
        t.setValorTotalICMS(UtilMethods.valueOfBigDecimal(aux.getValorTotalICMS()));
        t.setValorTotalICMSST(UtilMethods.valueOfBigDecimal(aux.getValorTotalICMSST()));
        t.setValorTotalII(UtilMethods.valueOfBigDecimal(aux.getValorTotalII()));
        t.setValorTotalIPI(UtilMethods.valueOfBigDecimal(aux.getValorTotalIPI()));
        t.setValorTotalIPIDevolvido(UtilMethods.valueOfBigDecimal(aux.getValorTotalIPIDevolvido()));
        t.setValorTotalNFe(UtilMethods.valueOfBigDecimal(aux.getValorTotalNFe()));
        t.setValorTotalSeguro(UtilMethods.valueOfBigDecimal(aux.getValorTotalSeguro()));
        t.setValorTotalTributos(UtilMethods.valueOfBigDecimal(aux.getValorTotalTributos()));
        return t;
    }

    protected NFNotaInfoISSQNTotal getIssTot(NFeNotaFiscalPropria.NFeNotaInfoTotal.NFeNotaInfoISSQNTotal aux) {
        if (aux == null) {
            return null;
        }
        NFNotaInfoISSQNTotal i = new NFNotaInfoISSQNTotal();
        i.setBaseCalculoISS(UtilMethods.valueOfBigDecimal(aux.getBaseCalculoISS()));
        i.setDataPrestacaoServico(aux.getDataPrestacaoServico());
        if (aux.getTributacao() != null) {
            i.setTributacao(NFNotaInfoRegimeEspecialTributacao.valueOfCodigo((String)aux.getTributacao().getCodigo()));
        }
        i.setValorCOFINSsobreServicos(UtilMethods.valueOfBigDecimal(aux.getValorCOFINSsobreServicos()));
        i.setValorDeducao(UtilMethods.valueOfBigDecimal(aux.getValorDeducao()));
        i.setValorOutros(UtilMethods.valueOfBigDecimal(aux.getValorOutros()));
        i.setValorPISsobreServicos(UtilMethods.valueOfBigDecimal(aux.getValorPISsobreServicos()));
        i.setValorTotalDescontoCondicionado(UtilMethods.valueOfBigDecimal(aux.getValorTotalDescontoCondicionado()));
        i.setValorTotalDescontoIncondicionado(UtilMethods.valueOfBigDecimal(aux.getValorTotalDescontoIncondicionado()));
        i.setValorTotalISS(UtilMethods.valueOfBigDecimal(aux.getValorTotalISS()));
        i.setValorTotalRetencaoISS(UtilMethods.valueOfBigDecimal(aux.getValorTotalRetencaoISS()));
        i.setValorTotalServicosSobNaoIncidenciaNaoTributadosICMS(UtilMethods.valueOfBigDecimal(aux.getValorTotalServicosSobNaoIncidenciaNaoTributadosICMS()));
        return i;
    }

    protected NFNotaInfoRetencoesTributos getRetTrib(NFeNotaFiscalPropria.NFeNotaInfoTotal.NFeNotaInfoRetencoesTributos aux) {
        if (aux == null) {
            return null;
        }
        NFNotaInfoRetencoesTributos i = new NFNotaInfoRetencoesTributos();
        i.setBaseCalculoIRRF(UtilMethods.valueOfBigDecimal(aux.getBaseCalculoIRRF()));
        i.setBaseCalculoRetencaoPrevidenciaSocial(UtilMethods.valueOfBigDecimal(aux.getBaseCalculoRetencaoPrevidenciaSocial()));
        i.setValorRetencaoPrevidenciaSocial(UtilMethods.valueOfBigDecimal(aux.getValorRetencaoPrevidenciaSocial()));
        i.setValorRetidoCOFINS(UtilMethods.valueOfBigDecimal(aux.getValorRetidoCOFINS()));
        i.setValorRetidoCSLL(UtilMethods.valueOfBigDecimal(aux.getValorRetidoCSLL()));
        i.setValorRetidoIRRF(UtilMethods.valueOfBigDecimal(aux.getValorRetidoIRRF()));
        i.setValorRetidoPIS(UtilMethods.valueOfBigDecimal(aux.getValorRetidoPIS()));
        return i;
    }

    protected NFNotaInfoAvulsa getAvulsa(NFeNotaFiscalPropria.NFeAvulsa aux) {
        if (aux == null) {
            return null;
        }
        NFNotaInfoAvulsa a = new NFNotaInfoAvulsa();
        a.setCnpj(aux.getCnpj());
        a.setDataEmissaoDocumentoArrecadacao(aux.getDataEmissaoDocumentoArrecadacao());
        a.setDataPagamentoDocumentoArrecadacao(aux.getDataPagamentoDocumentoArrecadacao());
        a.setFone(aux.getFone());
        a.setMatriculaAgente(aux.getMatriculaAgente());
        a.setNomeAgente(aux.getNomeAgente());
        a.setNumeroDocumentoArrecadacaoReceita(aux.getNumeroDocumentoArrecadacaoReceita());
        a.setOrgaoEmitente(aux.getOrgaoEmitente());
        a.setReparticaoFiscalEmitente(aux.getReparticaoFiscalEmitente());
        a.setUf(DFUnidadeFederativa.valueOfCodigo((String)aux.getUf()));
        a.setValorTotalConstanteDocumentoArrecadacaoReceita(UtilMethods.valueOfBigDecimal(aux.getValorTotalConstanteDocumentoArrecadacaoReceita()));
        return a;
    }
}

