/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.nfse.impl.cancelarnota;

import com.fasterxml.jackson.core.type.TypeReference;
import com.touchcomp.basementor.constants.enums.nfse.EnumConstConfigServicoNFSe;
import com.touchcomp.basementor.constants.enums.opcoesfaturamentonfse.EnumConstTipoAmbienteNFSe;
import com.touchcomp.basementor.model.vo.ConfigServicosTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoNFSe;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementorclientwebservices.nfse.constants.ConstStatusApiNFSe;
import com.touchcomp.basementorclientwebservices.nfse.impl.BaseCommunicantionNFSe;
import com.touchcomp.basementorclientwebservices.nfse.model.ret.NFSeResultCancelamento;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.notas.nfse.EnumExcepEnviaNFSe;
import com.touchcomp.basementorexceptions.exceptions.impl.notas.nfse.ExceptionEnviaNFSe;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementortools.tools.base64.ToolBase64;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.webserviceclient.ToolRESTWebServiceClient2;
import java.text.MessageFormat;
import java.util.HashMap;
import org.json.JSONObject;

public class UtilCancelaNFSe
extends BaseCommunicantionNFSe<NFSeResultCancelamento> {
    public NFSeResultCancelamento cancelar(ConfigServicosTerceiros configServ, OpcoesFaturamentoNFSe opFatNFSe, Rps rps, String motivoCancelamento) throws ExceptionBase {
        ToolRESTWebServiceClient2.Config config = new ToolRESTWebServiceClient2.Config();
        String token = "";
        String url = "";
        if (ToolMethods.isEquals((Object)opFatNFSe.getTipoAmbiente(), (Object)EnumConstTipoAmbienteNFSe.IDENT_AMBIENTE_PRODUCAO_NFSE.getValue())) {
            token = this.getValue(configServ, EnumConstConfigServicoNFSe.TOKEN.getChave());
            url = this.getValue(configServ, EnumConstConfigServicoNFSe.URL_CANCELAMENTO_NFSE.getChave());
        } else {
            token = this.getValue(configServ, EnumConstConfigServicoNFSe.TOKEN_HOMOLOGACAO.getChave());
            url = this.getValue(configServ, EnumConstConfigServicoNFSe.URL_CANCELAMENTO_NFSE_HOMOLOGACAO.getChave());
        }
        config.setUrl(MessageFormat.format(url, String.valueOf(rps)));
        config.getRequestProperties().put("Authorization", "Basic " + ToolBase64.encodeBase64((String)token));
        config.setMethod(ToolRESTWebServiceClient2.Method.DELETE);
        config.setBody(this.getParamMotivoCancelamento(motivoCancelamento));
        config.setStatusCode(this.statusHttpApi());
        NFSeResultCancelamento result = this.request(config, new TypeReference<NFSeResultCancelamento>(this){});
        return result;
    }

    private String getParamMotivoCancelamento(String motivoCancelamento) {
        HashMap<String, String> justificativa = new HashMap<String, String>();
        justificativa.put("justificativa", motivoCancelamento);
        JSONObject json = new JSONObject(justificativa);
        return json.toString();
    }

    @Override
    protected Boolean validResult(NFSeResultCancelamento result) throws ExceptionEnviaNFSe {
        if (UtilCancelaNFSe.isNull((Object)result).booleanValue()) {
            throw new ExceptionEnviaNFSe(EnumExcepEnviaNFSe.RESPOSTA_RECEBIDA_NULA, new Object[0]);
        }
        ConstStatusApiNFSe status = ConstStatusApiNFSe.get(result.getStatus());
        if (!UtilCancelaNFSe.isEquals((Object)((Object)status), (Object)((Object)ConstStatusApiNFSe.CANCELADA))) {
            if (UtilCancelaNFSe.isStrWithData((String)result.getCodigo()) || UtilCancelaNFSe.isNotNull((Object)status.getCode()).booleanValue()) {
                if (UtilCancelaNFSe.isStrWithData((String)result.getCodigo())) {
                    status = ConstStatusApiNFSe.get(result.getCodigo());
                }
                if (!UtilCancelaNFSe.isEquals((Object)((Object)status), (Object)((Object)ConstStatusApiNFSe.EM_PROCESSAMENTO))) {
                    switch (status) {
                        case NAO_ENCONTRADO: {
                            throw new ExceptionEnviaNFSe(EnumExcepEnviaNFSe.NFE_NAO_ENCONTRADA, new Object[]{result.getMensagem()});
                        }
                        case NFE_CANCELADA: {
                            throw new ExceptionEnviaNFSe(EnumExcepEnviaNFSe.NFE_CANCELADA, new Object[]{result.getMensagem()});
                        }
                        case NFE_NAO_AUTORIZADA: {
                            throw new ExceptionEnviaNFSe(EnumExcepEnviaNFSe.NFE_NAO_AUTORIZADA, new Object[]{result.getMensagem()});
                        }
                        case EMPRESA_NAO_HABILITADA: {
                            throw new ExceptionEnviaNFSe(EnumExcepEnviaNFSe.EMPRESA_NAO_HABILITADA, new Object[]{result.getMensagem()});
                        }
                        case CERITIFICADO_VENCIDO: {
                            throw new ExceptionEnviaNFSe(EnumExcepEnviaNFSe.CERTIFICADO_VENCIDO, new Object[]{result.getMensagem()});
                        }
                        case ERRO_VALIDACAO_SCHEMA: {
                            throw new ExceptionEnviaNFSe(EnumExcepEnviaNFSe.VALIDACAO_SCHEMA_XML, new Object[]{result.getMensagem()});
                        }
                        case ERRO_CANCELAMENTO: {
                            StringBuilder errors = new StringBuilder();
                            if (UtilCancelaNFSe.isWithData(result.getErros())) {
                                for (NFSeResultCancelamento.NFSeResultCancelamentoErros err : result.getErros()) {
                                    errors.append(err.getCodigo()).append(" - ").append(err.getMensagem()).append(" - ").append(err.getCorrecao()).append("\n");
                                }
                                errors.append("\n");
                            } else {
                                errors.append(MessagesBaseMentor.getErrorMsg((String)"E.ERP.0658.004", (Object[])new Object[0]));
                            }
                            throw new ExceptionEnviaNFSe(EnumExcepEnviaNFSe.ERRO_CANCELAMENTO, new Object[]{errors.toString()});
                        }
                    }
                    throw new ExceptionEnviaNFSe(EnumExcepEnviaNFSe.REQUISICAO_INVALIDA, new Object[]{result.getMensagem()});
                }
            } else {
                throw new ExceptionEnviaNFSe(EnumExcepEnviaNFSe.REQUISICAO_INVALIDA, new Object[]{result.getMensagem()});
            }
        }
        return true;
    }
}

