/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.nfse.impl.consultanota;

import com.fasterxml.jackson.core.type.TypeReference;
import com.touchcomp.basementor.constants.enums.nfse.EnumConstConfigServicoNFSe;
import com.touchcomp.basementor.constants.enums.opcoesfaturamentonfse.EnumConstTipoAmbienteNFSe;
import com.touchcomp.basementor.model.vo.ConfigServicosTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoNFSe;
import com.touchcomp.basementorclientwebservices.nfse.constants.ConstStatusApiNFSe;
import com.touchcomp.basementorclientwebservices.nfse.impl.BaseCommunicantionNFSe;
import com.touchcomp.basementorclientwebservices.nfse.model.ret.NFSeResultConsulta;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.notas.nfse.EnumExcepEnviaNFSe;
import com.touchcomp.basementorexceptions.exceptions.impl.notas.nfse.ExceptionEnviaNFSe;
import com.touchcomp.basementortools.tools.base64.ToolBase64;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.webserviceclient.ToolRESTWebServiceClient2;
import java.text.MessageFormat;

public class UtilConsultaNFSe
extends BaseCommunicantionNFSe<NFSeResultConsulta> {
    public NFSeResultConsulta consultar(ConfigServicosTerceiros configServ, OpcoesFaturamentoNFSe opFatNFSe, Long rps) throws ExceptionBase {
        ToolRESTWebServiceClient2.Config config = new ToolRESTWebServiceClient2.Config();
        String token = "";
        String url = "";
        if (ToolMethods.isEquals((Object)opFatNFSe.getTipoAmbiente(), (Object)EnumConstTipoAmbienteNFSe.IDENT_AMBIENTE_PRODUCAO_NFSE.getValue())) {
            token = this.getValue(configServ, EnumConstConfigServicoNFSe.TOKEN.getChave());
            url = this.getValue(configServ, EnumConstConfigServicoNFSe.URL_CONSULTA_NFSE.getChave());
        } else {
            token = this.getValue(configServ, EnumConstConfigServicoNFSe.TOKEN_HOMOLOGACAO.getChave());
            url = this.getValue(configServ, EnumConstConfigServicoNFSe.URL_CONSULTA_NFSE_HOMOLOGACAO.getChave());
        }
        config.setUrl(MessageFormat.format(url, String.valueOf(rps)));
        config.getRequestProperties().put("Authorization", "Basic " + ToolBase64.encodeBase64((String)token));
        config.setMethod(ToolRESTWebServiceClient2.Method.GET);
        config.setStatusCode(this.statusHttpApi());
        NFSeResultConsulta result = this.request(config, new TypeReference<NFSeResultConsulta>(this){});
        return result;
    }

    @Override
    protected Boolean validResult(NFSeResultConsulta result) throws ExceptionEnviaNFSe {
        if (UtilConsultaNFSe.isNull((Object)result).booleanValue()) {
            throw new ExceptionEnviaNFSe(EnumExcepEnviaNFSe.RESPOSTA_RECEBIDA_NULA, new Object[0]);
        }
        ConstStatusApiNFSe status = ConstStatusApiNFSe.get(result.getStatus());
        if (UtilConsultaNFSe.isEquals((Object)((Object)status), (Object)((Object)ConstStatusApiNFSe.ERRO_AUTORIZACAO))) {
            if (TMethods.isWithData(result.getErros())) {
                StringBuilder errors = new StringBuilder();
                for (NFSeResultConsulta.NFSeResultConsultaErros err : result.getErros()) {
                    errors.append(err.getCodigo()).append(" - ").append(err.getMensagem()).append(" - ").append(err.getCorrecao()).append("\n");
                }
                errors.append("\n");
                result.setErrosProcessados(errors.toString());
            } else {
                throw new ExceptionEnviaNFSe(EnumExcepEnviaNFSe.REQUISICAO_INVALIDA, new Object[0]);
            }
        }
        return true;
    }
}

