/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.ponto.communication;

import com.touchcomp.basementorclientwebservices.ponto.constants.EnumConstSistemaPonto;
import com.touchcomp.basementorclientwebservices.ponto.model.error.DTOTangerinoException;
import com.touchcomp.basementorclientwebservices.ponto.transformer.PontoBaseTransform;
import com.touchcomp.basementorexceptions.exceptions.impl.integracaoponto.EnumExcepIntegracaoPontoEletronico;
import com.touchcomp.basementorexceptions.exceptions.impl.integracaoponto.ExceptionIntegracaoPontoEletronico;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.EnumExcepWebService;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.web.ToolWebResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.http.NameValuePair;

public abstract class PontoBaseCommunication
extends ToolMethods {
    private String tokenAcesso = "Basic MGRhNjFlNGJmNjExNDQxNTgxZGE1ODIyNDRjNTc1NmQ6MGIxMzQ2Y2U0ZDFjNDNmOGE2NDQ3Njk5MmVhZWU3OWM=";
    private final Integer TIMEOUT = 60000;

    protected PontoBaseTransform getBuilder(EnumConstSistemaPonto sistema) throws ExceptionIntegracaoPontoEletronico {
        return PontoBaseTransform.getTransform(sistema);
    }

    protected String sendPost(String json, String urlStr) throws ExceptionIntegracaoPontoEletronico, ExceptionWebService, ExceptionIO {
        try {
            if (PontoBaseCommunication.isNull((Object)json).booleanValue()) {
                return null;
            }
            HttpURLConnection conn = this.initConnection(urlStr, new LinkedList<NameValuePair>());
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Length", Integer.toString(json.length()));
            OutputStream os = conn.getOutputStream();
            os.write(json.getBytes());
            os.flush();
            this.checkResponse(conn);
            String resp = this.readResult(conn);
            conn.disconnect();
            return resp;
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(PontoBaseCommunication.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIntegracaoPontoEletronico(EnumExcepIntegracaoPontoEletronico.ERRO_COMUNICACAO_SISTEMA_PONTO, new Object[]{ex.getMessage()});
        }
        catch (IOException ex) {
            Logger.getLogger(PontoBaseCommunication.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIntegracaoPontoEletronico(EnumExcepIntegracaoPontoEletronico.ERRO_COMUNICACAO_SISTEMA_PONTO, new Object[]{ex.getMessage()});
        }
    }

    private DTOTangerinoException getObjectResponse(HttpURLConnection connection) throws IOException, ExceptionIO {
        String text;
        InputStream stream = connection.getErrorStream();
        if (stream == null) {
            stream = connection.getInputStream();
        }
        if (PontoBaseCommunication.isStrWithData((String)(text = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"))))) {
            DTOTangerinoException exception = (DTOTangerinoException)this.readJson(text, DTOTangerinoException.class);
            return exception;
        }
        return null;
    }

    private void checkResponse(HttpURLConnection conn) throws IOException, ExceptionWebService, ExceptionIO {
        ToolWebResponse.ResponseStat stat = ToolWebResponse.checkResponse((Integer)conn.getResponseCode());
        if (PontoBaseCommunication.isNull((Object)stat).booleanValue() || !PontoBaseCommunication.isEquals((Object)stat.getStatus(), (Object)ToolWebResponse.ResponseConst.RESPOSTA_SUCESSO)) {
            String message = "";
            DTOTangerinoException exception = this.getObjectResponse(conn);
            if (PontoBaseCommunication.isNotNull((Object)exception).booleanValue() && PontoBaseCommunication.isStrWithData((String)exception.getMessage())) {
                message = exception.getMessage();
            }
            throw new ExceptionWebService(stat.getStatusCode(), EnumExcepWebService.ERRO_CHAMAR_WEBSERVICE, new Object[]{conn.getResponseCode() + ": " + conn.getResponseCode() + " \n Mensagem Servidor: " + message + " \n URL: " + conn.getURL().toString()});
        }
    }

    protected String sendGet(String urlStr) throws ExceptionIntegracaoPontoEletronico, ExceptionWebService, ExceptionIO {
        return this.sendGet(urlStr, new LinkedList<NameValuePair>());
    }

    private String builParameters(String url, List<NameValuePair> parameters) {
        Boolean first = true;
        if (PontoBaseCommunication.isStrWithData((String)url) && PontoBaseCommunication.isNotNull(parameters).booleanValue()) {
            for (NameValuePair p : parameters) {
                if (first.booleanValue()) {
                    url = (String)url + "?";
                    first = false;
                } else {
                    url = (String)url + "&";
                }
                url = (String)url + p.getName() + "=" + p.getValue();
            }
        }
        return url;
    }

    private HttpURLConnection initConnection(String urlStr, List<NameValuePair> parameters) throws ExceptionIntegracaoPontoEletronico {
        try {
            URL url = new URL(this.builParameters(urlStr, parameters));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(this.TIMEOUT);
            conn.setReadTimeout(conn.getConnectTimeout());
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            conn.setRequestProperty("Accept", "application/json;charset=UTF-8");
            conn.setRequestProperty("Accept-Encoding", "gzip, deflate, br, zstd");
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.2.3) Gecko/20100401");
            conn.setRequestProperty("Authorization", this.tokenAcesso);
            return conn;
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(PontoBaseCommunication.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIntegracaoPontoEletronico(EnumExcepIntegracaoPontoEletronico.ERRO_COMUNICACAO_SISTEMA_PONTO, new Object[]{ex.getMessage()});
        }
        catch (IOException ex) {
            Logger.getLogger(PontoBaseCommunication.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIntegracaoPontoEletronico(EnumExcepIntegracaoPontoEletronico.ERRO_COMUNICACAO_SISTEMA_PONTO, new Object[]{ex.getMessage()});
        }
    }

    private String readResult(HttpURLConnection conn) throws IOException {
        String output;
        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        Object resp = "";
        while ((output = br.readLine()) != null) {
            resp = (String)resp + output;
        }
        return resp;
    }

    protected String sendGet(String urlStr, List<NameValuePair> parameters) throws ExceptionIntegracaoPontoEletronico, ExceptionWebService, ExceptionIO {
        try {
            HttpURLConnection conn = this.initConnection(urlStr, parameters);
            this.checkResponse(conn);
            String resp = this.readResult(conn);
            conn.disconnect();
            return resp;
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(PontoBaseCommunication.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIntegracaoPontoEletronico(EnumExcepIntegracaoPontoEletronico.ERRO_COMUNICACAO_SISTEMA_PONTO, new Object[]{ex.getMessage()});
        }
        catch (IOException ex) {
            Logger.getLogger(PontoBaseCommunication.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIntegracaoPontoEletronico(EnumExcepIntegracaoPontoEletronico.ERRO_COMUNICACAO_SISTEMA_PONTO, new Object[]{ex.getMessage()});
        }
    }

    protected String sendDelete(String urlStr, List<NameValuePair> params) throws ExceptionIntegracaoPontoEletronico, ExceptionWebService, ExceptionIO {
        HttpURLConnection conn = this.initConnection(urlStr, params);
        return this.deleteInternal(conn);
    }

    protected String sendDelete(String urlStr, Long id) throws ExceptionIntegracaoPontoEletronico, ExceptionWebService, ExceptionIO {
        if (PontoBaseCommunication.isNotNull((Object)urlStr).booleanValue()) {
            urlStr = ((String)urlStr).endsWith("/") ? (String)urlStr + String.valueOf(id) : (String)urlStr + "/" + String.valueOf(id);
        }
        HttpURLConnection conn = this.initConnection((String)urlStr, new LinkedList<NameValuePair>());
        return this.deleteInternal(conn);
    }

    private String deleteInternal(HttpURLConnection conn) throws ExceptionIntegracaoPontoEletronico, ExceptionWebService, ExceptionIO {
        try {
            conn.setRequestMethod("DELETE");
            this.checkResponse(conn);
            String resp = this.readResult(conn);
            conn.disconnect();
            return resp;
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(PontoBaseCommunication.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIntegracaoPontoEletronico(EnumExcepIntegracaoPontoEletronico.ERRO_COMUNICACAO_SISTEMA_PONTO, new Object[]{ex.getMessage()});
        }
        catch (IOException ex) {
            Logger.getLogger(PontoBaseCommunication.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIntegracaoPontoEletronico(EnumExcepIntegracaoPontoEletronico.ERRO_COMUNICACAO_SISTEMA_PONTO, new Object[]{ex.getMessage()});
        }
    }

    protected Object readJson(String json, Class clazz) throws ExceptionIO {
        if (!PontoBaseCommunication.isStrWithData((String)json)) {
            return null;
        }
        Object data = ToolJson.readJson((String)json, (Class)clazz);
        return data;
    }
}

