/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.ponto.communication.funcionario;

import com.touchcomp.basementorclientwebservices.ponto.communication.PontoBaseCommunication;
import com.touchcomp.basementorclientwebservices.ponto.communication.funcionario.WebServicePontoFuncionario;
import com.touchcomp.basementorclientwebservices.ponto.constants.EnumConstSistemaPonto;
import com.touchcomp.basementorclientwebservices.ponto.model.funcionario.DTOPontoFuncionario;
import com.touchcomp.basementorclientwebservices.ponto.model.funcionario.result.DTOListResultFuncionarioTangerino;
import com.touchcomp.basementorclientwebservices.ponto.model.funcionario.result.DTOResultFuncionarioTangerino;
import com.touchcomp.basementorclientwebservices.ponto.transformer.impl.TangerinoTransform;
import com.touchcomp.basementorexceptions.exceptions.impl.integracaoponto.ExceptionIntegracaoPontoEletronico;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import java.util.ArrayList;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class WebServicePontoFuncionarioTangerino
extends PontoBaseCommunication
implements WebServicePontoFuncionario<DTOResultFuncionarioTangerino, DTOListResultFuncionarioTangerino> {
    @Override
    public void register(DTOPontoFuncionario funcionario) throws ExceptionIntegracaoPontoEletronico, ExceptionWebService, ExceptionInvalidData, ExceptionIO {
        if (WebServicePontoFuncionarioTangerino.isNotNull((Object)funcionario).booleanValue()) {
            TangerinoTransform builder = (TangerinoTransform)this.getBuilder(EnumConstSistemaPonto.TANGERINO);
            this.sendPost(builder.funcionario(funcionario), "https://employer.tangerino.com.br/employee/register?allowUpdate=false");
        }
    }

    @Override
    public DTOResultFuncionarioTangerino find(Long identificador) throws ExceptionWebService, ExceptionIntegracaoPontoEletronico, ExceptionInvalidData, ExceptionIO {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("externalId", String.valueOf(identificador)));
        params.add((NameValuePair)new BasicNameValuePair("ignoreFired", String.valueOf(true)));
        String result = this.sendGet("https://employer.tangerino.com.br/employee/find", params);
        return (DTOResultFuncionarioTangerino)this.readJson(result, DTOResultFuncionarioTangerino.class);
    }

    @Override
    public DTOListResultFuncionarioTangerino findAll() throws ExceptionWebService, ExceptionIntegracaoPontoEletronico, ExceptionInvalidData, ExceptionIO {
        String result = this.sendGet("https://employer.tangerino.com.br/employee/find-all");
        return (DTOListResultFuncionarioTangerino)this.readJson(result, DTOListResultFuncionarioTangerino.class);
    }
}

