/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.ponto.communication.tipoajuste;

import com.touchcomp.basementor.constants.enums.pontoeletronico.EnumConstTipoAjustePonto;
import com.touchcomp.basementorclientwebservices.ponto.communication.PontoBaseCommunication;
import com.touchcomp.basementorclientwebservices.ponto.model.tipoajuste.DTOPontoTipoAjuste;
import com.touchcomp.basementorexceptions.exceptions.impl.integracaoponto.ExceptionIntegracaoPontoEletronico;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import org.json.JSONObject;

public class WebServicePontoTipoAjusteTangerino
extends PontoBaseCommunication {
    public void registerTipoAjustes() throws ExceptionIntegracaoPontoEletronico, ExceptionWebService, ExceptionInvalidData, ExceptionIO {
        DTOPontoTipoAjuste ferias = this.getTipoAjusteFerias();
        String jsonFerias = this.buildTipoAjustePonto(ferias);
        this.sendPost(jsonFerias, "https://employer.tangerino.com.br/adjustment-reason/register");
        DTOPontoTipoAjuste afastamento = this.getTipoAjusteAfastamento();
        String jsonAfastamento = this.buildTipoAjustePonto(afastamento);
        this.sendPost(jsonAfastamento, "https://employer.tangerino.com.br/adjustment-reason/register");
    }

    private String buildTipoAjustePonto(DTOPontoTipoAjuste dto) {
        JSONObject builder = new JSONObject();
        builder.put("accountAsAbsenteeism", (Object)dto.getAccountAsAbsenteeism());
        builder.put("active", (Object)dto.getActive());
        builder.put("allowance", (Object)dto.getAllowance());
        builder.put("countAsMissing", (Object)dto.getCountAsMissing());
        builder.put("description", (Object)dto.getDescription());
        builder.put("enabledForEmployees", (Object)dto.getEnabledForEmployees());
        builder.put("enabledForManagers", (Object)dto.getEnabledForManagers());
        builder.put("fullDay", (Object)dto.getFullDay());
        builder.put("id", (Object)dto.getId());
        builder.put("limitRecord", (Object)dto.getLimitRecord());
        builder.put("message", (Object)dto.getMessage());
        builder.put("requireHourMeter", (Object)dto.getRequireHourMeter());
        builder.put("requireKM", (Object)dto.getRequireKM());
        builder.put("requireLicensePlate", (Object)dto.getRequireLicensePlate());
        builder.put("requireOthers", (Object)dto.getRequireOthers());
        builder.put("requireRoute", (Object)dto.getRequireRoute());
        return builder.toString();
    }

    private DTOPontoTipoAjuste getTipoAjusteFerias() {
        DTOPontoTipoAjuste ferias = new DTOPontoTipoAjuste();
        ferias.setId(EnumConstTipoAjustePonto.FERIAS.getIdentificador());
        ferias.setDescription(EnumConstTipoAjustePonto.FERIAS.getDescricao());
        ferias.setActive(true);
        ferias.setEnabledForEmployees(true);
        ferias.setEnabledForManagers(true);
        ferias.setFullDay(true);
        ferias.setRequireHourMeter(false);
        ferias.setRequireKM(false);
        ferias.setRequireLicensePlate(false);
        ferias.setRequireOthers(false);
        ferias.setRequireRoute(false);
        ferias.setAccountAsAbsenteeism(false);
        ferias.setLimitRecord(false);
        ferias.setCountAsMissing(false);
        ferias.setAllowance(true);
        return ferias;
    }

    private DTOPontoTipoAjuste getTipoAjusteAfastamento() {
        DTOPontoTipoAjuste afastamento = new DTOPontoTipoAjuste();
        afastamento.setId(EnumConstTipoAjustePonto.AFASTAMENTO.getIdentificador());
        afastamento.setDescription(EnumConstTipoAjustePonto.AFASTAMENTO.getDescricao());
        afastamento.setActive(true);
        afastamento.setEnabledForEmployees(false);
        afastamento.setEnabledForManagers(true);
        afastamento.setFullDay(false);
        afastamento.setRequireHourMeter(false);
        afastamento.setRequireKM(false);
        afastamento.setRequireLicensePlate(false);
        afastamento.setRequireOthers(false);
        afastamento.setRequireRoute(false);
        afastamento.setAccountAsAbsenteeism(true);
        afastamento.setLimitRecord(false);
        afastamento.setCountAsMissing(false);
        afastamento.setAllowance(true);
        return afastamento;
    }
}

