/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.ponto.transformer;

import com.touchcomp.basementorclientwebservices.ponto.constants.EnumConstSistemaPonto;
import com.touchcomp.basementorclientwebservices.ponto.model.abono.DTOPontoAbono;
import com.touchcomp.basementorclientwebservices.ponto.model.cargo.DTOPontoCargo;
import com.touchcomp.basementorclientwebservices.ponto.model.demissao.DTOPontoDemissao;
import com.touchcomp.basementorclientwebservices.ponto.model.departamento.DTOPontoDepartamento;
import com.touchcomp.basementorclientwebservices.ponto.model.empresaintegracao.DTOPontoEmpresaIntegracao;
import com.touchcomp.basementorclientwebservices.ponto.model.funcao.DTOPontoFuncao;
import com.touchcomp.basementorclientwebservices.ponto.model.funcionario.DTOPontoFuncionario;
import com.touchcomp.basementorclientwebservices.ponto.model.horario.DTOPontoHorario;
import com.touchcomp.basementorexceptions.exceptions.impl.integracaoponto.EnumExcepIntegracaoPontoEletronico;
import com.touchcomp.basementorexceptions.exceptions.impl.integracaoponto.ExceptionIntegracaoPontoEletronico;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class PontoBaseTransform
extends ToolMethods {
    public static PontoBaseTransform getTransform(EnumConstSistemaPonto sistema) throws ExceptionIntegracaoPontoEletronico {
        try {
            if (PontoBaseTransform.isNull((Object)((Object)sistema)).booleanValue()) {
                throw new ExceptionIntegracaoPontoEletronico(EnumExcepIntegracaoPontoEletronico.TRANSFORMER_NAO_LOZALIZADO, new Object[]{"NONE"});
            }
            List clazz = ToolReflections.getClassesFromInterface((String)"com.touchcomp.basementorclientwebservices.ponto.transformer.impl", PontoBaseTransform.class);
            if (TMethods.isWithData((Collection)clazz)) {
                for (Class c : clazz) {
                    PontoBaseTransform transform = (PontoBaseTransform)((Object)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    if (!PontoBaseTransform.isEquals((Object)((Object)transform.sistema()), (Object)((Object)sistema))) continue;
                    return transform;
                }
            }
            throw new ExceptionIntegracaoPontoEletronico(EnumExcepIntegracaoPontoEletronico.TRANSFORMER_NAO_LOZALIZADO, new Object[]{sistema.getDescricao()});
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            Logger.getLogger(PontoBaseTransform.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIntegracaoPontoEletronico(EnumExcepIntegracaoPontoEletronico.TRANSFORMER_NAO_LOZALIZADO, new Object[]{sistema.getDescricao(), ex.getMessage()});
        }
    }

    protected abstract String buildEmpresaIntegracao(DTOPontoEmpresaIntegracao var1);

    public String empresaIntegracao(DTOPontoEmpresaIntegracao dto) throws ExceptionInvalidData {
        if (PontoBaseTransform.isNull((Object)dto).booleanValue()) {
            throw new ExceptionInvalidData("Informe os dados da empresa para sincroniza\u00e7\u00e3o.", new Object[0]);
        }
        return this.buildEmpresaIntegracao(dto);
    }

    protected abstract String buildDemissao(DTOPontoDemissao var1);

    public String demissao(DTOPontoDemissao dto) throws ExceptionInvalidData {
        if (PontoBaseTransform.isNull((Object)dto).booleanValue()) {
            throw new ExceptionInvalidData("Informe os dados da demiss\u00e3o para sincroniza\u00e7\u00e3o.", new Object[0]);
        }
        return this.buildDemissao(dto);
    }

    protected abstract String buildCargo(DTOPontoCargo var1);

    public String cargo(DTOPontoCargo dto) throws ExceptionInvalidData {
        if (PontoBaseTransform.isNull((Object)dto).booleanValue()) {
            throw new ExceptionInvalidData("Informe os dados do cargo para sincroniza\u00e7\u00e3o.", new Object[0]);
        }
        return this.buildCargo(dto);
    }

    protected abstract String buildDepartamento(DTOPontoDepartamento var1);

    public String departamento(DTOPontoDepartamento dto) throws ExceptionInvalidData {
        if (PontoBaseTransform.isNull((Object)dto).booleanValue()) {
            throw new ExceptionInvalidData("Informe os dados do departamento para sincroniza\u00e7\u00e3o.", new Object[0]);
        }
        return this.buildDepartamento(dto);
    }

    protected abstract String buildFuncionario(DTOPontoFuncionario var1);

    public String funcionario(DTOPontoFuncionario dto) throws ExceptionInvalidData {
        if (PontoBaseTransform.isNull((Object)dto).booleanValue()) {
            throw new ExceptionInvalidData("Informe os dados do departamento para sincroniza\u00e7\u00e3o.", new Object[0]);
        }
        return this.buildFuncionario(dto);
    }

    protected abstract String buildHorario(DTOPontoHorario var1);

    public String horario(DTOPontoHorario dto) throws ExceptionInvalidData {
        if (PontoBaseTransform.isNull((Object)dto).booleanValue()) {
            throw new ExceptionInvalidData("Informe os dados do departamento para sincroniza\u00e7\u00e3o.", new Object[0]);
        }
        return this.buildHorario(dto);
    }

    protected abstract String buildAbono(DTOPontoAbono var1);

    public String abono(DTOPontoAbono dto) throws ExceptionInvalidData {
        if (PontoBaseTransform.isNull((Object)dto).booleanValue()) {
            throw new ExceptionInvalidData("Informe os dados do departamento para sincroniza\u00e7\u00e3o.", new Object[0]);
        }
        return this.buildAbono(dto);
    }

    protected abstract String buildFuncao(DTOPontoFuncao var1);

    public String funcao(DTOPontoFuncao dto) throws ExceptionInvalidData {
        if (PontoBaseTransform.isNull((Object)dto).booleanValue()) {
            throw new ExceptionInvalidData("Informe os dados da fun\u00e7\u00e3o para sincroniza\u00e7\u00e3o.", new Object[0]);
        }
        return this.buildFuncao(dto);
    }

    protected abstract EnumConstSistemaPonto sistema();

    protected Long getTime(Date data) {
        if (PontoBaseTransform.isNotNull((Object)data).booleanValue()) {
            return data.getTime();
        }
        return 0L;
    }
}

