/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.ponto.transformer.impl;

import com.touchcomp.basementor.constants.enums.EnumConstGenero;
import com.touchcomp.basementorclientwebservices.ponto.constants.EnumConstSistemaPonto;
import com.touchcomp.basementorclientwebservices.ponto.model.abono.DTOPontoAbono;
import com.touchcomp.basementorclientwebservices.ponto.model.cargo.DTOPontoCargo;
import com.touchcomp.basementorclientwebservices.ponto.model.demissao.DTOPontoDemissao;
import com.touchcomp.basementorclientwebservices.ponto.model.departamento.DTOPontoDepartamento;
import com.touchcomp.basementorclientwebservices.ponto.model.empresaintegracao.DTOPontoEmpresaIntegracao;
import com.touchcomp.basementorclientwebservices.ponto.model.funcao.DTOPontoFuncao;
import com.touchcomp.basementorclientwebservices.ponto.model.funcionario.DTOPontoFuncionario;
import com.touchcomp.basementorclientwebservices.ponto.model.horario.DTOPontoHorario;
import com.touchcomp.basementorclientwebservices.ponto.transformer.PontoBaseTransform;
import com.touchcomp.basementortools.tools.string.ToolString;
import org.json.JSONArray;
import org.json.JSONObject;

public class TangerinoTransform
extends PontoBaseTransform {
    @Override
    protected String buildEmpresaIntegracao(DTOPontoEmpresaIntegracao dto) {
        JSONObject builder = new JSONObject();
        builder.put("cnpj", (Object)ToolString.refina((String)dto.getCnpj()));
        builder.put("cnpjMask", JSONObject.NULL);
        builder.put("descriptionName", (Object)dto.getNome());
        builder.put("externalId", (Object)String.valueOf(dto.getIdEmpresa()));
        builder.put("fantasyName", (Object)dto.getNomeFantasia());
        builder.put("id", JSONObject.NULL);
        builder.put("socialReason", JSONObject.NULL);
        return builder.toString();
    }

    @Override
    protected String buildDemissao(DTOPontoDemissao dto) {
        JSONObject builder = new JSONObject();
        builder.put("externalId", (Object)dto.getIdentificador());
        builder.put("resignationDate", (Object)this.getTime(dto.getDtDemissao()));
        builder.put("tangerinoId", JSONObject.NULL);
        return builder.toString();
    }

    @Override
    protected String buildCargo(DTOPontoCargo dto) {
        JSONObject builder = new JSONObject();
        builder.put("alterationDate", (Object)dto.getAlterationDate());
        builder.put("description", (Object)dto.getDescricao());
        builder.put("cbo", (Object)dto.getCbo());
        builder.put("cboId", (Object)dto.getCboId());
        builder.put("externalId", (Object)dto.getExternalId());
        builder.put("id", (Object)dto.getId());
        builder.put("message", (Object)dto.getMessage());
        this.buildEmployer(builder, dto);
        this.buildSalary(builder, dto);
        return builder.toString();
    }

    private void buildSalary(JSONObject builder, DTOPontoCargo dtoCargo) {
        if (TangerinoTransform.isNotNull((Object)dtoCargo.getSalary()).booleanValue()) {
            JSONObject salary = new JSONObject();
            DTOPontoCargo.DTOSalario dto = dtoCargo.getSalary();
            salary.put("description", (Object)dto.getDescription());
            salary.put("salaryTypeId", (Object)dto.getSalaryTypeId());
            salary.put("value", (Object)dto.getValue());
            builder.put("salary", (Object)salary);
        } else {
            builder.put("salary", JSONObject.NULL);
        }
    }

    private void buildEmployer(JSONObject builder, DTOPontoCargo dtoCargo) {
        if (TangerinoTransform.isNotNull((Object)dtoCargo.getEmployer()).booleanValue()) {
            JSONObject employerDTO = new JSONObject();
            DTOPontoCargo.DTOEmpregador dto = dtoCargo.getEmployer();
            employerDTO.put("accountStatus", (Object)dto.getAccountStatus());
            employerDTO.put("address", (Object)dto.getAddress());
            employerDTO.put("channelName", (Object)dto.getChannelName());
            employerDTO.put("city", (Object)dto.getCity());
            employerDTO.put("companyName", (Object)dto.getCompanyName());
            employerDTO.put("complement", (Object)dto.getComplement());
            employerDTO.put("countryOrigin", (Object)dto.getCountryOrigin());
            employerDTO.put("currentlyPerformsPunch", (Object)dto.getCurrentlyPerformsPunch());
            employerDTO.put("document", (Object)dto.getDocument());
            employerDTO.put("email", (Object)dto.getEmail());
            employerDTO.put("employeeRange", (Object)dto.getEmployeeRange());
            employerDTO.put("externalCode", (Object)dto.getExternalCode());
            employerDTO.put("hashIdCadastroUnificado", (Object)dto.getHashIdCadastroUnificado());
            employerDTO.put("id", (Object)dto.getId());
            employerDTO.put("message", (Object)dto.getMessage());
            employerDTO.put("neighborhood", (Object)dto.getNeighborhood());
            employerDTO.put("number", (Object)dto.getNumber());
            employerDTO.put("origin", (Object)dto.getOrigin());
            employerDTO.put("password", (Object)dto.getPassword());
            employerDTO.put("phone", (Object)dto.getPhone());
            employerDTO.put("planExternalCode", (Object)dto.getPlanExternalCode());
            employerDTO.put("planNumberLicenses", (Object)dto.getPlanNumberLicenses());
            employerDTO.put("platform", (Object)dto.getPlatform());
            employerDTO.put("receiveNews", (Object)dto.getReceiveNews());
            employerDTO.put("role", (Object)dto.getRole());
            employerDTO.put("sellerCode", (Object)dto.getSellerCode());
            employerDTO.put("sponsorName", (Object)dto.getSponsorName());
            employerDTO.put("state", (Object)dto.getState());
            employerDTO.put("syncIntegration", (Object)dto.getSyncIntegration());
            employerDTO.put("token", (Object)dto.getToken());
            employerDTO.put("tokenIntegration", (Object)dto.getTokenIntegration());
            employerDTO.put("zipCode", (Object)dto.getZipCode());
            employerDTO.put("employerDTO", (Object)employerDTO);
        } else {
            builder.put("employerDTO", JSONObject.NULL);
        }
    }

    @Override
    protected String buildDepartamento(DTOPontoDepartamento dto) {
        JSONObject builder = new JSONObject();
        builder.put("name", (Object)dto.getDescricao());
        builder.put("externalId", (Object)dto.getExternalId());
        builder.put("id", (Object)dto.getIdentificador());
        builder.put("message", (Object)"");
        return builder.toString();
    }

    @Override
    protected String buildFuncionario(DTOPontoFuncionario dto) {
        JSONObject builder = new JSONObject();
        builder.put("admissionDate", (Object)this.getTime(dto.getDtaadmissao()));
        builder.put("birthDate", (Object)this.getTime(dto.getDtnascimento()));
        builder.put("cellphone", (Object)dto.getCellphone());
        builder.put("ci", (Object)"");
        builder.put("company", (Object)dto.getIdEmpresa());
        builder.put("companyExternalId", JSONObject.NULL);
        builder.put("corporateEmail", (Object)dto.getEmailCorporativo());
        builder.put("costCenter", (Object)"");
        builder.put("cpf", (Object)dto.getCpf());
        builder.put("ctps", (Object)dto.getCtps());
        builder.put("doubleBindEmployee", false);
        builder.put("effectiveDate", (Object)this.getTime(dto.getDtaadmissao()));
        builder.put("email", (Object)dto.getEmail());
        builder.put("esocialRegistration", (Object)"");
        builder.put("externalId", (Object)String.valueOf(dto.getIdentificador()));
        builder.put("foreignNational", false);
        builder.put("functionExternalId", (Object)String.valueOf(dto.getIdFuncao()));
        builder.put("functionId", JSONObject.NULL);
        if (dto.getSexo() != null) {
            EnumConstGenero genero = EnumConstGenero.get((Object)dto.getSexo());
            builder.put("gender", (Object)genero.getDescricao().toUpperCase());
        }
        builder.put("hasChildren", false);
        builder.put("id", JSONObject.NULL);
        builder.put("integration", false);
        builder.put("intern", false);
        builder.put("jobRole", JSONObject.NULL);
        builder.put("jobRoleDescription", (Object)"");
        builder.put("jobRoleExternalId", (Object)String.valueOf(dto.getIdCargo()));
        builder.put("message", (Object)"");
        builder.put("modulePro", false);
        builder.put("name", (Object)dto.getName());
        if (ToolString.isALongNumber((String)dto.getPhone())) {
            builder.put("phone", (Object)Long.valueOf(dto.getPhone()));
            builder.put("commercialPhone", (Object)Long.valueOf(dto.getPhone()));
        }
        builder.put("photoUrl", (Object)"");
        builder.put("pis", (Object)dto.getPis());
        builder.put("punchRuleDateInMillis", 0);
        builder.put("punchRuleExternalId", (Object)"");
        builder.put("series", (Object)dto.getSerie());
        builder.put("shirtSize", (Object)"");
        builder.put("socialName", (Object)"");
        builder.put("state", (Object)"");
        builder.put("tangerinoId", 0);
        builder.put("timezone", (Object)"SAO_PAULO");
        if (dto.getRegimeTributario() != null) {
            builder.put("typeOfLaborRelationship", (Object)dto.getRegimeTributario().toUpperCase());
        }
        builder.put("workSchedule", JSONObject.NULL);
        builder.put("workScheduleDateInMillis", JSONObject.NULL);
        builder.put("workScheduleExternalId", JSONObject.NULL);
        builder.put("workplace", JSONObject.NULL);
        builder.put("workplaceExternalId", (Object)String.valueOf(dto.getIdDepartamento()));
        this.buildModules(builder, dto);
        this.buildDevicePermissions(builder, dto);
        return builder.toString();
    }

    private void buildModules(JSONObject builder, DTOPontoFuncionario dto) {
        JSONArray modules = new JSONArray();
        builder.put("modules", (Object)modules);
    }

    private void buildDevicePermissions(JSONObject builder, DTOPontoFuncionario dto) {
        JSONObject devicePermissions = new JSONObject();
        JSONObject appPermissions = new JSONObject();
        appPermissions.put("allowDisablePunchReminder", false);
        appPermissions.put("allowHoursBalance", false);
        appPermissions.put("appAuthorization", (Object)"NONE");
        appPermissions.put("canViewWorkgroup", false);
        appPermissions.put("enableIndividualUsage", false);
        appPermissions.put("enableQRCode", false);
        appPermissions.put("onlyInterestPlaces", false);
        appPermissions.put("requireSpecificInteressePlace", false);
        appPermissions.put("requiresLateUploadPhoto", false);
        appPermissions.put("requiresRouteInfo", false);
        appPermissions.put("requiresUploadPhoto", false);
        devicePermissions.put("appPermissionsDTO", (Object)appPermissions);
        devicePermissions.put("editPunchManually", false);
        JSONObject webPermissions = new JSONObject();
        webPermissions.put("requiresFingerPrint", false);
        webPermissions.put("requiresLocation", false);
        webPermissions.put("requiresUploadPhoto", false);
        webPermissions.put("webAuthorization", (Object)"NONE");
        devicePermissions.put("webPermissionsDTO", (Object)webPermissions);
        builder.put("devicePermissionsDTO", (Object)devicePermissions);
    }

    @Override
    protected String buildHorario(DTOPontoHorario dto) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected String buildAbono(DTOPontoAbono dto) {
        JSONObject builder = new JSONObject();
        builder.put("adjustmentReasonId", (Object)dto.getTipoAjuste());
        builder.put("attachment", JSONObject.NULL);
        builder.put("employerDTO", JSONObject.NULL);
        builder.put("edited", false);
        builder.put("employeeExternalId", (Object)String.valueOf(dto.getIdColaborador()));
        builder.put("employeeId", JSONObject.NULL);
        builder.put("employerId", JSONObject.NULL);
        builder.put("endDate", (Object)this.getTime(dto.getDtFim()));
        builder.put("firstDayIsPartial", false);
        builder.put("fullDay", true);
        builder.put("hourMeter", JSONObject.NULL);
        builder.put("id", JSONObject.NULL);
        builder.put("km", JSONObject.NULL);
        builder.put("licencePlate", JSONObject.NULL);
        builder.put("origem", dto.getOrigem() != null ? dto.getOrigem() : JSONObject.NULL);
        builder.put("observation", dto.getObservao() != null ? dto.getObservao() : builder.get("origem"));
        builder.put("others", (Object)"");
        builder.put("photoUrl", JSONObject.NULL);
        builder.put("route", JSONObject.NULL);
        builder.put("status", (Object)"APROVADO");
        builder.put("startDate", (Object)this.getTime(dto.getDtInicio()));
        return builder.toString();
    }

    @Override
    protected String buildFuncao(DTOPontoFuncao dto) {
        JSONObject builder = new JSONObject();
        builder.put("externalId", (Object)dto.getIdentificador());
        builder.put("description", (Object)dto.getDescricao());
        return builder.toString();
    }

    @Override
    protected EnumConstSistemaPonto sistema() {
        return EnumConstSistemaPonto.TANGERINO;
    }
}

