/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.reinf.impl.evtcomercioprodrural;

import com.touchcomp.basementor.model.vo.NotaPropriaComercializacaoRural;
import com.touchcomp.basementor.model.vo.R1000;
import com.touchcomp.basementor.model.vo.ReinfClienteComRural;
import com.touchcomp.basementor.model.vo.ReinfComercializacaoProducaoRural;
import com.touchcomp.basementor.model.vo.ReinfEvento;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementorclientwebservices.reinf.DocReinfBaseImpl;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evtinfoprodrural.v2_01_02.ObjectFactory;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evtinfoprodrural.v2_01_02.Reinf;
import com.touchcomp.basementorclientwebservices.reinf.tools.ToolReinf;
import com.touchcomp.basementorexceptions.exceptions.impl.reinf.ExceptionReinf;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Date;

public class ImpEvtComercioProdRural
extends DocReinfBaseImpl {
    @Override
    public Reinf getRootEvento(ReinfEvento evento, R1000 opcoesReinf) throws ExceptionReinf {
        return this.getRootEvento(evento.getPreEvento(), opcoesReinf);
    }

    @Override
    public Reinf getRootEvento(ReinfPreEvento preEvento, R1000 opcoesReinf) throws ExceptionReinf {
        Reinf root = this.getFact().createReinf();
        root.setEvtComProd(this.getEvtComProducao(preEvento, opcoesReinf));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private Reinf.EvtComProd getEvtComProducao(ReinfPreEvento preEvento, R1000 opcoes) throws ExceptionReinf {
        Reinf.EvtComProd rural = this.getFact().createReinfEvtComProd();
        rural.setId(preEvento.getReinfEvento().getIdTagEventoReinf());
        rural.setIdeContri(this.getIdeContribuinte(opcoes));
        rural.setIdeEvento(this.getIdeEvento(preEvento.getReinfEvento()));
        rural.setInfoComProd(this.getInfoComProducao(preEvento));
        return rural;
    }

    private Reinf.EvtComProd.IdeContri getIdeContribuinte(R1000 opcoes) throws ExceptionReinf {
        Reinf.EvtComProd.IdeContri empregador = this.getFact().createReinfEvtComProdIdeContri();
        String tipoInscricao = ToolReinf.getTipoInscricaoEmpregador(opcoes.getEmpresa().getPessoa().getComplemento().getTipoPessoa());
        empregador.setTpInsc(Byte.parseByte(tipoInscricao));
        empregador.setNrInsc(ToolReinf.getNrInscricaoEmpresa(opcoes.getEmpresa()));
        return empregador;
    }

    private Reinf.EvtComProd.IdeEvento getIdeEvento(ReinfEvento evt) {
        Reinf.EvtComProd.IdeEvento cadastro = this.getFact().createReinfEvtComProdIdeEvento();
        if (evt.getPreEvento().getEventoRetificacao() != null && evt.getPreEvento().getEventoRetificacao().equals((short)1)) {
            cadastro.setIndRetif((short)2);
            cadastro.setNrRecibo(evt.getPreEvento().getEventoAnterior().getReinfEvento().getNrRecibo().trim());
        } else {
            cadastro.setIndRetif((short)1);
        }
        cadastro.setPerApur(ToolDate.formatDateAnoMes((Date)evt.getPreEvento().getReinfComercializacaoRural().getPeriodoReferencia()));
        cadastro.setTpAmb(Byte.parseByte(evt.getReinfLoteEventos().getIdentificacaoAmbiente().getCodigo().toString()));
        cadastro.setProcEmi(Byte.parseByte("1"));
        cadastro.setVerProc(this.getVersaoEsocialSistema());
        return cadastro;
    }

    private Reinf.EvtComProd.InfoComProd getInfoComProducao(ReinfPreEvento preEvento) {
        Reinf.EvtComProd.InfoComProd info = this.getFact().createReinfEvtComProdInfoComProd();
        info.setIdeEstab(this.getIdeEst(preEvento));
        return info;
    }

    private Reinf.EvtComProd.InfoComProd.IdeEstab getIdeEst(ReinfPreEvento preEvento) {
        Reinf.EvtComProd.InfoComProd.IdeEstab ide = this.getFact().createReinfEvtComProdInfoComProdIdeEstab();
        ide.setTpInscEstab(Byte.parseByte("1"));
        ide.setNrInscEstab(ToolString.refina((String)preEvento.getReinfComercializacaoRural().getEmpresa().getPessoa().getComplemento().getCnpj()));
        ide.setVlrRecBrutaTotal(this.getReceitaBruta(preEvento.getReinfComercializacaoRural()));
        ide.setVlrCPApur(this.getTotalInss(preEvento.getReinfComercializacaoRural()));
        ide.setVlrRatApur(this.getRat(preEvento.getReinfComercializacaoRural()));
        ide.setVlrSenarApur(this.getValorSenar(preEvento.getReinfComercializacaoRural()));
        ide.getTipoCom().add(this.getTipoCom(preEvento.getReinfComercializacaoRural()));
        return ide;
    }

    private String getReceitaBruta(ReinfComercializacaoProducaoRural reinfComercializacaoRural) {
        Double valorTotal = 0.0;
        for (ReinfClienteComRural cliente : reinfComercializacaoRural.getClienteProdRural()) {
            valorTotal = valorTotal + ToolFormatter.arrredondarNumero((Double)cliente.getValorBrutoAquisicao(), (int)2);
            valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        }
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        Integer inteira = valorTotal.intValue();
        Integer decimal = (int)Math.round((valorTotal - (double)valorTotal.intValue()) * 100.0);
        String numero = decimal.toString().length() == 1 ? inteira.toString() + ",0" + decimal.toString() : inteira.toString() + "," + decimal.toString();
        return numero;
    }

    private String getTotalInss(ReinfComercializacaoProducaoRural reinfComercializacaoRural) {
        Double valorTotal = 0.0;
        for (ReinfClienteComRural cliente : reinfComercializacaoRural.getClienteProdRural()) {
            for (NotaPropriaComercializacaoRural nota : cliente.getNotas()) {
                valorTotal = valorTotal + ToolFormatter.arrredondarNumero((Double)nota.getNotaPropria().getValoresNfPropria().getValorInss(), (int)2);
                valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
            }
        }
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        Integer inteira = valorTotal.intValue();
        Integer decimal = (int)Math.round((valorTotal - (double)valorTotal.intValue()) * 100.0);
        String numero = decimal.toString().length() == 1 ? inteira.toString() + ",0" + decimal.toString() : inteira.toString() + "," + decimal.toString();
        return numero;
    }

    private String getRat(ReinfComercializacaoProducaoRural reinfComercializacaoRural) {
        Double valorTotal = 0.0;
        for (ReinfClienteComRural cliente : reinfComercializacaoRural.getClienteProdRural()) {
            for (NotaPropriaComercializacaoRural nota : cliente.getNotas()) {
                valorTotal = valorTotal + ToolFormatter.arrredondarNumero((Double)nota.getNotaPropria().getValoresNfPropria().getValorRAT(), (int)2);
                valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
            }
        }
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        Integer inteira = valorTotal.intValue();
        Integer decimal = (int)Math.round((valorTotal - (double)valorTotal.intValue()) * 100.0);
        String numero = decimal.toString().length() == 1 ? inteira.toString() + ",0" + decimal.toString() : inteira.toString() + "," + decimal.toString();
        return numero;
    }

    private String getValorSenar(ReinfComercializacaoProducaoRural reinfComercializacaoRural) {
        Double valorTotal = 0.0;
        for (ReinfClienteComRural cliente : reinfComercializacaoRural.getClienteProdRural()) {
            for (NotaPropriaComercializacaoRural nota : cliente.getNotas()) {
                valorTotal = valorTotal + ToolFormatter.arrredondarNumero((Double)nota.getNotaPropria().getValoresNfPropria().getValorSenar(), (int)2);
                valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
            }
        }
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        Integer inteira = valorTotal.intValue();
        Integer decimal = (int)Math.round((valorTotal - (double)valorTotal.intValue()) * 100.0);
        String numero = decimal.toString().length() == 1 ? inteira.toString() + ",0" + decimal.toString() : inteira.toString() + "," + decimal.toString();
        return numero;
    }

    private Reinf.EvtComProd.InfoComProd.IdeEstab.TipoCom getTipoCom(ReinfComercializacaoProducaoRural reinfComercializacaoRural) {
        Reinf.EvtComProd.InfoComProd.IdeEstab.TipoCom tipoCom = this.getFact().createReinfEvtComProdInfoComProdIdeEstabTipoCom();
        tipoCom.setIndCom(Short.parseShort(reinfComercializacaoRural.getTipoComercializacaao().getCodigo()));
        tipoCom.setVlrRecBruta(this.getReceitaBruta(reinfComercializacaoRural));
        return tipoCom;
    }
}

