/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.reinf.impl.evtpagamentorendimentojuridica;

import com.touchcomp.basementor.model.vo.ItemReinf4020NaoIdentificado;
import com.touchcomp.basementor.model.vo.R1000;
import com.touchcomp.basementor.model.vo.ReinfEvento;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementorclientwebservices.reinf.DocReinfBaseImpl;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evt4020pagtobeneficiariopj.v2_01_02.ObjectFactory;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evt4020pagtobeneficiariopj.v2_01_02.Reinf;
import com.touchcomp.basementorclientwebservices.reinf.tools.ToolReinf;
import com.touchcomp.basementorexceptions.exceptions.impl.reinf.ExceptionReinf;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import java.util.Date;

public class ImpEvt4020PagRendimentoJuridicaNaoIdentificada
extends DocReinfBaseImpl {
    @Override
    public Reinf getRootEvento(ReinfEvento preEvento, R1000 opcoes) throws ExceptionReinf {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public Reinf getRootEvento(ReinfPreEvento preEvento, R1000 opcoes) throws ExceptionReinf {
        Reinf root = this.getFact().createReinf();
        root.setEvtRetPJ(this.getEvtRetPJ(preEvento, opcoes));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private Reinf.EvtRetPJ getEvtRetPJ(ReinfPreEvento preEvento, R1000 opcoes) throws ExceptionReinf {
        Reinf.EvtRetPJ evt = this.getFact().createReinfEvtRetPJ();
        evt.setId(preEvento.getReinfEvento().getIdTagEventoReinf());
        evt.setIdeContri(this.getIdeContribuinte(opcoes));
        evt.setIdeEvento(this.getIdeEvento(preEvento.getReinfEvento()));
        evt.setIdeEstab(this.getEstabelecimento(preEvento, opcoes));
        return evt;
    }

    private Reinf.EvtRetPJ.IdeContri getIdeContribuinte(R1000 opcoes) throws ExceptionReinf {
        Reinf.EvtRetPJ.IdeContri empregador = this.getFact().createReinfEvtRetPJIdeContri();
        String tipoInscricao = ToolReinf.getTipoInscricaoEmpregador(opcoes.getEmpresa().getPessoa().getComplemento().getTipoPessoa());
        empregador.setTpInsc(Byte.parseByte(tipoInscricao));
        empregador.setNrInsc(ToolReinf.getNrInscricaoEmpresa(opcoes.getEmpresa()));
        return empregador;
    }

    private Reinf.EvtRetPJ.IdeEvento getIdeEvento(ReinfEvento evt) {
        Reinf.EvtRetPJ.IdeEvento cadastro = this.getFact().createReinfEvtRetPJIdeEvento();
        if (evt.getPreEvento().getEventoRetificacao() != null && evt.getPreEvento().getEventoRetificacao().equals((short)1)) {
            cadastro.setIndRetif((short)2);
            cadastro.setNrRecibo(evt.getPreEvento().getEventoAnterior().getReinfEvento().getNrRecibo().trim());
        } else {
            cadastro.setIndRetif((short)1);
        }
        cadastro.setPerApur(ToolDate.formatDateAnoMes((Date)evt.getPreEvento().getItemReinfNaoId().getApuracao().getPeriodo()));
        cadastro.setTpAmb(Byte.parseByte(evt.getReinfLoteEventos().getIdentificacaoAmbiente().getCodigo().toString()));
        cadastro.setProcEmi(Byte.parseByte("1"));
        cadastro.setVerProc(this.getVersaoEsocialSistema());
        return cadastro;
    }

    private Reinf.EvtRetPJ.IdeEstab getEstabelecimento(ReinfPreEvento preEvento, R1000 opcoes) {
        Reinf.EvtRetPJ.IdeEstab est = this.getFact().createReinfEvtRetPJIdeEstab();
        est.setTpInscEstab(Short.parseShort("1"));
        est.setNrInscEstab(preEvento.getItemReinfNaoId().getEmpresa().getPessoa().getComplemento().getCnpj());
        est.setIdeBenef(this.getIdentificadorBeneficario(preEvento, opcoes));
        return est;
    }

    private Reinf.EvtRetPJ.IdeEstab.IdeBenef getIdentificadorBeneficario(ReinfPreEvento preEvento, R1000 opcoes) {
        Reinf.EvtRetPJ.IdeEstab.IdeBenef ideBen = this.getFact().createReinfEvtRetPJIdeEstabIdeBenef();
        ideBen.setCnpjBenef(preEvento.getItemReinfNaoId().getCpf());
        ideBen.getIdePgto().add(this.getIdePagamento(preEvento.getItemReinfNaoId()));
        return ideBen;
    }

    private Reinf.EvtRetPJ.IdeEstab.IdeBenef.IdePgto getIdePagamento(ItemReinf4020NaoIdentificado itemNota) {
        Reinf.EvtRetPJ.IdeEstab.IdeBenef.IdePgto idePagamento = this.getFact().createReinfEvtRetPJIdeEstabIdeBenefIdePgto();
        idePagamento.setNatRend(itemNota.getNaturezaRendimento().getCodigo());
        idePagamento.setObserv("OBSERVACAO");
        idePagamento.getInfoPgto().add(this.getInfoPagamento(itemNota));
        return idePagamento;
    }

    private Reinf.EvtRetPJ.IdeEstab.IdeBenef.IdePgto.InfoPgto getInfoPagamento(ItemReinf4020NaoIdentificado itemNota) {
        Reinf.EvtRetPJ.IdeEstab.IdeBenef.IdePgto.InfoPgto info = this.getFact().createReinfEvtRetPJIdeEstabIdeBenefIdePgtoInfoPgto();
        info.setDtFG(ToolDate.formatDateAnoMesDia((Date)itemNota.getDataPagamento()));
        info.setVlrBruto(this.getValor(itemNota.getValorBruto()));
        info.setRetencoes(this.getRetencoes(itemNota));
        return info;
    }

    private String getValor(Double valorTotal) {
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        Integer inteira = valorTotal.intValue();
        Integer decimal = (int)Math.round((valorTotal - (double)valorTotal.intValue()) * 100.0);
        String numero = decimal.toString().length() == 1 ? inteira.toString() + ",0" + decimal.toString() : inteira.toString() + "," + decimal.toString();
        return numero;
    }

    private Reinf.EvtRetPJ.IdeEstab.IdeBenef.IdePgto.InfoPgto.Retencoes getRetencoes(ItemReinf4020NaoIdentificado item) {
        Reinf.EvtRetPJ.IdeEstab.IdeBenef.IdePgto.InfoPgto.Retencoes ret = this.getFact().createReinfEvtRetPJIdeEstabIdeBenefIdePgtoInfoPgtoRetencoes();
        if (item.getValorIrrf() > 0.0) {
            ret.setVlrBaseIR(this.getValor(item.getBaseIrrf()));
            ret.setVlrIR(this.getValor(item.getValorIrrf()));
        }
        if (item.getValorAgregado() == 0.0 && item.getValorCsll() > 0.0) {
            ret.setVlrBaseCSLL(this.getValor(item.getBaseCsll()));
            ret.setVlrCSLL(this.getValor(item.getValorCsll()));
        }
        if (item.getValorAgregado() == 0.0 && item.getValorCofins() > 0.0) {
            ret.setVlrBaseCofins(this.getValor(item.getBaseCofins()));
            ret.setVlrCofins(this.getValor(item.getValorCofins()));
        }
        if (item.getValorAgregado() == 0.0 && item.getValorPis() > 0.0) {
            ret.setVlrBasePP(this.getValor(item.getBasePis()));
            ret.setVlrPP(this.getValor(item.getValorPis()));
        }
        if (item.getValorAgregado() > 0.0) {
            ret.setVlrBaseAgreg(this.getValor(item.getBaseAgregado()));
            ret.setVlrAgreg(this.getValor(item.getValorAgregado()));
        }
        return ret;
    }
}

