/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.reinf.impl.evtprestadorservicos;

import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemReinf2020;
import com.touchcomp.basementor.model.vo.ItemReinfNotas2020;
import com.touchcomp.basementor.model.vo.R1000;
import com.touchcomp.basementor.model.vo.ReinfEvento;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorclientwebservices.reinf.DocReinfBaseImpl;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evtprestadorservicos.v2_01_02.ObjectFactory;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evtprestadorservicos.v2_01_02.Reinf;
import com.touchcomp.basementorclientwebservices.reinf.tools.ToolReinf;
import com.touchcomp.basementorexceptions.exceptions.impl.reinf.ExceptionReinf;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;

public class ImplServicosPrestados
extends DocReinfBaseImpl {
    @Override
    public Reinf getRootEvento(ReinfEvento preEvento, R1000 opcoesReinf) throws ExceptionReinf {
        return this.getRootEvento(preEvento.getPreEvento(), opcoesReinf);
    }

    @Override
    public Reinf getRootEvento(ReinfPreEvento preEvento, R1000 opcoes) throws ExceptionReinf {
        Reinf root = this.getFact().createReinf();
        root.setEvtServPrest(this.getEvtServicosPrestados(preEvento, opcoes));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private Reinf.EvtServPrest getEvtServicosPrestados(ReinfPreEvento preEvento, R1000 opcoes) throws ExceptionReinf {
        Reinf.EvtServPrest servTom = new Reinf.EvtServPrest();
        servTom.setId(preEvento.getReinfEvento().getIdTagEventoReinf());
        servTom.setIdeContri(this.getIdeContribuinte(opcoes));
        servTom.setIdeEvento(this.getIdeEvento(preEvento.getReinfEvento()));
        servTom.setInfoServPrest(this.getInfServicosPrestados(preEvento));
        return servTom;
    }

    private Reinf.EvtServPrest.IdeContri getIdeContribuinte(R1000 opcoes) throws ExceptionReinf {
        Reinf.EvtServPrest.IdeContri empregador = this.getFact().createReinfEvtServPrestIdeContri();
        String tipoInscricao = ToolReinf.getTipoInscricaoEmpregador(opcoes.getEmpresa().getPessoa().getComplemento().getTipoPessoa());
        empregador.setTpInsc(Byte.parseByte(tipoInscricao));
        empregador.setNrInsc(ToolReinf.getNrInscricaoEmpresa(opcoes.getEmpresa()));
        return empregador;
    }

    private Reinf.EvtServPrest.IdeEvento getIdeEvento(ReinfEvento evt) {
        Reinf.EvtServPrest.IdeEvento cadastro = this.getFact().createReinfEvtServPrestIdeEvento();
        if (evt.getPreEvento().getEventoRetificacao() != null && evt.getPreEvento().getEventoRetificacao().equals((short)1)) {
            cadastro.setIndRetif((short)2);
            cadastro.setNrRecibo(evt.getPreEvento().getEventoAnterior().getReinfEvento().getNrRecibo().trim());
        } else {
            cadastro.setIndRetif((short)1);
        }
        cadastro.setPerApur(ToolDate.formatDateAnoMes((Date)evt.getPreEvento().getItemReinf2020().getApuracaoReinf().getPeriodo()));
        cadastro.setTpAmb(Byte.parseByte(evt.getReinfLoteEventos().getIdentificacaoAmbiente().getCodigo().toString()));
        cadastro.setProcEmi(Byte.parseByte("1"));
        cadastro.setVerProc(this.getVersaoEsocialSistema());
        return cadastro;
    }

    private Reinf.EvtServPrest.InfoServPrest getInfServicosPrestados(ReinfPreEvento preEvento) {
        Reinf.EvtServPrest.InfoServPrest serv = this.getFact().createReinfEvtServPrestInfoServPrest();
        serv.setIdeEstabPrest(this.getIdeEstabPrest(preEvento));
        return serv;
    }

    private Reinf.EvtServPrest.InfoServPrest.IdeEstabPrest getIdeEstabPrest(ReinfPreEvento preEvento) {
        Reinf.EvtServPrest.InfoServPrest.IdeEstabPrest obra = this.getFact().createReinfEvtServPrestInfoServPrestIdeEstabPrest();
        obra.setTpInscEstabPrest(Short.parseShort("1"));
        obra.setNrInscEstabPrest(preEvento.getItemReinf2020().getEmpresa().getPessoa().getComplemento().getCnpj());
        obra.setIdeTomador(this.getIdeTomador(preEvento));
        return obra;
    }

    private Reinf.EvtServPrest.InfoServPrest.IdeEstabPrest.IdeTomador getIdeTomador(ReinfPreEvento preEvento) {
        ItemReinf2020 item = preEvento.getItemReinf2020();
        Reinf.EvtServPrest.InfoServPrest.IdeEstabPrest.IdeTomador prestServ = this.getFact().createReinfEvtServPrestInfoServPrestIdeEstabPrestIdeTomador();
        if (preEvento.getItemReinf2020().getIndicadorObra() == null || preEvento.getItemReinf2020().getIndicadorObra().equals((short)0)) {
            prestServ.setTpInscTomador((short)1);
            prestServ.setNrInscTomador(ToolString.completaCaracter((String)item.getPessoa().getComplemento().getCnpj(), (String)"0", (int)14, (boolean)true));
            prestServ.setIndObra((short)0);
        } else {
            prestServ.setTpInscTomador((short)4);
            prestServ.setNrInscTomador(item.getCno().getCodigo());
            prestServ.setIndObra(item.getIndicadorEmpreitada());
        }
        prestServ.setVlrTotalBruto(this.formatNumber(this.getValorTotalNotas(item), 2));
        prestServ.setVlrTotalBaseRet(this.formatNumber(this.getValorBaseRetencoes(item), 2));
        prestServ.setVlrTotalRetPrinc(this.formatNumber(this.getValorRetencoes(item), 2));
        prestServ.setVlrTotalRetAdic(this.formatNumber(0.0, 2));
        prestServ.setVlrTotalNRetPrinc(this.formatNumber(0.0, 2));
        prestServ.setVlrTotalNRetAdic(this.formatNumber(0.0, 2));
        prestServ.getNfs().addAll(this.getNFs(item));
        return prestServ;
    }

    private Collection<? extends Reinf.EvtServPrest.InfoServPrest.IdeEstabPrest.IdeTomador.Nfs> getNFs(ItemReinf2020 item) {
        ArrayList<Reinf.EvtServPrest.InfoServPrest.IdeEstabPrest.IdeTomador.Nfs> lista = new ArrayList<Reinf.EvtServPrest.InfoServPrest.IdeEstabPrest.IdeTomador.Nfs>();
        for (ItemReinfNotas2020 i : item.getItens()) {
            Reinf.EvtServPrest.InfoServPrest.IdeEstabPrest.IdeTomador.Nfs nf;
            if (i.getRps() != null) {
                nf = this.getFact().createReinfEvtServPrestInfoServPrestIdeEstabPrestIdeTomadorNfs();
                nf.setSerie(i.getRps().getSerie());
                if (i.getRps().getNumeroNFse() != null && i.getRps().getNumeroNFse() > 0L) {
                    nf.setNumDocto(i.getRps().getNumeroNFse().toString());
                } else {
                    nf.setNumDocto(i.getRps().getNumero().toString());
                }
                nf.setDtEmissaoNF(ToolEsocial.converteData(i.getRps().getDataEmissao()));
                nf.setVlrBruto(this.formatNumber(i.getRps().getValorServico(), 2));
                nf.setObs("RPS: " + i.getRps().getNumero().toString());
                nf.getInfoTpServ().addAll(this.getTiposServicoNFs(i));
                lista.add(nf);
                continue;
            }
            if (i.getNotaPropria() == null) continue;
            nf = this.getFact().createReinfEvtServPrestInfoServPrestIdeEstabPrestIdeTomadorNfs();
            nf.setSerie(i.getNotaPropria().getSerie());
            nf.setNumDocto(i.getNotaPropria().getNumeroNota().toString());
            nf.setDtEmissaoNF(ToolEsocial.converteData(i.getNotaPropria().getDataEmissaoNota()));
            nf.setVlrBruto(this.formatNumber(i.getNotaPropria().getValoresNfPropria().getValorTotal(), 2));
            nf.setObs("NF: " + i.getNotaPropria().getNumeroNota().toString());
            nf.getInfoTpServ().addAll(this.getTiposServicoNFs(i));
            lista.add(nf);
        }
        return lista;
    }

    private Collection<? extends Reinf.EvtServPrest.InfoServPrest.IdeEstabPrest.IdeTomador.Nfs.InfoTpServ> getTiposServicoNFs(ItemReinfNotas2020 itemReinf) {
        ArrayList<Reinf.EvtServPrest.InfoServPrest.IdeEstabPrest.IdeTomador.Nfs.InfoTpServ> lista = new ArrayList<Reinf.EvtServPrest.InfoServPrest.IdeEstabPrest.IdeTomador.Nfs.InfoTpServ>();
        HashMap<String, Reinf.EvtServPrest.InfoServPrest.IdeEstabPrest.IdeTomador.Nfs.InfoTpServ> h = new HashMap<String, Reinf.EvtServPrest.InfoServPrest.IdeEstabPrest.IdeTomador.Nfs.InfoTpServ>();
        if (itemReinf.getRps() != null && itemReinf.getRps().getTipoServico() != null) {
            Reinf.EvtServPrest.InfoServPrest.IdeEstabPrest.IdeTomador.Nfs.InfoTpServ tipoServ = this.getFact().createReinfEvtServPrestInfoServPrestIdeEstabPrestIdeTomadorNfsInfoTpServ();
            tipoServ.setTpServico(new BigInteger(itemReinf.getRps().getTipoServico().getCodigo()));
            tipoServ.setVlrBaseRet(this.formatNumber(itemReinf.getRps().getValorServico(), 2));
            tipoServ.setVlrRetencao(this.formatNumber(this.getValorRetidoRPS(itemReinf.getRps()), 2));
            tipoServ.setVlrRetSub(this.formatNumber(0.0, 2));
            tipoServ.setVlrNRetPrinc(this.formatNumber(0.0, 2));
            tipoServ.setVlrServicos15(this.formatNumber(0.0, 2));
            tipoServ.setVlrServicos20(this.formatNumber(0.0, 2));
            tipoServ.setVlrServicos25(this.formatNumber(0.0, 2));
            tipoServ.setVlrAdicional(this.formatNumber(0.0, 2));
            tipoServ.setVlrNRetAdic(this.formatNumber(0.0, 2));
            h.put(itemReinf.getRps().getTipoServico().getCodigo(), tipoServ);
            lista.add(tipoServ);
        }
        if (itemReinf.getNotaPropria() != null) {
            HashMap<String, HashMap> temp = new HashMap<String, HashMap>();
            for (ItemNotaFiscalPropria i : itemReinf.getNotaPropria().getItensNotaPropria()) {
                HashMap item;
                if (i.getTipoServicoReinf() == null) continue;
                if (temp.get(i.getTipoServicoReinf().getCodigo()) != null) {
                    item = (HashMap)temp.get(i.getTipoServicoReinf().getCodigo());
                    if (this.getValorRetidoItemNota(i) > 0.0) {
                        item.put("VALOR_BASE_RETENCAO", (Double)item.get("VALOR_BASE_RETENCAO") + this.formatNumber(i.getItemNotaLivroFiscal().getValorTotal(), 2));
                    } else {
                        item.put("VALOR_BASE_RETENCAO", (Double)item.get("VALOR_BASE_RETENCAO") + 0.0);
                    }
                    item.put("VALOR_RETENCAO", (Double)item.get("VALOR_RETENCAO") + this.formatNumber(this.getValorRetidoItemNota(i), 2));
                    continue;
                }
                item = new HashMap();
                item.put("VALOR_BASE_RETENCAO", 0.0);
                item.put("VALOR_RETENCAO", 0.0);
                if (this.getValorRetidoItemNota(i) > 0.0) {
                    item.put("VALOR_BASE_RETENCAO", i.getItemNotaLivroFiscal().getValorTotal());
                } else {
                    item.put("VALOR_BASE_RETENCAO", 0.0);
                }
                item.put("VALOR_RETENCAO", (Double)item.get("VALOR_RETENCAO") + this.getValorRetidoItemNota(i));
                temp.put(i.getTipoServicoReinf().getCodigo(), item);
            }
            Set set = temp.keySet();
            for (Object o : set) {
                String codigo = (String)o;
                HashMap hh = (HashMap)temp.get(codigo);
                Double valorBaseRetencao = (Double)hh.get("VALOR_BASE_RETENCAO");
                Double valorRetencao = (Double)hh.get("VALOR_RETENCAO");
                Reinf.EvtServPrest.InfoServPrest.IdeEstabPrest.IdeTomador.Nfs.InfoTpServ tipoServ = this.getFact().createReinfEvtServPrestInfoServPrestIdeEstabPrestIdeTomadorNfsInfoTpServ();
                tipoServ.setTpServico(new BigInteger(codigo));
                tipoServ.setVlrBaseRet(this.formatNumber(valorBaseRetencao, 2));
                tipoServ.setVlrRetencao(this.formatNumber(valorRetencao, 2));
                tipoServ.setVlrRetSub(this.formatNumber(0.0, 2));
                tipoServ.setVlrNRetPrinc(this.formatNumber(0.0, 2));
                tipoServ.setVlrServicos15(this.formatNumber(0.0, 2));
                tipoServ.setVlrServicos20(this.formatNumber(0.0, 2));
                tipoServ.setVlrServicos25(this.formatNumber(0.0, 2));
                tipoServ.setVlrAdicional(this.formatNumber(0.0, 2));
                tipoServ.setVlrNRetAdic(this.formatNumber(0.0, 2));
                lista.add(tipoServ);
            }
        }
        return lista;
    }

    private Double getValorTotalNotas(ItemReinf2020 item) {
        Double valor = 0.0;
        for (ItemReinfNotas2020 nota : item.getItens()) {
            if (nota.getRps() != null) {
                valor = valor + nota.getRps().getValorServico();
                continue;
            }
            if (nota.getNotaPropria() == null) continue;
            valor = valor + nota.getNotaPropria().getValoresNfPropria().getValorTotal();
        }
        return valor;
    }

    private Number getValorBaseRetencoes(ItemReinf2020 item) {
        Double valor = 0.0;
        for (ItemReinfNotas2020 nota : item.getItens()) {
            if (nota.getRps() != null) {
                valor = valor + nota.getRps().getValorServico();
                continue;
            }
            if (nota.getNotaPropria() == null) continue;
            valor = valor + nota.getNotaPropria().getValoresNfPropria().getValorTotal();
        }
        return valor;
    }

    private Number getValorRetencoes(ItemReinf2020 item) {
        Double valor = 0.0;
        for (ItemReinfNotas2020 nota : item.getItens()) {
            if (nota.getRps() != null) {
                valor = valor + nota.getRps().getValorInss();
                continue;
            }
            if (nota.getNotaPropria() == null) continue;
            valor = valor + nota.getNotaPropria().getValoresNfPropria().getValorInss();
        }
        return valor;
    }

    public String formatNumber(Number n) {
        DecimalFormat staticDecimal = new DecimalFormat();
        staticDecimal.setMaximumFractionDigits(2);
        staticDecimal.setMinimumFractionDigits(2);
        staticDecimal.setMinimumIntegerDigits(1);
        n = n == null ? (Number)0.0 : (Number)n;
        String st = staticDecimal.format(n);
        st = st.replaceAll("\\.", "");
        return st;
    }

    public String formatNumber(Number n, int fractionDigits) {
        DecimalFormat variableDecimal = new DecimalFormat();
        variableDecimal.setMinimumIntegerDigits(1);
        variableDecimal.setMaximumFractionDigits(fractionDigits);
        variableDecimal.setMinimumFractionDigits(fractionDigits);
        String st = variableDecimal.format(n);
        st = st.replaceAll("\\.", "");
        return st;
    }

    private double getValorRetidoRPS(Rps r) {
        return r.getValorInss();
    }

    private double getValorRetidoItemNota(ItemNotaFiscalPropria i) {
        return i.getItemNotaLivroFiscal().getVrInss();
    }
}

