/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.reinf.impl.evtprocessosjudiciais;

import com.touchcomp.basementor.constants.enums.reinf.EnumReinfTipoEvento;
import com.touchcomp.basementor.model.vo.R1000;
import com.touchcomp.basementor.model.vo.R1070;
import com.touchcomp.basementor.model.vo.ReinfEvento;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorclientwebservices.reinf.DocReinfBaseImpl;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evttabprocesso.v2_01_02.ObjectFactory;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evttabprocesso.v2_01_02.Reinf;
import com.touchcomp.basementorclientwebservices.reinf.modellote.envioloteeventos.v1_04_00.Evento;
import com.touchcomp.basementorclientwebservices.reinf.tools.ToolReinf;
import com.touchcomp.basementorexceptions.exceptions.impl.reinf.ExceptionReinf;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.math.BigInteger;

public class ImplProcessosJudiciais
extends DocReinfBaseImpl {
    @Override
    public Evento getRootEvento(ReinfEvento evento, R1000 opcoesReinf) throws ExceptionReinf {
        return this.getRootEvento(evento.getPreEvento(), opcoesReinf);
    }

    @Override
    public Evento getRootEvento(ReinfPreEvento preEvento, R1000 opcoesReinf) throws ExceptionReinf {
        Reinf root = this.getFact().createReinf();
        root.setEvtTabProcesso(this.getEvtTabProcesso(preEvento, opcoesReinf));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private Reinf.EvtTabProcesso getEvtTabProcesso(ReinfPreEvento preEvento, R1000 opcoesReinf) throws ExceptionReinf {
        Reinf.EvtTabProcesso e = this.getFact().createReinfEvtTabProcesso();
        e.setId(preEvento.getReinfEvento().getIdTagEventoReinf());
        e.setIdeContri(this.getIdeContribuinte(opcoesReinf));
        e.setIdeEvento(this.getIdeEvento(preEvento.getReinfEvento()));
        e.setInfoProcesso(this.getInfoProcesso(preEvento));
        return e;
    }

    private Reinf.EvtTabProcesso.IdeContri getIdeContribuinte(R1000 opcoes) throws ExceptionReinf {
        Reinf.EvtTabProcesso.IdeContri empregador = this.getFact().createReinfEvtTabProcessoIdeContri();
        String tipoInscricao = ToolReinf.getTipoInscricaoEmpregador(opcoes.getEmpresa().getPessoa().getComplemento().getTipoPessoa());
        empregador.setTpInsc(Byte.parseByte(tipoInscricao));
        empregador.setNrInsc(ToolReinf.getNrInscricaoEmpresa(opcoes.getEmpresa()));
        return empregador;
    }

    private Reinf.EvtTabProcesso.IdeEvento getIdeEvento(ReinfEvento evt) {
        Reinf.EvtTabProcesso.IdeEvento cadastro = this.getFact().createReinfEvtTabProcessoIdeEvento();
        cadastro.setTpAmb(Byte.parseByte(evt.getReinfLoteEventos().getIdentificacaoAmbiente().getCodigo().toString()));
        cadastro.setProcEmi(Byte.parseByte("1"));
        cadastro.setVerProc(this.getVersaoEsocialSistema());
        return cadastro;
    }

    private Reinf.EvtTabProcesso.InfoProcesso getInfoProcesso(ReinfPreEvento preEvento) {
        Reinf.EvtTabProcesso.InfoProcesso i = this.getFact().createReinfEvtTabProcessoInfoProcesso();
        if (preEvento.getTipoEvento() == EnumReinfTipoEvento.TIPO_EVENTO_INCLUSAO.value) {
            i.setInclusao(this.getInclusao(preEvento));
        } else if (preEvento.getTipoEvento() == EnumReinfTipoEvento.TIPO_EVENTO_ALTERACAO.value) {
            i.setAlteracao(this.getAlteracao());
        } else if (preEvento.getTipoEvento() == EnumReinfTipoEvento.TIPO_EVENTO_EXLUSAO.value) {
            i.setExclusao(this.getExclusao());
        }
        return i;
    }

    private Reinf.EvtTabProcesso.InfoProcesso.Inclusao getInclusao(ReinfPreEvento preEvento) {
        Reinf.EvtTabProcesso.InfoProcesso.Inclusao i = this.getFact().createReinfEvtTabProcessoInfoProcessoInclusao();
        i.setIdeProcesso(this.getIdeProcesso(preEvento));
        return i;
    }

    private Reinf.EvtTabProcesso.InfoProcesso.Alteracao getAlteracao() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private Reinf.EvtTabProcesso.InfoProcesso.Exclusao getExclusao() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private Reinf.EvtTabProcesso.InfoProcesso.Inclusao.IdeProcesso getIdeProcesso(ReinfPreEvento preEvento) {
        R1070 r = preEvento.getR1070();
        Reinf.EvtTabProcesso.InfoProcesso.Inclusao.IdeProcesso i = this.getFact().createReinfEvtTabProcessoInfoProcessoInclusaoIdeProcesso();
        i.setTpProc(r.getTipoProcesso());
        i.setNrProc(ToolString.preencheString((String)r.getNumeroProcessoJudicial(), (int)21, (String)"0", (boolean)true));
        i.setIniValid(ToolEsocial.converteData(preEvento.getDataInicioValidade()));
        if (preEvento.getDataFimVal() != null) {
            i.setIniValid(ToolEsocial.converteData(preEvento.getDataFimVal()));
        }
        i.setIndAutoria(r.getAutoriaProcesso());
        i.getInfoSusp().add(this.getInfoSuspensao(r));
        i.setDadosProcJud(this.getDadosProcJudicial(r));
        return i;
    }

    private Reinf.EvtTabProcesso.InfoProcesso.Inclusao.IdeProcesso.InfoSusp getInfoSuspensao(R1070 r) {
        Reinf.EvtTabProcesso.InfoProcesso.Inclusao.IdeProcesso.InfoSusp infSusp = this.getFact().createReinfEvtTabProcessoInfoProcessoInclusaoIdeProcessoInfoSusp();
        infSusp.setCodSusp(r.getCodigoSuspensaoProcesso());
        infSusp.setIndSusp(r.getIndSuspensaoProcesso().getCodigo());
        infSusp.setDtDecisao(ToolEsocial.converteData(r.getDataDecisao()));
        infSusp.setIndDeposito(this.getSimOrNao(r.getIndicativoDepositoMontante()));
        return infSusp;
    }

    private String getSimOrNao(Short indicador) {
        if (indicador.equals((short)1)) {
            return "S";
        }
        return "N";
    }

    private Reinf.EvtTabProcesso.InfoProcesso.Inclusao.IdeProcesso.DadosProcJud getDadosProcJudicial(R1070 r) {
        if (r.getUfVara() != null && r.getCidadeVara() != null && r.getIdentificacaoVara() != null) {
            Reinf.EvtTabProcesso.InfoProcesso.Inclusao.IdeProcesso.DadosProcJud dados = this.getFact().createReinfEvtTabProcessoInfoProcessoInclusaoIdeProcessoDadosProcJud();
            dados.setUfVara(r.getUfVara().getSigla());
            dados.setCodMunic(new BigInteger(r.getCidadeVara().getCodIbgeCompleto()));
            dados.setIdVara(r.getIdentificacaoVara());
            return dados;
        }
        return null;
    }
}

