/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.reinf.impl.evtreabertura;

import com.touchcomp.basementor.model.vo.R1000;
import com.touchcomp.basementor.model.vo.ReinfEvento;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementorclientwebservices.reinf.DocReinfBaseImpl;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evtreabreevper.v2_01_02.ObjectFactory;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evtreabreevper.v2_01_02.Reinf;
import com.touchcomp.basementorclientwebservices.reinf.tools.ToolReinf;
import com.touchcomp.basementorexceptions.exceptions.impl.reinf.ExceptionReinf;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Date;

public class ImplReabertura
extends DocReinfBaseImpl {
    @Override
    public Reinf getRootEvento(ReinfEvento evento, R1000 opcoesReinf) throws ExceptionReinf {
        return this.getRootEvento(evento.getPreEvento(), opcoesReinf);
    }

    @Override
    public Reinf getRootEvento(ReinfPreEvento preEvento, R1000 opcoesReinf) throws ExceptionReinf {
        R1000 opcoes = opcoesReinf;
        Reinf root = this.getFact().createReinf();
        root.setEvtReabreEvPer(this.getEvtFechaPer(opcoes, preEvento));
        return root;
    }

    private Reinf.EvtReabreEvPer getEvtFechaPer(R1000 opcoes, ReinfPreEvento preEvento) throws ExceptionReinf {
        Reinf.EvtReabreEvPer infoFech = this.getFact().createReinfEvtReabreEvPer();
        infoFech.setIdeEvento(this.getIdeEvento(preEvento.getReinfEvento()));
        infoFech.setIdeContri(this.getIdeContribuinte(opcoes));
        infoFech.setId(preEvento.getReinfEvento().getIdTagEventoReinf());
        return infoFech;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private Reinf.EvtReabreEvPer.IdeEvento getIdeEvento(ReinfEvento evt) {
        Reinf.EvtReabreEvPer.IdeEvento cadastro = this.getFact().createReinfEvtReabreEvPerIdeEvento();
        cadastro.setTpAmb(Byte.parseByte(evt.getReinfLoteEventos().getIdentificacaoAmbiente().getCodigo().toString()));
        cadastro.setProcEmi(Byte.parseByte("1"));
        cadastro.setVerProc(this.getVersaoEsocialSistema());
        cadastro.setPerApur(ToolDate.formatDateAnoMes((Date)evt.getPreEvento().getR2099().getPeriodo()));
        return cadastro;
    }

    private Reinf.EvtReabreEvPer.IdeContri getIdeContribuinte(R1000 opcoes) throws ExceptionReinf {
        Reinf.EvtReabreEvPer.IdeContri empregador = this.getFact().createReinfEvtReabreEvPerIdeContri();
        String tipoInscricao = ToolReinf.getTipoInscricaoEmpregador(opcoes.getEmpresa().getPessoa().getComplemento().getTipoPessoa());
        empregador.setTpInsc(Byte.parseByte(tipoInscricao));
        empregador.setNrInsc(ToolReinf.getNrInscricaoEmpresa(opcoes.getEmpresa()));
        return empregador;
    }
}

