/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.reinf.impl.evttomadorservicos;

import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.ItemReinf2010;
import com.touchcomp.basementor.model.vo.ItemReinfNotas2010;
import com.touchcomp.basementor.model.vo.R1000;
import com.touchcomp.basementor.model.vo.ReinfEvento;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorclientwebservices.reinf.DocReinfBaseImpl;
import com.touchcomp.basementorclientwebservices.reinf.impl.evttomadorservicos.TempTipoServicoTomados;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evttomadorservicos.v2_01_02.ObjectFactory;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evttomadorservicos.v2_01_02.Reinf;
import com.touchcomp.basementorclientwebservices.reinf.tools.ToolReinf;
import com.touchcomp.basementorexceptions.exceptions.impl.reinf.ExceptionReinf;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;

public class ImplServicosTomados
extends DocReinfBaseImpl {
    @Override
    public Reinf getRootEvento(ReinfEvento preEvento, R1000 opcoesReinf) throws ExceptionReinf {
        return this.getRootEvento(preEvento.getPreEvento(), opcoesReinf);
    }

    @Override
    public Reinf getRootEvento(ReinfPreEvento preEvento, R1000 opcoes) throws ExceptionReinf {
        Reinf root = this.getFact().createReinf();
        root.setEvtServTom(this.getEvtServicosTomados(preEvento, opcoes));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private Reinf.EvtServTom getEvtServicosTomados(ReinfPreEvento preEvento, R1000 opcoes) throws ExceptionReinf {
        Reinf.EvtServTom servTom = new Reinf.EvtServTom();
        servTom.setId(preEvento.getReinfEvento().getIdTagEventoReinf());
        servTom.setIdeContri(this.getIdeContribuinte(opcoes));
        servTom.setIdeEvento(this.getIdeEvento(preEvento.getReinfEvento()));
        servTom.setInfoServTom(this.getInfServicosPrestados(preEvento));
        return servTom;
    }

    private Reinf.EvtServTom.IdeContri getIdeContribuinte(R1000 opcoes) throws ExceptionReinf {
        Reinf.EvtServTom.IdeContri empregador = this.getFact().createReinfEvtServTomIdeContri();
        String tipoInscricao = ToolReinf.getTipoInscricaoEmpregador(opcoes.getEmpresa().getPessoa().getComplemento().getTipoPessoa());
        empregador.setTpInsc(Byte.parseByte(tipoInscricao));
        empregador.setNrInsc(ToolReinf.getNrInscricaoEmpresa(opcoes.getEmpresa()));
        return empregador;
    }

    private Reinf.EvtServTom.IdeEvento getIdeEvento(ReinfEvento evt) {
        Reinf.EvtServTom.IdeEvento cadastro = this.getFact().createReinfEvtServTomIdeEvento();
        if (evt.getPreEvento().getEventoRetificacao() != null && evt.getPreEvento().getEventoRetificacao().equals((short)1)) {
            cadastro.setIndRetif((short)2);
            cadastro.setNrRecibo(evt.getPreEvento().getEventoAnterior().getReinfEvento().getNrRecibo().trim());
        } else {
            cadastro.setIndRetif((short)1);
        }
        cadastro.setPerApur(ToolDate.formatDateAnoMes((Date)evt.getPreEvento().getItemReinf2010().getApuracaoReinf().getPeriodo()));
        cadastro.setTpAmb(Byte.parseByte(evt.getReinfLoteEventos().getIdentificacaoAmbiente().getCodigo().toString()));
        cadastro.setProcEmi(Byte.parseByte("1"));
        cadastro.setVerProc(this.getVersaoEsocialSistema());
        return cadastro;
    }

    private Reinf.EvtServTom.InfoServTom getInfServicosPrestados(ReinfPreEvento preEvento) {
        Reinf.EvtServTom.InfoServTom serv = this.getFact().createReinfEvtServTomInfoServTom();
        serv.setIdeEstabObra(this.getIdeEstabObra(preEvento));
        return serv;
    }

    private Reinf.EvtServTom.InfoServTom.IdeEstabObra getIdeEstabObra(ReinfPreEvento preEvento) {
        Reinf.EvtServTom.InfoServTom.IdeEstabObra obra = this.getFact().createReinfEvtServTomInfoServTomIdeEstabObra();
        ItemReinf2010 item = preEvento.getItemReinf2010();
        if (item.getIndicadorObra() == null || item.getIndicadorObra().equals((short)0)) {
            obra.setTpInscEstab((short)1);
            obra.setNrInscEstab(item.getEmpresa().getPessoa().getComplemento().getCnpj());
            obra.setIndObra((short)0);
        } else {
            obra.setTpInscEstab((short)4);
            obra.setNrInscEstab(item.getCno().getCodigo());
            obra.setIndObra(item.getIndicadorEmpreitada());
        }
        obra.setIdePrestServ(this.getIdePrestacaoServicos(preEvento));
        return obra;
    }

    private Reinf.EvtServTom.InfoServTom.IdeEstabObra.IdePrestServ getIdePrestacaoServicos(ReinfPreEvento preEvento) {
        ItemReinf2010 item = preEvento.getItemReinf2010();
        Reinf.EvtServTom.InfoServTom.IdeEstabObra.IdePrestServ prestServ = this.getFact().createReinfEvtServTomInfoServTomIdeEstabObraIdePrestServ();
        if (item.getIndicadorObra() == null || item.getIndicadorObra().equals((short)0)) {
            prestServ.setCnpjPrestador(item.getPessoa().getComplemento().getCnpj());
        } else {
            prestServ.setCnpjPrestador(item.getCno().getPessoa().getComplemento().getCnpj());
        }
        prestServ.setVlrTotalBruto(this.formatNumber(this.getValorTotalNotas(item), 2));
        prestServ.setVlrTotalBaseRet(this.formatNumber(this.getValorBaseRetencoes(item), 2));
        prestServ.setVlrTotalRetPrinc(this.formatNumber(this.getValorRetencoes(item), 2));
        prestServ.setVlrTotalRetAdic(this.formatNumber(0.0, 2));
        prestServ.setVlrTotalNRetPrinc(this.formatNumber(0.0, 2));
        prestServ.setVlrTotalNRetAdic(this.formatNumber(0.0, 2));
        prestServ.setIndCPRB(this.getIndicadorCPRB(item));
        prestServ.getNfs().addAll(this.getNFs(item));
        return prestServ;
    }

    private Collection<? extends Reinf.EvtServTom.InfoServTom.IdeEstabObra.IdePrestServ.Nfs> getNFs(ItemReinf2010 item) {
        ArrayList<Reinf.EvtServTom.InfoServTom.IdeEstabObra.IdePrestServ.Nfs> lista = new ArrayList<Reinf.EvtServTom.InfoServTom.IdeEstabObra.IdePrestServ.Nfs>();
        for (ItemReinfNotas2010 i : item.getItens()) {
            Reinf.EvtServTom.InfoServTom.IdeEstabObra.IdePrestServ.Nfs nf = this.getFact().createReinfEvtServTomInfoServTomIdeEstabObraIdePrestServNfs();
            nf.setSerie(i.getNotaTerceiros().getSerie());
            nf.setNumDocto(i.getNotaTerceiros().getNumeroNota().toString());
            nf.setDtEmissaoNF(ToolEsocial.converteData(i.getNotaTerceiros().getDataEntrada()));
            nf.setVlrBruto(this.formatNumber(i.getNotaTerceiros().getValoresNfTerceiros().getValorTotal(), 2));
            nf.setObs("NF: " + i.getNotaTerceiros().getNumeroNota().toString());
            nf.getInfoTpServ().addAll(this.getTiposServicoNFs(i));
            lista.add(nf);
        }
        return lista;
    }

    private Collection<? extends Reinf.EvtServTom.InfoServTom.IdeEstabObra.IdePrestServ.Nfs.InfoTpServ> getTiposServicoNFs(ItemReinfNotas2010 itemReinf) {
        ArrayList<Reinf.EvtServTom.InfoServTom.IdeEstabObra.IdePrestServ.Nfs.InfoTpServ> lista = new ArrayList<Reinf.EvtServTom.InfoServTom.IdeEstabObra.IdePrestServ.Nfs.InfoTpServ>();
        HashMap<String, TempTipoServicoTomados> h = new HashMap<String, TempTipoServicoTomados>();
        ArrayList<TempTipoServicoTomados> temp = new ArrayList<TempTipoServicoTomados>();
        for (ItemNotaTerceiros itemNotaTerceiros : itemReinf.getNotaTerceiros().getItemNotaTerceiros()) {
            TempTipoServicoTomados t;
            if (itemNotaTerceiros.getTipoServico() == null || !(itemNotaTerceiros.getItemNotaLivroFiscal().getVrInss() > 0.0)) continue;
            if (h.get(itemNotaTerceiros.getTipoServico().getCodigo()) != null) {
                t = (TempTipoServicoTomados)h.get(itemNotaTerceiros.getTipoServico().getCodigo());
                t.setValorServico(t.getValorServico() + (itemNotaTerceiros.getVrProduto() + itemNotaTerceiros.getVrServico() + itemNotaTerceiros.getValorFrete() + itemNotaTerceiros.getVrSeguro() + itemNotaTerceiros.getValorDespAcessoria() - itemNotaTerceiros.getValorDesconto()) * ((itemNotaTerceiros.getVrProduto() + itemNotaTerceiros.getVrServico() + itemNotaTerceiros.getValorFrete() + itemNotaTerceiros.getVrSeguro() + itemNotaTerceiros.getValorDespAcessoria() - itemNotaTerceiros.getValorDesconto()) * (itemNotaTerceiros.getItemNotaLivroFiscal().getPercRedBcInss() / 100.0)));
                t.setValorRetencao(t.getValorRetencao() + itemNotaTerceiros.getItemNotaLivroFiscal().getVrInss());
                continue;
            }
            t = new TempTipoServicoTomados();
            t.setCodigo(itemNotaTerceiros.getTipoServico().getCodigo());
            t.setValorServico(itemNotaTerceiros.getVrProduto() + itemNotaTerceiros.getVrServico() + itemNotaTerceiros.getValorFrete() + itemNotaTerceiros.getVrSeguro() + itemNotaTerceiros.getValorDespAcessoria() - itemNotaTerceiros.getValorDesconto() - (itemNotaTerceiros.getVrProduto() + itemNotaTerceiros.getVrServico() + itemNotaTerceiros.getValorFrete() + itemNotaTerceiros.getVrSeguro() + itemNotaTerceiros.getValorDespAcessoria() - itemNotaTerceiros.getValorDesconto()) * (itemNotaTerceiros.getItemNotaLivroFiscal().getPercRedBcInss() / 100.0));
            t.setValorRetencao(itemNotaTerceiros.getItemNotaLivroFiscal().getVrInss());
            temp.add(t);
            h.put(itemNotaTerceiros.getTipoServico().getCodigo(), t);
        }
        for (TempTipoServicoTomados tempTipoServicoTomados : temp) {
            Reinf.EvtServTom.InfoServTom.IdeEstabObra.IdePrestServ.Nfs.InfoTpServ tipoServ = this.getFact().createReinfEvtServTomInfoServTomIdeEstabObraIdePrestServNfsInfoTpServ();
            tipoServ.setTpServico(new BigInteger(tempTipoServicoTomados.getCodigo()));
            if (tempTipoServicoTomados.getValorRetencao() > 0.0) {
                tipoServ.setVlrBaseRet(this.formatNumber(tempTipoServicoTomados.getValorServico(), 2));
            } else {
                tipoServ.setVlrBaseRet(this.formatNumber(0.0, 2));
            }
            tipoServ.setVlrRetencao(this.formatNumber(tempTipoServicoTomados.getValorRetencao(), 2));
            tipoServ.setVlrRetSub(this.formatNumber(0.0, 2));
            tipoServ.setVlrNRetPrinc(this.formatNumber(0.0, 2));
            tipoServ.setVlrServicos15(this.formatNumber(0.0, 2));
            tipoServ.setVlrServicos20(this.formatNumber(0.0, 2));
            tipoServ.setVlrServicos25(this.formatNumber(0.0, 2));
            tipoServ.setVlrAdicional(this.formatNumber(0.0, 2));
            tipoServ.setVlrNRetAdic(this.formatNumber(0.0, 2));
            lista.add(tipoServ);
        }
        return lista;
    }

    private Double getValorTotalNotas(ItemReinf2010 item) {
        Double valor = 0.0;
        for (ItemReinfNotas2010 nota : item.getItens()) {
            valor = valor + nota.getNotaTerceiros().getValoresNfTerceiros().getValorTotal();
        }
        return valor;
    }

    private Number getValorBaseRetencoes(ItemReinf2010 item) {
        Double valor = 0.0;
        for (ItemReinfNotas2010 nota : item.getItens()) {
            for (ItemNotaTerceiros i : nota.getNotaTerceiros().getItemNotaTerceiros()) {
                if (!(i.getItemNotaLivroFiscal().getVrInss() > 0.0)) continue;
                valor = valor + (i.getItemNotaLivroFiscal().getValorTotal() - i.getItemNotaLivroFiscal().getValorTotal() * i.getItemNotaLivroFiscal().getPercRedBcInss() / 100.0);
            }
        }
        return valor;
    }

    private Number getValorRetencoes(ItemReinf2010 item) {
        Double valor = 0.0;
        for (ItemReinfNotas2010 nota : item.getItens()) {
            for (ItemNotaTerceiros i : nota.getNotaTerceiros().getItemNotaTerceiros()) {
                if (!(i.getItemNotaLivroFiscal().getVrInss() > 0.0)) continue;
                valor = valor + i.getItemNotaLivroFiscal().getVrInss();
            }
        }
        return valor;
    }

    public String formatNumber(Number n) {
        DecimalFormat staticDecimal = new DecimalFormat();
        staticDecimal.setMaximumFractionDigits(2);
        staticDecimal.setMinimumFractionDigits(2);
        staticDecimal.setMinimumIntegerDigits(1);
        n = n == null ? (Number)0.0 : (Number)n;
        String st = staticDecimal.format(n);
        st = st.replaceAll("\\.", "");
        return st;
    }

    public String formatNumber(Number n, int fractionDigits) {
        DecimalFormat variableDecimal = new DecimalFormat();
        variableDecimal.setMinimumIntegerDigits(1);
        variableDecimal.setMaximumFractionDigits(fractionDigits);
        variableDecimal.setMinimumFractionDigits(fractionDigits);
        String st = variableDecimal.format(n);
        st = st.replaceAll("\\.", "");
        return st;
    }

    private short getIndicadorCPRB(ItemReinf2010 item) {
        for (ItemReinfNotas2010 i : item.getItens()) {
            for (ItemNotaTerceiros n : i.getNotaTerceiros().getItemNotaTerceiros()) {
                if (n.getTipoServico() == null || !n.getItemNotaLivroFiscal().getAliquotaInss().equals(11.0)) continue;
                return Short.parseShort("0");
            }
        }
        return Short.parseShort("1");
    }
}

