/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.webreceita;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementorclientwebservices.webreceita.model.RecAgroCalcAreaInp;
import com.touchcomp.basementorclientwebservices.webreceita.model.RecAgroCalcAreaRes;
import com.touchcomp.basementorclientwebservices.webreceita.model.RecAgroCalcQTDRes;
import com.touchcomp.basementorclientwebservices.webreceita.model.RecAgroCalcQtdInp;
import com.touchcomp.basementorclientwebservices.webreceita.v1.WebReceitaConfig;
import com.touchcomp.basementorclientwebservices.webreceita.v1.consultaarea.WebReceitaArea;
import com.touchcomp.basementorclientwebservices.webreceita.v1.consultaarea.model.DTOAreaResult;
import com.touchcomp.basementorclientwebservices.webreceita.v2.consultaarea.WebReceitaAreaV2;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.ToolMethods;

public class WebReceitaBase {
    public static final String WEB_RECEITA_V1 = "v1";
    public static final String WEB_RECEITA_V2 = "v2";

    public RecAgroCalcAreaRes getArea(WebReceitaConfig config, RecAgroCalcAreaInp calcParams) throws ExceptionIO, ExceptionValidacaoDados {
        switch (config.getVersao()) {
            case "v1": {
                DTOAreaResult res = new WebReceitaArea().getArea(config, calcParams.getIdUnidade(), calcParams.getQuantidade(), calcParams.getAplicacao(), calcParams.getDose(), calcParams.getVolume());
                if (!ToolMethods.isEquals((Object)res.getStatus(), (Object)EnumConstantsMentorStatus.SUCESSO)) {
                    throw new ExceptionValidacaoDados("01-02-00717", new Object[]{"Retorno: " + ToolJson.toJson((Object)res) + "Enviado: ND"});
                }
                return res.getSucesso();
            }
            case "v2": {
                return new WebReceitaAreaV2().getArea(config, calcParams.getIdUnidade(), calcParams.getQuantidade(), calcParams.getAplicacao(), calcParams.getDose(), calcParams.getVolume());
            }
        }
        return null;
    }

    public RecAgroCalcQTDRes getQuantidade(WebReceitaConfig config, RecAgroCalcQtdInp calcParams) throws ExceptionIO, ExceptionValidacaoDados {
        switch (config.getVersao()) {
            case "v1": {
                return null;
            }
            case "v2": {
                return new WebReceitaAreaV2().getQuantidade(config, calcParams.getIdUnidade(), calcParams.getArea(), calcParams.getAplicacao(), calcParams.getDose(), calcParams.getVolume());
            }
        }
        return null;
    }
}

