/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.webreceita.v1.agronomo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementorclientwebservices.webreceita.v1.WebReceita;
import com.touchcomp.basementorclientwebservices.webreceita.v1.WebReceitaConfig;
import com.touchcomp.basementorclientwebservices.webreceita.v1.agronomo.WebReceitaInterfaceAgronomo;
import com.touchcomp.basementorclientwebservices.webreceita.v1.agronomo.model.DTOAgronomo;
import com.touchcomp.basementorclientwebservices.webreceita.v1.agronomo.model.DTOAgronomoResult;
import com.touchcomp.basementorclientwebservices.webreceita.v1.agronomo.model.DTOAgronomoResultInsert;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementortools.tools.json.ToolJson;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.stereotype.Component;
import retrofit2.Call;
import retrofit2.Response;

@Component
public class WebReceitaAgronomo
extends WebReceita {
    public DTOAgronomoResult getAgronomos(WebReceitaConfig config, String cpf) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            WebReceitaInterfaceAgronomo bookResource = (WebReceitaInterfaceAgronomo)this.getRetrofit(config).create(WebReceitaInterfaceAgronomo.class);
            Call<DTOAgronomoResult> books = bookResource.getAgronomo(cpf);
            Response res = books.execute();
            DTOAgronomoResult ret = (DTOAgronomoResult)res.body();
            if (ret == null) {
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{res.message()});
            }
            if (ret.getAviso() != null) {
                ret.setStatus(EnumConstantsMentorStatus.ERRO);
            } else {
                ret.setStatus(EnumConstantsMentorStatus.SUCESSO);
            }
            return ret;
        }
        catch (IOException ex) {
            Logger.getLogger(WebReceitaAgronomo.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOAgronomoResult getAgronomos(WebReceitaConfig config, Long id) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            WebReceitaInterfaceAgronomo bookResource = (WebReceitaInterfaceAgronomo)this.getRetrofit(config).create(WebReceitaInterfaceAgronomo.class);
            Call<DTOAgronomoResult> books = bookResource.getAgronomo(id);
            Response res = books.execute();
            DTOAgronomoResult ret = (DTOAgronomoResult)res.body();
            if (ret == null) {
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{res.message()});
            }
            if (ret.getAviso() != null) {
                ret.setStatus(EnumConstantsMentorStatus.ERRO);
            } else {
                ret.setStatus(EnumConstantsMentorStatus.SUCESSO);
            }
            return ret;
        }
        catch (IOException ex) {
            Logger.getLogger(WebReceitaAgronomo.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOAgronomoResultInsert inserirAgronomo(WebReceitaConfig config, DTOAgronomo agronomo) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            ToolJson.toJson((Object)agronomo);
            WebReceitaInterfaceAgronomo bookResource = (WebReceitaInterfaceAgronomo)this.getRetrofit(config).create(WebReceitaInterfaceAgronomo.class);
            Call<DTOAgronomoResultInsert> books = bookResource.inserirAgronomo(agronomo);
            Response res = books.execute();
            DTOAgronomoResultInsert ret = (DTOAgronomoResultInsert)res.body();
            if (ret == null) {
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{res.message()});
            }
            if (ret.getSucesso() == null) {
                ret.setStatus(EnumConstantsMentorStatus.ERRO);
            } else {
                ret.setStatus(EnumConstantsMentorStatus.SUCESSO);
            }
            return ret;
        }
        catch (IOException ex) {
            Logger.getLogger(WebReceitaAgronomo.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }
}

